# Ryerson SGS Thesis Latex class
Provides a Latex template of Ryerson School of Graduate Studies (SGS) Thesis.

Adheres to the 2017-06-08 guidelines.

The link to the guidelines can be found [here](https://www.ryerson.ca/graduate/student-guide/academic-matters/dissertation-thesis-exams/)

Example tex file is [rsgs-example.tex](rsgs-example.tex)

Example pdf output is [rsgs-example.pdf](rsgs-example.pdf)

## Getting Started
- Copy the contents of this repository
- *Optional*: Add your remote thesis git repository as the *origin*
- Modify the contents (example.tex, example.bib and glossary.tex) to begin writing your thesis

### Prerequisites
A complete Latex distribution

Latex distribution options:
- [miktex](https://miktex.org)

GUI options:
- [texpad for Mac](https://www.texpad.com)
- [texmaker](http://www.xm1math.net/texmaker/download.html)


### Latex compile options
- pdfLatex + Bibliography + indicesx3

## Versioning
We use [SemVer](http://semver.org/) for versioning.

## Changelog
This project keeps a changelog - see the [CHANGELOG.md](CHANGELOG.md) file for details

## Authors
* [**Yasir Shoaib**](https://github.com/yshoaib) - *Original contributor*

## License
This project is licensed under the Apache License - see the [LICENSE](LICENSE) file for details

## CTAN
* [ryersonsgsthesis](https://ctan.org/pkg/ryersonsgsthesis)

## Acknowledgments
* Ryerson SGS thesis guidelines
* stackoverflow and other various sources on the web
