;; -*- lexical-binding: t; -*-

(TeX-add-style-hook
 "nicematrix-french"
 (lambda ()
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("IEEEaccess" "") ("article" "dvipsnames" "")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("polyglossia" "") ("geometry" "") ("array" "") ("tikz" "") ("enumitem" "") ("siunitx" "") ("verbatim" "") ("caption" "") ("tocloft" "") ("shortvrb" "") ("fancyvrb" "") ("titlesec" "") ("footnote" "") ("booktabs" "") ("varwidth" "") ("tcolorbox" "") ("adjustbox" "") ("lipsum" "auto-lang=false") ("makeidx" "") ("piton" "") ("hyperref" "hyperfootnotes=false") ("bookmark" "") ("colortbl" "") ("xcolor" "table") ("nicematrix" "" "footnote") ("babel" "spanish" "es-noshorthands") ("lmodern" "") ("TikZ" "")))
   (add-to-list 'LaTeX-verbatim-environments-local "SaveVerbatim")
   (add-to-list 'LaTeX-verbatim-environments-local "VerbatimOut")
   (add-to-list 'LaTeX-verbatim-environments-local "LVerbatim*")
   (add-to-list 'LaTeX-verbatim-environments-local "LVerbatim")
   (add-to-list 'LaTeX-verbatim-environments-local "BVerbatim*")
   (add-to-list 'LaTeX-verbatim-environments-local "BVerbatim")
   (add-to-list 'LaTeX-verbatim-environments-local "Verbatim*")
   (add-to-list 'LaTeX-verbatim-environments-local "Verbatim")
   (add-to-list 'LaTeX-verbatim-environments-local "Code")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "href")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "Verb*")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "Verb")
   (TeX-run-style-hooks
    "latex2e"
    "article"
    "art10"
    "polyglossia"
    "geometry"
    "array"
    "nicematrix"
    "tikz"
    "enumitem"
    "siunitx"
    "verbatim"
    "caption"
    "tocloft"
    "shortvrb"
    "fancyvrb"
    "titlesec"
    "footnote"
    "booktabs"
    "varwidth"
    "tcolorbox"
    "adjustbox"
    "lipsum"
    "makeidx"
    "piton"
    "hyperref"
    "bookmark"
    "colortbl"
    "xcolor"
    "babel"
    "IEEEaccess"
    "IEEEaccess10"
    "lmodern"
    "TikZ")
   (TeX-add-symbols
    '("stars" "Text")
    '("emph")
    '("crossbox" ["Text"])
    '("MyDraw")
    '("Blue")
    '("RedLine")
    '("indexenv" "Text")
    '("indexcommand" "Text")
    '("DefinitionCommande" "Text")
    '("Definition" "Text")
    '("cls" "Text")
    '("pkg" "Text")
    "blue"
    "interitem"
    "emphase"
    "TeXyear"
    "year")
   (LaTeX-add-labels
    "cell-space-limits"
    "Block"
    "horizontal-pos-block"
    "vertical-pos-block"
    "ampersand-in-blocks"
    "rules"
    "cline"
    "hvlines"
    "corners"
    "custom-line"
    "dotted"
    "color-in-code-before"
    "code-before"
    "chessboardcolors"
    "RowStyle"
    "width"
    "varwidth"
    "colonne-X"
    "exterior"
    "Cdots"
    "customization"
    "Hbrace"
    "dotted-and-rules"
    "delimiters-in-preamble"
    "code-after"
    "line-in-code-after"
    "sub-matrix"
    "TikzEveryCell"
    "s:notes"
    "s:caption"
    "tabularnote"
    "tabular-rounded-corners"
    "columns-type"
    "rotate"
    "small"
    "iRow"
    "light-syntax"
    "NiceArrayWithDelims"
    "name"
    "PGF-nodes"
    "no-cell-nodes"
    "node-V"
    "nodes-i"
    "node-sub-matrix"
    "parallelization"
    "empty-cells"
    "Tagging Project"
    "ex:tikz-key"
    "ex:tcolorbox"
    "ex:notes"
    "ex:no-longer-dotted-rules"
    "ex:colon"
    "ex:hbrace"
    "ex:tiretes"
    "ex:submatrix"
    "ex:triangular")
   (LaTeX-add-environments
    '("scope"))
   (LaTeX-add-index-entries
    "#1@\\texttt{\\textbackslash #1}"
    "#1@\\texttt{\\{#1\\}}"
    "cell-space-top-limit"
    "cell-space-bottom-limit"
    "cell-space-limits"
    "cellspace@\\pkg{cellspace} (extension)"
    "baseline (clé pour un environnement)"
    "Blocs@\\textbf{Blocs dans les tableaux}|("
    "fill!clé de \\texttt{\\textbackslash Block}"
    "opacity!clé de la commande \\texttt{\\textbackslash Block}"
    "draw (clé de \\texttt{\\textbackslash Block})"
    "color!clé de \\texttt{\\textbackslash Block}"
    "vlines!clé de \\texttt{\\textbackslash Block}"
    "hvlines!clé de
  \\texttt{\\textbackslash Block}"
    "hlines!clé de \\texttt{\\textbackslash Block}"
    "line-width (clé de \\texttt{\\textbackslash Block})"
    "rounded-corners!clé de \\texttt{\\textbackslash Block}"
    "Coins arrondis!pour un bloc"
    "borders (clé de \\texttt{\\textbackslash Block})"
    "tikzz@tikz!clé de «borders» de \\texttt{\\textbackslash Block}"
    "tikzz@tikz!clé de \\texttt{\\textbackslash Block}"
    "name!clé de \\texttt{\\textbackslash Block}"
    "respect-arraystretch (clé de \\texttt{\\textbackslash Block})"
    "transparent (clé de \\texttt{\\textbackslash Block})"
    "v-center (clé de \\texttt{\\textbackslash Block)})"
    "ampersand-in-blocks"
    "\\&-in-blocks"
    "Blocs@\\textbf{Blocs dans les tableaux}|)"
    "Filets@\\textbf{Filets dans les tableaux}|("
    "booktabs@\\pkg{booktabs} (extension)"
    "cline@\\texttt{\\textbackslash cline} (commande de LaTeX)"
    "standard-cline"
    "Couleur!des filets"
    "width!sous-clé de «rules»"
    "rules (clé pour un environnement)"
    "hlines|see{Filets}"
    "hlines!clé pour un environnement"
    "vlines|see{Filets}"
    "vlines!clé pour un environnement"
    "hvlines|see{Filets}"
    "hvlines!clé pour un environnement"
    "hvlines-except-borders"
    "Coins (les --- vides)"
    "corners (clé d'un environnement)"
    "command (clé de «custom-line»)"
    "ccommand (clé de «custom-line»)"
    "letter (clé de «custom-line»)"
    "custom-line|("
    "multiplicity (clé de «custom-line»)"
    "color!clé de «custom-line»"
    "sep-color (clé de «custom-line»)"
    "tikzz@tikz!clé de «custom-line»"
    "total-width (clé de «custom-line»)"
    "dotted (clé de «custom-line»)"
    "start (clé pour les filets)"
    "end (clé pour les filets)"
    "custom-line|)"
    "Filets@\\textbf{Filets dans les tableaux}|)"
    "Couleur!de fond pour les cases"
    "colortbl@\\pkg{colortbl} (extension)"
    "code-before!clé pour un environnement"
    "CodeBefore@\\texttt{\\textbackslash CodeBefore}...\\texttt{\\textbackslash Body}"
    "Body@\\texttt{\\textbackslash Body}|see{\\texttt{\\textbackslash CodeBefore}}"
    "cellcolor@\\texttt{\\textbackslash cellcolor}!commande du
  \\texttt{\\textbackslash CodeBefore}"
    "rectanglecolor@\\texttt{\\textbackslash rectanglecolor} (commande du
  \\texttt{\\textbackslash CodeBefore})"
    "rowcolor@\\texttt{\\textbackslash rowcolor}!commande du \\texttt{\\textbackslash CodeBefore}"
    "columncolor@\\texttt{\\textbackslash columncolor}!commande du
  \\texttt{\\textbackslash CodeBefore}"
    "rowcolors@\\texttt{\\textbackslash rowcolors} (commande du \\texttt{\\textbackslash CodeBefore})"
    "rowlistcolor@\\texttt{\\textbackslash rowlistcolors} (commande du
  \\texttt{\\textbackslash CodeBefore})"
    "chessboardcolors@\\texttt{\\textbackslash chessboardcolors}!(commande
  du \\texttt{\\textbackslash CodeBefore})"
    "arraycolor@\\texttt{\\textbackslash arraycolor} (commande du \\texttt{\\textbackslash
  CodeBefore)}"
    "opacity!clé des commandes comme\\newline \\texttt{\\textbackslash
    rowcolor}, etc."
    "cols (clé de \\texttt{\\textbackslash rowcolors} du
  \\texttt{\\textbackslash CodeBefore})"
    "restart (clé de \\texttt{\\textbackslash rowcolors} du
  \\texttt{\\textbackslash CodeBefore})"
    "respect-blocks (clé de \\texttt{\\textbackslash rowcolors} du\\newline
  \\texttt{\\textbackslash CodeBefore})"
    "definecolorseries@\\texttt{\\textbackslash definecolorseries}
  (commande de \\pkg{xcolor})"
    "resetcolorseries@\\texttt{\\textbackslash resetcolorseries}
  (commande de \\pkg{xcolor})"
    "corners (clé d'un environnement)|textit"
    "rotate@\\texttt{\\textbackslash rotate}|textit"
    "S (les colonnes S de \\pkg{siunitx})|textit"
    "EmptyRow@\\texttt{\\textbackslash EmptyRow} (commande du
  \\texttt{\\textbackslash CodeBefore})"
    "EmptyColumn@\\texttt{\\textbackslash EmptyColumn} (commande du
  \\texttt{\\textbackslash CodeBefore})"
    "cellcolor@\\texttt{\\textbackslash cellcolor}!commande en tableau"
    "rowcolor@\\texttt{\\textbackslash rowcolor}!commande en tableau"
    "columncolor@\\texttt{\\textbackslash columncolor}!commande dans le
  préambule d'un environnement"
    "nocolor"
    "nb-rows (clé de \\texttt{\\textbackslash RowStyle})"
    "rowcolor (clé de \\texttt{\\textbackslash RowStyle})"
    "fill!clé de \\texttt{\\textbackslash RowStyle}"
    "opacity!clé de \\texttt{\\textbackslash RowStyle}"
    "rounded-corners!clé de \\texttt{\\textbackslash RowStyle}"
    "color!clé de \\texttt{\\textbackslash RowStyle}"
    "bold (clé de \\texttt{\\textbackslash RowStyle})"
    "Largeur@\\textbf{Largeur des colonnes}|("
    "columns-width"
    "NiceMatrixBlock@\\texttt{\\{NiceMatrixBlock\\}}"
    "auto-columns-width!(clé de \\texttt{\\{NiceMatrixBlock\\}})"
    "varwidth@\\pkg{varwidth} (extension)"
    "V (les colonnes V de \\pkg{varwidth})"
    "tabularx@\\pkg{tabularx} (extension)"
    "NiceTabularX@\\texttt{\\{NiceTabularX\\}}"
    "X (les colonnes X)"
    "width!clé de \\texttt{\\{NiceTabular\\}}"
    "Largeur@\\textbf{Largeur des colonnes}|)"
    "first-row"
    "last-row"
    "first-col"
    "last-col"
    "code-for-first-row"
    "code-for-first-col"
    "code-for-last-row"
    "code-for-last-col"
    "Pointillés@\\textbf{Pointillés (lignes en ---)}|("
    "Lignes en pointillés|see{Pointillés}"
    "Ddots@\\texttt{\\textbackslash Ddots}|textbf"
    "Iddots@\\texttt{\\textbackslash Iddots}|textbf"
    "mathdots@\\pkg{mathdots} (extension)"
    "xdots (et ses sous-clés)"
    "nullify-dots"
    "renew-matrix"
    "renew-dots"
    "color!clé des lignes pointillées"
    "radius (clé des lignes pointillées)"
    "inter (clé des lignes pointillées)"
    "line-style (clé des lignes pointillées)"
    "shorten (clé des lignes pointillées)"
    "shorten-end (clé des lignes pointillées)"
    "shorten-start (clé des lignes pointillées)"
    "horizontal-label(s) (clé des lignes pointillées)"
    "brace (nicematrix/brace est un style TikZ\\newline utilisé par \\textbackslash
  Hbrace et \\textbackslash Vbrace)"
    "Pointillés@\\textbf{Pointillés (lignes en ---)}|)"
    "blkarray@\\pkg{blkarray} (extension)"
    "delimiteurs@délimiteurs dans les préambules"
    "left@\\texttt{\\textbackslash left} : utilisé par \\pkg{nicematrix}\\newline
  pour des délimiteurs\\newline dans les préambules"
    "right@\\texttt{\\textbackslash right} : utilisé par
  \\pkg{nicematrix}\\newline pour des délimiteurs\\newline dans les préambules"
    "CodeAfter@\\texttt{\\textbackslash CodeAfter}|("
    "code-after"
    "sub-matrix (clé de \\texttt{\\textbackslash CodeAfter}, avec sous-clés)"
    "line@\\texttt{\\textbackslash line} (commande du
  \\texttt{\\textbackslash CodeAfter})"
    "SubMatrix@\\texttt{\\textbackslash SubMatrix} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du 
\\texttt{\\textbackslash CodeBefore})|textbf"
    "left-xshift (clé de \\texttt{\\textbackslash SubMatrix})"
    "right-xshift (clé de \\texttt{\\textbackslash SubMatrix})"
    "xshift (clé de \\texttt{\\textbackslash SubMatrix})"
    "extra-height (clé de \\texttt{\\textbackslash SubMatrix})"
    "delimiters!---/color pour \\texttt{\\textbackslash SubMatrix}"
    "slim (clé de \\texttt{\\textbackslash SubMatrix})"
    "vlines!clé de \\texttt{\\textbackslash SubMatrix}"
    "hlines!clé de \\texttt{\\textbackslash SubMatrix}"
    "hvlines!clé de \\texttt{\\textbackslash SubMatrix}"
    "code (clé de \\texttt{\\textbackslash SubMatrix})"
    "UncerBrace@\\texttt{\\textbackslash UnderBrace} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du
\\texttt{\\textbackslash CodeBefore})"
    "OverBrace@\\texttt{\\textbackslash OverBrace} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du
\\texttt{\\textbackslash CodeBefore})"
    "color!clé de \\texttt{\\textbackslash OverBrace} et \\texttt{\\textbackslash
  UnderBrace}"
    "yshift (clé de \\texttt{\\textbackslash OverBrace} et \\texttt{\\textbackslash
  UnderBrace})"
    "left-shorten (clé de \\texttt{\\textbackslash OverBrace} et\\newline \\texttt{\\textbackslash
  UnderBrace})"
    "right-shorten (clé de \\texttt{\\textbackslash OverBrace} et\\newline \\texttt{\\textbackslash
  UnderBrace})"
    "tikzeverycell@\\texttt{\\textbackslash TikzEveryCell} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du
\\texttt{\\textbackslash CodeBefore})|textbf"
    "empty (clé de \\texttt{\\textbackslash TikzEveryCell})"
    "non-empty (clé de \\texttt{\\textbackslash TikzEveryCell})"
    "CodeAfter@\\texttt{\\textbackslash CodeAfter}|)"
    "caption (clé de \\texttt{\\{NiceTabular\\}})"
    "short-caption"
    "label (clé de \\texttt{\\{NiceTabular\\}})"
    "caption-above"
    "Legende@\\textbf{Légende des tableaux}"
    "footnote@\\pkg{footnote} (extension)"
    "footnote (clé)"
    "footnotehyper@\\pkg{footnotehyper} (extension)"
    "footnotehyper (clé)"
    "nota@\\textbf{Notes dans les tableaux}|("
    "tabularnote@\\texttt{\\textbackslash tabularnote}"
    "enumitem@\\pkg{enumitem} (extension requise pour utiliser\\newline
  \\texttt{\\textbackslash tabularnote})"
    "tabularnote (clé de \\texttt{\\{NiceTabular\\}})"
    "tabularnote-env@\\texttt{\\{TabularNote\\}}"
    "notes (clé pour paramétrer les notes de\\newline tableau)"
    "para (sous-clé de «notes»)"
    "bottomrule (sous-clé de «notes»)"
    "style (sous-clé de «notes»)"
    "label-in-tabular (sous-clé de «notes»)"
    "label-in-list (sous-clé de «notes»)"
    "enumitem-keys (sous-clé de «notes»)"
    "enumitem-keys-para (sous-clé de «notes»)"
    "code-before!sous-clé de «notes»"
    "detect-duplicates (sous-clé de «notes»)"
    "nota@\\textbf{Notes dans les tableaux}|)"
    "threeparttable@\\pkg{threeparttable} (extension)"
    "rounded-corners!clé de \\texttt{\\{NiceTabular\\}}"
    "Coins arrondis!pour un tableau"
    "ShowCellNames@\\texttt{\\textbackslash ShowCellNames} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du 
\\texttt{\\textbackslash CodeBefore})"
    "S (les colonnes S de \\pkg{siunitx})"
    "siunitx@\\pkg{siunitx} (extension)"
    "columns-type (clé de \\texttt{\\{NiceMatrix\\}}, etc.)"
    "rotate@\\texttt{\\textbackslash rotate}"
    "first-row|textit"
    "last-row|textit"
    "code-for-first-row|textit"
    "code-for-last-row|textit"
    "last-col|textit"
    "code-for-last-col|textit"
    "small (clé pour un environnement)"
    "smallmatrix@\\texttt{\\{smallmatrix\\}} (environnement de \\pkg{amsmath})"
    "iRow (compteur LaTeX)"
    "jCol (compteur LaTeX)"
    "light-syntax"
    "end-of-row (à utiliser avec light-syntax)"
    "light-syntax-expanded"
    "delimiters!---/color pour un environnement"
    "color!pour les délimiteurs de matrices"
    "Couleur!des délimiteurs de matrices"
    "NiceArrayWithDelims@\\texttt{\\{NiceArrayWithDelims\\}}"
    "tikza@TikZ (utilisation avec \\pkg{nicematrix})"
    "noeud@\\textbf{Nœuds PGF/Tikz}|("
    "no-cell-nodes"
    "name!clé pour un environnement"
    "pgf-node-code"
    "create-medium-nodes"
    "create-large-nodes"
    "create-extra-nodes"
    "left-margin"
    "right-margin"
    "extra-left-margin"
    "extra-right-margin"
    "create-cell-nodes (clé de \\texttt{\\textbackslash CodeBefore})"
    "SubMatrix@\\texttt{\\textbackslash SubMatrix} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du 
\\texttt{\\textbackslash CodeBefore})"
    "name!clé de \\texttt{\\textbackslash SubMatrix}"
    "noeud@\\textbf{Nœuds PGF/Tikz}|)"
    "crossbox@\\texttt{\\textbackslash crossbox} (définie dans un exemple)|textit"
    "parallelize-diags"
    "Ddots@\\texttt{\\textbackslash Ddots}"
    "Iddots@\\texttt{\\textbackslash Iddots}"
    "draw-first (clé de \\texttt{\\textbackslash Ddots} et
  \\texttt{\\textbackslash Iddots})"
    "exterior-arraycolsep"
    "Incompatibilités"
    "Tagging Project"
    "tikzz@tikz!clé de \\texttt{\\textbackslash Block}|textit"
    "transparent (clé de \\texttt{\\textbackslash Block})|textit"
    "columncolor@\\texttt{\\textbackslash columncolor}!commande du
  \\texttt{\\textbackslash CodeBefore}|textit"
    "tcolorbox@\\pkg{tcolorbox} (extension)|textit"
    "hvlines-except-borders|textit"
    "rules (clé pour un environnement)|textit"
    "rowcolor@\\texttt{\\textbackslash rowcolor}!commande du
  \\texttt{\\textbackslash CodeBefore}|textit"
    "nota@\\textbf{Notes dans les tableaux}|textit"
    "tabularnote@\\texttt{\\textbackslash tabularnote}|textit"
    "notes (clé pour paramétrer les notes de\\newline tableau)|textit"
    "style (sous-clé de «notes»)|textit"
    "enumitem-keys (sous-clé de «notes»)|textit"
    "enumitem@\\pkg{enumitem} (extension requise pour utiliser\\newline
  \\texttt{\\textbackslash tabularnote})|textit"
    "Pointillés@\\textbf{Pointillés (lignes en ---)}|textit"
    "Ddots@\\texttt{\\textbackslash Ddots}|textit"
    "line-style (clé pour les lignes pointillées)|textit"
    "tikzz@tikz!clé de «borders» de \\texttt{\\textbackslash Block}|textit"
    "NiceMatrixBlock@\\texttt{\\{NiceMatrixBlock\\}}|textit"
    "auto-columns-width!(clé de \\texttt{\\{NiceMatrixBlock\\}})|textit"
    "max-width (sous-clé de «delimiters»)"
    "delimiters!---/max-width"
    "SubMatrix@\\texttt{\\textbackslash SubMatrix} (commande du 
\\texttt{\\textbackslash CodeAfter}\\newline et du 
\\texttt{\\textbackslash CodeBefore})|textit"
    "vlines-in-sub-matrix"
    "draw (clé de \\texttt{\\textbackslash Block})|textit"
    "rowcolor@\\texttt{\\textbackslash rowcolor}!commande en tableau|textit"
    "highlight (style TikZ défini dans\\newline un exemple)|textit"
    "create-cell-nodes (clé de \\texttt{\\textbackslash CodeBefore})|textit"
    "CodeBefore@\\texttt{\\textbackslash CodeBefore}...\\texttt{\\textbackslash Body}|textit"
    "create-medium-nodes|textit"
    "CodeAfter@\\texttt{\\textbackslash CodeAfter}|textit"
    "pgf-node-code|textit"
    "Coins (les --- vides)|textit"
    "chessboardcolors@\\texttt{\\textbackslash chessboardcolors}!(commande
  du \\texttt{\\textbackslash CodeBefore})|textit")
   (LaTeX-add-counters
    "fniddots")
   (LaTeX-add-polyglossia-langs
    '("french" "mainlanguage" ""))
   (LaTeX-add-array-newcolumntypes
    "I"))
 :latex)

