/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousPageStore
extends DelegatingPageStore {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousPageStore.class);
    private static final long OFFER_WAIT = 30L;
    private static final long POLL_WAIT = 1000L;
    private final Thread pageSavingThread;
    private final BlockingQueue<PendingAdd> queue;
    private final ConcurrentMap<String, PendingAdd> queueMap;

    public AsynchronousPageStore(IPageStore delegate, int capacity) {
        super(delegate);
        this.queue = new LinkedBlockingQueue<PendingAdd>(capacity);
        this.queueMap = new ConcurrentHashMap<String, PendingAdd>();
        PageAddingRunnable savingRunnable = new PageAddingRunnable(delegate, this.queue, this.queueMap);
        this.pageSavingThread = new Thread((Runnable)savingRunnable, "Wicket-AsyncPageStore-PageSavingThread");
        this.pageSavingThread.setDaemon(true);
        this.pageSavingThread.start();
    }

    private static String getKey(String sessionId, int pageId) {
        return pageId + ":::" + sessionId;
    }

    @Override
    public void destroy() {
        if (this.pageSavingThread.isAlive()) {
            this.pageSavingThread.interrupt();
            try {
                this.pageSavingThread.join();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        super.destroy();
    }

    @Override
    public IManageablePage getPage(IPageContext context, int pageId) {
        String sessionId = context.getSessionId(false);
        if (sessionId == null) {
            return null;
        }
        PendingAdd entry = (PendingAdd)this.queueMap.get(AsynchronousPageStore.getKey(sessionId, pageId));
        if (entry != null) {
            log.debug("Returning the page of a non-stored entry with page id '{}'", (Object)pageId);
            return entry.page;
        }
        IManageablePage page = this.getDelegate().getPage(context, pageId);
        log.debug("Returning the page of a stored entry with page id '{}'", (Object)pageId);
        return page;
    }

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        String sessionId = context.getSessionId(false);
        if (sessionId == null) {
            return;
        }
        String key = AsynchronousPageStore.getKey(sessionId, page.getPageId());
        PendingAdd entry = (PendingAdd)this.queueMap.remove(key);
        if (entry != null) {
            this.queue.remove(entry);
        }
        this.getDelegate().removePage(context, page);
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        PendingAdd add = new PendingAdd(context, page);
        if (this.getDelegate().canBeAsynchronous(add)) {
            String key = add.getKey();
            this.queueMap.put(key, add);
            try {
                if (this.queue.offer(add, 30L, TimeUnit.MILLISECONDS)) {
                    log.debug("Offered for storing asynchronously page with id '{}'", (Object)page.getPageId());
                    return;
                }
                log.debug("Storing synchronously page with id '{}'", (Object)page.getPageId());
                this.queueMap.remove(key);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.queueMap.remove(key);
            }
        } else {
            log.warn("Delegated page store '{}' can not be asynchronous", (Object)this.getDelegate().getClass().getName());
        }
        this.getDelegate().addPage(context, page);
    }

    @Override
    public void removeAllPages(IPageContext context) {
        String sessionId = context.getSessionId(false);
        if (sessionId == null) {
            return;
        }
        this.queue.removeIf(add -> {
            if (add.sessionId.equals(sessionId)) {
                this.queueMap.remove(add.getKey());
                return true;
            }
            return false;
        });
        this.getDelegate().removeAllPages(context);
    }

    private static class PageAddingRunnable
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(PageAddingRunnable.class);
        private final BlockingQueue<PendingAdd> queue;
        private final ConcurrentMap<String, PendingAdd> map;
        private final IPageStore delegate;

        private PageAddingRunnable(IPageStore delegate, BlockingQueue<PendingAdd> queue, ConcurrentMap<String, PendingAdd> map) {
            this.delegate = delegate;
            this.queue = queue;
            this.map = map;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                PendingAdd add = null;
                try {
                    add = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.debug("PageAddingRunnable:: Interrupted...");
                    Thread.currentThread().interrupt();
                }
                if (add == null) continue;
                try {
                    log.debug("Saving asynchronously: {}...", (Object)add);
                    add.asynchronous = true;
                    this.delegate.addPage(add, add.page);
                }
                catch (Exception x) {
                    log.error("An error occurred while saving asynchronously '{}'", (Object)add, (Object)x);
                }
                finally {
                    this.map.remove(add.getKey());
                }
            }
        }
    }

    private static class PendingAdd
    implements IPageContext {
        private final IPageContext context;
        private final IManageablePage page;
        private final String sessionId;
        private boolean asynchronous = false;
        private final Map<String, Serializable> attributeCache = new HashMap<String, Serializable>();
        private final Map<MetaDataKey<?>, Serializable> dataCache = new HashMap();

        public PendingAdd(IPageContext context, IManageablePage page) {
            this.context = (IPageContext)Args.notNull((Object)context, (String)"context");
            this.page = (IManageablePage)Args.notNull((Object)page, (String)"page");
            this.sessionId = context.getSessionId(true);
        }

        private String getKey() {
            return AsynchronousPageStore.getKey(this.sessionId, this.page.getPageId());
        }

        public String toString() {
            return "PendingAdd [sessionId=" + this.sessionId + ", pageId=" + this.page.getPageId() + ", pageClass=" + Classes.name(this.page.getClass()) + "]";
        }

        @Override
        public <T> T getRequestData(MetaDataKey<T> key, Supplier<T> value) {
            if (this.asynchronous) {
                throw new WicketRuntimeException("request data not available asynchronuously");
            }
            return this.context.getRequestData(key, value);
        }

        @Override
        public <T extends Serializable> T getSessionAttribute(String key, Supplier<T> defaultValue) {
            Serializable value;
            if (this.asynchronous) {
                value = this.attributeCache.get(key);
                if (value == null && defaultValue.get() != null) {
                    throw new WicketRuntimeException("session attribute can not be changed asynchronuously");
                }
            } else {
                value = this.context.getSessionAttribute(key, defaultValue);
                if (value != null) {
                    this.attributeCache.put(key, value);
                }
            }
            return (T)value;
        }

        @Override
        public <T extends Serializable> T getSessionData(MetaDataKey<T> key, Supplier<T> defaultValue) {
            Serializable value;
            if (this.asynchronous) {
                value = this.dataCache.get(key);
                if (value == null && defaultValue.get() != null) {
                    throw new WicketRuntimeException("session data can not be changed asynchronuously");
                }
            } else {
                value = this.context.getSessionData(key, defaultValue);
                if (value != null) {
                    this.dataCache.put(key, value);
                }
            }
            return (T)value;
        }

        @Override
        public String getSessionId(boolean bind) {
            return this.sessionId;
        }
    }
}

