/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.media.video;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.media.MediaComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class Video
extends MediaComponent {
    private static final long serialVersionUID = 1L;
    private Integer width;
    private Integer height;
    private ResourceReference poster;
    private PageParameters posterPageParameters;

    public Video(String id) {
        super(id);
    }

    public Video(String id, IModel<?> model) {
        super(id, model);
    }

    public Video(String id, ResourceReference resourceReference) {
        super(id, resourceReference);
    }

    public Video(String id, IModel<?> model, ResourceReference resourceReference) {
        super(id, model, resourceReference);
    }

    public Video(String id, ResourceReference resourceReference, PageParameters pageParameters) {
        super(id, resourceReference, pageParameters);
    }

    public Video(String id, IModel<?> model, ResourceReference resourceReference, PageParameters pageParameters) {
        super(id, model, resourceReference, pageParameters);
    }

    public Video(String id, String url) {
        super(id, url);
    }

    public Video(String id, IModel<?> model, String url) {
        super(id, model, url);
    }

    public Video(String id, String url, PageParameters pageParameters) {
        super(id, null, url, pageParameters);
    }

    public Video(String id, IModel<?> model, String url, PageParameters pageParameters) {
        super(id, model, url, pageParameters);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        ResourceReference _poster;
        Integer _height;
        this.checkComponentTag(tag, "video");
        super.onComponentTag(tag);
        Integer _width = this.getWidth();
        if (_width != null) {
            tag.put("width", _width);
        }
        if ((_height = this.getHeight()) != null) {
            tag.put("height", _height);
        }
        if ((_poster = this.getPoster()) != null) {
            tag.put("poster", RequestCycle.get().urlFor(_poster, this.getPosterPageParameters()));
        }
    }

    public ResourceReference getPoster() {
        return this.poster;
    }

    public PageParameters getPosterPageParameters() {
        return this.posterPageParameters;
    }

    public void setPosterPageParameters(PageParameters posterPageParameters) {
        this.posterPageParameters = posterPageParameters;
    }

    public void setPoster(ResourceReference poster) {
        this.poster = poster;
    }

    public void setPoster(ResourceReference poster, PageParameters posterPageParameters) {
        this.poster = poster;
        this.posterPageParameters = posterPageParameters;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }
}

