/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.debug.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptToggleBreakpointAdapter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RutaToggleBreakpointAdapter
extends ScriptToggleBreakpointAdapter {
    protected String getDebugModelId() {
        return "org.eclipse.dltk.debug.rutaModel";
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection;
            int lineNumber;
            ITextEditor textEditor = this.getTextEditor(part);
            ILineBreakpoint breakpoint = BreakpointUtils.findLineBreakpoint((ITextEditor)textEditor, (int)(lineNumber = (textSelection = (ITextSelection)selection).getStartLine() + 1));
            if (breakpoint != null) {
                breakpoint.delete();
                return;
            }
            if (textEditor instanceof ScriptEditor) {
                ScriptEditor scriptEditor = (ScriptEditor)textEditor;
                try {
                    IDocument doc = scriptEditor.getScriptSourceViewer().getDocument();
                    IRegion region = doc.getLineInformation(lineNumber - 1);
                    String string = doc.get(region.getOffset(), region.getLength());
                    int index = string.indexOf("function");
                    if (index != -1) {
                        int apos = (string = string.substring(index + "function".length()).trim()).indexOf(40);
                        if (apos >= 0) {
                            string = string.substring(0, apos).trim();
                        }
                        BreakpointUtils.addMethodEntryBreakpoint((ITextEditor)textEditor, (int)lineNumber, (String)string);
                        return;
                    }
                }
                catch (BadLocationException e) {
                    DLTKDebugPlugin.log((Throwable)e);
                    return;
                }
            }
            BreakpointUtils.addLineBreakpoint((ITextEditor)textEditor, (int)lineNumber);
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            String text = textSelection.getText();
            if (part instanceof ScriptEditor) {
                ScriptEditor scriptEditor = (ScriptEditor)part;
                try {
                    IDocument doc = scriptEditor.getScriptSourceViewer().getDocument();
                    IRegion region = doc.getLineInformation(textSelection.getStartLine());
                    String string = doc.get(region.getOffset(), region.getLength());
                    return string.indexOf(61) != -1 || string.trim().startsWith("var ");
                }
                catch (BadLocationException e) {
                    DLTKUIPlugin.log((Throwable)e);
                }
            }
            return text.indexOf("=") != -1;
        }
        return true;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextEditor editor = this.getTextEditor(part);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            IResource resource = BreakpointUtils.getBreakpointResource((ITextEditor)editor);
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            for (int i = 0; i < breakpoints.length; ++i) {
                IBreakpoint breakpoint = breakpoints[i];
                if (!resource.equals((Object)breakpoint.getMarker().getResource()) || ((ILineBreakpoint)breakpoint).getLineNumber() != lineNumber) continue;
                breakpoint.delete();
                return;
            }
            if (editor instanceof ScriptEditor) {
                try {
                    ScriptEditor scriptEditor = (ScriptEditor)editor;
                    IDocument doc = scriptEditor.getScriptSourceViewer().getDocument();
                    IRegion region = doc.getLineInformation(lineNumber - 1);
                    String string = doc.get(region.getOffset(), region.getLength());
                    int index = string.indexOf(61);
                    if (index != -1) {
                        string = string.substring(0, index);
                    }
                    if ((index = string.lastIndexOf(46)) != -1) {
                        string = string.substring(index + 1);
                    }
                    if ((index = (string = string.trim()).lastIndexOf(32)) != -1) {
                        string = string.substring(index + 1).trim();
                    }
                    if (string.endsWith(";")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    BreakpointUtils.addWatchPoint((ITextEditor)editor, (int)lineNumber, (String)string);
                }
                catch (BadLocationException e) {
                    DLTKUIPlugin.log((Throwable)e);
                }
            }
        }
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }
}

