/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.authenticator;

import org.apache.fulcrum.security.authenticator.Authenticator;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicUserImpl;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CryptoAuthenticatorTest
extends BaseUnit5Test {
    private static final String preDefinedInput = "Oeltanks";
    private static final String preDefinedResult = "XBSqev4ilv7P7852G2rL5WgX3FLy8VzfOY+tVq+xjek=";

    @BeforeEach
    public void setUp() {
        try {
            this.setRoleFileName("src/test/CryptoRoleConfig.xml");
            this.setConfigurationFileName("src/test/CryptoComponentConfig.xml");
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testAuthenticate() throws Exception {
        DynamicUserImpl user = new DynamicUserImpl();
        user.setName("Bob");
        user.setPassword(preDefinedResult);
        Authenticator authenticator = (Authenticator)this.lookup(Authenticator.ROLE);
        Assert.assertTrue((boolean)authenticator.authenticate((User)user, preDefinedInput));
        Assert.assertFalse((boolean)authenticator.authenticate((User)user, "mypassword"));
    }
}

