/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.servlet;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Set;
import org.apache.tomee.security.cdi.TomEESecurityExtension;
import org.apache.tomee.security.provider.TomEESecurityAuthConfigProvider;

public class TomEESecurityServletContainerInitializer
implements ServletContainerInitializer,
ServletContextListener {
    public static final String CONTEXT_REGISTRATION_ID = "org.apache.tomee.security.message.registrationId";

    public void onStartup(Set<Class<?>> c, final ServletContext ctx) throws ServletException {
        String registrationId;
        TomEESecurityExtension securityExtension;
        try {
            BeanManager beanManager = this.getBeanManager();
            securityExtension = (TomEESecurityExtension)beanManager.getExtension(TomEESecurityExtension.class);
        }
        catch (IllegalStateException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (securityExtension.hasAuthenticationMechanisms() && (registrationId = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return AuthConfigFactory.getFactory().registerConfigProvider((AuthConfigProvider)new TomEESecurityAuthConfigProvider(new HashMap(), null), "HttpServlet", ctx.getVirtualServerName() + " " + ctx.getContextPath(), "TomEE Security JSR-375");
            }
        })) != null) {
            ctx.setAttribute(CONTEXT_REGISTRATION_ID, (Object)registrationId);
        }
    }

    private BeanManager getBeanManager() throws IllegalStateException {
        return CDI.current().getBeanManager();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        final String registrationId = (String)sce.getServletContext().getAttribute(CONTEXT_REGISTRATION_ID);
        if (registrationId != null && registrationId.length() > 0) {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return AuthConfigFactory.getFactory().removeRegistration(registrationId);
                }
            });
        }
    }
}

