/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.ejb.EJBContext;
import jakarta.ejb.MessageDrivenBean;
import jakarta.resource.spi.UnavailableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.InstanceContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbContext;
import org.apache.openejb.core.timer.TimerServiceWrapper;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MdbInstanceFactory {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final BeanContext beanContext;
    private final int instanceLimit;
    private int instanceCount;
    private final MdbContext mdbContext;

    public MdbInstanceFactory(BeanContext beanContext, SecurityService securityService, int instanceLimit) throws OpenEJBException {
        this.beanContext = beanContext;
        this.instanceLimit = instanceLimit;
        this.mdbContext = new MdbContext(securityService);
        try {
            Context context = beanContext.getJndiEnc();
            context.bind("comp/EJBContext", (Object)this.mdbContext);
            context.bind("comp/TimerService", (Object)new TimerServiceWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Failed to bind EJBContext/TimerService", e);
        }
        beanContext.set(EJBContext.class, this.mdbContext);
    }

    public int getInstanceLimit() {
        return this.instanceLimit;
    }

    public synchronized int getInstanceCount() {
        return this.instanceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createInstance(boolean ignoreInstanceCount) throws UnavailableException {
        if (!ignoreInstanceCount) {
            MdbInstanceFactory mdbInstanceFactory = this;
            synchronized (mdbInstanceFactory) {
                if (this.instanceLimit > 0 && this.instanceCount >= this.instanceLimit) {
                    throw new UnavailableException("Only " + this.instanceLimit + " instances can be created");
                }
                ++this.instanceCount;
            }
        }
        try {
            Object bean = this.constructBean();
            return bean;
        }
        catch (UnavailableException e) {
            if (!ignoreInstanceCount) {
                MdbInstanceFactory mdbInstanceFactory = this;
                synchronized (mdbInstanceFactory) {
                    --this.instanceCount;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeInstance(Instance instance, boolean ignoredInstanceCount) {
        ThreadContext callContext;
        if (instance == null) {
            throw new NullPointerException("bean is null");
        }
        if (!ignoredInstanceCount) {
            MdbInstanceFactory mdbInstanceFactory = this;
            synchronized (mdbInstanceFactory) {
                --this.instanceCount;
            }
        }
        Operation originalOperation = (callContext = ThreadContext.getThreadContext()) == null ? null : callContext.getCurrentOperation();
        BaseContext.State[] originalAllowedStates = callContext == null ? null : callContext.getCurrentAllowedStates();
        try {
            if (callContext != null) {
                callContext.setCurrentOperation(Operation.PRE_DESTROY);
            }
            Method remove = instance.bean instanceof MessageDrivenBean ? MessageDrivenBean.class.getMethod("ejbRemove", new Class[0]) : null;
            List<InterceptorData> callbackInterceptors = this.beanContext.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
            interceptorStack.invoke(new Object[0]);
            if (instance.creationalContext != null) {
                instance.creationalContext.release();
            }
        }
        catch (Throwable re) {
            logger.error("The bean instance " + instance.bean + " threw a system exception:" + re, re);
        }
        finally {
            if (callContext != null) {
                callContext.setCurrentOperation(originalOperation);
                callContext.setCurrentAllowedStates(originalAllowedStates);
            }
        }
    }

    public Object recreateInstance(Object bean) throws UnavailableException {
        if (bean == null) {
            throw new NullPointerException("bean is null");
        }
        Object newBean = this.constructBean();
        return newBean;
    }

    private Object constructBean() throws UnavailableException {
        BeanContext beanContext = this.beanContext;
        ThreadContext callContext = new ThreadContext(beanContext, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        try {
            Object create;
            InstanceContext context = beanContext.newInstance();
            if (context.getBean() instanceof MessageDrivenBean) {
                callContext.setCurrentOperation(Operation.CREATE);
                create = beanContext.getCreateMethod();
                InterceptorStack ejbCreate = new InterceptorStack(context.getBean(), (Method)create, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                ejbCreate.invoke(new Object[0]);
            }
            create = new Instance(context.getBean(), context.getInterceptors(), context.getCreationalContext());
            return create;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            String message = "The bean instance threw a system exception:" + e;
            logger.error(message, e);
            throw new UnavailableException(message, e);
        }
        finally {
            ThreadContext.exit(oldContext);
        }
    }
}

