/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.modelresolver.impl;

import java.util.Properties;
import org.apache.batchee.container.jsl.ExecutionElement;
import org.apache.batchee.container.modelresolver.PropertyResolverFactory;
import org.apache.batchee.container.modelresolver.impl.AbstractPropertyResolver;
import org.apache.batchee.jaxb.Decision;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.Listener;
import org.apache.batchee.jaxb.Split;
import org.apache.batchee.jaxb.Step;

public class JobPropertyResolver
extends AbstractPropertyResolver<JSLJob> {
    public JobPropertyResolver(boolean isPartitionStep) {
        super(isPartitionStep);
    }

    @Override
    public JSLJob substituteProperties(JSLJob job, Properties submittedProps, Properties parentProps) {
        job.setId(this.replaceAllProperties(job.getId(), submittedProps, parentProps));
        job.setRestartable(this.replaceAllProperties(job.getRestartable(), submittedProps, parentProps));
        Properties currentProps = null;
        if (job.getProperties() != null) {
            currentProps = this.resolveElementProperties(job.getProperties().getPropertyList(), submittedProps, parentProps);
        }
        if (job.getListeners() != null) {
            for (Listener listener : job.getListeners().getListenerList()) {
                PropertyResolverFactory.createListenerPropertyResolver(this.isPartitionedStep).substituteProperties(listener, submittedProps, currentProps);
            }
        }
        for (ExecutionElement next : job.getExecutionElements()) {
            if (next instanceof Step) {
                PropertyResolverFactory.createStepPropertyResolver(this.isPartitionedStep).substituteProperties((Step)next, submittedProps, currentProps);
                continue;
            }
            if (next instanceof Decision) {
                PropertyResolverFactory.createDecisionPropertyResolver(this.isPartitionedStep).substituteProperties((Decision)next, submittedProps, currentProps);
                continue;
            }
            if (next instanceof Split) {
                PropertyResolverFactory.createSplitPropertyResolver(this.isPartitionedStep).substituteProperties((Split)next, submittedProps, currentProps);
                continue;
            }
            if (!(next instanceof Flow)) continue;
            PropertyResolverFactory.createFlowPropertyResolver(this.isPartitionedStep).substituteProperties((Flow)next, submittedProps, currentProps);
        }
        return job;
    }
}

