/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;

@ChannelHandler.Sharable
public class HttpRequestIdHandler
extends ChannelDuplexHandler {
    private static final AttributeKey<Boolean> IN_USE = AttributeKey.valueOf((String)"inUse");
    public static String REQUEST_ID_HEADER_NAME = "Gremlin-RequestId";

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            Boolean currentlyInUse = (Boolean)ctx.channel().attr(IN_USE).get();
            if (currentlyInUse != null && currentlyInUse.booleanValue()) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            ctx.channel().attr(StateKey.REQUEST_ID).set((Object)UUID.randomUUID());
            ctx.channel().attr(IN_USE).set((Object)true);
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().attr(IN_USE).set((Object)false);
        super.exceptionCaught(ctx, cause);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            response.headers().add(REQUEST_ID_HEADER_NAME, ctx.channel().attr(StateKey.REQUEST_ID).get());
        }
        if (msg instanceof LastHttpContent) {
            ctx.channel().attr(IN_USE).set((Object)false);
        }
        ctx.write(msg, promise);
    }
}

