/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.DocumentSampleStream;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class DocumentSampleStreamFactory<P>
extends AbstractSampleStreamFactory<DocumentSample, P> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(DocumentSample.class, "opennlp", new DocumentSampleStreamFactory<Parameters>(Parameters.class));
    }

    protected DocumentSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<DocumentSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new DocumentSampleStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

