/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;
import opennlp.tools.cmdline.chunker.ChunkerConverterTool;
import opennlp.tools.cmdline.chunker.ChunkerCrossValidatorTool;
import opennlp.tools.cmdline.chunker.ChunkerEvaluatorTool;
import opennlp.tools.cmdline.chunker.ChunkerMETool;
import opennlp.tools.cmdline.chunker.ChunkerTrainerTool;
import opennlp.tools.cmdline.dictionary.DictionaryBuilderTool;
import opennlp.tools.cmdline.doccat.DoccatConverterTool;
import opennlp.tools.cmdline.doccat.DoccatCrossValidatorTool;
import opennlp.tools.cmdline.doccat.DoccatEvaluatorTool;
import opennlp.tools.cmdline.doccat.DoccatTool;
import opennlp.tools.cmdline.doccat.DoccatTrainerTool;
import opennlp.tools.cmdline.entitylinker.EntityLinkerTool;
import opennlp.tools.cmdline.langdetect.LanguageDetectorConverterTool;
import opennlp.tools.cmdline.langdetect.LanguageDetectorCrossValidatorTool;
import opennlp.tools.cmdline.langdetect.LanguageDetectorEvaluatorTool;
import opennlp.tools.cmdline.langdetect.LanguageDetectorTool;
import opennlp.tools.cmdline.langdetect.LanguageDetectorTrainerTool;
import opennlp.tools.cmdline.languagemodel.NGramLanguageModelTool;
import opennlp.tools.cmdline.lemmatizer.LemmatizerEvaluatorTool;
import opennlp.tools.cmdline.lemmatizer.LemmatizerMETool;
import opennlp.tools.cmdline.lemmatizer.LemmatizerTrainerTool;
import opennlp.tools.cmdline.namefind.CensusDictionaryCreatorTool;
import opennlp.tools.cmdline.namefind.TokenNameFinderConverterTool;
import opennlp.tools.cmdline.namefind.TokenNameFinderCrossValidatorTool;
import opennlp.tools.cmdline.namefind.TokenNameFinderEvaluatorTool;
import opennlp.tools.cmdline.namefind.TokenNameFinderTool;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.parser.BuildModelUpdaterTool;
import opennlp.tools.cmdline.parser.CheckModelUpdaterTool;
import opennlp.tools.cmdline.parser.ParserConverterTool;
import opennlp.tools.cmdline.parser.ParserEvaluatorTool;
import opennlp.tools.cmdline.parser.ParserTool;
import opennlp.tools.cmdline.parser.ParserTrainerTool;
import opennlp.tools.cmdline.parser.TaggerModelReplacerTool;
import opennlp.tools.cmdline.postag.POSTaggerConverterTool;
import opennlp.tools.cmdline.postag.POSTaggerCrossValidatorTool;
import opennlp.tools.cmdline.postag.POSTaggerEvaluatorTool;
import opennlp.tools.cmdline.postag.POSTaggerTool;
import opennlp.tools.cmdline.postag.POSTaggerTrainerTool;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorConverterTool;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorCrossValidatorTool;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorEvaluatorTool;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTool;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.tokenizer.DictionaryDetokenizerTool;
import opennlp.tools.cmdline.tokenizer.SimpleTokenizerTool;
import opennlp.tools.cmdline.tokenizer.TokenizerConverterTool;
import opennlp.tools.cmdline.tokenizer.TokenizerCrossValidatorTool;
import opennlp.tools.cmdline.tokenizer.TokenizerMEEvaluatorTool;
import opennlp.tools.cmdline.tokenizer.TokenizerMETool;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CLI {
    private static final Logger logger = LoggerFactory.getLogger(CLI.class);
    public static final String CMD = "opennlp";
    private static Map<String, CmdLineTool> toolLookupMap = new LinkedHashMap<String, CmdLineTool>();

    public static Set<String> getToolNames() {
        return toolLookupMap.keySet();
    }

    public static Map<String, CmdLineTool> getToolLookupMap() {
        return toolLookupMap;
    }

    private static void usage() {
        logger.info("OpenNLP {}.", (Object)Version.currentVersion());
        logger.info("Usage: {} TOOL", (Object)CMD);
        int numberOfSpaces = -1;
        for (String toolName : toolLookupMap.keySet()) {
            if (toolName.length() <= numberOfSpaces) continue;
            numberOfSpaces = toolName.length();
        }
        numberOfSpaces += 4;
        StringBuilder sb = new StringBuilder("where TOOL is one of: \n\n");
        for (CmdLineTool tool : toolLookupMap.values()) {
            sb.append("  ").append(tool.getName());
            for (int i = 0; i < StrictMath.abs(tool.getName().length() - numberOfSpaces); ++i) {
                sb.append(" ");
            }
            sb.append(tool.getShortDescription()).append("\n");
        }
        logger.info(sb.toString());
        logger.info("All tools print help when invoked with help parameter");
        logger.info("Example: opennlp SimpleTokenizer help");
    }

    public static void main(String[] args) {
        long startTime;
        block12: {
            if (args.length == 0) {
                CLI.usage();
                System.exit(0);
            }
            startTime = System.currentTimeMillis();
            String[] toolArguments = new String[args.length - 1];
            System.arraycopy(args, 1, toolArguments, 0, toolArguments.length);
            String toolName = args[0];
            String formatName = CMD;
            int idx = toolName.indexOf(".");
            if (-1 < idx) {
                formatName = toolName.substring(idx + 1);
                toolName = toolName.substring(0, idx);
            }
            CmdLineTool tool = toolLookupMap.get(toolName);
            try {
                if (null == tool) {
                    throw new TerminateToolException(1, "Tool " + toolName + " is not found.");
                }
                if (0 == toolArguments.length && tool.hasParams() || 0 < toolArguments.length && "help".equals(toolArguments[0])) {
                    if (tool instanceof TypedCmdLineTool) {
                        logger.info(((TypedCmdLineTool)tool).getHelp(formatName));
                    } else if (tool instanceof BasicCmdLineTool) {
                        logger.info(tool.getHelp());
                    }
                    System.exit(0);
                }
                if (tool instanceof TypedCmdLineTool) {
                    ((TypedCmdLineTool)tool).run(formatName, toolArguments);
                    break block12;
                }
                if (tool instanceof BasicCmdLineTool) {
                    if (-1 == idx) {
                        ((BasicCmdLineTool)tool).run(toolArguments);
                        break block12;
                    }
                    throw new TerminateToolException(1, "Tool " + toolName + " does not support formats.");
                }
                throw new TerminateToolException(1, "Tool " + toolName + " is not supported.");
            }
            catch (TerminateToolException e) {
                logger.error(e.getLocalizedMessage(), e);
                System.exit(e.getCode());
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info(String.format("Execution time: %.3f seconds\n", (double)(endTime - startTime) / 1000.0));
    }

    static {
        LinkedList<CmdLineTool> tools = new LinkedList<CmdLineTool>();
        tools.add(new DoccatTool());
        tools.add(new DoccatTrainerTool());
        tools.add(new DoccatEvaluatorTool());
        tools.add(new DoccatCrossValidatorTool());
        tools.add(new DoccatConverterTool());
        tools.add(new LanguageDetectorTool());
        tools.add(new LanguageDetectorTrainerTool());
        tools.add(new LanguageDetectorConverterTool());
        tools.add(new LanguageDetectorCrossValidatorTool());
        tools.add(new LanguageDetectorEvaluatorTool());
        tools.add(new DictionaryBuilderTool());
        tools.add(new SimpleTokenizerTool());
        tools.add(new TokenizerMETool());
        tools.add(new TokenizerTrainerTool());
        tools.add(new TokenizerMEEvaluatorTool());
        tools.add(new TokenizerCrossValidatorTool());
        tools.add(new TokenizerConverterTool());
        tools.add(new DictionaryDetokenizerTool());
        tools.add(new SentenceDetectorTool());
        tools.add(new SentenceDetectorTrainerTool());
        tools.add(new SentenceDetectorEvaluatorTool());
        tools.add(new SentenceDetectorCrossValidatorTool());
        tools.add(new SentenceDetectorConverterTool());
        tools.add(new TokenNameFinderTool());
        tools.add(new TokenNameFinderTrainerTool());
        tools.add(new TokenNameFinderEvaluatorTool());
        tools.add(new TokenNameFinderCrossValidatorTool());
        tools.add(new TokenNameFinderConverterTool());
        tools.add(new CensusDictionaryCreatorTool());
        tools.add(new POSTaggerTool());
        tools.add(new POSTaggerTrainerTool());
        tools.add(new POSTaggerEvaluatorTool());
        tools.add(new POSTaggerCrossValidatorTool());
        tools.add(new POSTaggerConverterTool());
        tools.add(new LemmatizerMETool());
        tools.add(new LemmatizerTrainerTool());
        tools.add(new LemmatizerEvaluatorTool());
        tools.add(new ChunkerMETool());
        tools.add(new ChunkerTrainerTool());
        tools.add(new ChunkerEvaluatorTool());
        tools.add(new ChunkerCrossValidatorTool());
        tools.add(new ChunkerConverterTool());
        tools.add(new ParserTool());
        tools.add(new ParserTrainerTool());
        tools.add(new ParserEvaluatorTool());
        tools.add(new ParserConverterTool());
        tools.add(new BuildModelUpdaterTool());
        tools.add(new CheckModelUpdaterTool());
        tools.add(new TaggerModelReplacerTool());
        tools.add(new EntityLinkerTool());
        tools.add(new NGramLanguageModelTool());
        for (CmdLineTool tool : tools) {
            toolLookupMap.put(tool.getName(), tool);
        }
        toolLookupMap = Collections.unmodifiableMap(toolLookupMap);
    }
}

