/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import jcuda.Pointer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.context.ExecutionConfig;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.utils.GPUStatistics;

public class MatrixReshapeGPUInstruction
extends GPUInstruction {
    private final CPOperand _opRows;
    private final CPOperand _opCols;
    private final CPOperand _opByRow;

    protected MatrixReshapeGPUInstruction(Operator op, String opcode, String istr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out) {
        super(op, in1, null, out, opcode, istr);
        this._opRows = in2;
        this._opCols = in3;
        this._opByRow = in4;
    }

    public static MatrixReshapeGPUInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 6);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand in4 = new CPOperand(parts[5]);
        CPOperand out = new CPOperand(parts[6]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MatrixReshapeGPUInstruction: " + str);
        }
        return new MatrixReshapeGPUInstruction(new ReorgOperator(SwapIndex.getSwapIndexFnObject()), opcode, str, in1, in2, in3, in4, out);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        int rows = (int)ec.getScalarInput(this._opRows).getLongValue();
        int cols = (int)ec.getScalarInput(this._opCols).getLongValue();
        BooleanObject byRow = (BooleanObject)ec.getScalarInput(this._opByRow.getName(), Types.ValueType.BOOLEAN, this._opByRow.isLiteral());
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String instName = this.getExtendedOpcode();
        GPUContext gCtx = ec.getGPUContext(0);
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        if ((long)(rows * cols) != mat.getNumRows() * mat.getNumColumns()) {
            throw new DMLRuntimeException("Incorrect number of rows and cols in rshape instruction");
        }
        Pointer inPtr = LibMatrixCUDA.getDensePointer(gCtx, mat, instName);
        MatrixObject out = LibMatrixCUDA.getDenseMatrixOutputForGPUInstruction(ec, instName, this._output.getName(), rows, cols, false);
        Pointer outPtr = LibMatrixCUDA.getDensePointer(gCtx, out, instName);
        if (byRow.getBooleanValue()) {
            LibMatrixCUDA.deviceCopy(instName, inPtr, outPtr, LibMatrixCUDA.toInt(mat.getNumRows()), LibMatrixCUDA.toInt(mat.getNumColumns()));
        } else {
            LibMatrixCUDA.getCudaKernels(gCtx).launchKernel("colwise_reshape", ExecutionConfig.getConfigForSimpleVectorOperations(LibMatrixCUDA.toInt(rows * cols)), inPtr, outPtr, LibMatrixCUDA.toInt(rows * cols), LibMatrixCUDA.toInt(mat.getNumRows()), LibMatrixCUDA.toInt(mat.getNumColumns()), rows, cols);
        }
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this._output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this._input1, this._opRows, this._opCols, this._opByRow)));
    }
}

