/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.cost.InstructionTypeCounter;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;

public class FederatedWorkloadAnalyzer {
    protected static final Log LOG = LogFactory.getLog((String)FederatedWorkloadAnalyzer.class.getName());
    private static final int compressRunFrequency = 10;
    private final ConcurrentHashMap<Long, ConcurrentHashMap<Long, InstructionTypeCounter>> m = new ConcurrentHashMap();
    private int counter = 0;

    public void incrementWorkload(ExecutionContext ec, long tid, Instruction ins) {
        if (ins instanceof ComputationCPInstruction) {
            this.incrementWorkload(ec, tid, (ComputationCPInstruction)ins);
        }
    }

    public void compressRun(ExecutionContext ec, long tid) {
        if (this.counter >= 10) {
            this.counter = 0;
            this.get(tid).forEach((K2, V) -> CompressedMatrixBlockFactory.compressAsync(ec, Long.toString(K2), V));
        }
    }

    private void incrementWorkload(ExecutionContext ec, long tid, ComputationCPInstruction cpIns) {
        this.incrementWorkload(ec, this.get(tid), cpIns);
    }

    public void incrementWorkload(ExecutionContext ec, ConcurrentHashMap<Long, InstructionTypeCounter> mm, ComputationCPInstruction cpIns) {
        if (cpIns instanceof AggregateBinaryCPInstruction) {
            String n1 = cpIns.input1.getName();
            MatrixObject d1 = (MatrixObject)ec.getCacheableData(n1);
            String n2 = cpIns.input2.getName();
            MatrixObject d2 = (MatrixObject)ec.getCacheableData(n2);
            int r1 = (int)d1.getDim(0);
            int c1 = (int)d1.getDim(1);
            int r2 = (int)d2.getDim(0);
            int c2 = (int)d2.getDim(1);
            if (FederatedWorkloadAnalyzer.validSize(r1, c1)) {
                FederatedWorkloadAnalyzer.getOrMakeCounter(mm, Long.parseLong(n1)).incRMM(c2);
                FederatedWorkloadAnalyzer.getOrMakeCounter(mm, Long.parseLong(n1)).incOverlappingDecompressions();
                ++this.counter;
            }
            if (FederatedWorkloadAnalyzer.validSize(r2, c2)) {
                FederatedWorkloadAnalyzer.getOrMakeCounter(mm, Long.parseLong(n2)).incLMM(r1);
                ++this.counter;
            }
        }
    }

    private static InstructionTypeCounter getOrMakeCounter(ConcurrentHashMap<Long, InstructionTypeCounter> mm, long id) {
        if (mm.containsKey(id)) {
            return mm.get(id);
        }
        InstructionTypeCounter r = new InstructionTypeCounter();
        mm.put(id, r);
        return r;
    }

    private ConcurrentHashMap<Long, InstructionTypeCounter> get(long tid) {
        if (this.m.containsKey(tid)) {
            return this.m.get(tid);
        }
        ConcurrentHashMap<Long, InstructionTypeCounter> r = new ConcurrentHashMap<Long, InstructionTypeCounter>();
        this.m.put(tid, r);
        return r;
    }

    private static boolean validSize(int nRow, int nCol) {
        return nRow > 90 && nRow >= nCol;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("  Counter: ");
        sb.append(this.counter);
        sb.append("\n");
        sb.append(this.m);
        return sb.toString();
    }
}

