/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLException;
import org.apache.sysds.runtime.DMLRuntimeException;

public class FederatedSSLUtil {
    private static SslContextMan sslInstance = null;

    private FederatedSSLUtil() {
    }

    protected static SslContextMan SslConstructor() {
        if (sslInstance == null) {
            return new SslContextMan();
        }
        return sslInstance;
    }

    protected static SslHandler createSSLHandler(SocketChannel ch, InetSocketAddress address) {
        return FederatedSSLUtil.SslConstructor().context.newHandler(ch.alloc(), address.getAddress().getHostAddress(), address.getPort());
    }

    private static class SslContextMan {
        protected final SslContext context;

        private SslContextMan() {
            try {
                this.context = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new DMLRuntimeException("Static SSL setup failed for client side", e);
            }
        }
    }
}

