/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.common;

import java.util.Arrays;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.runtime.DMLRuntimeException;

public interface Types {

    public static interface FunctionBlock {
        public FunctionBlock cloneFunctionBlock();
    }

    public static enum FileFormat {
        TEXT,
        MM,
        CSV,
        COMPRESSED,
        LIBSVM,
        JSONL,
        BINARY,
        FEDERATED,
        PROTO,
        HDF5,
        COG,
        UNKNOWN;


        public boolean isIJV() {
            return this == TEXT || this == MM;
        }

        public boolean isTextFormat() {
            return this != BINARY && this != COMPRESSED;
        }

        public static boolean isTextFormat(String fmt) {
            try {
                return FileFormat.valueOf(fmt.toUpperCase()).isTextFormat();
            }
            catch (Exception ex) {
                return false;
            }
        }

        public boolean isDelimitedFormat() {
            return this == CSV || this == LIBSVM;
        }

        public static boolean isDelimitedFormat(String fmt) {
            try {
                return FileFormat.valueOf(fmt.toUpperCase()).isDelimitedFormat();
            }
            catch (Exception ex) {
                return false;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static FileFormat defaultFormat() {
            return TEXT;
        }

        public static String defaultFormatString() {
            return FileFormat.defaultFormat().toString();
        }

        public static FileFormat safeValueOf(String fmt) {
            try {
                return FileFormat.valueOf(fmt.toUpperCase());
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Unknown file format: " + fmt + " (valid values: " + Arrays.toString((Object[])FileFormat.values()) + ")");
            }
        }
    }

    public static enum OpOpData {
        PERSISTENTREAD,
        PERSISTENTWRITE,
        TRANSIENTREAD,
        TRANSIENTWRITE,
        FUNCTIONOUTPUT,
        SQLREAD,
        FEDERATED;


        public boolean isTransient() {
            return this == TRANSIENTREAD || this == TRANSIENTWRITE;
        }

        public boolean isPersistent() {
            return this == PERSISTENTREAD || this == PERSISTENTWRITE;
        }

        public boolean isWrite() {
            return this == TRANSIENTWRITE || this == PERSISTENTWRITE;
        }

        public boolean isRead() {
            return this == TRANSIENTREAD || this == PERSISTENTREAD;
        }

        public String toString() {
            switch (this) {
                case PERSISTENTREAD: {
                    return "PRead";
                }
                case PERSISTENTWRITE: {
                    return "PWrite";
                }
                case TRANSIENTREAD: {
                    return "TRead";
                }
                case TRANSIENTWRITE: {
                    return "TWrite";
                }
                case FUNCTIONOUTPUT: {
                    return "FunOut";
                }
                case SQLREAD: {
                    return Opcodes.SQL.toString();
                }
                case FEDERATED: {
                    return "Fed";
                }
            }
            return "Invalid";
        }
    }

    public static enum OpOpDG {
        RAND,
        SEQ,
        FRAMEINIT,
        SINIT,
        SAMPLE,
        TIME;

    }

    public static enum OpOpDnn {
        MAX_POOL,
        MAX_POOL_BACKWARD,
        AVG_POOL,
        AVG_POOL_BACKWARD,
        CONV2D,
        CONV2D_BACKWARD_FILTER,
        CONV2D_BACKWARD_DATA,
        BIASADD,
        BIASMULT,
        BATCH_NORM2D_TEST,
        CHANNEL_SUMS,
        UPDATE_NESTEROV_X,
        CONV2D_BIAS_ADD,
        RELU_MAX_POOL,
        RELU_MAX_POOL_BACKWARD,
        RELU_BACKWARD;

    }

    public static enum ParamBuiltinOp {
        AUTODIFF,
        CDF,
        CONTAINS,
        INVALID,
        INVCDF,
        GROUPEDAGG,
        RMEMPTY,
        REPLACE,
        REXPAND,
        LOWER_TRI,
        UPPER_TRI,
        TRANSFORMAPPLY,
        TRANSFORMDECODE,
        TRANSFORMCOLMAP,
        TRANSFORMMETA,
        TOKENIZE,
        TOSTRING,
        LIST,
        PARAMSERV;

    }

    public static enum ReOrgOp {
        DIAG,
        RESHAPE,
        REV,
        ROLL,
        SORT,
        TRANS;


        public boolean preservesValues() {
            return this != DIAG && this != SORT;
        }

        public String toString() {
            switch (this) {
                case DIAG: {
                    return Opcodes.DIAG.toString();
                }
                case TRANS: {
                    return Opcodes.TRANSPOSE.toString();
                }
                case RESHAPE: {
                    return Opcodes.RESHAPE.toString();
                }
            }
            return this.name().toLowerCase();
        }

        public static ReOrgOp valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "rdiag": {
                    return DIAG;
                }
                case "r'": {
                    return TRANS;
                }
                case "rshape": {
                    return RESHAPE;
                }
            }
            return ReOrgOp.valueOf(opcode.toUpperCase());
        }
    }

    public static enum OpOpN {
        PRINTF,
        CBIND,
        RBIND,
        MIN,
        MAX,
        PLUS,
        MULT,
        EVAL,
        LIST;


        public boolean isCellOp() {
            return this == MIN || this == MAX || this == PLUS || this == MULT;
        }
    }

    public static enum OpOp4 {
        WSLOSS,
        WSIGMOID,
        WDIVMM,
        WCEMM,
        WUMM;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum OpOp3 {
        QUANTILE,
        INTERQUANTILE,
        CTABLE,
        MOMENT,
        COV,
        PLUS_MULT,
        MINUS_MULT,
        IFELSE,
        MAP;


        public String toString() {
            switch (this) {
                case MOMENT: {
                    return Opcodes.CM.toString();
                }
                case PLUS_MULT: {
                    return Opcodes.PM.toString();
                }
                case MINUS_MULT: {
                    return Opcodes.MINUSMULT.toString();
                }
                case MAP: {
                    return Opcodes.MAP.toString();
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp3 valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "cm": {
                    return MOMENT;
                }
                case "+*": {
                    return PLUS_MULT;
                }
                case "-*": {
                    return MINUS_MULT;
                }
                case "_map": {
                    return MAP;
                }
            }
            return OpOp3.valueOf(opcode.toUpperCase());
        }
    }

    public static enum OpOp2 {
        AND(true),
        APPLY_SCHEMA(false),
        BITWAND(true),
        BITWOR(true),
        BITWSHIFTL(true),
        BITWSHIFTR(true),
        BITWXOR(true),
        CBIND(false),
        COMPRESS(true),
        CONCAT(false),
        COV(false),
        DIV(true),
        DROP_INVALID_TYPE(false),
        DROP_INVALID_LENGTH(false),
        EQUAL(true),
        FRAME_ROW_REPLICATE(true),
        GREATER(true),
        GREATEREQUAL(true),
        INTDIV(true),
        INTERQUANTILE(false),
        IQM(false),
        LESS(true),
        LESSEQUAL(true),
        LOG(true),
        MAX(true),
        MEDIAN(false),
        MIN(true),
        MINUS(true),
        MODULUS(true),
        MOMENT(false),
        MULT(true),
        NOTEQUAL(true),
        OR(true),
        PLUS(true),
        POW(true),
        PRINT(false),
        QUANTILE(false),
        SOLVE(false),
        RBIND(false),
        VALUE_SWAP(false),
        XOR(true),
        CAST_AS_FRAME(false),
        MINUS_NZ(false),
        LOG_NZ(false),
        MINUS1_MULT(false);

        private final boolean _validOuter;

        private OpOp2(boolean outer) {
            this._validOuter = outer;
        }

        public boolean isValidOuter() {
            return this._validOuter;
        }

        public String toString() {
            switch (this) {
                case PLUS: {
                    return Opcodes.PLUS.toString();
                }
                case MINUS: {
                    return Opcodes.MINUS.toString();
                }
                case MINUS_NZ: {
                    return Opcodes.MINUS_NZ.toString();
                }
                case MINUS1_MULT: {
                    return Opcodes.MINUS1_MULT.toString();
                }
                case MULT: {
                    return Opcodes.MULT.toString();
                }
                case DIV: {
                    return Opcodes.DIV.toString();
                }
                case MODULUS: {
                    return Opcodes.MODULUS.toString();
                }
                case INTDIV: {
                    return Opcodes.INTDIV.toString();
                }
                case LESSEQUAL: {
                    return Opcodes.LESSEQUAL.toString();
                }
                case LESS: {
                    return Opcodes.LESS.toString();
                }
                case GREATEREQUAL: {
                    return Opcodes.GREATEREQUAL.toString();
                }
                case GREATER: {
                    return Opcodes.GREATER.toString();
                }
                case EQUAL: {
                    return Opcodes.EQUAL.toString();
                }
                case NOTEQUAL: {
                    return Opcodes.NOTEQUAL.toString();
                }
                case OR: {
                    return Opcodes.OR.toString();
                }
                case AND: {
                    return Opcodes.AND.toString();
                }
                case POW: {
                    return Opcodes.POW.toString();
                }
                case IQM: {
                    return "IQM";
                }
                case MOMENT: {
                    return Opcodes.CM.toString();
                }
                case BITWAND: {
                    return Opcodes.BITWAND.toString();
                }
                case BITWOR: {
                    return Opcodes.BITWOR.toString();
                }
                case BITWXOR: {
                    return Opcodes.BITWXOR.toString();
                }
                case BITWSHIFTL: {
                    return Opcodes.BITWSHIFTL.toString();
                }
                case BITWSHIFTR: {
                    return Opcodes.BITWSHIFTR.toString();
                }
                case DROP_INVALID_TYPE: {
                    return Opcodes.DROPINVALIDTYPE.toString();
                }
                case DROP_INVALID_LENGTH: {
                    return Opcodes.DROPINVALIDLENGTH.toString();
                }
                case FRAME_ROW_REPLICATE: {
                    return Opcodes.FREPLICATE.toString();
                }
                case VALUE_SWAP: {
                    return Opcodes.VALUESWAP.toString();
                }
                case APPLY_SCHEMA: {
                    return Opcodes.APPLYSCHEMA.toString();
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp2 valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "+": {
                    return PLUS;
                }
                case "-": {
                    return MINUS;
                }
                case "-nz": {
                    return MINUS_NZ;
                }
                case "1-*": {
                    return MINUS1_MULT;
                }
                case "*": {
                    return MULT;
                }
                case "/": {
                    return DIV;
                }
                case "%%": {
                    return MODULUS;
                }
                case "%/%": {
                    return INTDIV;
                }
                case "<=": {
                    return LESSEQUAL;
                }
                case "<": {
                    return LESS;
                }
                case ">=": {
                    return GREATEREQUAL;
                }
                case ">": {
                    return GREATER;
                }
                case "==": {
                    return EQUAL;
                }
                case "!=": {
                    return NOTEQUAL;
                }
                case "||": {
                    return OR;
                }
                case "&&": {
                    return AND;
                }
                case "^": {
                    return POW;
                }
                case "IQM": {
                    return IQM;
                }
                case "cm": {
                    return MOMENT;
                }
                case "bitwAnd": {
                    return BITWAND;
                }
                case "bitwOr": {
                    return BITWOR;
                }
                case "bitwXor": {
                    return BITWXOR;
                }
                case "bitwShiftL": {
                    return BITWSHIFTL;
                }
                case "bitwShiftR": {
                    return BITWSHIFTR;
                }
                case "dropInvalidType": {
                    return DROP_INVALID_TYPE;
                }
                case "dropInvalidLength": {
                    return DROP_INVALID_LENGTH;
                }
                case "freplicate": {
                    return FRAME_ROW_REPLICATE;
                }
                case "valueSwap": {
                    return VALUE_SWAP;
                }
                case "applySchema": {
                    return APPLY_SCHEMA;
                }
            }
            return OpOp2.valueOf(opcode.toUpperCase());
        }
    }

    public static enum OpOp1 {
        ABS,
        ACOS,
        ASIN,
        ASSERT,
        ATAN,
        BROADCAST,
        CAST_AS_FRAME,
        CAST_AS_LIST,
        CAST_AS_MATRIX,
        CAST_AS_SCALAR,
        CAST_AS_BOOLEAN,
        CAST_AS_DOUBLE,
        CAST_AS_INT,
        CEIL,
        CHOLESKY,
        COS,
        COSH,
        CUMMAX,
        CUMMIN,
        CUMPROD,
        CUMSUM,
        CUMSUMPROD,
        DET,
        DETECTSCHEMA,
        COLNAMES,
        EIGEN,
        EXISTS,
        EXP,
        FLOOR,
        INVERSE,
        IQM,
        ISNA,
        ISNAN,
        ISINF,
        LENGTH,
        LINEAGE,
        LOG,
        NCOL,
        NOT,
        NROW,
        MEDIAN,
        PREFETCH,
        PRINT,
        ROUND,
        SIN,
        SINH,
        SIGN,
        SOFTMAX,
        SQRT,
        STOP,
        _EVICT,
        SVD,
        TAN,
        TANH,
        TYPEOF,
        TRIGREMOTE,
        SQRT_MATRIX_JAVA,
        SPROP,
        SIGMOID,
        LOG_NZ,
        COMPRESS,
        DECOMPRESS,
        LOCAL,
        MULT2,
        MINUS1_MULT,
        MINUS_RIGHT,
        POW2,
        SUBTRACT_NZ;


        public boolean isScalarOutput() {
            return this == CAST_AS_SCALAR || this == DET || this == NROW || this == NCOL || this == LENGTH || this == EXISTS || this == IQM || this == LINEAGE || this == MEDIAN;
        }

        public String toString() {
            switch (this) {
                case CAST_AS_SCALAR: {
                    return "castdts";
                }
                case CAST_AS_MATRIX: {
                    return "castdtm";
                }
                case CAST_AS_FRAME: {
                    return "castdtf";
                }
                case CAST_AS_LIST: {
                    return "castdtl";
                }
                case CAST_AS_DOUBLE: {
                    return "castvtd";
                }
                case CAST_AS_INT: {
                    return "castvti";
                }
                case CAST_AS_BOOLEAN: {
                    return "castvtb";
                }
                case CUMMAX: {
                    return Opcodes.UCUMMAX.toString();
                }
                case CUMMIN: {
                    return Opcodes.UCUMMIN.toString();
                }
                case CUMPROD: {
                    return Opcodes.UCUMM.toString();
                }
                case CUMSUM: {
                    return Opcodes.UCUMKP.toString();
                }
                case CUMSUMPROD: {
                    return Opcodes.UCUMKPM.toString();
                }
                case DET: {
                    return Opcodes.DET.toString();
                }
                case DETECTSCHEMA: {
                    return Opcodes.DETECTSCHEMA.toString();
                }
                case MULT2: {
                    return Opcodes.MULT2.toString();
                }
                case NOT: {
                    return Opcodes.NOT.toString();
                }
                case POW2: {
                    return Opcodes.POW2.toString();
                }
                case TYPEOF: {
                    return Opcodes.TYPEOF.toString();
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp1 valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "castdts": {
                    return CAST_AS_SCALAR;
                }
                case "castdtm": {
                    return CAST_AS_MATRIX;
                }
                case "castdtf": {
                    return CAST_AS_FRAME;
                }
                case "castdtl": {
                    return CAST_AS_LIST;
                }
                case "castvtd": {
                    return CAST_AS_DOUBLE;
                }
                case "castvti": {
                    return CAST_AS_INT;
                }
                case "castvtb": {
                    return CAST_AS_BOOLEAN;
                }
                case "ucummax": {
                    return CUMMAX;
                }
                case "ucummin": {
                    return CUMMIN;
                }
                case "ucum*": {
                    return CUMPROD;
                }
                case "ucumk+": {
                    return CUMSUM;
                }
                case "ucumk+*": {
                    return CUMSUMPROD;
                }
                case "detectSchema": {
                    return DETECTSCHEMA;
                }
                case "*2": {
                    return MULT2;
                }
                case "!": {
                    return NOT;
                }
                case "^2": {
                    return POW2;
                }
                case "typeOf": {
                    return TYPEOF;
                }
            }
            return OpOp1.valueOf(opcode.toUpperCase());
        }
    }

    public static enum AggOp {
        SUM,
        SUM_SQ,
        MIN,
        MAX,
        PROD,
        SUM_PROD,
        TRACE,
        MEAN,
        VAR,
        MAXINDEX,
        MININDEX,
        COUNT_DISTINCT,
        COUNT_DISTINCT_APPROX,
        UNIQUE;


        public String toString() {
            switch (this) {
                case SUM: {
                    return "+";
                }
                case SUM_SQ: {
                    return "sq+";
                }
                case PROD: {
                    return "*";
                }
            }
            return this.name().toLowerCase();
        }

        public static AggOp valueOfByOpcode(String opcode) {
            switch (opcode) {
                case "+": {
                    return SUM;
                }
                case "sq+": {
                    return SUM_SQ;
                }
                case "*": {
                    return PROD;
                }
            }
            return AggOp.valueOf(opcode.toUpperCase());
        }
    }

    public static enum CorrectionLocationType {
        NONE,
        LASTROW,
        LASTCOLUMN,
        LASTTWOROWS,
        LASTTWOCOLUMNS,
        LASTFOURROWS,
        LASTFOURCOLUMNS,
        INVALID;


        public int getNumRemovedRowsColumns() {
            return this == LASTROW || this == LASTCOLUMN ? 1 : (this == LASTTWOROWS || this == LASTTWOCOLUMNS ? 2 : (this == LASTFOURROWS || this == LASTFOURCOLUMNS ? 4 : 0));
        }

        public boolean isRows() {
            return this == LASTROW || this == LASTTWOROWS || this == LASTFOURROWS;
        }
    }

    public static enum Direction {
        RowCol,
        Row,
        Col;


        public boolean isRow() {
            return this == Row;
        }

        public boolean isCol() {
            return this == Col;
        }

        public boolean isRowCol() {
            return this == RowCol;
        }

        public String toString() {
            switch (this) {
                case RowCol: {
                    return "RC";
                }
                case Row: {
                    return "R";
                }
                case Col: {
                    return "C";
                }
            }
            throw new RuntimeException("Invalid direction type: " + this);
        }
    }

    public static enum ReturnType {
        NO_RETURN,
        SINGLE_RETURN,
        MULTI_RETURN;

    }

    public static enum BlockType {
        EMPTY_BLOCK,
        ULTRA_SPARSE_BLOCK,
        SPARSE_BLOCK,
        DENSE_BLOCK,
        DEDUP_BLOCK;

    }

    public static enum ValueType {
        UINT4,
        UINT8,
        FP32,
        FP64,
        INT32,
        INT64,
        BOOLEAN,
        STRING,
        UNKNOWN,
        HASH64,
        HASH32,
        CHARACTER;


        public boolean isNumeric() {
            switch (this) {
                case FP32: 
                case FP64: 
                case UINT4: 
                case UINT8: 
                case INT32: 
                case INT64: {
                    return true;
                }
            }
            return false;
        }

        public boolean isFP() {
            return this == FP64 || this == FP32;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isPseudoNumeric() {
            switch (this) {
                case FP32: 
                case FP64: 
                case UINT4: 
                case UINT8: 
                case INT32: 
                case INT64: 
                case BOOLEAN: 
                case HASH32: 
                case HASH64: 
                case CHARACTER: {
                    return true;
                }
            }
            return false;
        }

        public String toExternalString() {
            switch (this) {
                case FP32: 
                case FP64: {
                    return "DOUBLE";
                }
                case UINT4: 
                case UINT8: 
                case INT32: 
                case INT64: {
                    return "INT";
                }
                case BOOLEAN: {
                    return "BOOLEAN";
                }
            }
            return this.toString();
        }

        public static ValueType fromExternalString(String value) {
            String lValue;
            if (value == null) {
                throw new DMLRuntimeException("Unknown null value type");
            }
            switch (lValue = value.toUpperCase()) {
                case "FLOAT": 
                case "FP32": {
                    return FP32;
                }
                case "FP64": 
                case "DOUBLE": {
                    return FP64;
                }
                case "UINT4": {
                    return UINT4;
                }
                case "UINT8": {
                    return UINT8;
                }
                case "INT32": {
                    return INT32;
                }
                case "INT64": 
                case "INT": {
                    return INT64;
                }
                case "BOOL": 
                case "BOOLEAN": {
                    return BOOLEAN;
                }
                case "STR": 
                case "STRING": {
                    return STRING;
                }
                case "CHAR": 
                case "CHARACTER": {
                    return CHARACTER;
                }
                case "UNKNOWN": {
                    return UNKNOWN;
                }
                case "HASH64": {
                    return HASH64;
                }
                case "HASH32": {
                    return HASH32;
                }
            }
            throw new DMLRuntimeException("Unknown value type: " + value);
        }

        public static boolean isSameTypeString(ValueType vt1, ValueType vt2) {
            return vt1.toExternalString().equals(vt2.toExternalString());
        }

        public static ValueType getHighestCommonTypeSafe(ValueType a, ValueType b) {
            if (a == b) {
                return a;
            }
            return ValueType.getHighestCommonTypeSwitch(a, b);
        }

        public static ValueType getHighestCommonType(ValueType a, ValueType b) {
            if (a == b) {
                return a;
            }
            if (a == UNKNOWN || b == UNKNOWN) {
                throw new DMLRuntimeException(String.format("Invalid or not implemented support for comparing valueType of: %s and %s", new Object[]{a, b}));
            }
            return ValueType.getHighestCommonTypeSwitch(a, b);
        }

        private static ValueType getHighestCommonTypeSwitch(ValueType a, ValueType b) {
            switch (a) {
                case CHARACTER: {
                    switch (b) {
                        case UNKNOWN: {
                            return a;
                        }
                    }
                    return STRING;
                }
                case HASH32: {
                    switch (b) {
                        case UNKNOWN: {
                            return a;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                        case HASH64: 
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case HASH64: {
                    switch (b) {
                        case UNKNOWN: {
                            return a;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case STRING: {
                    switch (b) {
                        case UNKNOWN: {
                            return a;
                        }
                    }
                    return STRING;
                }
                case FP64: {
                    switch (b) {
                        case HASH32: 
                        case HASH64: 
                        case CHARACTER: {
                            return STRING;
                        }
                        case UNKNOWN: {
                            return a;
                        }
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case FP32: {
                    switch (b) {
                        case HASH32: 
                        case HASH64: 
                        case CHARACTER: {
                            return STRING;
                        }
                        case FP64: 
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case INT64: {
                    switch (b) {
                        case HASH32: 
                        case HASH64: {
                            return b;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                        case FP32: 
                        case FP64: 
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case INT32: {
                    switch (b) {
                        case HASH32: 
                        case HASH64: {
                            return b;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                        case FP32: 
                        case FP64: 
                        case INT64: 
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case UINT4: {
                    switch (b) {
                        case HASH32: 
                        case HASH64: {
                            return b;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                        case FP32: 
                        case FP64: 
                        case UINT8: 
                        case INT32: 
                        case INT64: 
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case UINT8: {
                    switch (b) {
                        case HASH32: 
                        case HASH64: {
                            return b;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                        case FP32: 
                        case FP64: 
                        case INT32: 
                        case INT64: 
                        case STRING: {
                            return b;
                        }
                    }
                    return a;
                }
                case BOOLEAN: {
                    switch (b) {
                        case UNKNOWN: {
                            return a;
                        }
                        case CHARACTER: {
                            return STRING;
                        }
                    }
                    return b;
                }
            }
            return b;
        }
    }

    public static enum DataType {
        TENSOR,
        MATRIX,
        SCALAR,
        FRAME,
        LIST,
        UNKNOWN,
        ENCRYPTED_CIPHER,
        ENCRYPTED_PLAIN;


        public boolean isMatrix() {
            return this == MATRIX;
        }

        public boolean isTensor() {
            return this == TENSOR;
        }

        public boolean isFrame() {
            return this == FRAME;
        }

        public boolean isMatrixOrFrame() {
            return this.isMatrix() || this.isFrame();
        }

        public boolean isScalar() {
            return this == SCALAR;
        }

        public boolean isList() {
            return this == LIST;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }
    }

    public static enum ExecType {
        CP,
        CP_FILE,
        SPARK,
        GPU,
        FED,
        INVALID;

    }

    public static enum ExecMode {
        SINGLE_NODE,
        HYBRID,
        SPARK;

    }
}

