/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.HashIntegerArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.lib.FrameUtil;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.DoubleParser;
import org.apache.sysds.utils.MemoryEstimates;

public class DoubleArray
extends Array<Double> {
    private double[] _data;

    private DoubleArray(int nRow) {
        this(new double[nRow]);
    }

    public DoubleArray(double[] data) {
        super(data.length);
        this._data = data;
    }

    public double[] get() {
        return this._data;
    }

    @Override
    public Double get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, Double value) {
        this._data[index] = value != null ? value : 0.0;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = value;
    }

    @Override
    public void set(int index, String value) {
        this.set(index, DoubleArray.parseDouble(value));
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this._data[i] = UtilFunctions.objectToDouble(vt, value.get(i));
        }
    }

    @Override
    public void set(int rl, int ru, Array<Double> value, int rlSrc) {
        try {
            System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
        }
        catch (Exception e) {
            super.set(rl, ru, value, rlSrc);
        }
    }

    @Override
    public void setNz(int rl, int ru, Array<Double> value) {
        double[] data2 = ((DoubleArray)value)._data;
        for (int i = rl; i <= ru; ++i) {
            if (data2[i] == 0.0) continue;
            this._data[i] = data2[i];
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            double v = UtilFunctions.objectToDouble(vt, value.get(i));
            if (v == 0.0) continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(DoubleArray.parseDouble(value));
    }

    @Override
    public void append(Double value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value : 0.0;
    }

    @Override
    public Array<Double> append(Array<Double> other) {
        int endSize = this._size + other.size();
        double[] ret = new double[endSize];
        System.arraycopy(this._data, 0, ret, 0, this._size);
        System.arraycopy(other.get(), 0, ret, this._size, other.size());
        if (other instanceof OptionalArray) {
            return OptionalArray.appendOther((OptionalArray)other, new DoubleArray(ret));
        }
        return new DoubleArray(ret);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.FP64.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeDouble(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readDouble();
        }
    }

    protected static DoubleArray read(DataInput in, int nRow) throws IOException {
        DoubleArray arr = new DoubleArray(nRow);
        arr.readFields(in);
        return arr;
    }

    @Override
    public Array<Double> clone() {
        return new DoubleArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public Array<Double> slice(int rl, int ru) {
        return new DoubleArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new double[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = 0.0;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer doubleBuffer = ByteBuffer.allocate(8 * this._size);
        doubleBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < this._size; ++i) {
            doubleBuffer.putDouble(this._data[i]);
        }
        return doubleBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.FP64;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        Types.ValueType state = FrameUtil.isType(this._data[0]);
        block17: for (int i = 0; i < Math.min(maxCells, this._size); ++i) {
            Types.ValueType c = FrameUtil.isType(this._data[i], state);
            if (state == Types.ValueType.FP64) {
                return new Pair<Types.ValueType, Boolean>(Types.ValueType.FP64, false);
            }
            switch (state) {
                case FP32: {
                    switch (c) {
                        case FP64: {
                            state = c;
                            continue block17;
                        }
                    }
                    continue block17;
                }
                case INT64: {
                    switch (c) {
                        case FP64: 
                        case FP32: {
                            state = c;
                            continue block17;
                        }
                    }
                    continue block17;
                }
                case INT32: {
                    switch (c) {
                        case FP64: 
                        case FP32: 
                        case INT64: {
                            state = c;
                            continue block17;
                        }
                    }
                    continue block17;
                }
                default: {
                    switch (c) {
                        case FP64: 
                        case FP32: 
                        case INT64: 
                        case INT32: {
                            state = c;
                            continue block17;
                        }
                    }
                }
            }
        }
        return new Pair<Types.ValueType, Boolean>(state, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.FP64;
    }

    @Override
    public long getInMemorySize() {
        long size = super.getInMemorySize();
        size = (long)((double)size + MemoryEstimates.doubleArrayCost(this._data.length));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + 8 * this._size;
    }

    @Override
    protected Array<Boolean> changeTypeBitSet(Array<Boolean> ret, int l, int u) {
        for (int i = l; i < u; ++i) {
            if (this._data[i] != 0.0 && this._data[i] != 1.0) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret.set(i, this._data[i] != 0.0);
        }
        return ret;
    }

    @Override
    protected Array<Boolean> changeTypeBoolean(Array<Boolean> retA, int l, int u) {
        boolean[] ret = (boolean[])retA.get();
        for (int i = l; i < u; ++i) {
            if (this._data[i] != 0.0 && this._data[i] != 1.0) {
                throw new DMLRuntimeException("Unable to change to Boolean from Integer array because of value:" + this._data[i]);
            }
            ret[i] = this._data[i] != 0.0;
        }
        return retA;
    }

    @Override
    protected Array<Double> changeTypeDouble(Array<Double> retA, int l, int u) {
        double[] ret = (double[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Float> changeTypeFloat(Array<Float> retA, int l, int u) {
        float[] ret = (float[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = (float)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Integer> changeTypeInteger(Array<Integer> retA, int l, int u) {
        int[] ret = (int[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = (int)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Long> changeTypeLong(Array<Long> retA, int l, int u) {
        long[] ret = (long[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = (long)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash64(Array<Object> retA, int l, int u) {
        long[] ret = ((HashLongArray)retA).getLongs();
        for (int i = l; i < u; ++i) {
            ret[i] = (long)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<Object> changeTypeHash32(Array<Object> retA, int l, int u) {
        int[] ret = ((HashIntegerArray)retA).getInts();
        for (int i = l; i < u; ++i) {
            ret[i] = (int)this._data[i];
        }
        return retA;
    }

    @Override
    protected Array<String> changeTypeString(Array<String> retA, int l, int u) {
        String[] ret = (String[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = Double.toString(this._data[i]);
        }
        return retA;
    }

    @Override
    public Array<Character> changeTypeCharacter(Array<Character> retA, int l, int u) {
        char[] ret = (char[])retA.get();
        for (int i = l; i < u; ++i) {
            ret[i] = Double.toString(this._data[i]).charAt(0);
        }
        return retA;
    }

    @Override
    public void fill(String value) {
        this.fill(DoubleArray.parseDouble(value));
    }

    @Override
    public void fill(Double value) {
        value = value != null ? value : 0.0;
        Arrays.fill(this._data, value);
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i];
    }

    public static double parseDouble(String value) {
        try {
            if (value == null || value.isEmpty()) {
                return 0.0;
            }
            return DoubleParser.parseFloatingPointLiteral(value, 0, value.length());
        }
        catch (NumberFormatException e) {
            int len = value.length();
            if (len == 3 && value.compareToIgnoreCase("Inf") == 0) {
                return Double.POSITIVE_INFINITY;
            }
            if (len == 4 && value.compareToIgnoreCase("-Inf") == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            throw new DMLRuntimeException(e);
        }
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (!this.isNotEmpty(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Array<Double> select(int[] indices) {
        double[] ret = new double[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new DoubleArray(ret);
    }

    @Override
    public Array<Double> select(boolean[] select, int nTrue) {
        double[] ret = new double[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new DoubleArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i] != 0.0;
    }

    @Override
    public double hashDouble(int idx) {
        return Double.hashCode(this._data[idx]);
    }

    @Override
    public boolean equals(Array<Double> other) {
        if (other instanceof DoubleArray) {
            return Arrays.equals(this._data, ((DoubleArray)other)._data);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return true;
    }

    @Override
    public boolean containsNull() {
        for (int i = 0; i < this._size; ++i) {
            if (!Double.isNaN(this._data[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] minMax(int l, int u) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = l; i < u; ++i) {
            double inVal = this._data[i];
            if (Double.isNaN(inVal)) continue;
            min = Math.min(min, inVal);
            max = Math.max(max, inVal);
        }
        return new double[]{min, max};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 5 + 2);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i] + ",");
        }
        sb.append(this._data[this._size - 1]);
        sb.append("]");
        return sb.toString();
    }
}

