/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.federated.ExecutionContextMap;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandlerException;

public class FederatedLookupTable {
    public static final String NOHOST = "nohost";
    private static final Logger LOG = Logger.getLogger(FederatedLookupTable.class);
    private final Map<FedUniqueCoordID, ExecutionContextMap> _lookup_table = new ConcurrentHashMap<FedUniqueCoordID, ExecutionContextMap>();

    public ExecutionContextMap getECM(String host, long pid) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        FedUniqueCoordID funCID = new FedUniqueCoordID(host, pid);
        LOG.trace((Object)("Getting the ExecutionContextMap for coordinator " + funCID.toString()));
        ExecutionContextMap ecm = this._lookup_table.computeIfAbsent(funCID, k -> this.createNewECM());
        if (ecm == null) {
            LOG.error((Object)("Computing federated execution context map failed. No valid resolution for " + funCID.toString() + " found."));
            throw new FederatedWorkerHandlerException("Computing federated execution context map failed. No valid resolution for " + funCID.toString() + " found.");
        }
        if (DMLScript.STATISTICS) {
            FederatedStatistics.incFedLookupTableGetCount();
            FederatedStatistics.incFedLookupTableGetTime(System.nanoTime() - t0);
        }
        return ecm;
    }

    public void removeECM(String host, long pid) {
        FedUniqueCoordID funCID = new FedUniqueCoordID(host, pid);
        LOG.trace((Object)("Removing the ExecutionContextMap of coordinator " + funCID.toString()));
        if (this._lookup_table.remove(funCID) == null) {
            LOG.warn((Object)("Removing federated execution context map failed. No valid resolution for " + funCID.toString() + " found."));
        }
    }

    public boolean containsFunCID(String host, long pid) {
        FedUniqueCoordID funCID = new FedUniqueCoordID(host, pid);
        return this._lookup_table.containsKey(funCID);
    }

    private ExecutionContextMap createNewECM() {
        ExecutionContextMap ecm = new ExecutionContextMap();
        if (DMLScript.STATISTICS) {
            FederatedStatistics.incFedLookupTableEntryCount();
        }
        return ecm;
    }

    public String toString() {
        return this._lookup_table.toString();
    }

    private static class FedUniqueCoordID {
        private final String _host;
        private final long _pid;

        public FedUniqueCoordID(String host, long pid) {
            this._host = host;
            this._pid = pid;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FedUniqueCoordID)) {
                return false;
            }
            FedUniqueCoordID funCID = (FedUniqueCoordID)obj;
            return Objects.equals(this._host, funCID._host) && this._pid == funCID._pid;
        }

        public int hashCode() {
            return Objects.hash(this._host, this._pid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._pid);
            sb.append("@");
            sb.append(this._host);
            return sb.toString();
        }
    }
}

