/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;

public class FederatedPlannerUtils {
    public static ArrayList<Hop> getTransientInputs(Hop currentHop, Map<String, Hop> paramMap, Map<String, Hop> transientWrites, LocalVariableMap localVariableMap) {
        Hop tWriteHop = null;
        if (paramMap != null) {
            tWriteHop = paramMap.get(currentHop.getName());
        }
        if (tWriteHop == null) {
            tWriteHop = transientWrites.get(currentHop.getName());
        }
        if (tWriteHop == null) {
            if (localVariableMap.get(currentHop.getName()) != null) {
                return null;
            }
            throw new DMLRuntimeException("Transient write not found for " + currentHop);
        }
        return new ArrayList<Hop>(Collections.singletonList(tWriteHop));
    }

    public static Map<String, Hop> getParamMap(FunctionOp funcOp) {
        String[] inputNames = funcOp.getInputVariableNames();
        HashMap<String, Hop> paramMap = new HashMap<String, Hop>();
        if (inputNames != null) {
            for (int i = 0; i < funcOp.getInput().size(); ++i) {
                paramMap.put(inputNames[i], funcOp.getInput(i));
            }
        }
        return paramMap;
    }

    public static void mapFunctionOutputs(FunctionOp sbHop, FunctionStatement funcStatement, Map<String, Hop> transientWrites) {
        for (int i = 0; i < sbHop.getOutputVariableNames().length; ++i) {
            Hop outputWrite = transientWrites.get(funcStatement.getOutputParams().get(i).getName());
            transientWrites.put(sbHop.getOutputVariableNames()[i], outputWrite);
        }
    }
}

