/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.interceptor.BundleContextAware;
import org.apache.struts2.osgi.interceptor.ServiceAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(OsgiInterceptor.class);
    private BundleContext bundleContext;

    public String intercept(ActionInvocation invocation) throws Exception {
        LOG.trace("OSGi Interceptor - intercept() called - ActionInvocation: [{}]", (Object)invocation);
        if (this.bundleContext != null) {
            Object action = invocation.getAction();
            this.injectBundleContext(action);
            this.injectServicesUsingDeprecatedInterface(action);
            this.injectServices(action);
        } else {
            LOG.warn("The OSGi interceptor was not able to find the BundleContext in the ServletContext");
        }
        return invocation.invoke();
    }

    private void injectBundleContext(Object action) {
        if (action instanceof BundleContextAware) {
            ((BundleContextAware)action).setBundleContext(this.bundleContext);
        }
        if (action instanceof org.apache.struts2.osgi.action.BundleContextAware) {
            ((org.apache.struts2.osgi.action.BundleContextAware)action).withBundleContext(this.bundleContext);
        }
    }

    @Deprecated
    private void injectServicesUsingDeprecatedInterface(Object action) throws InvalidSyntaxException {
        Type[] types;
        if (action instanceof ServiceAware && (types = action.getClass().getGenericInterfaces()) != null) {
            for (Type type : types) {
                Class serviceClass;
                ServiceReference[] refs;
                Class clazz;
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !((parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) || !ServiceAware.class.equals((Object)(clazz = (Class)parameterizedType.getRawType())) || (refs = this.bundleContext.getAllServiceReferences((serviceClass = (Class)parameterizedType.getActualTypeArguments()[0]).getName(), null)) == null) continue;
                ArrayList<Object> services = new ArrayList<Object>(refs.length);
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (service == null) continue;
                    services.add(service);
                }
                if (services.isEmpty()) continue;
                ((ServiceAware)action).setServices(services);
            }
        }
    }

    private void injectServices(Object action) throws InvalidSyntaxException {
        Type[] types;
        if (action instanceof org.apache.struts2.osgi.action.ServiceAware && (types = action.getClass().getGenericInterfaces()) != null) {
            for (Type type : types) {
                Class serviceClass;
                ServiceReference[] refs;
                Class clazz;
                ParameterizedType parameterizedType;
                if (!(type instanceof ParameterizedType) || !((parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) || !org.apache.struts2.osgi.action.ServiceAware.class.equals((Object)(clazz = (Class)parameterizedType.getRawType())) || (refs = this.bundleContext.getAllServiceReferences((serviceClass = (Class)parameterizedType.getActualTypeArguments()[0]).getName(), null)) == null) continue;
                ArrayList<Object> services = new ArrayList<Object>(refs.length);
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (service == null) continue;
                    services.add(service);
                }
                if (services.isEmpty()) continue;
                ((org.apache.struts2.osgi.action.ServiceAware)action).withServices(services);
            }
        }
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        LOG.trace("OSGi Interceptor - setServletContext() called - ServletContext: [{}] ", (Object)servletContext);
        this.bundleContext = (BundleContext)servletContext.getAttribute("__struts_osgi_bundle_context");
    }
}

