/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.oval.Check;
import net.sf.oval.context.IterableElementContext;
import net.sf.oval.context.MapKeyContext;
import net.sf.oval.context.MapValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.CollectionUtils;
import net.sf.oval.localization.context.DefaultOValContextRenderer;

public class ConstraintViolation
implements Serializable {
    private static final Log LOG = Log.getLog(ConstraintViolation.class);
    private static final long serialVersionUID = 1L;
    @Deprecated
    private final ConstraintViolation[] causes;
    private final OValContext checkDeclaringContext;
    private final String checkName;
    private final String errorCode;
    private final int severity;
    private transient Object validatedObject;
    private transient Object invalidValue;
    private final List<OValContext> contextPath;
    private final String message;
    private final String messageTemplate;
    private final Map<String, ? extends Serializable> messageVariables;

    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, List<OValContext> invalidValuePath) {
        this(check, message, validatedObject, invalidValue, invalidValuePath, null);
    }

    private ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, List<OValContext> invalidValuePath, ConstraintViolation ... causes) {
        Assert.argumentNotEmpty("invalidValuePath", invalidValuePath);
        this.checkName = check.getClass().getName();
        this.checkDeclaringContext = check.getContext();
        this.errorCode = check.getErrorCode();
        this.message = message;
        this.messageTemplate = check.getMessage();
        this.messageVariables = check.getMessageVariables();
        this.severity = check.getSeverity();
        this.validatedObject = validatedObject;
        this.invalidValue = invalidValue;
        this.contextPath = CollectionUtils.clone(invalidValuePath);
        this.causes = causes != null && causes.length == 0 ? null : causes;
    }

    @Deprecated
    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, OValContext context) {
        this(check, message, validatedObject, invalidValue, Arrays.asList(context), null);
    }

    @Deprecated
    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, OValContext context, ConstraintViolation ... causes) {
        this(check, message, validatedObject, invalidValue, Arrays.asList(context), causes);
    }

    @Deprecated
    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, OValContext context, List<ConstraintViolation> causes) {
        this(check, message, validatedObject, invalidValue, Arrays.asList(context), causes == null || causes.isEmpty() ? null : causes.toArray(new ConstraintViolation[causes.size()]));
    }

    @Deprecated
    public ConstraintViolation[] getCauses() {
        return this.causes == null ? null : (ConstraintViolation[])this.causes.clone();
    }

    public OValContext getCheckDeclaringContext() {
        return this.checkDeclaringContext;
    }

    public String getCheckName() {
        return this.checkName;
    }

    @Deprecated
    public OValContext getContext() {
        ListIterator<OValContext> listIterator = this.contextPath.listIterator(this.contextPath.size());
        OValContext ctx = null;
        while (listIterator.hasPrevious()) {
            ctx = listIterator.previous();
            if (!(ctx instanceof IterableElementContext) && !(ctx instanceof MapKeyContext) && !(ctx instanceof MapValueContext)) break;
        }
        return ctx;
    }

    public List<OValContext> getContextPath() {
        return this.contextPath;
    }

    public String getContextPathAsString() {
        return DefaultOValContextRenderer.INSTANCE.render(this.contextPath);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object getInvalidValue() {
        return this.invalidValue;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public Map<String, ? extends Serializable> getMessageVariables() {
        return this.messageVariables;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Object getValidatedObject() {
        return this.validatedObject;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.readBoolean()) {
            this.validatedObject = in.readObject();
        }
        if (in.readBoolean()) {
            this.invalidValue = in.readObject();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.validatedObject instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.validatedObject);
        } else {
            LOG.warn("Field 'validatedObject' not serialized because the field value object " + this.validatedObject + " of type " + this.invalidValue.getClass() + " does not implement " + Serializable.class.getName());
            out.writeBoolean(false);
        }
        if (this.invalidValue instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.invalidValue);
        } else {
            LOG.warn("Field 'invalidValue' could not be serialized because the field value object {1} does not implement java.io.Serializable.", this.invalidValue);
            out.writeBoolean(false);
        }
    }
}

