/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.security.impl.ldap;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.system.security.impl.ldap.LdapUserNotExistActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class LdapService {
    private static final Logger log = LoggerFactory.getLogger(LdapService.class);
    @Value(value="${ldap.urls:#{null}}")
    private String ldapUrls;
    @Value(value="${ldap.base-dn:#{null}}")
    private String ldapBaseDn;
    @Value(value="${ldap.username:#{null}}")
    private String ldapSecurityPrincipal;
    @Value(value="${ldap.password:#{null}}")
    private String ldapPrincipalPassword;
    @Value(value="${ldap.user.identity-attribute:#{null}}")
    private String ldapUserIdentifyingAttribute;
    @Value(value="${ldap.user.email-attribute:#{null}}")
    private String ldapEmailAttribute;
    @Value(value="${ldap.user.not-exist-action:CREATE}")
    private String ldapUserNotExistAction;

    public String ldapLogin(String userId, String userPwd) {
        block5: {
            Properties searchEnv = this.getManagerLdapEnv();
            try {
                InitialLdapContext ctx = new InitialLdapContext(searchEnv, null);
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{this.ldapEmailAttribute});
                sc.setSearchScope(2);
                EqualsFilter filter = new EqualsFilter(this.ldapUserIdentifyingAttribute, userId);
                NamingEnumeration<SearchResult> results = ctx.search(this.ldapBaseDn, filter.toString(), sc);
                if (!results.hasMore()) break block5;
                SearchResult result = results.next();
                NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
                while (attrs.hasMore()) {
                    searchEnv.put("java.naming.security.principal", result.getNameInNamespace());
                    searchEnv.put("java.naming.security.credentials", userPwd);
                    try {
                        new InitialDirContext(searchEnv);
                    }
                    catch (Exception e) {
                        log.warn("invalid ldap credentials or ldap search error", (Throwable)e);
                        return null;
                    }
                    Attribute attr = attrs.next();
                    if (!attr.getID().equals(this.ldapEmailAttribute)) continue;
                    return (String)attr.get();
                }
            }
            catch (NamingException e) {
                log.error("ldap search error", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    Properties getManagerLdapEnv() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.ldapSecurityPrincipal);
        env.put("java.naming.security.credentials", this.ldapPrincipalPassword);
        env.put("java.naming.provider.url", this.ldapUrls);
        return env;
    }

    public LdapUserNotExistActionType getLdapUserNotExistAction() {
        if (StringUtils.isBlank((CharSequence)this.ldapUserNotExistAction)) {
            log.info("security.authentication.ldap.user.not.exist.action configuration is empty, the default value 'CREATE'");
            return LdapUserNotExistActionType.CREATE;
        }
        return LdapUserNotExistActionType.valueOf(this.ldapUserNotExistAction);
    }

    public boolean createIfUserNotExists() {
        return this.getLdapUserNotExistAction() == LdapUserNotExistActionType.CREATE;
    }
}

