/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.streampark.console.base.properties.ShiroProperties;
import org.apache.streampark.console.base.util.SpringContextUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;

public class JWTFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JWTFilter.class);
    private static final String TOKEN = "Authorization";
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws UnauthorizedException {
        String[] anonUrl;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        ShiroProperties properties = SpringContextUtils.getBean(ShiroProperties.class);
        for (String u : anonUrl = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)properties.getAnonUrl(), (String)",")) {
            if (!this.pathMatcher.match(u.trim(), httpServletRequest.getRequestURI())) continue;
            return true;
        }
        if (this.isLoginAttempt(request, response)) {
            return this.executeLogin(request, response);
        }
        return false;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        HttpServletRequest req = (HttpServletRequest)request;
        String token = req.getHeader(TOKEN);
        return token != null;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(TOKEN);
        JWTToken jwtToken = new JWTToken(WebUtils.decryptToken(token));
        try {
            this.getSubject(request, response).login((AuthenticationToken)jwtToken);
            return true;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return false;
        }
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Access-control-Allow-Origin", httpServletRequest.getHeader("Origin"));
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
        httpServletResponse.setHeader("Access-Control-Allow-Headers", httpServletRequest.getHeader("Access-Control-Request-Headers"));
        if (httpServletRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            return false;
        }
        boolean preHandleResult = super.preHandle(request, response);
        int httpStatus = httpServletResponse.getStatus();
        if (!preHandleResult && httpStatus == 401) {
            httpServletResponse.setHeader("WWW-Authenticate", null);
        }
        return preHandleResult;
    }
}

