/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.core.service.SqlCompleteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class SqlCompleteServiceImpl
implements SqlCompleteService {
    private static final Logger log = LoggerFactory.getLogger(SqlCompleteServiceImpl.class);
    private static final Set<Character> BLACK_SET = Sets.newHashSet((Object[])new Character[]{Character.valueOf(' '), Character.valueOf(';')});
    private static SqlCompleteFstTree completeFstTree;

    @PostConstruct
    public void initialize() {
        completeFstTree = new SqlCompleteFstTree();
    }

    @Override
    public List<String> getComplete(String sql) {
        if (sql.length() > 0 && BLACK_SET.contains(Character.valueOf(sql.charAt(sql.length() - 1)))) {
            return new ArrayList<String>();
        }
        String[] temp = sql.split("\\s");
        return completeFstTree.getComplicate(temp[temp.length - 1]);
    }

    private static class TreeNode {
        private final Character step;
        private boolean stop = false;
        private int count = 0;
        private final Map<Character, TreeNode> next;

        public TreeNode(Character step) {
            this.step = step;
            this.next = new HashMap<Character, TreeNode>();
        }

        public void setCount(int count) {
            this.count += count;
        }

        public int getCount() {
            return this.count;
        }

        public void setStop() {
            this.stop = true;
        }

        public boolean isStop() {
            return this.stop;
        }

        public Character getStep() {
            return this.step;
        }

        public Map<Character, TreeNode> getNext() {
            return this.next;
        }
    }

    private static class SqlCompleteFstTree {
        private static final String CHARACTER_NOTICE = "()\t<>\t\"\"\t''\t{}";
        private static final String SPLIT_CHAR = "\t";
        private static final TreeNode READ_FROM_HEAD = new TreeNode(Character.valueOf(' '));
        private static final TreeNode READ_FROM_TAIL = new TreeNode(Character.valueOf(' '));

        public SqlCompleteFstTree() {
            Scanner scanner;
            ClassPathResource resource;
            try {
                resource = new ClassPathResource("sql-rev.dict");
                scanner = new Scanner(resource.getInputStream());
                StringBuilder stringBuffer = new StringBuilder();
                while (scanner.hasNextLine()) {
                    stringBuffer.append(scanner.nextLine()).append(SPLIT_CHAR);
                }
                scanner.close();
                String dict = stringBuffer.toString();
                Arrays.stream(dict.split(SPLIT_CHAR)).map(e -> e.trim().toLowerCase()).forEach(e -> this.initSearchTree((String)e, 1));
            }
            catch (IOException e2) {
                log.error("FstTree require reserved word init fail, {}", (Object)e2.getMessage());
            }
            Arrays.stream(CHARACTER_NOTICE.split(SPLIT_CHAR)).map(e -> e.trim().toLowerCase()).forEach(e -> this.initSearchTree((String)e, 1));
            try {
                resource = new ClassPathResource("sql-statistics.dict");
                scanner = new Scanner(resource.getInputStream());
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] sqlStat = line.split(SPLIT_CHAR);
                    this.initSearchTree(sqlStat[0], Integer.parseInt(sqlStat[1].trim()));
                }
                scanner.close();
            }
            catch (Exception e3) {
                log.info("Error while FstTree ini that: {}", (Object)e3.getMessage());
            }
        }

        public void initSearchTree(String word, int count) {
            this.buildTree(word, count, READ_FROM_HEAD);
            this.buildTree(new StringBuffer(word).reverse().toString(), count, READ_FROM_TAIL);
        }

        public void buildTree(String word, int count, TreeNode buildWay) {
            Map<Character, TreeNode> nowStep = buildWay.getNext();
            TreeNode preNode = null;
            for (int loc = 0; loc < word.length(); ++loc) {
                Character nowChar = Character.valueOf(word.charAt(loc));
                if (!nowStep.containsKey(nowChar)) {
                    TreeNode temp = new TreeNode(nowChar);
                    nowStep.put(nowChar, temp);
                }
                preNode = nowStep.get(nowChar);
                nowStep = nowStep.get(nowChar).getNext();
            }
            Utils.required((preNode != null ? 1 : 0) != 0);
            preNode.setStop();
            preNode.setCount(count);
        }

        private List<TreeNode> getMaybeNodeList(String word, TreeNode searchWay, Single breakLoc) {
            int loc;
            Map<Character, TreeNode> nowStep = searchWay.getNext();
            for (loc = 0; loc < word.length(); ++loc) {
                Character nowChar = Character.valueOf(word.charAt(loc));
                if (!nowStep.containsKey(nowChar)) {
                    breakLoc.loc = loc;
                    break;
                }
                nowStep = nowStep.get(nowChar).getNext();
            }
            breakLoc.loc = loc;
            return loc > 0 ? new ArrayList<TreeNode>(nowStep.values()) : new ArrayList();
        }

        private void getDFSWord(List<WordWithFrequency> returnSource, String buffer, TreeNode now) {
            if (now.getNext().size() == 0 || now.isStop()) {
                returnSource.add(new WordWithFrequency(buffer + now.getStep(), now.getCount()));
            } else {
                now.getNext().values().forEach(each -> this.getDFSWord(returnSource, buffer + now.getStep(), (TreeNode)each));
            }
        }

        private SortedSet<WordWithFrequency> tryComplicate(String word, TreeNode tree, Single passLength) {
            ArrayList temp = new ArrayList();
            ArrayList tempNPreview = new ArrayList();
            Single breLoc = new Single();
            this.getMaybeNodeList(word, tree, breLoc).forEach(each -> this.getDFSWord(temp, "", (TreeNode)each));
            SortedSet returnSource = temp.stream().map(e -> new WordWithFrequency(word.substring(0, breLoc.loc) + e.word, e.count)).collect(Collectors.toCollection(TreeSet::new));
            if (breLoc.loc < word.length() && breLoc.loc > 1) {
                this.getMaybeNodeList(word.substring(0, breLoc.loc - 1), tree, breLoc).forEach(each -> this.getDFSWord(tempNPreview, "", (TreeNode)each));
                returnSource.addAll(tempNPreview.stream().map(e -> new WordWithFrequency(word.substring(0, breLoc.loc) + e.word, e.count)).collect(Collectors.toList()));
            }
            passLength.loc = breLoc.loc;
            return returnSource;
        }

        public List<String> getComplicate(String word) {
            word = word.toLowerCase();
            Single searchFromHeadPassLength = new Single();
            Single searchFromReversePassLength = new Single();
            SortedSet<WordWithFrequency> head = this.tryComplicate(word, READ_FROM_HEAD, searchFromHeadPassLength);
            SortedSet tail = this.tryComplicate(new StringBuffer(word).reverse().toString(), READ_FROM_HEAD, searchFromReversePassLength).stream().map(e -> new WordWithFrequency(new StringBuffer(e.word).reverse().toString(), e.count)).collect(Collectors.toCollection(TreeSet::new));
            TreeSet<WordWithFrequency> temp = new TreeSet<WordWithFrequency>(head);
            temp.retainAll(tail);
            TreeSet<WordWithFrequency> returnSource = new TreeSet<WordWithFrequency>((SortedSet<WordWithFrequency>)temp);
            if (searchFromReversePassLength.loc > searchFromHeadPassLength.loc) {
                returnSource.addAll(tail);
            }
            returnSource.addAll(head);
            return returnSource.stream().map(e -> e.word).collect(Collectors.toList());
        }

        private static class Single {
            public Integer loc = 0;

            private Single() {
            }
        }
    }

    private static class WordWithFrequency
    implements Comparable<WordWithFrequency> {
        String word;
        Integer count;

        public WordWithFrequency(String word, int count) {
            this.word = word;
            this.count = count;
        }

        @Override
        public int compareTo(WordWithFrequency other) {
            int num = this.count - other.count;
            if (num == 0) {
                return this.word.compareTo(other.word) * -1;
            }
            return num * -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WordWithFrequency that = (WordWithFrequency)o;
            return Objects.equals(this.word, that.word) && Objects.equals(this.count, that.count);
        }

        public int hashCode() {
            return Objects.hash(this.word, this.count);
        }
    }
}

