/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.entity.Message;
import org.apache.streampark.console.core.enums.NoticeType;
import org.apache.streampark.console.core.service.MessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"metrics"})
public class MetricsController {
    private static final Logger log = LoggerFactory.getLogger(MetricsController.class);
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"notice"})
    public RestResponse notice(Integer type, RestRequest request) {
        NoticeType noticeType = NoticeType.of(type);
        IPage<Message> pages = this.messageService.getUnRead(noticeType, request);
        return RestResponse.success(pages);
    }

    @PostMapping(value={"delnotice"})
    public RestResponse delNotice(Long id) {
        return RestResponse.success(this.messageService.removeById(id));
    }
}

