/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.streaming.api.transformations.SinkTransformation;

@Public
public class DataStreamSink<T> {
    private final PhysicalTransformation<T> transformation;

    protected DataStreamSink(DataStream<T> inputStream, StreamSink<T> operator) {
        this.transformation = new LegacySinkTransformation<T>(inputStream.getTransformation(), "Unnamed", operator, inputStream.getExecutionEnvironment().getParallelism());
    }

    protected DataStreamSink(DataStream<T> inputStream, Sink<T, ?, ?, ?> sink) {
        this.transformation = new SinkTransformation(inputStream.getTransformation(), sink, "Unnamed", inputStream.getExecutionEnvironment().getParallelism());
        inputStream.getExecutionEnvironment().addOperator(this.transformation);
    }

    @Internal
    public LegacySinkTransformation<T> getTransformation() {
        if (this.transformation instanceof LegacySinkTransformation) {
            return (LegacySinkTransformation)this.transformation;
        }
        throw new IllegalStateException("There is no the LegacySinkTransformation.");
    }

    public DataStreamSink<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> setUidHash(String uidHash) {
        this.transformation.setUidHash(uidHash);
        return this;
    }

    public DataStreamSink<T> setParallelism(int parallelism) {
        this.transformation.setParallelism(parallelism);
        return this;
    }

    private DataStreamSink<T> setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.transformation.setResources(minResources, preferredResources);
        return this;
    }

    private DataStreamSink<T> setResources(ResourceSpec resources) {
        this.transformation.setResources(resources, resources);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> disableChaining() {
        this.transformation.setChainingStrategy(ChainingStrategy.NEVER);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> slotSharingGroup(SlotSharingGroup slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }
}

