/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.conf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.Converter$;
import org.apache.streampark.common.conf.InternalOption;
import org.apache.streampark.common.conf.K8sFlinkConfig$;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public final class InternalConfigHolder$
implements org.apache.streampark.common.util.Logger {
    public static InternalConfigHolder$ MODULE$;
    private final int initialCapacity;
    private final ConcurrentHashMap<String, Object> confData;
    private final ConcurrentHashMap<String, InternalOption> confOptions;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new InternalConfigHolder$();
    }

    @Override
    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$(this);
    }

    @Override
    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private int initialCapacity() {
        return this.initialCapacity;
    }

    private ConcurrentHashMap<String, Object> confData() {
        return this.confData;
    }

    private ConcurrentHashMap<String, InternalOption> confOptions() {
        return this.confOptions;
    }

    public void register(@Nonnull InternalOption conf) {
        block0: {
            this.confOptions().put(conf.key(), conf);
            if (conf.defaultValue() == null) break block0;
            this.confData().put(conf.key(), conf.defaultValue());
        }
    }

    @Nonnull
    public <T> T get(@Nonnull InternalOption conf) {
        Object object;
        Object object2 = this.confData().get(conf.key());
        if (object2 == null) {
            String string = SystemPropertyUtils$.MODULE$.get(conf.key());
            Object object3 = string != null ? Converter$.MODULE$.convert(string, conf.classType()) : conf.defaultValue();
            object = object3;
        } else if (object2 instanceof Object) {
            Object object4;
            object = object4 = object2;
        } else {
            throw new MatchError(object2);
        }
        return (T)object;
    }

    @Nonnull
    public <T> T get(@Nonnull String key) throws IllegalArgumentException {
        Object object;
        Object object2 = this.confData().get(key);
        if (object2 == null) {
            Object object3;
            InternalOption internalOption = this.confOptions().get(key);
            if (internalOption == null) {
                InternalOption config = this.getConfig(key);
                String string = SystemPropertyUtils$.MODULE$.get(key);
                if (string == null) {
                    throw new IllegalArgumentException(new StringBuilder(36).append("config key has not been registered: ").append(key).toString());
                }
                Object t = Converter$.MODULE$.convert(string, config.classType());
                object3 = t;
            } else if (internalOption != null) {
                InternalOption internalOption2 = internalOption;
                object3 = internalOption2.defaultValue();
            } else {
                throw new MatchError((Object)internalOption);
            }
            object = object3;
        } else if (object2 instanceof Object) {
            Object object4;
            object = object4 = object2;
        } else {
            throw new MatchError(object2);
        }
        return (T)object;
    }

    @Nullable
    public InternalOption getConfig(String key) {
        return this.confOptions().get(key);
    }

    @Nonnull
    public Set<String> keys() {
        HashMap<String, InternalOption> map = new HashMap<String, InternalOption>(this.confOptions().size());
        map.putAll(this.confOptions());
        return map.keySet();
    }

    public void set(@Nonnull InternalOption conf, Object value) throws IllegalArgumentException {
        if (!this.confOptions().containsKey(conf.key())) {
            throw new IllegalArgumentException(new StringBuilder(36).append("config key has not been registered: ").append(conf).toString());
        }
        Object object = value;
        if (object == null) {
            this.confData().remove(conf.key());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Class<?> clazz = conf.classType();
            Class<?> clazz2 = object.getClass();
            if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                throw new IllegalArgumentException(new StringBuilder(56).append("config value type is not match of ").append(conf.key()).append(", required: ").append(conf.classType()).append(", actual: ").append(object.getClass()).toString());
            }
            SystemPropertyUtils$.MODULE$.set(conf.key(), object.toString());
            this.confData().put(conf.key(), object);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void log() {
        Set<String> configKeys = this.keys();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("registered configs:\n         |ConfigHub collected configs: ").append(configKeys.size()).append("\n         |  ").append(((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(configKeys).map((Function1 & Serializable & scala.Serializable)key -> new StringBuilder(3).append((String)key).append(" = ").append((Object)(key.contains("password") ? ConfigConst$.MODULE$.DEFAULT_DATAMASK_STRING() : MODULE$.get((String)key))).toString(), Set$.MODULE$.canBuildFrom())).mkString("\n  ")).toString())).stripMargin());
    }

    private InternalConfigHolder$() {
        MODULE$ = this;
        org.apache.streampark.common.util.Logger.$init$(this);
        this.initialCapacity = 45;
        this.confData = new ConcurrentHashMap(this.initialCapacity());
        this.confOptions = new ConcurrentHashMap(this.initialCapacity());
        Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{CommonConfig$.MODULE$, K8sFlinkConfig$.MODULE$}));
    }
}

