/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.Collections;
import org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeDesc;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.hive.service.rpc.thrift.TTypeQualifiers;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class SparkExecuteStatementOperation$ {
    public static final SparkExecuteStatementOperation$ MODULE$ = new SparkExecuteStatementOperation$();

    public boolean $lessinit$greater$default$5() {
        return true;
    }

    public TTypeId toTTypeId(DataType typ) {
        DataType dataType = typ;
        if (NullType$.MODULE$.equals(dataType)) {
            return TTypeId.NULL_TYPE;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return TTypeId.BOOLEAN_TYPE;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return TTypeId.TINYINT_TYPE;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return TTypeId.SMALLINT_TYPE;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return TTypeId.INT_TYPE;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return TTypeId.BIGINT_TYPE;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return TTypeId.FLOAT_TYPE;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return TTypeId.DOUBLE_TYPE;
        }
        if (dataType instanceof CharType) {
            return TTypeId.CHAR_TYPE;
        }
        if (dataType instanceof VarcharType) {
            return TTypeId.VARCHAR_TYPE;
        }
        if (dataType instanceof StringType) {
            return TTypeId.STRING_TYPE;
        }
        if (dataType instanceof DecimalType) {
            return TTypeId.DECIMAL_TYPE;
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return TTypeId.DATE_TYPE;
        }
        if (dataType instanceof TimeType) {
            return TTypeId.STRING_TYPE;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return TTypeId.TIMESTAMP_TYPE;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return TTypeId.TIMESTAMP_TYPE;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return TTypeId.BINARY_TYPE;
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return TTypeId.STRING_TYPE;
        }
        if (dataType instanceof DayTimeIntervalType) {
            return TTypeId.INTERVAL_DAY_TIME_TYPE;
        }
        if (dataType instanceof YearMonthIntervalType) {
            return TTypeId.INTERVAL_YEAR_MONTH_TYPE;
        }
        if (dataType instanceof ArrayType) {
            return TTypeId.ARRAY_TYPE;
        }
        if (dataType instanceof MapType) {
            return TTypeId.MAP_TYPE;
        }
        if (dataType instanceof StructType) {
            return TTypeId.STRUCT_TYPE;
        }
        throw new IllegalArgumentException("Unrecognized type name: " + dataType.catalogString());
    }

    private TTypeQualifiers toTTypeQualifiers(DataType typ) {
        java.util.Map map;
        TTypeQualifiers ret = new TTypeQualifiers();
        DataType dataType = typ;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value((int)decimalType.precision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value((int)decimalType.scale()))}))).asJava();
        } else {
            map = (dataType instanceof VarcharType ? true : dataType instanceof CharType) ? CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characterMaximumLength"), (Object)TTypeQualifierValue.i32Value((int)typ.defaultSize()))}))).asJava() : Collections.emptyMap();
        }
        java.util.Map qualifiers = map;
        ret.setQualifiers(qualifiers);
        return ret;
    }

    private TTypeDesc toTTypeDesc(DataType typ) {
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry((TPrimitiveTypeEntry)typeEntry));
        return tTypeDesc;
    }

    private TColumnDesc toTColumnDesc(StructField field, int pos) {
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(field.name());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(field.dataType()));
        tColumnDesc.setComment((String)field.getComment().getOrElse((Function0 & Serializable)() -> ""));
        tColumnDesc.setPosition(pos);
        return tColumnDesc;
    }

    public TTableSchema toTTableSchema(StructType schema) {
        TTableSchema tTableSchema = new TTableSchema();
        ((IterableOnceOps)CharVarcharUtils$.MODULE$.getRawSchema(schema).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SparkExecuteStatementOperation$.$anonfun$toTTableSchema$1(tTableSchema, x0$1);
            return BoxedUnit.UNIT;
        });
        return tTableSchema;
    }

    public static final /* synthetic */ void $anonfun$toTTableSchema$1(TTableSchema tTableSchema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            int i = tuple2._2$mcI$sp();
            tTableSchema$1.addToColumns(MODULE$.toTColumnDesc(f, i));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SparkExecuteStatementOperation$() {
    }
}

