/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.util.sketch.BitArray;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.BloomFilterBase;
import org.apache.spark.util.sketch.IncompatibleMergeException;

class BloomFilterImplV2
extends BloomFilterBase
implements Serializable {
    BloomFilterImplV2(int numHashFunctions, long numBits, int seed) {
        this(new BitArray(numBits), numHashFunctions, seed);
    }

    private BloomFilterImplV2(BitArray bits, int numHashFunctions, int seed) {
        super(bits, numHashFunctions, seed);
    }

    private BloomFilterImplV2() {
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BloomFilterImplV2)) {
            return false;
        }
        BloomFilterImplV2 that = (BloomFilterImplV2)other;
        return this.numHashFunctions == that.numHashFunctions && this.seed == that.seed && this.bits.equals(that.bits);
    }

    @Override
    protected boolean scatterHashAndSetAllBits(BloomFilterBase.HiLoHash inputHash) {
        int h1 = inputHash.hi();
        int h2 = inputHash.lo();
        long bitSize = this.bits.bitSize();
        boolean bitsChanged = false;
        long combinedHash = (long)h1 * Integer.MAX_VALUE;
        for (long i = 0L; i < (long)this.numHashFunctions; ++i) {
            long combinedIndex = (combinedHash += (long)h2) < 0L ? combinedHash ^ 0xFFFFFFFFFFFFFFFFL : combinedHash;
            bitsChanged |= this.bits.set(combinedIndex % bitSize);
        }
        return bitsChanged;
    }

    @Override
    protected boolean scatterHashAndGetAllBits(BloomFilterBase.HiLoHash inputHash) {
        int h1 = inputHash.hi();
        int h2 = inputHash.lo();
        long bitSize = this.bits.bitSize();
        long combinedHash = (long)h1 * Integer.MAX_VALUE;
        for (long i = 0L; i < (long)this.numHashFunctions; ++i) {
            long combinedIndex;
            long l = combinedIndex = (combinedHash += (long)h2) < 0L ? combinedHash ^ 0xFFFFFFFFFFFFFFFFL : combinedHash;
            if (this.bits.get(combinedIndex % bitSize)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BloomFilterImplV2 checkCompatibilityForMerge(BloomFilter other) throws IncompatibleMergeException {
        if (other == null) {
            throw new IncompatibleMergeException("Cannot merge null bloom filter");
        }
        if (!(other instanceof BloomFilterImplV2)) {
            throw new IncompatibleMergeException("Cannot merge bloom filter of class " + other.getClass().getName());
        }
        BloomFilterImplV2 that = (BloomFilterImplV2)other;
        if (this.bitSize() != that.bitSize()) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different bit size");
        }
        if (this.seed != that.seed) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different seeds");
        }
        if (this.numHashFunctions != that.numHashFunctions) {
            throw new IncompatibleMergeException("Cannot merge bloom filters with different number of hash functions");
        }
        return that;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(BloomFilter.Version.V2.getVersionNumber());
        dos.writeInt(this.numHashFunctions);
        dos.writeInt(this.seed);
        this.bits.writeTo(dos);
    }

    private void readFrom0(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        int version = dis.readInt();
        if (version != BloomFilter.Version.V2.getVersionNumber()) {
            throw new IOException("Unexpected Bloom filter version number (" + version + ")");
        }
        this.numHashFunctions = dis.readInt();
        this.seed = dis.readInt();
        this.bits = BitArray.readFrom(dis);
    }

    public static BloomFilterImplV2 readFrom(InputStream in) throws IOException {
        BloomFilterImplV2 filter = new BloomFilterImplV2();
        filter.readFrom0(in);
        return filter;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readFrom0(in);
    }
}

