/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.Localiser;

public class StringIndexOf3Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(this.stmt);
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(expr);
        ArrayList<SQLExpression> funcArgs2 = new ArrayList<SQLExpression>();
        SQLExpression substrExpr = args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        funcArgs2.add(substrExpr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        funcArgs.add(new StringExpression(this.stmt, this.getMappingForClass(String.class), "CAST", funcArgs2, (List)types));
        if (args.size() == 2) {
            SQLExpression fromExpr = args.get(1);
            if (!(fromExpr instanceof NumericExpression)) {
                throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 1, "NumericExpression"}));
            }
            types = new ArrayList();
            types.add("BIGINT");
            ArrayList<NumericExpression> funcArgs3 = new ArrayList<NumericExpression>();
            funcArgs3.add(new NumericExpression(fromExpr, Expression.OP_ADD, one));
            funcArgs.add(new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "CAST", funcArgs3, (List)types));
        }
        NumericExpression locateExpr = new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "LOCATE", funcArgs);
        return new NumericExpression(locateExpr, Expression.OP_SUB, one).encloseInParentheses();
    }
}

