/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.package$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.ExtendedAnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException$;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.Star;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRegex;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.InvalidUDFClassException;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GroupingID;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFunction;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.AnyValue;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Assignment;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.errors.CompilationErrors;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.SchemaUtils;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class QueryCompilationErrors$
implements QueryErrorsBase,
CompilationErrors {
    public static final QueryCompilationErrors$ MODULE$ = new QueryCompilationErrors$();

    static {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)MODULE$);
        QueryErrorsBase.$init$(MODULE$);
        CompilationErrors.$init$((CompilationErrors)MODULE$);
    }

    public AnalysisException ambiguousColumnOrFieldError(Seq<String> name, int numMatches) {
        return CompilationErrors.ambiguousColumnOrFieldError$((CompilationErrors)this, name, (int)numMatches);
    }

    public AnalysisException columnNotFoundError(String colName) {
        return CompilationErrors.columnNotFoundError$((CompilationErrors)this, (String)colName);
    }

    public AnalysisException descriptorParseError(Throwable cause) {
        return CompilationErrors.descriptorParseError$((CompilationErrors)this, (Throwable)cause);
    }

    public AnalysisException describeJsonNotExtendedError(String tableName) {
        return CompilationErrors.describeJsonNotExtendedError$((CompilationErrors)this, (String)tableName);
    }

    public AnalysisException describeColJsonUnsupportedError() {
        return CompilationErrors.describeColJsonUnsupportedError$((CompilationErrors)this);
    }

    public AnalysisException cannotFindDescriptorFileError(String filePath, Throwable cause) {
        return CompilationErrors.cannotFindDescriptorFileError$((CompilationErrors)this, (String)filePath, (Throwable)cause);
    }

    public Throwable usingUntypedScalaUDFError() {
        return CompilationErrors.usingUntypedScalaUDFError$((CompilationErrors)this);
    }

    public Throwable invalidBoundaryStartError(long start) {
        return CompilationErrors.invalidBoundaryStartError$((CompilationErrors)this, (long)start);
    }

    public Throwable invalidBoundaryEndError(long end) {
        return CompilationErrors.invalidBoundaryEndError$((CompilationErrors)this, (long)end);
    }

    public Throwable invalidSaveModeError(String saveMode) {
        return CompilationErrors.invalidSaveModeError$((CompilationErrors)this, (String)saveMode);
    }

    public Throwable sortByWithoutBucketingError() {
        return CompilationErrors.sortByWithoutBucketingError$((CompilationErrors)this);
    }

    public Throwable bucketByUnsupportedByOperationError(String operation) {
        return CompilationErrors.bucketByUnsupportedByOperationError$((CompilationErrors)this, (String)operation);
    }

    public Throwable bucketByAndSortByUnsupportedByOperationError(String operation) {
        return CompilationErrors.bucketByAndSortByUnsupportedByOperationError$((CompilationErrors)this, (String)operation);
    }

    public Throwable operationNotSupportPartitioningError(String operation) {
        return CompilationErrors.operationNotSupportPartitioningError$((CompilationErrors)this, (String)operation);
    }

    public Throwable operationNotSupportClusteringError(String operation) {
        return CompilationErrors.operationNotSupportClusteringError$((CompilationErrors)this, (String)operation);
    }

    public Throwable clusterByWithPartitionedBy() {
        return CompilationErrors.clusterByWithPartitionedBy$((CompilationErrors)this);
    }

    public Throwable clusterByWithBucketing() {
        return CompilationErrors.clusterByWithBucketing$((CompilationErrors)this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    public Throwable unexpectedRequiredParameter(String routineName, Seq<InputParameter> parameters) {
        String errorMessage = "Routine " + this.toSQLId(routineName) + " has an unexpected required argument for the provided routine signature " + parameters.mkString("[", ", ", "]") + ". All required arguments should come before optional arguments.";
        return SparkException$.MODULE$.internalError(errorMessage);
    }

    public Throwable namedArgumentsNotSupported(String functionName) {
        return new AnalysisException("NAMED_PARAMETERS_NOT_SUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(functionName))})));
    }

    public Throwable positionalAndNamedArgumentDoubleReference(String routineName, String parameterName) {
        String errorClass = "DUPLICATE_ROUTINE_PARAMETER_ASSIGNMENT.BOTH_POSITIONAL_AND_NAMED";
        return new AnalysisException(errorClass, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(routineName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameterName"), (Object)this.toSQLId(parameterName))})));
    }

    public Throwable doubleNamedArgumentReference(String routineName, String parameterName) {
        String errorClass = "DUPLICATE_ROUTINE_PARAMETER_ASSIGNMENT.DOUBLE_NAMED_ARGUMENT_REFERENCE";
        return new AnalysisException(errorClass, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(routineName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameterName"), (Object)this.toSQLId(parameterName))})));
    }

    public Throwable requiredParameterNotFound(String routineName, String parameterName, int index) {
        return new AnalysisException("REQUIRED_PARAMETER_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(routineName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameterName"), (Object)this.toSQLId(parameterName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index))})));
    }

    public Throwable unrecognizedParameterName(String routineName, String argumentName, Seq<String> candidates) {
        Seq inputs = (Seq)candidates.map((Function1 & Serializable)candidate -> new .colon.colon(candidate, (List)Nil$.MODULE$));
        Seq recommendations = (Seq)StringUtils$.MODULE$.orderSuggestedIdentifiersBySimilarity(argumentName, (Seq<Seq<String>>)inputs).take(3);
        return new AnalysisException("UNRECOGNIZED_PARAMETER_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(routineName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argumentName"), (Object)this.toSQLId(argumentName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)recommendations.mkString(" "))})));
    }

    public Throwable unexpectedPositionalArgument(String routineName, String precedingNamedArgument) {
        return new AnalysisException("UNEXPECTED_POSITIONAL_ARGUMENT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(routineName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameterName"), (Object)this.toSQLId(precedingNamedArgument))})));
    }

    public Throwable groupingIDMismatchError(GroupingID groupingID, Seq<Expression> groupByExprs) {
        return new AnalysisException("GROUPING_ID_COLUMN_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupingIdColumn"), (Object)groupingID.groupByExprs().mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupByColumns"), (Object)groupByExprs.mkString(","))})));
    }

    public Throwable groupingColInvalidError(Expression groupingCol, Seq<Expression> groupByExprs) {
        return new AnalysisException("GROUPING_COLUMN_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grouping"), (Object)groupingCol.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupingColumns"), (Object)groupByExprs.mkString(","))})));
    }

    public Throwable groupingSizeTooLargeError(int sizeLimit) {
        return new AnalysisException("GROUPING_SIZE_LIMIT_EXCEEDED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxSize"), (Object)Integer.toString(sizeLimit))})));
    }

    public Throwable zeroArgumentIndexError() {
        return new AnalysisException("INVALID_PARAMETER_VALUE.ZERO_INDEX", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId("strfmt")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId("format_string"))})));
    }

    public Throwable binaryFormatError(String funcName, String invalidFormat) {
        return new AnalysisException("INVALID_PARAMETER_VALUE.BINARY_FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId("format")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(funcName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidFormat"), (Object)this.toSQLValue(invalidFormat, (DataType)StringType$.MODULE$))})));
    }

    public Throwable nullArgumentError(String funcName, String parameter) {
        return new AnalysisException("INVALID_PARAMETER_VALUE.NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId(parameter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(funcName))})));
    }

    public Throwable invalidRandomSeedParameter(String functionName, Expression invalidValue) {
        return this.invalidParameter("LONG", functionName, "seed", invalidValue);
    }

    public Throwable invalidReverseParameter(Expression invalidValue) {
        return this.invalidParameter("BOOLEAN", "collect_top_k", "reverse", invalidValue);
    }

    public Throwable invalidNumParameter(Expression invalidValue) {
        return this.invalidParameter("INTEGER", "collect_top_k", "num", invalidValue);
    }

    public Throwable invalidIgnoreNullsParameter(String functionName, Expression invalidValue) {
        return this.invalidParameter("BOOLEAN", functionName, "ignoreNulls", invalidValue);
    }

    public Throwable invalidIgnoreNAParameter(String functionName, Expression invalidValue) {
        return this.invalidParameter("BOOLEAN", functionName, "ignoreNA", invalidValue);
    }

    public Throwable invalidDdofParameter(String functionName, Expression invalidValue) {
        return this.invalidParameter("INTEGER", functionName, "ddof", invalidValue);
    }

    public Throwable invalidAlphaParameter(Expression invalidValue) {
        return this.invalidParameter("DOUBLE", "ewm", "alpha", invalidValue);
    }

    public Throwable invalidStringParameter(String functionName, String parameter, Expression invalidValue) {
        return this.invalidParameter("STRING", functionName, parameter, invalidValue);
    }

    public Throwable invalidParameter(String subClass, String functionName, String parameter, Expression invalidValue) {
        return new AnalysisException("INVALID_PARAMETER_VALUE." + subClass, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(functionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId(parameter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidValue"), (Object)this.toSQLExpr(invalidValue))})));
    }

    public Throwable unorderablePivotColError(Expression pivotCol) {
        return new AnalysisException("INCOMPARABLE_PIVOT_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(pivotCol.sql()))})));
    }

    public Throwable nonLiteralPivotValError(Expression pivotVal) {
        return new AnalysisException("NON_LITERAL_PIVOT_VALUES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)this.toSQLExpr(pivotVal))})));
    }

    public Throwable pivotValDataTypeMismatchError(Expression pivotVal, Expression pivotCol) {
        return new AnalysisException("PIVOT_VALUE_DATA_TYPE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)pivotVal.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)pivotVal.dataType().simpleString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pivotType"), (Object)pivotCol.dataType().catalogString())})));
    }

    public Throwable unpivotRequiresAttributes(String given, String empty, Seq<NamedExpression> expressions) {
        Seq nonAttributes = (Seq)((IterableOps)expressions.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QueryCompilationErrors$.$anonfun$unpivotRequiresAttributes$1(x$1)))).map((Function1 & Serializable)e -> MODULE$.toSQLExpr((Expression)e));
        return new AnalysisException("UNPIVOT_REQUIRES_ATTRIBUTES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"given"), (Object)given), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"empty"), (Object)empty), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressions"), (Object)nonAttributes.mkString(", "))})));
    }

    public Throwable unpivotRequiresValueColumns() {
        return new AnalysisException("UNPIVOT_REQUIRES_VALUE_COLUMNS", Predef$.MODULE$.Map().empty());
    }

    public Throwable unpivotValueSizeMismatchError(int names) {
        return new AnalysisException("UNPIVOT_VALUE_SIZE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"names"), (Object)Integer.toString(names))})));
    }

    public Throwable unpivotValueDataTypeMismatchError(Seq<Seq<NamedExpression>> values2) {
        List dataTypes = ((List)((IterableOps)values2.map((Function1 & Serializable)x0$1 -> {
            SeqOps seqOps;
            Seq seq = x0$1;
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                NamedExpression value = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return value;
            }
            return (NamedExpression)new Some((Object)CreateStruct$.MODULE$.apply((Seq<Expression>)seq)).map((Function1 & Serializable)e -> {
                CreateNamedStruct x$1 = e;
                String x$2 = e.sql();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }).get();
        })).groupBy((Function1 & Serializable)x$2 -> ((Expression)((Object)x$2)).dataType()).transform((Function2 & Serializable)(x$3, values) -> (Seq)((SeqOps)values.map((Function1 & Serializable)value -> MODULE$.toSQLId(value.name()))).sorted((Ordering)Ordering.String$.MODULE$)).transform((Function2 & Serializable)(x$4, values) -> {
            if (values.length() > 3) {
                return (Seq)((SeqOps)values.take(3)).$colon$plus((Object)"...");
            }
            return values;
        }).toList().sortBy((Function1 & Serializable)x$5 -> ((DataType)x$5._1()).sql(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return MODULE$.toSQLType((AbstractDataType)dataType) + " (" + values.mkString(", ") + ")";
            }
            throw new MatchError((Object)tuple2);
        });
        return new AnalysisException("UNPIVOT_VALUE_DATA_TYPE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"types"), (Object)dataTypes.mkString(", "))})));
    }

    public Throwable unsupportedIfNotExistsError(String tableName) {
        return new AnalysisException("UNSUPPORTED_FEATURE.INSERT_PARTITION_SPEC_IF_NOT_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName))})));
    }

    public Throwable nonPartitionColError(String partitionName) {
        return new AnalysisException("NON_PARTITION_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(partitionName))})));
    }

    public Throwable missingStaticPartitionColumn(String staticName) {
        return SparkException$.MODULE$.internalError("Unknown static partition column: " + staticName + ".");
    }

    public Throwable staticPartitionInUserSpecifiedColumnsError(String staticName) {
        return new AnalysisException("STATIC_PARTITION_COLUMN_IN_INSERT_COLUMN_LIST", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"staticName"), (Object)staticName)})));
    }

    public Throwable nestedGeneratorError(Expression trimmedNestedGenerator) {
        return new AnalysisException("UNSUPPORTED_GENERATOR.NESTED_IN_EXPRESSIONS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)this.toSQLExpr(trimmedNestedGenerator))})));
    }

    public Throwable moreThanOneGeneratorError(Seq<Expression> generators) {
        return new AnalysisException("UNSUPPORTED_GENERATOR.MULTI_GENERATOR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num"), (Object)Integer.toString(generators.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generators"), (Object)((IterableOnceOps)generators.map((Function1 & Serializable)e -> MODULE$.toSQLExpr((Expression)e))).mkString(", "))})));
    }

    public Throwable generatorOutsideSelectError(LogicalPlan plan2) {
        return new AnalysisException("UNSUPPORTED_GENERATOR.OUTSIDE_SELECT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plan"), (Object)plan2.simpleString(SQLConf$.MODULE$.get().maxToStringFields()))})));
    }

    public Throwable legacyStoreAssignmentPolicyError() {
        String configKey = SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key();
        return new AnalysisException("_LEGACY_ERROR_TEMP_1000", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configKey"), (Object)configKey)})));
    }

    public Throwable namedArgumentsNotEnabledError(String functionName, String argumentName) {
        return new AnalysisException("NAMED_PARAMETER_SUPPORT_DISABLED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(functionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argument"), (Object)this.toSQLId(argumentName))})));
    }

    public Throwable collatedStringsInMapKeysNotSupportedError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.COLLATIONS_IN_MAP_KEYS", Predef$.MODULE$.Map().empty());
    }

    public Throwable objectLevelCollationsNotEnabledError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.OBJECT_LEVEL_COLLATIONS", Predef$.MODULE$.Map().empty());
    }

    public Throwable trimCollationNotEnabledError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.TRIM_COLLATION", Predef$.MODULE$.Map().empty());
    }

    public Throwable trailingCommaInSelectError(Origin origin) {
        return new AnalysisException("TRAILING_COMMA_IN_SELECT", Predef$.MODULE$.Map().empty(), origin);
    }

    public Throwable unresolvedUsingColForJoinError(String colName, String suggestion, String side) {
        return new AnalysisException("UNRESOLVED_USING_COLUMN_FOR_JOIN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"side"), (Object)side), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"suggestion"), (Object)suggestion)})));
    }

    public Throwable unresolvedAttributeError(String errorClass, String colName, Seq<String> candidates, Origin origin) {
        Map commonParam = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)this.toSQLId(colName))}));
        Map proposalParam = candidates.isEmpty() ? Predef$.MODULE$.Map().empty() : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)((IterableOnceOps)((IterableOps)candidates.take(5)).map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString(", "))}));
        String errorSubClass = candidates.isEmpty() ? "WITHOUT_SUGGESTION" : "WITH_SUGGESTION";
        return new AnalysisException(errorClass + "." + errorSubClass, (Map)commonParam.$plus$plus((IterableOnce)proposalParam), origin);
    }

    public Throwable unresolvedColumnError(String columnName, Seq<String> proposal) {
        Map commonParam = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)this.toSQLId(columnName))}));
        Map proposalParam = proposal.isEmpty() ? Predef$.MODULE$.Map().empty() : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)((IterableOnceOps)((IterableOps)proposal.take(5)).map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString(", "))}));
        String errorSubClass = proposal.isEmpty() ? "WITHOUT_SUGGESTION" : "WITH_SUGGESTION";
        return new AnalysisException("UNRESOLVED_COLUMN." + errorSubClass, (Map)commonParam.$plus$plus((IterableOnce)proposalParam));
    }

    public Throwable unresolvedFieldError(String fieldName, Seq<String> columnPath, Seq<String> proposal) {
        Map commonParams = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnPath"), (Object)this.toSQLId(columnPath))}));
        Map proposalParam = proposal.isEmpty() ? Predef$.MODULE$.Map().empty() : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)((IterableOnceOps)proposal.map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString(", "))}));
        String errorSubClass = proposal.isEmpty() ? "WITHOUT_SUGGESTION" : "WITH_SUGGESTION";
        return new AnalysisException("UNRESOLVED_FIELD." + errorSubClass, (Map)commonParams.$plus$plus((IterableOnce)proposalParam));
    }

    public Throwable dataTypeMismatchForDeserializerError(DataType dataType, String desiredType) {
        return new AnalysisException("UNSUPPORTED_DESERIALIZER.DATA_TYPE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desiredType"), (Object)this.toSQLType(desiredType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)dataType))})));
    }

    public Throwable fieldNumberMismatchForDeserializerError(StructType schema, int maxOrdinal) {
        return new AnalysisException("UNSUPPORTED_DESERIALIZER.FIELD_NUMBER_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)schema)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ordinal"), (Object)Integer.toString(maxOrdinal + 1))})));
    }

    public Throwable upCastFailureError(String fromStr, Expression from, DataType to, Seq<String> walkedTypePath) {
        return new AnalysisException("CANNOT_UP_CAST_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)fromStr), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType((AbstractDataType)from.dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"details"), (Object)("The type path of the target object is:\n" + walkedTypePath.mkString("", "\n", "\n") + "You can either add an explicit cast to the input data or choose a higher precision type of the field in the target object"))})));
    }

    public Throwable outerScopeFailureForNewInstanceError(String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1002", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable referenceColNotFoundForAlterTableChangesError(String fieldName, String[] fields) {
        return new AnalysisException("FIELD_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)Predef$.MODULE$.wrapRefArray((Object[])fields).mkString(", "))})));
    }

    public Throwable windowSpecificationNotDefinedError(String windowName) {
        return new AnalysisException("MISSING_WINDOW_SPECIFICATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowName"), (Object)windowName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())})));
    }

    public Throwable selectExprNotInGroupByError(Expression expr, Seq<Alias> groupByAliases) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1005", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupByAliases"), (Object)groupByAliases.toString())})));
    }

    public Throwable groupingMustWithGroupingSetsOrCubeOrRollupError() {
        return new AnalysisException("UNSUPPORTED_GROUPING_EXPRESSION", Predef$.MODULE$.Map().empty());
    }

    public Throwable pandasUDFAggregateNotSupportedInPivotError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.PANDAS_UDAF_IN_PIVOT", Predef$.MODULE$.Map().empty());
    }

    public Throwable aggregateExpressionRequiredForPivotError(String sql2) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1006", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sql"), (Object)sql2)})));
    }

    public Throwable writeIntoTempViewNotAllowedError(String quoted) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1007", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoted"), (Object)quoted)})));
    }

    public Throwable readNonStreamingTempViewError(String quoted) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1008", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoted"), (Object)quoted)})));
    }

    public Throwable viewDepthExceedsMaxResolutionDepthError(TableIdentifier identifier, int maxNestedDepth, TreeNode<?> t) {
        return new AnalysisException("VIEW_EXCEED_MAX_NESTED_DEPTH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(identifier.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxNestedDepth"), (Object)Integer.toString(maxNestedDepth))})), t.origin());
    }

    public Throwable insertIntoViewNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException("EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(identifier.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"INSERT")})), t.origin());
    }

    public Throwable writeIntoViewNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1011", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)identifier.toString())})), t.origin());
    }

    public Throwable writeIntoV1TableNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1012", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)identifier.toString())})), t.origin());
    }

    public Throwable expectTableNotViewError(Seq<String> nameParts, String cmd, boolean suggestAlternative, TreeNode<?> t) {
        return new AnalysisException(suggestAlternative ? "EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW" : "EXPECT_TABLE_NOT_VIEW.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(nameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)cmd)})), t.origin());
    }

    public Throwable expectViewNotTableError(Seq<String> nameParts, String cmd, boolean suggestAlternative, TreeNode<?> t) {
        return new AnalysisException(suggestAlternative ? "EXPECT_VIEW_NOT_TABLE.USE_ALTER_TABLE" : "EXPECT_VIEW_NOT_TABLE.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(nameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)cmd)})), t.origin());
    }

    public Throwable expectPermanentViewNotTempViewError(Seq<String> nameParts, String cmd, TreeNode<?> t) {
        return new AnalysisException("EXPECT_PERMANENT_VIEW_NOT_TEMP", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(nameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)cmd)})), t.origin());
    }

    public Throwable expectPersistentFuncError(String name, String cmd, Option<String> mismatchHint, TreeNode<?> t) {
        String hintStr = (String)mismatchHint.map((Function1 & Serializable)x$6 -> " " + x$6).getOrElse((Function0 & Serializable)() -> "");
        return new AnalysisException("_LEGACY_ERROR_TEMP_1017", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hintStr"), (Object)hintStr)})), t.origin());
    }

    public Throwable permanentViewNotSupportedByStreamingReadingAPIError(String quoted) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1018", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoted"), (Object)quoted)})));
    }

    public Throwable starNotAllowedWhenGroupByOrdinalPositionUsedError() {
        return new AnalysisException("STAR_GROUP_BY_POS", Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidStarUsageError(String prettyName, Seq<Star> stars) {
        Seq regExpr = (Seq)stars.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Star, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnresolvedRegex) {
                    UnresolvedRegex unresolvedRegex = (UnresolvedRegex)A1;
                    String pattern = unresolvedRegex.regexPattern();
                    return (B1)("'" + pattern + "'");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Star x1) {
                Star star = x1;
                return star instanceof UnresolvedRegex;
            }
        });
        Option resExprMsg = Option$.MODULE$.apply(regExpr.distinct()).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.nonEmpty())).map((Function1 & Serializable)x0$1 -> {
            SeqOps seqOps;
            Seq seq = x0$1;
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                String p = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return "regular expression " + p;
            }
            return "regular expressions " + seq.mkString(", ");
        });
        None$ starMsg = stars.length() - regExpr.length() > 0 ? new Some((Object)"'*'") : None$.MODULE$;
        String elem = ((IterableOnceOps)new .colon.colon((Object)starMsg, (List)new .colon.colon((Object)resExprMsg, (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms())).mkString(" and ");
        return new AnalysisException("INVALID_USAGE_OF_STAR_OR_REGEX", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elem"), (Object)elem), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prettyName"), (Object)prettyName)})));
    }

    public Throwable singleTableStarInCountNotAllowedError(String targetString) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1021", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetString"), (Object)targetString)})));
    }

    public Throwable orderByPositionRangeError(int index, int size, TreeNode<?> t) {
        return new AnalysisException("ORDER_BY_POS_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Integer.toString(size))})), t.origin());
    }

    public Throwable groupByPositionRefersToAggregateFunctionError(int index, Expression expr) {
        return new AnalysisException("GROUP_BY_POS_AGGREGATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aggExpr"), (Object)expr.sql())})));
    }

    public Throwable groupByPositionRangeError(int index, int size) {
        return new AnalysisException("GROUP_BY_POS_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Integer.toString(size))})));
    }

    public Throwable generatorNotExpectedError(FunctionIdentifier name, String classCanonicalName) {
        return new AnalysisException("UNSUPPORTED_GENERATOR.NOT_GENERATOR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(name.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"classCanonicalName"), (Object)classCanonicalName)})));
    }

    public Throwable functionWithUnsupportedSyntaxError(String prettyName, String syntax) {
        return new AnalysisException("INVALID_SQL_SYNTAX.FUNCTION_WITH_UNSUPPORTED_SYNTAX", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prettyName"), (Object)this.toSQLId(prettyName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"syntax"), (Object)this.toSQLStmt(syntax))})));
    }

    public Throwable subqueryExpressionInLambdaOrHigherOrderFunctionNotAllowedError() {
        return new AnalysisException("UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.HIGHER_ORDER_FUNCTION", Predef$.MODULE$.Map().empty());
    }

    public Throwable nonDeterministicFilterInAggregateError(Expression filterExpr) {
        return new AnalysisException("INVALID_AGGREGATE_FILTER.NON_DETERMINISTIC", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filterExpr"), (Object)this.toSQLExpr(filterExpr))})));
    }

    public Throwable nonBooleanFilterInAggregateError(Expression filterExpr) {
        return new AnalysisException("INVALID_AGGREGATE_FILTER.NOT_BOOLEAN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filterExpr"), (Object)this.toSQLExpr(filterExpr))})));
    }

    public Throwable aggregateInAggregateFilterError(Expression filterExpr, Expression aggExpr) {
        return new AnalysisException("INVALID_AGGREGATE_FILTER.CONTAINS_AGGREGATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filterExpr"), (Object)this.toSQLExpr(filterExpr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aggExpr"), (Object)this.toSQLExpr(aggExpr))})));
    }

    public Throwable windowFunctionInAggregateFilterError(Expression filterExpr, Expression windowExpr) {
        return new AnalysisException("INVALID_AGGREGATE_FILTER.CONTAINS_WINDOW_FUNCTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filterExpr"), (Object)this.toSQLExpr(filterExpr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowExpr"), (Object)this.toSQLExpr(windowExpr))})));
    }

    public Throwable distinctWithOrderingFunctionUnsupportedError(String funcName) {
        return new AnalysisException("INVALID_WITHIN_GROUP_EXPRESSION.DISTINCT_UNSUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(funcName))})));
    }

    public Throwable functionMissingWithinGroupError(String funcName) {
        return new AnalysisException("INVALID_WITHIN_GROUP_EXPRESSION.WITHIN_GROUP_MISSING", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(funcName))})));
    }

    public Throwable wrongNumOrderingsForFunctionError(String funcName, int validOrderingsNumber, int actualOrderingsNumber) {
        return new AnalysisException("INVALID_WITHIN_GROUP_EXPRESSION.WRONG_NUM_ORDERINGS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(funcName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)Integer.toString(validOrderingsNumber)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)Integer.toString(actualOrderingsNumber))})));
    }

    public Throwable aliasNumberNotMatchColumnNumberError(int columnSize, int outputSize, TreeNode<?> t) {
        return new AnalysisException("ASSIGNMENT_ARITY_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numExpr"), (Object)Integer.toString(columnSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTarget"), (Object)Integer.toString(outputSize))})), t.origin());
    }

    public Throwable aliasesNumberNotMatchUDTFOutputError(int aliasesSize, String aliasesNames) {
        return new AnalysisException("UDTF_ALIAS_NUMBER_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aliasesSize"), (Object)Integer.toString(aliasesSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aliasesNames"), (Object)aliasesNames)})));
    }

    public Throwable invalidSortOrderInUDTFOrderingColumnFromAnalyzeMethodHasAlias(String aliasName) {
        return new AnalysisException("UDTF_INVALID_ALIAS_IN_REQUESTED_ORDERING_STRING_FROM_ANALYZE_METHOD", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aliasName"), (Object)aliasName)})));
    }

    public Throwable invalidUDTFSelectExpressionFromAnalyzeMethodNeedsAlias(String expression) {
        return new AnalysisException("UDTF_INVALID_REQUESTED_SELECTED_EXPRESSION_FROM_ANALYZE_METHOD_REQUIRES_ALIAS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)expression)})));
    }

    public Throwable windowAggregateFunctionWithFilterNotSupportedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1030", Predef$.MODULE$.Map().empty());
    }

    public Throwable windowFunctionInsideAggregateFunctionNotAllowedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1031", Predef$.MODULE$.Map().empty());
    }

    public Throwable expressionWithoutWindowExpressionError(NamedExpression expr) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1032", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)((Expression)((Object)expr)).toString())})));
    }

    public Throwable expressionWithMultiWindowExpressionsError(NamedExpression expr, Seq<WindowSpecDefinition> distinctWindowSpec) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1033", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)((Expression)((Object)expr)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distinctWindowSpec"), (Object)distinctWindowSpec.toString())})));
    }

    public Throwable windowFunctionNotAllowedError(String clauseName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1034", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clauseName"), (Object)clauseName)})));
    }

    public Throwable cannotSpecifyWindowFrameError(String prettyName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1035", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prettyName"), (Object)prettyName)})));
    }

    public Throwable windowFrameNotMatchRequiredFrameError(SpecifiedWindowFrame f, WindowFrame required) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1036", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wf"), (Object)f.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"required"), (Object)((Expression)((Object)required)).toString())})));
    }

    public Throwable windowFunctionWithWindowFrameNotOrderedError(WindowFunction wf) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1037", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wf"), (Object)((Expression)((Object)wf)).toString())})));
    }

    public Throwable multiTimeWindowExpressionsNotSupportedError(TreeNode<?> t) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1039", Predef$.MODULE$.Map().empty(), t.origin());
    }

    public Throwable sessionWindowGapDurationDataTypeError(DataType dt) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1040", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dt"), (Object)dt.toString())})));
    }

    public Throwable unresolvedVariableError(Seq<String> name, Seq<String> searchPath) {
        return new AnalysisException("UNRESOLVED_VARIABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"variableName"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"searchPath"), (Object)this.toSQLId(searchPath))})));
    }

    public Throwable unresolvedVariableError(Seq<String> name, Seq<String> searchPath, Origin origin) {
        return new AnalysisException("UNRESOLVED_VARIABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"variableName"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"searchPath"), (Object)this.toSQLId(searchPath))})), origin);
    }

    public Throwable failedToLoadRoutineError(Seq<String> nameParts, Exception e) {
        return new AnalysisException("FAILED_TO_LOAD_ROUTINE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(nameParts))})), (Option)new Some((Object)e));
    }

    public Throwable unresolvedRoutineError(FunctionIdentifier name, Seq<String> searchPath) {
        return new AnalysisException("UNRESOLVED_ROUTINE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(name.funcName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"searchPath"), (Object)((IterableOnceOps)searchPath.map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString("[", ", ", "]"))})));
    }

    public Throwable unresolvedRoutineError(Seq<String> nameParts, Seq<String> searchPath, Origin context) {
        return new AnalysisException("UNRESOLVED_ROUTINE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routineName"), (Object)this.toSQLId(nameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"searchPath"), (Object)((IterableOnceOps)searchPath.map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString("[", ", ", "]"))})), context);
    }

    public Throwable wrongNumArgsError(String name, Seq<Object> validParametersCount, int actualNumber, String legacyNum, String legacyConfKey, String legacyConfValue) {
        String expectedNumberOfParameters;
        String string = validParametersCount.isEmpty() ? "0" : (expectedNumberOfParameters = validParametersCount.length() == 1 ? validParametersCount.head().toString() : validParametersCount.mkString("[", ", ", "]"));
        if (legacyNum.isEmpty()) {
            return new AnalysisException("WRONG_NUM_ARGS.WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)expectedNumberOfParameters), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)Integer.toString(actualNumber)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())})));
        }
        return new AnalysisException("WRONG_NUM_ARGS.WITH_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)expectedNumberOfParameters), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)Integer.toString(actualNumber)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"legacyNum"), (Object)legacyNum), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"legacyConfKey"), (Object)legacyConfKey), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"legacyConfValue"), (Object)legacyConfValue)})));
    }

    public String wrongNumArgsError$default$4() {
        return "";
    }

    public String wrongNumArgsError$default$5() {
        return "";
    }

    public String wrongNumArgsError$default$6() {
        return "";
    }

    public Throwable alterV2TableSetLocationWithPartitionNotSupportedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1045", Predef$.MODULE$.Map().empty());
    }

    public Throwable joinStrategyHintParameterNotSupportedError(Expression unsupported) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1046", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupported"), (Object)this.toSQLExpr(unsupported)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)unsupported.getClass().toString())})));
    }

    public Throwable invalidHintParameterError(String hintName, Seq<Expression> invalidParams) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1047", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hintName"), (Object)hintName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidParams"), (Object)((IterableOnceOps)invalidParams.map((Function1 & Serializable)e -> MODULE$.toSQLExpr((Expression)e))).mkString(", "))})));
    }

    public Throwable invalidCoalesceHintParameterError(String hintName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1048", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hintName"), (Object)hintName)})));
    }

    public Throwable starExpandDataTypeNotSupportedError(Seq<String> attributes) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1050", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attributes"), (Object)attributes.toString())})));
    }

    public Throwable cannotResolveStarExpandGivenInputColumnsError(String targetString, String columns) {
        return new AnalysisException("CANNOT_RESOLVE_STAR_EXPAND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetString"), (Object)this.toSQLId(targetString)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columns"), (Object)columns)})));
    }

    public Throwable addColumnWithV1TableCannotSpecifyNotNullError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1052", Predef$.MODULE$.Map().empty());
    }

    public Throwable unsupportedTableOperationError(CatalogPlugin catalog, Identifier ident, String operation) {
        String string = catalog.name();
        return this.unsupportedTableOperationError((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)string, ClassTag$.MODULE$.apply(String.class))), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq(), operation);
    }

    public Throwable unsupportedTableOperationError(TableIdentifier ident, String operation) {
        return this.unsupportedTableOperationError((Seq<String>)new .colon.colon((Object)((String)ident.catalog().get()), (List)new .colon.colon((Object)((String)ident.database().get()), (List)new .colon.colon((Object)ident.table(), (List)Nil$.MODULE$))), operation);
    }

    private Throwable unsupportedTableOperationError(Seq<String> qualifiedTableName, String operation) {
        return new AnalysisException("UNSUPPORTED_FEATURE.TABLE_OPERATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(qualifiedTableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)})));
    }

    private Throwable unsupportedTableOperationError(String tableName, String operation) {
        return new AnalysisException("UNSUPPORTED_FEATURE.TABLE_OPERATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)})));
    }

    public Throwable unsupportedBatchReadError(Table table) {
        return this.unsupportedTableOperationError(table.name(), "batch scan");
    }

    public Throwable unsupportedStreamingScanError(Table table) {
        return this.unsupportedTableOperationError(table.name(), "either micro-batch or continuous scan");
    }

    public Throwable unsupportedAppendInBatchModeError(String name) {
        return this.unsupportedTableOperationError(name, "append in batch mode");
    }

    public Throwable unsupportedDynamicOverwriteInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table.name(), "dynamic overwrite in batch mode");
    }

    public Throwable unsupportedTruncateInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table.name(), "truncate in batch mode");
    }

    public Throwable unsupportedOverwriteByFilterInBatchModeError(String name) {
        return this.unsupportedTableOperationError(name, "overwrite by filter in batch mode");
    }

    public Throwable catalogOperationNotSupported(CatalogPlugin catalog, String operation) {
        return new AnalysisException("UNSUPPORTED_FEATURE.CATALOG_OPERATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogName"), (Object)this.toSQLId((Seq<String>)new .colon.colon((Object)catalog.name(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)})));
    }

    public Throwable functionAndOrderExpressionMismatchError(String functionName, Expression functionArg, Seq<SortOrder> orderExpr) {
        return new AnalysisException("INVALID_WITHIN_GROUP_EXPRESSION.MISMATCH_WITH_DISTINCT_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(functionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcArg"), (Object)this.toSQLExpr(functionArg)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orderingExpr"), (Object)((IterableOnceOps)orderExpr.map((Function1 & Serializable)order -> MODULE$.toSQLExpr(order.child()))).mkString(", "))})));
    }

    public Throwable wrongCommandForObjectTypeError(String operation, String requiredType, String objectName, String foundType, String alternative) {
        return new AnalysisException("WRONG_COMMAND_FOR_OBJECT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)requiredType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)objectName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foundType"), (Object)foundType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alternative"), (Object)alternative)})));
    }

    public Throwable showColumnsWithConflictNamespacesError(Seq<String> namespaceA, Seq<String> namespaceB) {
        return new AnalysisException("SHOW_COLUMNS_WITH_CONFLICT_NAMESPACE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespaceA"), (Object)this.toSQLId(namespaceA)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespaceB"), (Object)this.toSQLId(namespaceB))})));
    }

    public Throwable cannotCreateTableWithBothProviderAndSerdeError(Option<String> provider, Option<SerdeInfo> maybeSerdeInfo) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1058", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serDeInfo"), (Object)((SerdeInfo)maybeSerdeInfo.get()).describe())})));
    }

    public Throwable invalidFileFormatForStoredAsError(SerdeInfo serdeInfo) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1059", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serdeInfo"), serdeInfo.storedAs().get())})));
    }

    public Throwable commandNotSupportNestedColumnError(String command, String quoted) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1060", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"command"), (Object)command), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)quoted)})));
    }

    public Throwable renameTempViewToExistingViewError(String newName) {
        return new TableAlreadyExistsException(newName);
    }

    public Throwable cannotDropNonemptyDatabaseError(String db) {
        return new AnalysisException("SCHEMA_NOT_EMPTY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)this.toSQLId(db))})));
    }

    public Throwable cannotDropNonemptyNamespaceError(Seq<String> namespace) {
        return new AnalysisException("SCHEMA_NOT_EMPTY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaName"), (Object)((IterableOnceOps)namespace.map((Function1 & Serializable)part -> org.apache.spark.sql.catalyst.util.package$.MODULE$.quoteIdentifier((String)part))).mkString("."))})));
    }

    public Throwable invalidNameForTableOrDatabaseError(String name) {
        return new AnalysisException("INVALID_SCHEMA_OR_RELATION_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name))})));
    }

    public Throwable cannotCreateDatabaseWithSameNameAsPreservedDatabaseError(String database) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1066", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)database)})));
    }

    public Throwable cannotDropDefaultDatabaseError(Seq<String> nameParts) {
        return new AnalysisException("UNSUPPORTED_FEATURE.DROP_DATABASE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)this.toSQLId(nameParts))})));
    }

    public Throwable cannotUsePreservedDatabaseAsCurrentDatabaseError(String database) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1068", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)database)})));
    }

    public Throwable createExternalTableWithoutLocationError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1069", Predef$.MODULE$.Map().empty());
    }

    public Throwable dropNonExistentColumnsNotSupportedError(Seq<String> nonExistentColumnNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1071", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonExistentColumnNames"), (Object)nonExistentColumnNames.mkString("[", ",", "]"))})));
    }

    public Throwable cannotRetrieveTableOrViewNotInSameDatabaseError(Seq<QualifiedTableName> qualifiedTableNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1072", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qualifiedTableNames"), (Object)qualifiedTableNames.toString())})));
    }

    public Throwable renameTableSourceAndDestinationMismatchError(String db, String newDb) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1073", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"db"), (Object)db), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newDb"), (Object)newDb)})));
    }

    public Throwable cannotRenameTempViewWithDatabaseSpecifiedError(TableIdentifier oldName, TableIdentifier newName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1074", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldName"), (Object)oldName.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newName"), (Object)newName.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"db"), newName.database().get())})));
    }

    public Throwable cannotRenameTempViewToExistingTableError(TableIdentifier newName) {
        return new TableAlreadyExistsException(newName.nameParts());
    }

    public Throwable invalidPartitionSpecError(String details) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1076", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"details"), (Object)details)})));
    }

    public Throwable functionAlreadyExistsError(FunctionIdentifier func) {
        return new FunctionAlreadyExistsException(func.nameParts());
    }

    public Throwable cannotLoadClassWhenRegisteringFunctionError(String className, FunctionIdentifier func) {
        return new AnalysisException("CANNOT_LOAD_FUNCTION_CLASS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(func.toString()))})));
    }

    public Throwable resourceTypeNotSupportedError(String resourceType) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1079", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceType"), (Object)resourceType)})));
    }

    public Throwable tableNotSpecifyDatabaseError(TableIdentifier identifier) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1080", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)identifier.toString())})));
    }

    public Throwable tableNotSpecifyLocationUriError(TableIdentifier identifier) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1081", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)identifier.toString())})));
    }

    public Throwable partitionNotSpecifyLocationUriError(String specString) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1082", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specString"), (Object)specString)})));
    }

    public Throwable invalidBucketNumberError(int bucketingMaxBuckets, int numBuckets) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1083", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bucketingMaxBuckets"), (Object)Integer.toString(bucketingMaxBuckets)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numBuckets"), (Object)Integer.toString(numBuckets))})));
    }

    public Throwable corruptedTableNameContextInCatalogError(int numParts, int index) {
        return new AnalysisException("INTERNAL_ERROR_METADATA_CATALOG.TABLE_NAME_CONTEXT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numParts"), (Object)Integer.toString(numParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index))})));
    }

    public Throwable corruptedViewSQLConfigsInCatalogError(Exception e) {
        return new AnalysisException("INTERNAL_ERROR_METADATA_CATALOG.SQL_CONFIG", Predef$.MODULE$.Map().empty(), (Option)new Some((Object)e));
    }

    public Throwable corruptedViewQueryOutputColumnsInCatalogError(String numCols, int index) {
        return new AnalysisException("INTERNAL_ERROR_METADATA_CATALOG.VIEW_QUERY_COLUMN_ARITY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)numCols), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)Integer.toString(index))})));
    }

    public Throwable corruptedViewReferredTempViewInCatalogError(Exception e) {
        return new AnalysisException("INTERNAL_ERROR_METADATA_CATALOG.TEMP_VIEW_REFERENCE", Predef$.MODULE$.Map().empty(), (Option)new Some((Object)e));
    }

    public Throwable corruptedViewReferredTempFunctionsInCatalogError(Exception e) {
        return new AnalysisException("INTERNAL_ERROR_METADATA_CATALOG.TEMP_FUNCTION_REFERENCE", Predef$.MODULE$.Map().empty(), (Option)new Some((Object)e));
    }

    public Throwable columnStatisticsDeserializationNotSupportedError(String name, DataType dataType) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1089", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})));
    }

    public Throwable columnStatisticsSerializationNotSupportedError(String colName, DataType dataType) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1090", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})));
    }

    public Throwable insufficientTablePropertyError(String key) {
        return new AnalysisException("INSUFFICIENT_TABLE_PROPERTY.MISSING_KEY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLConf(key))})));
    }

    public Throwable insufficientTablePropertyPartError(String key, String totalAmountOfParts) {
        return new AnalysisException("INSUFFICIENT_TABLE_PROPERTY.MISSING_KEY_PART", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLConf(key)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalAmountOfParts"), (Object)totalAmountOfParts)})));
    }

    public Throwable unexpectedSchemaTypeError(Expression exp) {
        return new AnalysisException("INVALID_SCHEMA.NON_STRING_LITERAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSchema"), (Object)this.toSQLExpr(exp))})));
    }

    public Throwable schemaIsNotStructTypeError(Expression exp, DataType dataType) {
        return this.schemaIsNotStructTypeError(this.toSQLExpr(exp), dataType);
    }

    public Throwable schemaIsNotStructTypeError(String inputSchema, DataType dataType) {
        return new AnalysisException("INVALID_SCHEMA.NON_STRUCT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSchema"), (Object)inputSchema), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)dataType))})));
    }

    public Throwable keyValueInMapNotStringError(CreateMap m) {
        return new AnalysisException("INVALID_OPTIONS.NON_STRING_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapType"), (Object)this.toSQLType((AbstractDataType)m.dataType()))})));
    }

    public Throwable nonMapFunctionNotAllowedError() {
        return new AnalysisException("INVALID_OPTIONS.NON_MAP_FUNCTION", Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidFieldTypeForCorruptRecordError(String columnName, DataType actualType) {
        return new AnalysisException("INVALID_CORRUPT_RECORD_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(columnName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualType"), (Object)this.toSQLType((AbstractDataType)actualType))})));
    }

    public Throwable dataTypeUnsupportedByClassError(DataType x, String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1098", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)x.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable parseModeUnsupportedError(String funcName, ParseMode mode) {
        return new AnalysisException("PARSE_MODE_UNSUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(funcName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)mode.name())})));
    }

    public Throwable nonFoldableArgumentError(String funcName, String paramName, DataType paramType) {
        return new AnalysisException("NON_FOLDABLE_ARGUMENT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(funcName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramName"), (Object)this.toSQLId(paramName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramType"), (Object)this.toSQLType((AbstractDataType)paramType))})));
    }

    public Throwable literalTypeUnsupportedForSourceTypeError(String field, Expression source) {
        return new AnalysisException("INVALID_EXTRACT_FIELD", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)this.toSQLId(field)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(source))})));
    }

    public Throwable arrayComponentTypeUnsupportedError(Class<?> clz) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1103", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clz"), (Object)clz.toString())})));
    }

    public Throwable secondArgumentNotDoubleLiteralError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1104", Predef$.MODULE$.Map().empty());
    }

    public Throwable dataTypeUnsupportedByExtractValueError(DataType dataType, Expression extraction, Expression child) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof StructType) {
            return new AnalysisException("INVALID_EXTRACT_FIELD_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extraction"), (Object)this.toSQLExpr(extraction))})));
        }
        return new AnalysisException("INVALID_EXTRACT_BASE_FIELD_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"base"), (Object)this.toSQLExpr(child)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)this.toSQLType((AbstractDataType)dataType2))})));
    }

    public Throwable noHandlerForUDAFError(String name) {
        return new InvalidUDFClassException("NO_HANDLER_FOR_UDAF", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)name)}))));
    }

    public Throwable batchWriteCapabilityError(Table table, String v2WriteClassName, String v1WriteClassName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1107", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchWrite"), (Object)TableCapability.V1_BATCH_WRITE.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v2WriteClassName"), (Object)v2WriteClassName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v1WriteClassName"), (Object)v1WriteClassName)})));
    }

    public Throwable unsupportedDeleteByConditionWithSubqueryError(Expression condition) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1108", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)condition.toString())})));
    }

    public Throwable cannotTranslateExpressionToSourceFilterError(Expression f) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1109", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f"), (Object)f.toString())})));
    }

    public Throwable cannotDeleteTableWhereFiltersError(Table table, Predicate[] filters) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1110", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filters"), (Object)Predef$.MODULE$.wrapRefArray((Object[])filters).mkString("[", ", ", "]"))})));
    }

    public Throwable describeDoesNotSupportPartitionForV2TablesError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1111", Predef$.MODULE$.Map().empty());
    }

    public Throwable cannotReplaceMissingTableError(Identifier tableIdentifier) {
        return new CannotReplaceMissingTableException(tableIdentifier, CannotReplaceMissingTableException$.MODULE$.$lessinit$greater$default$2());
    }

    public Throwable cannotReplaceMissingTableError(Identifier tableIdentifier, Option<Throwable> cause) {
        return new CannotReplaceMissingTableException(tableIdentifier, cause);
    }

    public Throwable streamingSourcesDoNotSupportCommonExecutionModeError(Seq<String> microBatchSources, Seq<String> continuousSources) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1114", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"microBatchSources"), (Object)microBatchSources.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"continuousSources"), (Object)continuousSources.mkString(", "))})));
    }

    public NoSuchTableException noSuchTableError(Identifier ident) {
        return new NoSuchTableException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
    }

    public Throwable noSuchTableError(Seq<String> nameParts) {
        return new NoSuchTableException(nameParts);
    }

    public Throwable noSuchNamespaceError(String[] namespace) {
        return new NoSuchNamespaceException(namespace);
    }

    public Throwable tableAlreadyExistsError(Identifier ident) {
        return new TableAlreadyExistsException(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier());
    }

    public Throwable requiresSinglePartNamespaceError(Seq<String> namespace) {
        return new AnalysisException("REQUIRES_SINGLE_PART_NAMESPACE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sessionCatalog"), (Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)this.toSQLId(namespace))})));
    }

    public Throwable namespaceAlreadyExistsError(String[] namespace) {
        return new NamespaceAlreadyExistsException(namespace);
    }

    private Throwable notSupportedInJDBCCatalog(String cmd) {
        return new AnalysisException("NOT_SUPPORTED_IN_JDBC_CATALOG.COMMAND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)this.toSQLStmt(cmd))})));
    }

    private Throwable notSupportedInJDBCCatalog(String cmd, String property) {
        return new AnalysisException("NOT_SUPPORTED_IN_JDBC_CATALOG.COMMAND_WITH_PROPERTY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)this.toSQLStmt(cmd)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)this.toSQLConf(property))})));
    }

    public Throwable cannotCreateJDBCTableUsingProviderError() {
        return this.notSupportedInJDBCCatalog("CREATE TABLE ... USING ...");
    }

    public Throwable cannotCreateJDBCTableUsingLocationError() {
        return this.notSupportedInJDBCCatalog("CREATE TABLE ... LOCATION ...");
    }

    public Throwable cannotCreateJDBCNamespaceUsingProviderError() {
        return this.notSupportedInJDBCCatalog("CREATE NAMESPACE ... LOCATION ...");
    }

    public Throwable cannotCreateJDBCNamespaceWithPropertyError(String property) {
        return this.notSupportedInJDBCCatalog("CREATE NAMESPACE", property);
    }

    public Throwable cannotSetJDBCNamespaceWithPropertyError(String property) {
        return this.notSupportedInJDBCCatalog("SET NAMESPACE", property);
    }

    public Throwable cannotUnsetJDBCNamespaceWithPropertyError(String property) {
        return this.notSupportedInJDBCCatalog("UNSET NAMESPACE", property);
    }

    public Throwable unsupportedJDBCNamespaceChangeInCatalogError(Seq<NamespaceChange> changes) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1120", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changes"), (Object)changes.toString())})));
    }

    private Throwable tableDoesNotSupportError(String cmd, Table table) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1121", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.name())})));
    }

    public Throwable tableDoesNotSupportReadsError(Table table) {
        return this.tableDoesNotSupportError("reads", table);
    }

    public Throwable tableDoesNotSupportWritesError(Table table) {
        return this.tableDoesNotSupportError("writes", table);
    }

    public Throwable tableDoesNotSupportDeletesError(Table table) {
        return this.tableDoesNotSupportError("deletes", table);
    }

    public Throwable tableDoesNotSupportTruncatesError(Table table) {
        return this.tableDoesNotSupportError("truncates", table);
    }

    public Throwable tableDoesNotSupportPartitionManagementError(Table table) {
        return this.tableDoesNotSupportError("partition management", table);
    }

    public Throwable tableDoesNotSupportAtomicPartitionManagementError(Table table) {
        return this.tableDoesNotSupportError("atomic partition management", table);
    }

    public Throwable tableIsNotRowLevelOperationTableError(Table table) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1122", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.name())})));
    }

    public Throwable cannotRenameTableWithAlterViewError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1123", Predef$.MODULE$.Map().empty());
    }

    private Throwable notSupportedForV2TablesError(String cmd) {
        return new AnalysisException("NOT_SUPPORTED_COMMAND_FOR_V2_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)this.toSQLStmt(cmd))})));
    }

    public Throwable analyzeTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ANALYZE TABLE");
    }

    public Throwable alterTableRecoverPartitionsNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ALTER TABLE ... RECOVER PARTITIONS");
    }

    public Throwable alterTableSerDePropertiesNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]");
    }

    public Throwable describeAsJsonNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("DESCRIBE TABLE AS JSON");
    }

    public Throwable loadDataNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("LOAD DATA");
    }

    public Throwable showCreateTableAsSerdeNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("SHOW CREATE TABLE AS SERDE");
    }

    public Throwable repairTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("MSCK REPAIR TABLE");
    }

    public Throwable databaseFromV1SessionCatalogNotSpecifiedError() {
        return new AnalysisException("MISSING_DATABASE_FOR_V1_SESSION_CATALOG", Predef$.MODULE$.Map().empty());
    }

    public Throwable nestedDatabaseUnsupportedByV1SessionCatalogError(String catalog) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1126", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), (Object)catalog)})));
    }

    public Throwable invalidRepartitionExpressionsError(Seq<Object> sortOrders) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1127", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sortOrders"), (Object)sortOrders.toString())})));
    }

    public Throwable partitionColumnNotSpecifiedError(String format, String partitionColumn) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1128", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionColumn"), (Object)partitionColumn)})));
    }

    public Throwable dataSchemaNotSpecifiedError(String format) {
        return new AnalysisException("UNABLE_TO_INFER_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format)})));
    }

    public Throwable dataPathNotExistError(String path) {
        return new AnalysisException("PATH_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})));
    }

    public AnalysisException dataSourceOutputModeUnsupportedError(String className, OutputMode outputMode) {
        return new AnalysisException("STREAMING_OUTPUT_MODE.UNSUPPORTED_DATASOURCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputMode"), (Object)outputMode.toString().toLowerCase(Locale.ROOT))})));
    }

    public AnalysisException unsupportedOutputModeForStreamingOperationError(OutputMode outputMode, String operation) {
        return new AnalysisException("STREAMING_OUTPUT_MODE.UNSUPPORTED_OPERATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputMode"), (Object)outputMode.toString().toLowerCase(Locale.ROOT)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)})));
    }

    public Throwable schemaNotSpecifiedForSchemaRelationProviderError(String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1132", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable userSpecifiedSchemaMismatchActualSchemaError(StructType schema, StructType actualSchema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1133", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.toDDL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualSchema"), (Object)actualSchema.toDDL())})));
    }

    public Throwable dataSchemaNotSpecifiedError(String format, String fileCatalog) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1134", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileCatalog"), (Object)fileCatalog)})));
    }

    public Throwable invalidDataSourceError(String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1135", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable cannotResolveAttributeError(String name, String outputStr) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1137", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputStr"), (Object)outputStr)})));
    }

    public Throwable orcNotUsedWithHiveEnabledError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1138", Predef$.MODULE$.Map().empty());
    }

    public Throwable failedToFindAvroDataSourceError(String provider) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1139", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider)})));
    }

    public Throwable failedToFindKafkaDataSourceError(String provider) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1140", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider)})));
    }

    public Throwable findMultipleDataSourceError(String provider, Seq<String> sourceNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1141", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceNames"), (Object)sourceNames.mkString(", "))})));
    }

    public Throwable writeEmptySchemasUnsupportedByDataSourceError(String format) {
        return new AnalysisException("EMPTY_SCHEMA_NOT_SUPPORTED_FOR_DATASOURCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format)})));
    }

    public Throwable insertMismatchedColumnNumberError(Seq<Attribute> targetAttributes, Seq<Attribute> sourceAttributes, int staticPartitionsSize) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1143", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSize"), (Object)Integer.toString(targetAttributes.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualSize"), (Object)Integer.toString(sourceAttributes.size() + staticPartitionsSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"staticPartitionsSize"), (Object)Integer.toString(staticPartitionsSize))})));
    }

    public Throwable insertMismatchedPartitionNumberError(StructType targetPartitionSchema, int providedPartitionsSize) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1144", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSize"), (Object)Integer.toString(targetPartitionSchema.fields().length)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"providedPartitionsSize"), (Object)Integer.toString(providedPartitionsSize))})));
    }

    public Throwable invalidPartitionColumnError(String partKey, StructType targetPartitionSchema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1145", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partKey"), (Object)partKey), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionColumns"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields()), (Function1 & Serializable)x$8 -> x$8.name(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ",", "]"))})));
    }

    public Throwable multiplePartitionColumnValuesSpecifiedError(StructField field, Map<String, String> potentialSpecs) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1146", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partColumn"), (Object)field.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)potentialSpecs.mkString("[", ", ", "]"))})));
    }

    public Throwable invalidOrderingForConstantValuePartitionColumnError(StructType targetPartitionSchema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1147", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partColumns"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields()), (Function1 & Serializable)x$9 -> x$9.name(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ",", "]"))})));
    }

    public Throwable cannotWriteDataToRelationsWithMultiplePathsError(Seq<Path> paths) {
        return new AnalysisException("UNSUPPORTED_INSERT.MULTI_PATH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)paths.mkString("[", ",", "]"))})));
    }

    public Throwable failedToRebuildExpressionError(Filter filter) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1149", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filter"), (Object)filter.toString())})));
    }

    public Throwable dataTypeUnsupportedByDataSourceError(String format, StructField column) {
        return new AnalysisException("UNSUPPORTED_DATA_TYPE_FOR_DATASOURCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(column.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)this.toSQLType((AbstractDataType)column.dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format)})));
    }

    public Throwable failToResolveDataSourceForTableError(CatalogTable table, String key) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1151", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.identifier().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR().key())})));
    }

    public Throwable outputPathAlreadyExistsError(Path outputPath) {
        return new AnalysisException("PATH_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputPath"), (Object)outputPath.toString())})));
    }

    public Throwable invalidPartitionColumnDataTypeError(StructField field) {
        return new AnalysisException("INVALID_PARTITION_COLUMN_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSQLType((AbstractDataType)field.dataType()))})));
    }

    public Throwable cannotUseAllColumnsForPartitionColumnsError() {
        return new AnalysisException("ALL_PARTITION_COLUMNS_NOT_ALLOWED", Predef$.MODULE$.Map().empty());
    }

    public Throwable partitionColumnNotFoundInSchemaError(String col, String schemaCatalog) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1155", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)col), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaCatalog"), (Object)schemaCatalog)})));
    }

    public Throwable columnNotFoundInSchemaError(DataType colType, String colName, String tableName, String[] tableCols) {
        return new AnalysisException("COLUMN_NOT_DEFINED_IN_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colType"), (Object)this.toSQLType((AbstractDataType)colType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableCols"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tableCols), (Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts), ClassTag$.MODULE$.apply(String.class))).mkString(", "))})));
    }

    public Throwable saveDataIntoViewNotAllowedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1158", Predef$.MODULE$.Map().empty());
    }

    public Throwable mismatchedTableFormatError(String tableName, Class<?> existingProvider, Class<?> specifiedProvider) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1159", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingProvider"), (Object)existingProvider.getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedProvider"), (Object)specifiedProvider.getSimpleName())})));
    }

    public Throwable mismatchedTableLocationError(TableIdentifier identifier, CatalogTable existingTable, CatalogTable tableDesc) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1160", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)identifier.quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingTableLoc"), (Object)existingTable.location().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableDescLoc"), (Object)tableDesc.location().toString())})));
    }

    public Throwable mismatchedTableColumnNumberError(String tableName, CatalogTable existingTable, LogicalPlan query) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1161", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingTableSchema"), (Object)existingTable.schema().catalogString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"querySchema"), (Object)query.schema().catalogString())})));
    }

    public Throwable cannotResolveColumnGivenInputColumnsError(String col, String inputColumns) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1162", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)col), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputColumns"), (Object)inputColumns)})));
    }

    public Throwable mismatchedTablePartitionColumnError(String tableName, Seq<String> specifiedPartCols, String existingPartCols) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1163", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedPartCols"), (Object)specifiedPartCols.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingPartCols"), (Object)existingPartCols)})));
    }

    public Throwable mismatchedTableBucketingError(String tableName, String specifiedBucketString, String existingBucketString) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1164", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedBucketString"), (Object)specifiedBucketString), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingBucketString"), (Object)existingBucketString)})));
    }

    public Throwable mismatchedTableClusteringError(String tableName, String specifiedClusteringString, String existingClusteringString) {
        return new AnalysisException("CLUSTERING_COLUMNS_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedClusteringString"), (Object)specifiedClusteringString), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingClusteringString"), (Object)existingClusteringString)})));
    }

    public Throwable specifyPartitionNotAllowedWhenTableSchemaNotDefinedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1165", Predef$.MODULE$.Map().empty());
    }

    public Throwable bucketingColumnCannotBePartOfPartitionColumnsError(String bucketCol, Seq<String> normalizedPartCols) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1166", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bucketCol"), (Object)bucketCol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normalizedPartCols"), (Object)normalizedPartCols.mkString(", "))})));
    }

    public Throwable bucketSortingColumnCannotBePartOfPartitionColumnsError(String sortCol, Seq<String> normalizedPartCols) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1167", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sortCol"), (Object)sortCol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normalizedPartCols"), (Object)normalizedPartCols.mkString(", "))})));
    }

    public Throwable invalidBucketColumnDataTypeError(DataType dataType) {
        return new AnalysisException("INVALID_BUCKET_COLUMN_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSQLType((AbstractDataType)dataType))})));
    }

    public Throwable requestedPartitionsMismatchTablePartitionsError(String tableName, Map<String, Option<String>> normalizedPartSpec, StructType partColNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1169", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normalizedPartSpec"), (Object)normalizedPartSpec.keys().mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partColNames"), (Object)((IterableOnceOps)partColNames.map((Function1 & Serializable)x$10 -> x$10.name())).mkString(","))})));
    }

    public Throwable ddlWithoutHiveSupportEnabledError(String cmd) {
        return new AnalysisException("NOT_SUPPORTED_COMMAND_WITHOUT_HIVE_SUPPORT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)})));
    }

    public Throwable createTableColumnTypesOptionColumnNotFoundInSchemaError(String col, StructType schema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1171", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)col), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.catalogString())})));
    }

    public Throwable invalidVariantMissingFieldError(String field) {
        return new AnalysisException("INVALID_VARIANT_FROM_PARQUET.MISSING_FIELD", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field)})));
    }

    public Throwable invalidVariantNullableOrNotBinaryFieldError(String field) {
        return new AnalysisException("INVALID_VARIANT_FROM_PARQUET.NULLABLE_OR_NOT_BINARY_FIELD", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field)})));
    }

    public Throwable invalidVariantShreddingSchema(DataType schema) {
        return new AnalysisException("INVALID_VARIANT_SHREDDING_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)schema))})));
    }

    public Throwable invalidVariantWrongNumFieldsError() {
        return new AnalysisException("INVALID_VARIANT_FROM_PARQUET.WRONG_NUM_FIELDS", Predef$.MODULE$.Map().empty());
    }

    public Throwable parquetTypeUnsupportedYetError(String parquetType) {
        return new AnalysisException("PARQUET_TYPE_NOT_SUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquetType"), (Object)parquetType)})));
    }

    public Throwable illegalParquetTypeError(String parquetType) {
        return new AnalysisException("PARQUET_TYPE_ILLEGAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquetType"), (Object)parquetType)})));
    }

    public Throwable unrecognizedParquetTypeError(String field) {
        return new AnalysisException("PARQUET_TYPE_NOT_RECOGNIZED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field)})));
    }

    public Throwable cannotConvertDataTypeToParquetTypeError(StructField field) {
        return new AnalysisException("INTERNAL_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)("Cannot convert Spark data type " + this.toSQLType((AbstractDataType)field.dataType()) + " to any Parquet type."))})));
    }

    public Throwable incompatibleViewSchemaChangeError(String viewName, String colName, int expectedNum, Seq<Attribute> actualCols, Option<String> viewDDL) {
        return (Throwable)viewDDL.map((Function1 & Serializable)v -> new AnalysisException("INCOMPATIBLE_VIEW_SCHEMA_CHANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)viewName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)Integer.toString(expectedNum)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualCols"), (Object)((IterableOnceOps)actualCols.map((Function1 & Serializable)x$11 -> x$11.name())).mkString("[", ",", "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"suggestion"), v)})))).getOrElse((Function0 & Serializable)() -> new AnalysisException("INCOMPATIBLE_VIEW_SCHEMA_CHANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)viewName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)Integer.toString(expectedNum)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualCols"), (Object)((IterableOnceOps)actualCols.map((Function1 & Serializable)x$12 -> x$12.name())).mkString("[", ",", "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"suggestion"), (Object)"CREATE OR REPLACE TEMPORARY VIEW")}))));
    }

    public Throwable numberOfPartitionsNotAllowedWithUnspecifiedDistributionError() {
        return new AnalysisException("INVALID_WRITE_DISTRIBUTION.PARTITION_NUM_WITH_UNSPECIFIED_DISTRIBUTION", Predef$.MODULE$.Map().empty());
    }

    public Throwable partitionSizeNotAllowedWithUnspecifiedDistributionError() {
        return new AnalysisException("INVALID_WRITE_DISTRIBUTION.PARTITION_SIZE_WITH_UNSPECIFIED_DISTRIBUTION", Predef$.MODULE$.Map().empty());
    }

    public Throwable numberAndSizeOfPartitionsNotAllowedTogether() {
        return new AnalysisException("INVALID_WRITE_DISTRIBUTION.PARTITION_NUM_AND_SIZE", Predef$.MODULE$.Map().empty());
    }

    public Throwable unexpectedInputDataTypeError(String functionName, int paramIndex, DataType dataType, Expression expression) {
        return new AnalysisException("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(paramIndex - 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(functionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)dataType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(expression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)expression.dataType()))})));
    }

    public Throwable unexpectedNullError(String exprName, Expression expression) {
        return new AnalysisException("DATATYPE_MISMATCH.UNEXPECTED_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.toSQLId(exprName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(expression))})));
    }

    public Throwable streamJoinStreamWithoutEqualityPredicateUnsupportedError(LogicalPlan plan2) {
        return new ExtendedAnalysisException(new AnalysisException("_LEGACY_ERROR_TEMP_1181", Predef$.MODULE$.Map().empty()), plan2);
    }

    public Throwable invalidPandasUDFPlacementError(Seq<String> groupAggPandasUDFNames) {
        return new AnalysisException("INVALID_PANDAS_UDF_PLACEMENT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionList"), (Object)((IterableOnceOps)groupAggPandasUDFNames.map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString(", "))})));
    }

    public Throwable ambiguousAttributesInSelfJoinError(Seq<AttributeReference> ambiguousAttrs) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1182", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ambiguousAttrs"), (Object)ambiguousAttrs.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.FAIL_AMBIGUOUS_SELF_JOIN_ENABLED().key())})));
    }

    public Throwable ambiguousColumnOrFieldError(Seq<String> name, int numMatches, Origin context) {
        return DataTypeErrors$.MODULE$.ambiguousColumnOrFieldError(name, numMatches, context);
    }

    public Throwable ambiguousReferenceError(String name, Seq<Attribute> ambiguousReferences) {
        return new AnalysisException("AMBIGUOUS_REFERENCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"referenceNames"), (Object)((IterableOnceOps)((SeqOps)ambiguousReferences.map((Function1 & Serializable)ar -> MODULE$.toSQLId(ar.qualifiedName()))).sorted((Ordering)Ordering.String$.MODULE$)).mkString("[", ", ", "]"))})));
    }

    public Throwable cannotUseIntervalTypeInTableSchemaError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1183", Predef$.MODULE$.Map().empty());
    }

    public Throwable missingCatalogAbilityError(CatalogPlugin plugin, String ability) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plugin"), (Object)plugin.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ability"), (Object)ability)})));
    }

    public Throwable tableValuedArgumentsNotYetImplementedForSqlFunctions(String action, String functionName) {
        return new AnalysisException("TABLE_VALUED_ARGUMENTS_NOT_YET_IMPLEMENTED_FOR_SQL_FUNCTIONS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"action"), (Object)action), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName)})));
    }

    public Throwable tableValuedFunctionTooManyTableArgumentsError(int num) {
        return new AnalysisException("TABLE_VALUED_FUNCTION_TOO_MANY_TABLE_ARGUMENTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num"), (Object)Integer.toString(num))})));
    }

    public Throwable tableValuedFunctionFailedToAnalyseInPythonError(String msg) {
        return new AnalysisException("TABLE_VALUED_FUNCTION_FAILED_TO_ANALYZE_IN_PYTHON", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg)})));
    }

    public Throwable pythonDataSourceError(String action, String tpe, String msg) {
        return new AnalysisException("PYTHON_DATA_SOURCE_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"action"), (Object)action), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)tpe), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg)})));
    }

    public Throwable identifierTooManyNamePartsError(String originalIdentifier) {
        return new AnalysisException("IDENTIFIER_TOO_MANY_NAME_PARTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)this.toSQLId(originalIdentifier))})));
    }

    public Throwable identifierTooManyNamePartsError(Seq<String> names) {
        return new AnalysisException("IDENTIFIER_TOO_MANY_NAME_PARTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)this.toSQLId(names))})));
    }

    public Throwable emptyMultipartIdentifierError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1186", Predef$.MODULE$.Map().empty());
    }

    public Throwable cannotOperateOnHiveDataSourceFilesError(String operation) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1187", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)})));
    }

    public Throwable setPathOptionAndCallWithPathParameterError(String method) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1188", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"method"), (Object)method), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key())})));
    }

    public Throwable userSpecifiedSchemaUnsupportedError(String operation) {
        return DataTypeErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
    }

    public Throwable tempViewNotSupportStreamingWriteError(String viewName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1190", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)viewName)})));
    }

    public Throwable streamingIntoViewNotSupportedError(String viewName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1191", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)viewName)})));
    }

    public Throwable inputSourceDiffersFromDataSourceProviderError(String source, String tableName, CatalogTable table) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1192", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)source), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), table.provider().get())})));
    }

    public Throwable tableNotSupportStreamingWriteError(String tableName, Table t) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1193", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t"), (Object)t.toString())})));
    }

    public Throwable queryNameNotSpecifiedForMemorySinkError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1194", Predef$.MODULE$.Map().empty());
    }

    public Throwable sourceNotSupportedWithContinuousTriggerError(String source) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1195", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)source)})));
    }

    public Throwable columnNotFoundInExistingColumnsError(String columnType, String columnName, Seq<String> validColumnNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1196", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)columnType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"validColumnNames"), (Object)validColumnNames.mkString(", "))})));
    }

    public Throwable mixedRefsInAggFunc(String funcStr, Origin origin) {
        String x$1 = "UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.AGGREGATE_FUNCTION_MIXED_OUTER_LOCAL_REFERENCES";
        Origin x$2 = origin;
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"function"), (Object)funcStr)}));
        return new AnalysisException("UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.AGGREGATE_FUNCTION_MIXED_OUTER_LOCAL_REFERENCES", x$3, x$2);
    }

    public Throwable subqueryReturnMoreThanOneColumn(int number, Origin origin) {
        String x$1 = "INVALID_SUBQUERY_EXPRESSION.SCALAR_SUBQUERY_RETURN_MORE_THAN_ONE_OUTPUT_COLUMN";
        Origin x$2 = origin;
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)Integer.toString(number))}));
        return new AnalysisException("INVALID_SUBQUERY_EXPRESSION.SCALAR_SUBQUERY_RETURN_MORE_THAN_ONE_OUTPUT_COLUMN", x$3, x$2);
    }

    public Throwable unsupportedCorrelatedReferenceDataTypeError(Expression expr, DataType dataType, Origin origin) {
        String x$1 = "UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.UNSUPPORTED_CORRELATED_REFERENCE_DATA_TYPE";
        Origin x$2 = origin;
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr.sql()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.typeName())}));
        return new AnalysisException("UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.UNSUPPORTED_CORRELATED_REFERENCE_DATA_TYPE", x$3, x$2);
    }

    public Throwable unsupportedCorrelatedSubqueryInJoinConditionError(Seq<Expression> unsupportedSubqueryExpressions) {
        return new AnalysisException("UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.UNSUPPORTED_CORRELATED_EXPRESSION_IN_JOIN_CONDITION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subqueryExpression"), (Object)((IterableOnceOps)unsupportedSubqueryExpressions.map((Function1 & Serializable)x$13 -> x$13.sql())).mkString(", "))})));
    }

    public Throwable functionCannotProcessInputError(UnboundFunction unbound, Seq<Expression> arguments, UnsupportedOperationException unsupported) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1198", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unbound"), (Object)unbound.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arguments"), (Object)((IterableOnceOps)arguments.map((Function1 & Serializable)x$14 -> x$14.dataType().simpleString())).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupported"), (Object)unsupported.getMessage())})), (Option)new Some((Object)unsupported));
    }

    public Throwable v2FunctionInvalidInputTypeLengthError(BoundFunction bound, Seq<Expression> args) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1199", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bound"), (Object)bound.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argsLen"), (Object)Integer.toString(args.length())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputTypesLen"), (Object)Integer.toString(bound.inputTypes().length))})));
    }

    public Throwable cannotResolveColumnNameAmongAttributesError(String colName, String fieldNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1201", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)fieldNames)})));
    }

    public Throwable cannotWriteTooManyColumnsToTableError(String tableName, Seq<String> expected, Seq<Attribute> queryOutput) {
        return new AnalysisException("INSERT_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)((IterableOnceOps)expected.map((Function1 & Serializable)c -> MODULE$.toSQLId((String)c))).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)((IterableOnceOps)queryOutput.map((Function1 & Serializable)c -> MODULE$.toSQLId(c.name()))).mkString(", "))})));
    }

    public Throwable cannotWriteNotEnoughColumnsToTableError(String tableName, Seq<String> expected, Seq<Attribute> queryOutput) {
        return new AnalysisException("INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)((IterableOnceOps)expected.map((Function1 & Serializable)c -> MODULE$.toSQLId((String)c))).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)((IterableOnceOps)queryOutput.map((Function1 & Serializable)c -> MODULE$.toSQLId(c.name()))).mkString(", "))})));
    }

    public Throwable incompatibleDataToTableCannotFindDataError(String tableName, String colName) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_FIND_DATA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName))})));
    }

    public Throwable incompatibleDataToTableAmbiguousColumnNameError(String tableName, String colName) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.AMBIGUOUS_COLUMN_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName))})));
    }

    public Throwable incompatibleDataToTableExtraColumnsError(String tableName, String extraColumns) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.EXTRA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extraColumns"), (Object)extraColumns)})));
    }

    public Throwable incompatibleDataToTableExtraStructFieldsError(String tableName, String colName, String extraFields) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.EXTRA_STRUCT_FIELDS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extraFields"), (Object)extraFields)})));
    }

    public Throwable incompatibleDataToTableNullableColumnError(String tableName, String colName) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.NULLABLE_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName))})));
    }

    public Throwable incompatibleDataToTableNullableArrayElementsError(String tableName, String colName) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.NULLABLE_ARRAY_ELEMENTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName))})));
    }

    public Throwable incompatibleDataToTableNullableMapValuesError(String tableName, String colName) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.NULLABLE_MAP_VALUES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName))})));
    }

    public Throwable incompatibleDataToTableCannotSafelyCastError(String tableName, String colName, String srcType, String targetType) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)this.toSQLType(srcType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(targetType))})));
    }

    public Throwable incompatibleDataToTableStructMissingFieldsError(String tableName, String colName, String missingFields) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.STRUCT_MISSING_FIELDS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"missingFields"), (Object)missingFields)})));
    }

    public Throwable incompatibleDataToTableUnexpectedColumnNameError(String tableName, String colName, int order, String expected, String found) {
        return new AnalysisException("INCOMPATIBLE_DATA_FOR_TABLE.UNEXPECTED_COLUMN_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"order"), (Object)Integer.toString(order)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expected"), (Object)this.toSQLId(expected)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"found"), (Object)this.toSQLId(found))})));
    }

    public Throwable invalidRowLevelOperationAssignments(Seq<Assignment> assignments, Seq<String> errors) {
        return new AnalysisException("DATATYPE_MISMATCH.INVALID_ROW_LEVEL_OPERATION_ASSIGNMENTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)((IterableOnceOps)assignments.map((Function1 & Serializable)e -> MODULE$.toSQLExpr((Expression)e))).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"errors"), (Object)errors.mkString("\n- ", "\n- ", ""))})));
    }

    public Throwable invalidEscapeChar(Expression sqlExpr) {
        return new AnalysisException("INVALID_ESCAPE_CHAR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(sqlExpr))})));
    }

    public Throwable secondArgumentOfFunctionIsNotIntegerError(String function, NumberFormatException e) {
        return new AnalysisException("SECOND_FUNCTION_ARGUMENT_NOT_INTEGER", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)function)})), (Option)new Some((Object)e));
    }

    public Throwable nonPartitionPruningPredicatesNotExpectedError(Seq<Expression> nonPartitionPruningPredicates) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1205", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonPartitionPruningPredicates"), (Object)nonPartitionPruningPredicates.toString())})));
    }

    public Throwable columnNotDefinedInTableError(String colType, String colName, String tableName, Seq<String> tableCols) {
        return new AnalysisException("COLUMN_NOT_DEFINED_IN_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colType"), (Object)colType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableCols"), (Object)((IterableOnceOps)tableCols.map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString(", "))})));
    }

    public Throwable invalidLiteralForWindowDurationError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1207", Predef$.MODULE$.Map().empty());
    }

    public Throwable noSuchStructFieldInGivenFieldsError(String fieldName, StructField[] fields) {
        return new AnalysisException("FIELD_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> MODULE$.toSQLId(f.name()), ClassTag$.MODULE$.apply(String.class))).mkString(", "))})));
    }

    public Throwable ambiguousReferenceToFieldsError(String field, int numberOfAppearance) {
        return new AnalysisException("AMBIGUOUS_REFERENCE_TO_FIELDS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)this.toSQLId(field)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)Integer.toString(numberOfAppearance))})));
    }

    public Throwable secondArgumentInFunctionIsNotBooleanLiteralError(String funcName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1210", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
    }

    public Throwable joinConditionMissingOrTrivialError(Join join, LogicalPlan left, LogicalPlan right) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1211", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType"), (Object)join.joinType().sql()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftPlan"), (Object)left.treeString(false, left.treeString$default$2(), left.treeString$default$3(), left.treeString$default$4()).trim()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightPlan"), (Object)right.treeString(false, right.treeString$default$2(), right.treeString$default$3(), right.treeString$default$4()).trim())})));
    }

    public Throwable usePythonUDFInJoinConditionUnsupportedError(JoinType joinType) {
        return new AnalysisException("UNSUPPORTED_FEATURE.PYTHON_UDF_IN_ON_CLAUSE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType"), (Object)this.toSQLStmt(joinType.sql()))})));
    }

    public Throwable conflictingAttributesInJoinConditionError(AttributeSet conflictingAttrs, LogicalPlan outerPlan, LogicalPlan subplan) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1212", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conflictingAttrs"), (Object)conflictingAttrs.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outerPlan"), (Object)outerPlan.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subplan"), (Object)subplan.toString())})));
    }

    public Throwable emptyWindowExpressionError(Window expr) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1213", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr.toString())})));
    }

    public Throwable foundDifferentWindowFunctionTypeError(Seq<NamedExpression> windowExpressions) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1214", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowExpressions"), (Object)windowExpressions.toString())})));
    }

    public Throwable escapeCharacterInTheMiddleError(String pattern, String string) {
        return new AnalysisException("INVALID_FORMAT.ESC_IN_THE_MIDDLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)this.toSQLValue(pattern, (DataType)StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"char"), (Object)this.toSQLValue(string, (DataType)StringType$.MODULE$))})));
    }

    public Throwable escapeCharacterAtTheEndError(String pattern) {
        return new AnalysisException("INVALID_FORMAT.ESC_AT_THE_END", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)this.toSQLValue(pattern, (DataType)StringType$.MODULE$))})));
    }

    public Throwable tableIdentifierExistsError(TableIdentifier tableIdentifier) {
        return new TableAlreadyExistsException(tableIdentifier.nameParts());
    }

    public Throwable tableIdentifierNotConvertedToHadoopFsRelationError(TableIdentifier tableIdentifier) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1218", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentifier"), (Object)tableIdentifier.toString())})));
    }

    public Throwable alterDatabaseLocationUnsupportedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1219", Predef$.MODULE$.Map().empty());
    }

    public Throwable hiveTableTypeUnsupportedError(String tableName, String tableType) {
        return new AnalysisException("UNSUPPORTED_FEATURE.HIVE_TABLE_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableType"), (Object)tableType)})));
    }

    public Throwable unknownHiveResourceTypeError(String resourceType) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1222", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceType"), (Object)resourceType)})));
    }

    public Throwable configRemovedInVersionError(String configName, String version, String comment) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1226", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configName"), (Object)configName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), (Object)comment)})));
    }

    public Throwable invalidPartitionColumnKeyInTableError(String key, String tableName) {
        return new AnalysisException("PARTITIONS_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)this.toSQLId(key)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName))})));
    }

    public Throwable invalidPartitionSpecError(String specKeys, Seq<String> partitionColumnNames, String tableName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1232", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specKeys"), (Object)specKeys), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionColumnNames"), (Object)partitionColumnNames.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName))})));
    }

    public Throwable columnAlreadyExistsError(String columnName) {
        return new AnalysisException("COLUMN_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(columnName))})));
    }

    public Throwable noSuchTableError(String db, String table) {
        return new NoSuchTableException(db, table);
    }

    public Throwable tempViewNotCachedForAnalyzingColumnsError(TableIdentifier tableIdent) {
        return new AnalysisException("UNSUPPORTED_FEATURE.ANALYZE_UNCACHED_TEMP_VIEW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(tableIdent.toString()))})));
    }

    public Throwable columnTypeNotSupportStatisticsCollectionError(String name, TableIdentifier tableIdent, DataType dataType) {
        return new AnalysisException("UNSUPPORTED_FEATURE.ANALYZE_UNSUPPORTED_COLUMN_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnType"), (Object)this.toSQLType((AbstractDataType)dataType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableIdent.toString()))})));
    }

    public Throwable analyzeTableNotSupportedOnViewsError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.ANALYZE_VIEW", Predef$.MODULE$.Map().empty());
    }

    public Throwable unexpectedPartitionColumnPrefixError(String table, String database, String schemaColumns, String specColumns) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1237", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)database), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaColumns"), (Object)schemaColumns), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specColumns"), (Object)specColumns)})));
    }

    public Throwable noSuchPartitionError(String db, String table, Map<String, String> partition) {
        return new NoSuchPartitionException(db, table, partition);
    }

    public Throwable notExistPartitionError(Identifier table, InternalRow partitionIdent, StructType partitionSchema) {
        return new NoSuchPartitionException(table.toString(), partitionIdent, partitionSchema);
    }

    public Throwable analyzingColumnStatisticsNotSupportedForColumnTypeError(String name, DataType dataType) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1239", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})));
    }

    public Throwable tableAlreadyExistsError(String table) {
        return new TableAlreadyExistsException(table);
    }

    public Throwable createTableAsSelectWithNonEmptyDirectoryError(String tablePath) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1241", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tablePath"), (Object)tablePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.ALLOW_NON_EMPTY_LOCATION_IN_CTAS().key())})));
    }

    public Throwable alterTableChangeColumnNotSupportedForColumnTypeError(String tableName, StructField originColumn, StructField newColumn, Origin origin) {
        return new AnalysisException("NOT_SUPPORTED_CHANGE_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"originName"), (Object)this.toSQLId(originColumn.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"originType"), (Object)this.toSQLType((AbstractDataType)originColumn.dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newName"), (Object)this.toSQLId(newColumn.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newType"), (Object)this.toSQLType((AbstractDataType)newColumn.dataType()))})), origin);
    }

    public Throwable cannotAlterPartitionColumn(String tableName, String columnName) {
        return new AnalysisException("CANNOT_ALTER_PARTITION_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(columnName))})));
    }

    public Throwable cannotAlterCollationBucketColumn(String tableName, String columnName) {
        return new AnalysisException("CANNOT_ALTER_COLLATION_BUCKET_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(columnName))})));
    }

    public Throwable cannotFindColumnError(String name, String[] fieldNames) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1246", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)Predef$.MODULE$.wrapRefArray((Object[])fieldNames).mkString("[`", "`, `", "`]"))})));
    }

    public Throwable alterTableSetSerdeForSpecificPartitionNotSupportedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1247", Predef$.MODULE$.Map().empty());
    }

    public Throwable alterTableSetSerdeNotSupportedError(String tableName) {
        return new AnalysisException("UNSUPPORTED_FEATURE.ALTER_TABLE_SERDE_FOR_DATASOURCE_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName))})));
    }

    public Throwable cmdOnlyWorksOnPartitionedTablesError(String operation, String tableIdentWithDB) {
        return new AnalysisException("NOT_A_PARTITIONED_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)this.toSQLStmt(operation)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable cmdOnlyWorksOnTableWithLocationError(String cmd, String tableIdentWithDB) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_2446", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable actionNotAllowedOnTableWithFilesourcePartitionManagementDisabledError(String action, String tableName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1250", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"action"), (Object)action), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public Throwable actionNotAllowedOnTableSincePartitionMetadataNotStoredError(String action, String tableName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1251", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"action"), (Object)action), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public Throwable cannotAlterViewWithAlterTableError(String viewName) {
        return new AnalysisException("EXPECT_TABLE_NOT_VIEW.USE_ALTER_VIEW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(viewName))})));
    }

    public Throwable cannotAlterTableWithAlterViewError(String tableName) {
        return new AnalysisException("EXPECT_VIEW_NOT_TABLE.USE_ALTER_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"ALTER VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(tableName))})));
    }

    public Throwable cannotOverwritePathBeingReadFromError(String path) {
        return new AnalysisException("UNSUPPORTED_OVERWRITE.PATH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})));
    }

    public Throwable cannotOverwriteTableThatIsBeingReadFromError(TableIdentifier tableIdent) {
        return new AnalysisException("UNSUPPORTED_OVERWRITE.TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)this.toSQLId(tableIdent.nameParts()))})));
    }

    public Throwable cannotDropBuiltinFuncError(String functionName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1255", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName)})));
    }

    public Throwable cannotRefreshBuiltInFuncError(String functionName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1256", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName)})));
    }

    public Throwable cannotRefreshTempFuncError(String functionName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1257", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName)})));
    }

    public Throwable noSuchFunctionError(FunctionIdentifier identifier) {
        return new NoSuchFunctionException((String)identifier.database().get(), identifier.funcName());
    }

    public Throwable alterAddColNotSupportViewError(TableIdentifier table) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1259", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.toString())})));
    }

    public Throwable alterAddColNotSupportDatasourceTableError(Object tableType, TableIdentifier table) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1260", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableType"), (Object)tableType.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.toString())})));
    }

    public Throwable loadDataNotSupportedForDatasourceTablesError(String tableIdentWithDB) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1261", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable loadDataWithoutPartitionSpecProvidedError(String tableIdentWithDB) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1262", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable loadDataPartitionSizeNotMatchNumPartitionColumnsError(String tableIdentWithDB, int partitionSize, int targetTableSize) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1263", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionSize"), (Object)Integer.toString(partitionSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetTableSize"), (Object)Integer.toString(targetTableSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable loadDataTargetTableNotPartitionedButPartitionSpecWasProvidedError(String tableIdentWithDB) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1264", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable loadDataInputPathNotExistError(String path) {
        return new AnalysisException("LOAD_DATA_PATH_NOT_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})));
    }

    public Throwable truncateTableOnExternalTablesError(String tableIdentWithDB) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1266", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable truncateTablePartitionNotSupportedForNotPartitionedTablesError(String tableIdentWithDB) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1267", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB)})));
    }

    public Throwable failToTruncateTableWhenRemovingDataError(String tableIdentWithDB, Path path, Throwable e) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1268", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentWithDB"), (Object)tableIdentWithDB), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path.toString())})), (Option)new Some((Object)e));
    }

    public Throwable descPartitionNotAllowedOnTempView(String table) {
        return new AnalysisException("FORBIDDEN_OPERATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt("DESC PARTITION")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectType"), (Object)"TEMPORARY VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)this.toSQLId(table))})));
    }

    public Throwable descPartitionNotAllowedOnView(String table) {
        return new AnalysisException("FORBIDDEN_OPERATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt("DESC PARTITION")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectType"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)this.toSQLId(table))})));
    }

    public Throwable showPartitionNotAllowedOnTableNotPartitionedError(String tableIdentWithDB) {
        return new AnalysisException("INVALID_PARTITION_OPERATION.PARTITION_SCHEMA_IS_EMPTY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(tableIdentWithDB))})));
    }

    public Throwable showCreateTableNotSupportedOnTempView(String table) {
        return new AnalysisException("UNSUPPORTED_SHOW_CREATE_TABLE.ON_TEMPORARY_VIEW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(table))})));
    }

    public Throwable showCreateTableNotSupportTransactionalHiveTableError(CatalogTable table) {
        return new AnalysisException("UNSUPPORTED_SHOW_CREATE_TABLE.ON_TRANSACTIONAL_HIVE_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(table.identifier().nameParts()))})));
    }

    public Throwable showCreateTableFailToExecuteUnsupportedConfError(TableIdentifier table, String configs) {
        return new AnalysisException("UNSUPPORTED_SHOW_CREATE_TABLE.WITH_UNSUPPORTED_SERDE_CONFIGURATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(table.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configs"), (Object)configs)})));
    }

    public Throwable showCreateTableAsSerdeNotAllowedOnSparkDataSourceTableError(TableIdentifier table) {
        return new AnalysisException("UNSUPPORTED_SHOW_CREATE_TABLE.ON_DATA_SOURCE_TABLE_WITH_AS_SERDE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(table.nameParts()))})));
    }

    public Throwable showCreateTableOrViewFailToExecuteUnsupportedFeatureError(CatalogTable table, Seq<String> unsupportedFeatures) {
        return new AnalysisException("UNSUPPORTED_SHOW_CREATE_TABLE.WITH_UNSUPPORTED_FEATURE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(table.identifier().nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupportedFeatures"), (Object)((IterableOnceOps)unsupportedFeatures.map((Function1 & Serializable)x$15 -> " - " + x$15)).mkString("\n"))})));
    }

    public Throwable logicalPlanForViewNotAnalyzedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1276", Predef$.MODULE$.Map().empty());
    }

    public Throwable cannotCreateViewTooManyColumnsError(TableIdentifier viewIdent, Seq<String> expected, LogicalPlan query) {
        return new AnalysisException("CREATE_VIEW_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(viewIdent.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewColumns"), (Object)((IterableOnceOps)expected.map((Function1 & Serializable)c -> MODULE$.toSQLId((String)c))).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)((IterableOnceOps)query.output().map((Function1 & Serializable)c -> MODULE$.toSQLId(c.name()))).mkString(", "))})));
    }

    public Throwable cannotCreateViewNotEnoughColumnsError(TableIdentifier viewIdent, Seq<String> expected, LogicalPlan query) {
        return new AnalysisException("CREATE_VIEW_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)this.toSQLId(viewIdent.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewColumns"), (Object)((IterableOnceOps)expected.map((Function1 & Serializable)c -> MODULE$.toSQLId((String)c))).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)((IterableOnceOps)query.output().map((Function1 & Serializable)c -> MODULE$.toSQLId(c.name()))).mkString(", "))})));
    }

    public Throwable cannotAlterTempViewWithSchemaBindingError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.TEMPORARY_VIEW_WITH_SCHEMA_BINDING_MODE", Predef$.MODULE$.Map().empty());
    }

    public Throwable unsupportedCreateOrReplaceViewOnTableError(TableIdentifier name, boolean replace) {
        if (replace) {
            return new AnalysisException("EXPECT_VIEW_NOT_TABLE.NO_ALTERNATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(name.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"CREATE OR REPLACE VIEW")})));
        }
        return new AnalysisException("TABLE_OR_VIEW_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)this.toSQLId(name.nameParts()))})));
    }

    public Throwable viewAlreadyExistsError(TableIdentifier name) {
        return new AnalysisException("TABLE_OR_VIEW_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationName"), (Object)name.toString())})));
    }

    public Throwable createPersistedViewFromDatasetAPINotAllowedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1280", Predef$.MODULE$.Map().empty());
    }

    public Throwable recursiveViewDetectedError(TableIdentifier viewIdent, Seq<TableIdentifier> newPath) {
        return new AnalysisException("RECURSIVE_VIEW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewIdent"), (Object)this.toSQLId(viewIdent.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newPath"), (Object)((IterableOnceOps)newPath.map((Function1 & Serializable)p -> MODULE$.toSQLId(p.nameParts()))).mkString(" -> "))})));
    }

    public Throwable notAllowedToCreatePermanentViewWithoutAssigningAliasForExpressionError(TableIdentifier name, Attribute attr) {
        return new AnalysisException("CREATE_PERMANENT_VIEW_WITHOUT_ALIAS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr"), (Object)this.toSQLExpr(attr))})));
    }

    public Throwable notAllowedToCreatePermanentViewByReferencingTempViewError(TableIdentifier name, String nameParts) {
        return new AnalysisException("INVALID_TEMP_OBJ_REFERENCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)this.toSQLId(name.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)this.toSQLId(nameParts))})));
    }

    public Throwable notAllowedToCreatePermanentViewByReferencingTempFuncError(TableIdentifier name, String funcName) {
        return new AnalysisException("INVALID_TEMP_OBJ_REFERENCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)this.toSQLId(name.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"FUNCTION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)this.toSQLId(funcName))})));
    }

    public Throwable notAllowedToCreatePermanentViewByReferencingTempVarError(TableIdentifier name, String varName) {
        return new AnalysisException("INVALID_TEMP_OBJ_REFERENCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"obj"), (Object)"VIEW"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objName"), (Object)this.toSQLId(name.nameParts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObj"), (Object)"VARIABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tempObjName"), (Object)this.toSQLId(varName))})));
    }

    public Throwable queryFromRawFilesIncludeCorruptRecordColumnError() {
        return new AnalysisException("UNSUPPORTED_FEATURE.QUERY_ONLY_CORRUPT_RECORD_COLUMN", Predef$.MODULE$.Map().empty());
    }

    public Throwable userDefinedPartitionNotFoundInJDBCRelationError(String columnName, String schema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1286", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema)})));
    }

    public Throwable invalidPartitionColumnTypeError(StructField column) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1287", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numericType"), (Object)NumericType$.MODULE$.simpleString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateType"), (Object)DateType$.MODULE$.catalogString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampType"), (Object)TimestampType$.MODULE$.catalogString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)column.dataType().catalogString())})));
    }

    public Throwable tableOrViewAlreadyExistsError(String name) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1288", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})));
    }

    public Throwable invalidColumnNameAsPathError(String datasource, String columnName) {
        return new AnalysisException("INVALID_COLUMN_NAME_AS_PATH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasource"), (Object)datasource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(columnName))})));
    }

    public Throwable textDataSourceWithMultiColumnsError(StructType schema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1290", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schemaSize"), (Object)Integer.toString(schema.size()))})));
    }

    public Throwable cannotFindPartitionColumnInPartitionSchemaError(StructField readField, StructType partitionSchema) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1291", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readField"), (Object)readField.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionSchema"), (Object)partitionSchema.toString())})));
    }

    public Throwable cannotSpecifyDatabaseForTempViewError(TableIdentifier tableIdent) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1292", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdent"), (Object)tableIdent.toString())})));
    }

    public Throwable cannotCreateTempViewUsingHiveDataSourceError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1293", Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidTimestampProvidedForStrategyError(String strategy, String timeString) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1294", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"strategy"), (Object)strategy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeString"), (Object)timeString)})));
    }

    public Throwable hostOptionNotSetError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1295", Predef$.MODULE$.Map().empty());
    }

    public Throwable portOptionNotSetError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1296", Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidIncludeTimestampValueError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1297", Predef$.MODULE$.Map().empty());
    }

    public Throwable checkpointLocationNotSpecifiedError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1298", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.CHECKPOINT_LOCATION().key())})));
    }

    public Throwable recoverQueryFromCheckpointUnsupportedError(Path checkpointPath) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1299", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkpointPath"), (Object)checkpointPath.toString())})));
    }

    public Throwable cannotFindColumnInRelationOutputError(String colName, LogicalPlan relation) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1300", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualColumns"), (Object)((IterableOnceOps)relation.output().map((Function1 & Serializable)x$16 -> x$16.name())).mkString(", "))})));
    }

    public Throwable tableOrViewNotFound(Seq<String> ident) {
        return new NoSuchTableException(ident);
    }

    public Throwable unsupportedTableChangeInJDBCCatalogError(TableChange change, String tableName) {
        String sanitizedTableName = tableName.replaceAll("\"", "");
        return new AnalysisException("UNSUPPORTED_TABLE_CHANGE_IN_JDBC_CATALOG", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"change"), (Object)change.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)this.toSQLId(sanitizedTableName))})));
    }

    public Throwable pathOptionNotSetCorrectlyWhenReadingError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1306", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key())})));
    }

    public Throwable pathOptionNotSetCorrectlyWhenWritingError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1307", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key())})));
    }

    public Throwable invalidSingleVariantColumn() {
        return new AnalysisException("INVALID_SINGLE_VARIANT_COLUMN", Predef$.MODULE$.Map().empty());
    }

    public Throwable writeWithSaveModeUnsupportedBySourceError(String source, String createMode) {
        return new AnalysisException("UNSUPPORTED_DATA_SOURCE_SAVE_MODE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)source), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"createMode"), (Object)this.toDSOption(createMode))})));
    }

    public Throwable partitionByDoesNotAllowedWhenUsingInsertIntoError() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1309", Predef$.MODULE$.Map().empty());
    }

    public Throwable cannotFindCatalogToHandleIdentifierError(String quote) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1310", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)quote)})));
    }

    public Throwable tableAlreadyExistsError(TableIdentifier tableIdent) {
        return new TableAlreadyExistsException(tableIdent.nameParts());
    }

    public Throwable invalidPartitionTransformationError(Expression expr) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1316", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr.sql())})));
    }

    public AnalysisException unresolvedColumnError(String colName, String[] fields) {
        return new AnalysisException("UNRESOLVED_COLUMN.WITH_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts), ClassTag$.MODULE$.apply(String.class))).mkString(", "))})));
    }

    public AnalysisException unresolvedColumnError(Seq<String> fieldName, String[] fields, Origin context) {
        return new AnalysisException("UNRESOLVED_COLUMN.WITH_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)this.toSQLId(fieldName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts), ClassTag$.MODULE$.apply(String.class))).mkString(", "))})), context);
    }

    public Throwable cannotParseIntervalError(String delayThreshold, Throwable e) {
        String threshold = delayThreshold == null ? "" : delayThreshold;
        return new AnalysisException("CANNOT_PARSE_INTERVAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"intervalString"), (Object)this.toSQLValue(threshold, (DataType)StringType$.MODULE$))})), (Option)new Some((Object)e));
    }

    public Throwable invalidJoinTypeInJoinWithError(JoinType joinType) {
        return new AnalysisException("INVALID_JOIN_TYPE_FOR_JOINWITH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType"), (Object)joinType.sql())})));
    }

    public Throwable cannotPassTypedColumnInUntypedSelectError(String typedCol) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1320", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typedCol"), (Object)typedCol)})));
    }

    public Throwable invalidViewNameError(String viewName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1321", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)viewName)})));
    }

    public Throwable invalidBucketsNumberError(String numBuckets, String e) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1322", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numBuckets"), (Object)numBuckets), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)e)})));
    }

    public Throwable aggregationFunctionAppliedOnNonNumericColumnError(String colName) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1323", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName)})));
    }

    public Throwable aggregationFunctionAppliedOnNonNumericColumnError(String pivotColumn, int maxValues) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1324", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pivotColumn"), (Object)pivotColumn), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValues"), (Object)Integer.toString(maxValues)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.DATAFRAME_PIVOT_MAX_VALUES().key())})));
    }

    public Throwable cannotModifyValueOfStaticConfigError(String key) {
        return new AnalysisException("CANNOT_MODIFY_CONFIG", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLConf(key)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())})));
    }

    public Throwable cannotModifyValueOfSparkConfigError(String key, String docroot) {
        return new AnalysisException("CANNOT_MODIFY_CONFIG", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLConf(key)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)docroot)})));
    }

    public Throwable commandExecutionInRunnerUnsupportedError(String runner) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1327", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"runner"), (Object)runner)})));
    }

    public Throwable udfClassDoesNotImplementAnyUDFInterfaceError(String className) {
        return new AnalysisException("NO_UDF_INTERFACE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable udfClassImplementMultiUDFInterfacesError(String className) {
        return new AnalysisException("MULTI_UDF_INTERFACE_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable udfClassWithTooManyTypeArgumentsError(int n) {
        return new AnalysisException("UNSUPPORTED_FEATURE.TOO_MANY_TYPE_ARGUMENTS_FOR_UDF_CLASS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num"), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)n)))})));
    }

    public Throwable classWithoutPublicNonArgumentConstructorError(String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1328", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable cannotLoadClassNotOnClassPathError(String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1329", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable classDoesNotImplementUserDefinedAggregateFunctionError(String className) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1330", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public Throwable invalidFieldName(Seq<String> fieldName, Seq<String> path, Origin context) {
        return new AnalysisException("INVALID_FIELD_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.toSQLId(path))})), context);
    }

    public Throwable invalidJsonSchema(DataType schema) {
        return new AnalysisException("INVALID_JSON_SCHEMA_MAP_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonSchema"), (Object)this.toSQLType((AbstractDataType)schema))})));
    }

    public Throwable invalidXmlSchema(DataType schema) {
        return new AnalysisException("INVALID_XML_SCHEMA_MAP_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"xmlSchema"), (Object)this.toSQLType((AbstractDataType)schema))})));
    }

    public Throwable tableIndexNotSupportedError(String errorMessage) {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1332", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"errorMessage"), (Object)errorMessage)})));
    }

    public Throwable invalidTimeTravelSpecError() {
        return new AnalysisException("INVALID_TIME_TRAVEL_SPEC", Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidTimestampExprForTimeTravel(String errorClass, Expression expr) {
        return new AnalysisException(errorClass, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expr))})));
    }

    public Throwable timeTravelUnsupportedError(String relationId) {
        return new AnalysisException("UNSUPPORTED_FEATURE.TIME_TRAVEL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationId"), (Object)relationId)})));
    }

    public Throwable writeDistributionAndOrderingNotSupportedInContinuousExecution() {
        return new AnalysisException("_LEGACY_ERROR_TEMP_1338", Predef$.MODULE$.Map().empty());
    }

    public Throwable defaultReferencesNotAllowedInComplexExpressionsInInsertValuesList() {
        return new AnalysisException("DEFAULT_PLACEMENT_INVALID", Predef$.MODULE$.Map().empty());
    }

    public Throwable defaultReferencesNotAllowedInComplexExpressionsInUpdateSetClause() {
        return new AnalysisException("DEFAULT_PLACEMENT_INVALID", Predef$.MODULE$.Map().empty());
    }

    public Throwable defaultReferencesNotAllowedInComplexExpressionsInMergeInsertsOrUpdates() {
        return new AnalysisException("DEFAULT_PLACEMENT_INVALID", Predef$.MODULE$.Map().empty());
    }

    public Throwable nonDeterministicMergeCondition(String condName, Expression cond) {
        return new AnalysisException("UNSUPPORTED_MERGE_CONDITION.NON_DETERMINISTIC", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condName"), (Object)condName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cond"), (Object)this.toSQLExpr(cond))})));
    }

    public Throwable subqueryNotAllowedInMergeCondition(String condName, Expression cond) {
        return new AnalysisException("UNSUPPORTED_MERGE_CONDITION.SUBQUERY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condName"), (Object)condName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cond"), (Object)this.toSQLExpr(cond))})));
    }

    public Throwable aggregationNotAllowedInMergeCondition(String condName, Expression cond) {
        return new AnalysisException("UNSUPPORTED_MERGE_CONDITION.AGGREGATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condName"), (Object)condName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cond"), (Object)this.toSQLExpr(cond))})));
    }

    public Throwable defaultReferencesNotAllowedInDataSource(String statementType, String dataSource) {
        return new AnalysisException("DEFAULT_UNSUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)this.toSQLStmt(statementType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSource"), (Object)dataSource)})));
    }

    public Throwable addNewDefaultColumnToExistingTableNotAllowed(String statementType, String dataSource) {
        return new AnalysisException("ADD_DEFAULT_UNSUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)this.toSQLStmt(statementType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSource"), (Object)dataSource)})));
    }

    public Throwable defaultValuesDataTypeError(String statement, String colName, String defaultValue, DataType expectedType, DataType actualType) {
        return new AnalysisException("INVALID_DEFAULT_VALUE.DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt(statement)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)defaultValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualType"), (Object)this.toSQLType((AbstractDataType)actualType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedType"), (Object)this.toSQLType((AbstractDataType)expectedType))})));
    }

    public Throwable defaultValuesUnresolvedExprError(String statement, String colName, String defaultValue, Throwable cause) {
        return new AnalysisException("INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt(statement)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)defaultValue)})), Option$.MODULE$.apply((Object)cause));
    }

    public Throwable defaultValuesMayNotContainSubQueryExpressions(String statement, String colName, String defaultValue) {
        return new AnalysisException("INVALID_DEFAULT_VALUE.SUBQUERY_EXPRESSION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt(statement)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)defaultValue)})));
    }

    public Throwable defaultValueNotConstantError(String statement, String colName, String defaultValue) {
        return new AnalysisException("INVALID_DEFAULT_VALUE.NOT_CONSTANT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt(statement)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId(colName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)defaultValue)})));
    }

    public Throwable nullableColumnOrFieldError(Seq<String> name) {
        return new AnalysisException("NULLABLE_COLUMN_OR_FIELD", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name))})));
    }

    public Throwable notNullConstraintViolationArrayElementError(Seq<String> path) {
        return new AnalysisException("NOT_NULL_CONSTRAINT_VIOLATION.ARRAY_ELEMENT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnPath"), (Object)this.toSQLId(path))})));
    }

    public Throwable notNullConstraintViolationMapValueError(Seq<String> path) {
        return new AnalysisException("NOT_NULL_CONSTRAINT_VIOLATION.MAP_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnPath"), (Object)this.toSQLId(path))})));
    }

    public Throwable invalidColumnOrFieldDataTypeError(Seq<String> name, DataType dt, DataType expected) {
        return new AnalysisException("INVALID_COLUMN_OR_FIELD_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSQLType((AbstractDataType)dt)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedType"), (Object)this.toSQLType((AbstractDataType)expected))})));
    }

    public Throwable columnNotInGroupByClauseError(Expression expression) {
        return new AnalysisException("MISSING_AGGREGATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)this.toSQLExpr(expression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressionAnyValue"), (Object)this.toSQLExpr(new AnyValue(expression)))})));
    }

    public Throwable explicitCollationMismatchError(Seq<StringType> explicitTypes) {
        return new AnalysisException("COLLATION_MISMATCH.EXPLICIT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"explicitTypes"), (Object)((IterableOnceOps)explicitTypes.map((Function1 & Serializable)t -> MODULE$.toSQLType((AbstractDataType)t))).mkString(", "))})));
    }

    public Throwable indeterminateCollationInExpressionError(Expression expr) {
        return new AnalysisException("INDETERMINATE_COLLATION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expr))})));
    }

    public Throwable indeterminateCollationInSchemaError(Seq<SchemaUtils.ColumnPath> columnPaths) {
        return new AnalysisException("INDETERMINATE_COLLATION_IN_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnPaths"), (Object)((IterableOnceOps)columnPaths.map((Function1 & Serializable)x$17 -> x$17.toString())).mkString(", "))})));
    }

    public Throwable cannotConvertProtobufTypeToSqlTypeError(String protobufColumn, Seq<String> sqlColumn, String protobufType, DataType sqlType) {
        return new AnalysisException("CANNOT_CONVERT_PROTOBUF_FIELD_TYPE_TO_SQL_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufColumn"), (Object)protobufColumn), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlColumn"), (Object)this.toSQLId(sqlColumn)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufType"), (Object)protobufType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)this.toSQLType((AbstractDataType)sqlType))})));
    }

    public Throwable cannotConvertCatalystTypeToProtobufTypeError(Seq<String> sqlColumn, String protobufColumn, DataType sqlType, String protobufType) {
        return new AnalysisException("CANNOT_CONVERT_SQL_TYPE_TO_PROTOBUF_FIELD_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlColumn"), (Object)this.toSQLId(sqlColumn)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufColumn"), (Object)protobufColumn), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)this.toSQLType((AbstractDataType)sqlType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufType"), (Object)protobufType)})));
    }

    public Throwable cannotConvertProtobufTypeToCatalystTypeError(String protobufType, DataType sqlType, Throwable cause) {
        return new AnalysisException("CANNOT_CONVERT_PROTOBUF_MESSAGE_TYPE_TO_SQL_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufType"), (Object)protobufType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toType"), (Object)this.toSQLType((AbstractDataType)sqlType))})), Option$.MODULE$.apply((Object)cause));
    }

    public Throwable cannotConvertSqlTypeToProtobufError(String protobufType, DataType sqlType, Throwable cause) {
        return new AnalysisException("UNABLE_TO_CONVERT_TO_PROTOBUF_MESSAGE_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufType"), (Object)protobufType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toType"), (Object)this.toSQLType((AbstractDataType)sqlType))})), Option$.MODULE$.apply((Object)cause));
    }

    public Throwable protobufTypeUnsupportedYetError(String protobufType) {
        return new AnalysisException("PROTOBUF_TYPE_NOT_SUPPORT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufType"), (Object)protobufType)})));
    }

    public Throwable unknownProtobufMessageTypeError(String descriptorName, String containingType) {
        return new AnalysisException("UNKNOWN_PROTOBUF_MESSAGE_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"descriptorName"), (Object)descriptorName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"containingType"), (Object)containingType)})));
    }

    public Throwable cannotFindCatalystTypeInProtobufSchemaError(String catalystFieldPath) {
        return new AnalysisException("NO_SQL_TYPE_IN_PROTOBUF_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalystFieldPath"), (Object)catalystFieldPath)})));
    }

    public Throwable cannotFindProtobufFieldInCatalystError(String field) {
        return new AnalysisException("PROTOBUF_FIELD_MISSING_IN_SQL_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field)})));
    }

    public Throwable protobufFieldMatchError(String field, String protobufSchema, String matchSize, String matches) {
        return new AnalysisException("PROTOBUF_FIELD_MISSING", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufSchema"), (Object)protobufSchema), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"matchSize"), (Object)matchSize), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"matches"), (Object)matches)})));
    }

    public Throwable unableToLocateProtobufMessageError(String messageName) {
        return new AnalysisException("PROTOBUF_MESSAGE_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"messageName"), (Object)messageName)})));
    }

    public Throwable foundRecursionInProtobufSchema(String fieldDescriptor) {
        return new AnalysisException("RECURSIVE_PROTOBUF_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldDescriptor"), (Object)fieldDescriptor)})));
    }

    public Throwable protobufFieldTypeMismatchError(String field) {
        return new AnalysisException("PROTOBUF_FIELD_TYPE_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field)})));
    }

    public Throwable protobufClassLoadError(String protobufClassName, String explanation, Throwable cause) {
        return new AnalysisException("CANNOT_LOAD_PROTOBUF_CLASS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protobufClassName"), (Object)protobufClassName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"explanation"), (Object)explanation)})), Option$.MODULE$.apply((Object)cause));
    }

    public Throwable protobufClassLoadError$default$3() {
        return null;
    }

    public Throwable protobufDescriptorDependencyError(String dependencyName) {
        return new AnalysisException("PROTOBUF_DEPENDENCY_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dependencyName"), (Object)dependencyName)})));
    }

    public Throwable invalidByteStringFormatError(Object unsupported) {
        return new AnalysisException("INVALID_BYTE_STRING", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupported"), (Object)unsupported.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)unsupported.getClass().toString())})));
    }

    public Throwable funcBuildError(String funcName, Exception cause) {
        Throwable throwable = cause.getCause();
        if (throwable instanceof SparkThrowable) {
            Throwable throwable2 = throwable;
            return throwable2;
        }
        return new AnalysisException("FAILED_FUNCTION_CALL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(funcName))})), Option$.MODULE$.apply((Object)throwable));
    }

    public Throwable ambiguousRelationAliasNameInNestedCTEError(String name) {
        return new AnalysisException("AMBIGUOUS_ALIAS_IN_NESTED_CTE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.LEGACY_CTE_PRECEDENCE_POLICY().key())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())})));
    }

    public Throwable ambiguousLateralColumnAliasError(String name, int numOfMatches) {
        return new AnalysisException("AMBIGUOUS_LATERAL_COLUMN_ALIAS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)Integer.toString(numOfMatches))})));
    }

    public Throwable ambiguousLateralColumnAliasError(Seq<String> nameParts, int numOfMatches) {
        return new AnalysisException("AMBIGUOUS_LATERAL_COLUMN_ALIAS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(nameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)Integer.toString(numOfMatches))})));
    }

    public Throwable lateralColumnAliasInAggFuncUnsupportedError(Seq<String> lcaNameParts, Expression aggExpr) {
        return new AnalysisException("UNSUPPORTED_FEATURE.LATERAL_COLUMN_ALIAS_IN_AGGREGATE_FUNC", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lca"), (Object)this.toSQLId(lcaNameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aggFunc"), (Object)this.toSQLExpr(aggExpr))})));
    }

    public Throwable lateralColumnAliasInWindowUnsupportedError(Seq<String> lcaNameParts, Expression windowExpr) {
        return new AnalysisException("UNSUPPORTED_FEATURE.LATERAL_COLUMN_ALIAS_IN_WINDOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lca"), (Object)this.toSQLId(lcaNameParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowExpr"), (Object)this.toSQLExpr(windowExpr))})));
    }

    public Throwable lateralColumnAliasInAggWithWindowAndHavingUnsupportedError(Seq<String> lcaNameParts) {
        return new AnalysisException("UNSUPPORTED_FEATURE.LATERAL_COLUMN_ALIAS_IN_AGGREGATE_WITH_WINDOW_AND_HAVING", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lca"), (Object)this.toSQLId(lcaNameParts))})));
    }

    public Throwable dataTypeOperationUnsupportedError() {
        return SparkException$.MODULE$.internalError("The operation `dataType` is not supported.");
    }

    public Throwable nullableRowIdError(Seq<AttributeReference> nullableRowIdAttrs) {
        return new AnalysisException("NULLABLE_ROW_ID_ATTRIBUTES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullableRowIdAttrs"), (Object)nullableRowIdAttrs.mkString(", "))})));
    }

    public Throwable cannotRenameTableAcrossSchemaError() {
        return new SparkUnsupportedOperationException("CANNOT_RENAME_ACROSS_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"table")})));
    }

    public Throwable avroIncompatibleReadError(String avroPath, String sqlPath, String avroType, String sqlType) {
        return new AnalysisException("AVRO_INCOMPATIBLE_READ_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avroPath"), (Object)avroPath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlPath"), (Object)sqlPath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avroType"), (Object)avroType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)this.toSQLType(sqlType))})));
    }

    public Throwable optionMustBeLiteralString(String key) {
        return new AnalysisException("INVALID_SQL_SYNTAX.OPTION_IS_INVALID", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supported"), (Object)"literal strings")})));
    }

    public Throwable optionMustBeConstant(String key, Option<Throwable> cause) {
        return new AnalysisException("INVALID_SQL_SYNTAX.OPTION_IS_INVALID", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supported"), (Object)"constant expressions")})), cause);
    }

    public Option<Throwable> optionMustBeConstant$default$2() {
        return None$.MODULE$;
    }

    public Throwable tableValuedFunctionRequiredMetadataIncompatibleWithCall(String functionName, String requestedMetadata, String invalidFunctionCallProperty) {
        return new AnalysisException("TABLE_VALUED_FUNCTION_REQUIRED_METADATA_INCOMPATIBLE_WITH_CALL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestedMetadata"), (Object)requestedMetadata), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidFunctionCallProperty"), (Object)invalidFunctionCallProperty)})));
    }

    public Throwable tableValuedFunctionRequiredMetadataInvalid(String functionName, String reason) {
        return new AnalysisException("TABLE_VALUED_FUNCTION_REQUIRED_METADATA_INVALID", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason)})));
    }

    public Throwable dataSourceAlreadyExists(String name) {
        return new AnalysisException("DATA_SOURCE_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)name)})));
    }

    public Throwable dataSourceDoesNotExist(String name) {
        return new AnalysisException("DATA_SOURCE_NOT_EXIST", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)name)})));
    }

    public Throwable externalDataSourceException(Throwable cause) {
        return new AnalysisException("DATA_SOURCE_EXTERNAL_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Option)new Some((Object)cause));
    }

    public Throwable foundMultipleDataSources(String provider) {
        return new AnalysisException("FOUND_MULTIPLE_DATA_SOURCES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider)})));
    }

    public Throwable foundMultipleXMLDataSourceError(String provider, Seq<String> sourceNames, String externalSource) {
        return new AnalysisException("MULTIPLE_XML_DATA_SOURCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceNames"), (Object)sourceNames.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"externalSource"), (Object)externalSource)})));
    }

    public Throwable xmlRowTagRequiredError(String optionName) {
        return new AnalysisException("XML_ROW_TAG_MISSING", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowTag"), (Object)this.toSQLId(optionName))})));
    }

    public Throwable invalidUDFClassError(String invalidClass) {
        return new InvalidUDFClassException("_LEGACY_ERROR_TEMP_2450", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidClass"), (Object)invalidClass)}))));
    }

    public Throwable unsupportedParameterExpression(Expression expr) {
        return new AnalysisException("UNSUPPORTED_EXPR_FOR_PARAMETER", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidExprSql"), (Object)this.toSQLExpr(expr))})), expr.origin());
    }

    public Throwable invalidQueryAllParametersMustBeNamed(Seq<Expression> expr) {
        return new AnalysisException("ALL_PARAMETERS_MUST_BE_NAMED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprs"), (Object)((IterableOnceOps)expr.map((Function1 & Serializable)e -> MODULE$.toSQLExpr((Expression)e))).mkString(", "))})));
    }

    public Throwable invalidQueryMixedQueryParameters() {
        throw new AnalysisException("INVALID_QUERY_MIXED_QUERY_PARAMETERS", Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidExecuteImmediateVariableType(DataType dataType) {
        throw new AnalysisException("INVALID_VARIABLE_TYPE_FOR_QUERY_EXECUTE_IMMEDIATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varType"), (Object)this.toSQLType((AbstractDataType)dataType))})));
    }

    public Throwable nullSQLStringExecuteImmediate(String varName) {
        throw new AnalysisException("NULL_QUERY_STRING_EXECUTE_IMMEDIATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)this.toSQLId(varName))})));
    }

    public Throwable invalidStatementForExecuteInto(String queryString) {
        throw new AnalysisException("INVALID_STATEMENT_FOR_EXECUTE_INTO", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlString"), (Object)this.toSQLStmt(queryString))})));
    }

    public Throwable nestedExecuteImmediate(String queryString) {
        throw new AnalysisException("NESTED_EXECUTE_IMMEDIATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlString"), (Object)this.toSQLStmt(queryString))})));
    }

    public Throwable sqlScriptInExecuteImmediate(String sqlScriptString) {
        throw new AnalysisException("SQL_SCRIPT_IN_EXECUTE_IMMEDIATE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlString"), (Object)this.toSQLStmt(sqlScriptString))})));
    }

    public Throwable dataSourceTableSchemaMismatchError(StructType dsSchema, StructType expectedSchema) {
        return new AnalysisException("DATA_SOURCE_TABLE_SCHEMA_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dsSchema"), (Object)this.toSQLType((AbstractDataType)dsSchema)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedSchema"), (Object)this.toSQLType((AbstractDataType)expectedSchema))})));
    }

    public Throwable cannotResolveDataFrameColumn(Expression e) {
        return new AnalysisException("CANNOT_RESOLVE_DATAFRAME_COLUMN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLExpr(e))})), e.origin());
    }

    public Throwable ambiguousColumnReferences(Expression e) {
        return new AnalysisException("AMBIGUOUS_COLUMN_REFERENCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLExpr(e))})), e.origin());
    }

    private Throwable callDeprecatedMethodError(String oldMethod, String newMethod) {
        return SparkException$.MODULE$.internalError("The method `" + oldMethod + "` is deprecated, please use `" + newMethod + "` instead.");
    }

    public Throwable createTableDeprecatedError() {
        return this.callDeprecatedMethodError("createTable(..., StructType, ...)", "createTable(..., Array[Column], ...)");
    }

    public RuntimeException mustOverrideOneMethodError(String methodName) {
        String msg = "You must override one `" + methodName + "`. It's preferred to not override the deprecated one.";
        return new SparkRuntimeException("INTERNAL_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)msg)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotAssignEventTimeColumn() {
        return new AnalysisException("CANNOT_ASSIGN_EVENT_TIME_COLUMN_WITHOUT_WATERMARK", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }

    public AnalysisException unsupportedSinglePassAnalyzerFeature(String feature) {
        return new AnalysisException("UNSUPPORTED_SINGLE_PASS_ANALYZER_FEATURE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature"), (Object)feature)})));
    }

    public AnalysisException ambiguousResolverExtension(LogicalPlan operator, Seq<String> extensionNames) {
        return new AnalysisException("AMBIGUOUS_RESOLVER_EXTENSION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operator"), (Object)operator.getClass().getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extensions"), (Object)extensionNames.mkString(", "))})));
    }

    public Throwable fixedPointFailedSinglePassSucceeded(LogicalPlan singlePassResult, Throwable fixedPointException) {
        return new ExtendedAnalysisException(new AnalysisException("HYBRID_ANALYZER_EXCEPTION.FIXED_POINT_FAILED_SINGLE_PASS_SUCCEEDED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"singlePassOutput"), (Object)singlePassResult.toString())})), (Option)new Some((Object)fixedPointException)), singlePassResult);
    }

    public Throwable hybridAnalyzerOutputSchemaComparisonMismatch(StructType fixedPointOutputSchema, StructType singlePassOutputSchema) {
        return new AnalysisException("HYBRID_ANALYZER_EXCEPTION.OUTPUT_SCHEMA_COMPARISON_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fixedPointOutputSchema"), (Object)QueryCompilationErrors$.structToString$1(fixedPointOutputSchema)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"singlePassOutputSchema"), (Object)QueryCompilationErrors$.structToString$1(singlePassOutputSchema))})));
    }

    public Throwable hybridAnalyzerLogicalPlanComparisonMismatch(LogicalPlan fixedPointOutput, LogicalPlan singlePassOutput) {
        return new AnalysisException("HYBRID_ANALYZER_EXCEPTION.LOGICAL_PLAN_COMPARISON_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fixedPointOutput"), (Object)fixedPointOutput.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"singlePassOutput"), (Object)singlePassOutput.toString())})));
    }

    public Throwable resolutionValidationError(Throwable cause, LogicalPlan plan2) {
        String x$1 = "INTERNAL_ERROR";
        Some x$2 = new Some((Object)cause);
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)("The analysis phase failed with an internal error. Reason: " + cause.getMessage()))}));
        return new ExtendedAnalysisException(new AnalysisException("INTERNAL_ERROR", x$3, (Option)x$2), plan2);
    }

    public Throwable avroNotLoadedSqlFunctionsUnusable(String functionName) {
        return new AnalysisException("AVRO_NOT_LOADED_SQL_FUNCTIONS_UNUSABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName)})));
    }

    public Throwable avroOptionsException(String optionName, String message) {
        return new AnalysisException("STDS_INVALID_OPTION_VALUE.WITH_MESSAGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"optionName"), (Object)optionName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message)})));
    }

    public Throwable protobufNotLoadedSqlFunctionsUnusable(String functionName) {
        return new AnalysisException("PROTOBUF_NOT_LOADED_SQL_FUNCTIONS_UNUSABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)functionName)})));
    }

    public Throwable pipeOperatorAggregateExpressionContainsNoAggregateFunction(Expression expr) {
        return new AnalysisException("PIPE_OPERATOR_AGGREGATE_EXPRESSION_CONTAINS_NO_AGGREGATE_FUNCTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr.toString())})), expr.origin());
    }

    public Throwable pipeOperatorContainsAggregateFunction(Expression expr, String clause) {
        return new AnalysisException("PIPE_OPERATOR_CONTAINS_AGGREGATE_FUNCTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clause"), (Object)clause)})), expr.origin());
    }

    public Throwable inlineTableContainsScalarSubquery(LogicalPlan inlineTable) {
        return new AnalysisException("UNSUPPORTED_SUBQUERY_EXPRESSION_CATEGORY.SCALAR_SUBQUERY_IN_VALUES", Predef$.MODULE$.Map().empty(), inlineTable.origin());
    }

    public Throwable ordinalOutOfBoundsError(int ordinal, Seq<Attribute> attributes) {
        return new AnalysisException("COLUMN_ORDINAL_OUT_OF_BOUNDS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ordinal"), (Object)Integer.toString(ordinal)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attributesLength"), (Object)Integer.toString(attributes.length())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attributes"), (Object)((IterableOnceOps)attributes.map((Function1 & Serializable)attr -> MODULE$.toSQLId(attr.name()))).mkString(", "))})));
    }

    public Throwable numColumnsMismatch(String operator, int firstNumColumns, int invalidOrdinalNum, int invalidNumColumns, Origin origin) {
        return new AnalysisException("NUM_COLUMNS_MISMATCH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operator"), (Object)this.toSQLStmt(operator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstNumColumns"), (Object)Integer.toString(firstNumColumns)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidOrdinalNum"), (Object)this.ordinalNumber(invalidOrdinalNum)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidNumColumns"), (Object)Integer.toString(invalidNumColumns))})), origin);
    }

    public Throwable incompatibleColumnTypeError(String operator, int columnOrdinalNumber, int tableOrdinalNumber, DataType dataType1, DataType dataType2, String hint, Origin origin) {
        return new AnalysisException("INCOMPATIBLE_COLUMN_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operator"), (Object)this.toSQLStmt(operator)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnOrdinalNumber"), (Object)this.ordinalNumber(columnOrdinalNumber)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableOrdinalNumber"), (Object)this.ordinalNumber(tableOrdinalNumber)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType1"), (Object)this.toSQLType((AbstractDataType)dataType1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType2"), (Object)this.toSQLType((AbstractDataType)dataType2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)hint)})), origin);
    }

    public static final /* synthetic */ boolean $anonfun$unpivotRequiresAttributes$1(NamedExpression x$1) {
        return x$1 instanceof Attribute;
    }

    private static final String structToString$1(StructType struct) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])struct.fields()), (Function1 & Serializable)x$18 -> QueryCompilationErrors$.structFieldToStringWithMetadata$1(x$18), ClassTag$.MODULE$.apply(String.class))).mkString(",");
    }

    private static final String structFieldToStringWithMetadata$1(StructField sf) {
        return "(" + sf.name() + "," + sf.dataType() + "," + sf.nullable() + "," + sf.metadata() + ")";
    }

    private QueryCompilationErrors$() {
    }
}

