/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t]b\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0012)A\u0005-\"A!\f\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003W\u0011!a\u0006A!f\u0001\n\u0003i\u0006\u0002C5\u0001\u0005#\u0005\u000b\u0011\u00020\t\u000b)\u0004A\u0011A6\t\u000bA\u0004A\u0011I9\t\u000b)\u0004A\u0011A;\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u00111\u0003\u0001\u0005R\u0005U\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u0019\t9\u0005\u0001C)+\"1\u0011\u0011\n\u0001\u0005REDq!a\u0013\u0001\t#\ni\u0005C\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z!I\u0011\u0011\r\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003GB\u0011\"a\u001f\u0001#\u0003%\t!! \t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\r\u0005\"CAJ\u0001\u0005\u0005I\u0011AAK\u0011%\ti\nAA\u0001\n\u0003\ty\nC\u0005\u0002&\u0002\t\t\u0011\"\u0011\u0002(\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003w\u0003\u0011\u0011!C!\u0003{C\u0011\"!1\u0001\u0003\u0003%\t%a1\b\u0013\u00055x%!A\t\u0002\u0005=h\u0001\u0003\u0014(\u0003\u0003E\t!!=\t\r)tB\u0011\u0001B\u0005\u0011%\u0011YAHA\u0001\n\u000b\u0012i\u0001C\u0005\u0003\u0010y\t\t\u0011\"!\u0003\u0012!I!\u0011\u0004\u0010\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u00057q\u0012\u0011!CA\u0005;A\u0011Ba\u000b\u001f#\u0003%\t!! \t\u0013\t5b$!A\u0005\n\t=\"a\u0004#bi\u00164uN]7bi\u000ec\u0017m]:\u000b\u0005!J\u0013aC3yaJ,7o]5p]NT!AK\u0016\u0002\u0011\r\fG/\u00197zgRT!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001b:y}\u0012\u0005\n\u0005\u00027o5\tq%\u0003\u00029O\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003miJ!aO\u0014\u00031QKW.Z:uC6\u0004hi\u001c:nCR$XM\u001d%fYB,'\u000f\u0005\u00027{%\u0011ah\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a\u0007Q\u0005\u0003\u0003\u001e\u0012\u0001\u0005R3gCVdGo\u0015;sS:<\u0007K]8ek\u000eLgnZ#yaJ,7o]5p]B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n9\u0001K]8ek\u000e$\bCA%R\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002Ng\u00051AH]8pizJ\u0011!R\u0005\u0003!\u0012\u000bq\u0001]1dW\u0006<W-\u0003\u0002S'\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\u000bR\u0001\u0005Y\u00164G/F\u0001W!\t1t+\u0003\u0002YO\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002=B\u00191iX1\n\u0005\u0001$%AB(qi&|g\u000e\u0005\u0002cM:\u00111\r\u001a\t\u0003\u0017\u0012K!!\u001a#\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003K\u0012\u000b1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"B\u0001\\7o_B\u0011a\u0007\u0001\u0005\u0006)\u001e\u0001\rA\u0016\u0005\u00065\u001e\u0001\rA\u0016\u0005\b9\u001e\u0001\n\u00111\u0001_\u00039qW\u000f\u001c7J]R|G.\u001a:b]R,\u0012A\u001d\t\u0003\u0007NL!\u0001\u001e#\u0003\u000f\t{w\u000e\\3b]R\u0019AN^<\t\u000bQK\u0001\u0019\u0001,\t\u000biK\u0001\u0019\u0001,\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001{!\rI50`\u0005\u0003yN\u00131aU3r!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0016\u0002\u000bQL\b/Z:\n\u0007\u0005\u0015qP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR!\u00111BA\t!\r1\u0014QB\u0005\u0004\u0003\u001f9#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o\u0011\u0015a6\u00021\u0001b\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t9\"!\b\u0002\"A\u00191)!\u0007\n\u0007\u0005mAIA\u0002B]fDq!a\b\r\u0001\u0004\t9\"A\u0005uS6,7\u000f^1na\"9\u00111\u0005\u0007A\u0002\u0005]\u0011A\u00024pe6\fG/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011FA\u001b\u0003\u007f\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_9\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003g\tiC\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9$\u0004a\u0001\u0003s\t1a\u0019;y!\u0011\tY#a\u000f\n\t\u0005u\u0012Q\u0006\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\t%\u0004a\u0001\u0003S\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001b\u000311wN]7biN#(/\u001b8h\u0003%I7\u000fU1sg&tw-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)A.a\u0014\u0002T!1\u0011\u0011K\tA\u0002Y\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002VE\u0001\rAV\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001da\u00171LA/\u0003?Bq\u0001\u0016\n\u0011\u0002\u0003\u0007a\u000bC\u0004[%A\u0005\t\u0019\u0001,\t\u000fq\u0013\u0002\u0013!a\u0001=\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA3U\r1\u0016qM\u0016\u0003\u0003S\u0002B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0005v]\u000eDWmY6fI*\u0019\u00111\u000f#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002x\u00055$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fR3AXA4\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006L1aZAE\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\nE\u0002D\u00033K1!a'E\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9\"!)\t\u0013\u0005\r\u0006$!AA\u0002\u0005]\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*B1\u00111VAY\u0003/i!!!,\u000b\u0007\u0005=F)\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002.\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0011\u0018\u0011\u0018\u0005\n\u0003GS\u0012\u0011!a\u0001\u0003/\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QQA`\u0011%\t\u0019kGA\u0001\u0002\u0004\t9*\u0001\u0004fcV\fGn\u001d\u000b\u0004e\u0006\u0015\u0007\"CAR9\u0005\u0005\t\u0019AA\fQ]\u0001\u0011\u0011ZAh\u0003#\f).a6\u0002\\\u0006u\u0017\u0011]Ar\u0003O\fI\u000fE\u00027\u0003\u0017L1!!4(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a5\u0002i~3UKT\"`QQLW.Z:uC6\u0004H\u0006\t4ni&\u0002S\u0006I\"p]Z,'\u000f^:!ARLW.Z:uC6\u0004\b\r\t;pA\u0005\u0004c/\u00197vK\u0002zg\rI:ue&tw\rI5oAQDW\r\t4pe6\fG\u000fI:qK\u000eLg-[3eA\tL\b\u0005\u001e5fA\u0011\fG/\u001a\u0011g_Jl\u0017\r\u001e\u0011aM6$\bML\u0001\nCJ<W/\\3oiN\f#!!7\u0002\u0005[R\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016\u001cH/Y7qA5\u0002\u0013\t\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002\u001aHO]5oO\u0002\"x\u000e\t2fA\r|gN^3si\u0016$\u0007\u0005^8!i\",\u0007eZ5wK:\u0004cm\u001c:nCRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0Cz\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty.A$\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.aQj\u0003\u0007O\u0014-A\u001dJx%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\ndG\u0003\u0011!\u0003\u00159'o\\;qC\t\t)/\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005-\u0018!B\u0019/k9\u0002\u0014a\u0004#bi\u00164uN]7bi\u000ec\u0017m]:\u0011\u0005Yr2#\u0002\u0010\u0002t\u0006}\b\u0003CA{\u0003w4fK\u00187\u000e\u0005\u0005](bAA}\t\u00069!/\u001e8uS6,\u0017\u0002BA\u007f\u0003o\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!\u0002\u0002B\u0003\u0003\u001b\u000b!![8\n\u0007I\u0013\u0019\u0001\u0006\u0002\u0002p\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0006\u0006)\u0011\r\u001d9msR9ANa\u0005\u0003\u0016\t]\u0001\"\u0002+\"\u0001\u00041\u0006\"\u0002.\"\u0001\u00041\u0006b\u0002/\"!\u0003\u0005\rAX\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\u0010\u0005O\u0001BaQ0\u0003\"A11Ia\tW-zK1A!\nE\u0005\u0019!V\u000f\u001d7fg!A!\u0011F\u0012\u0002\u0002\u0003\u0007A.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0019!\u0011\t9Ia\r\n\t\tU\u0012\u0011\u0012\u0002\u0007\u001f\nTWm\u0019;")
public class DateFormatClass
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass x$0) {
        return DateFormatClass$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatterOption$lzycompute();
        }
        return this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)formatter.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(timestamp, x$1) -> "UTF8String.fromString(" + timestampFormatter + ".format(" + timestamp + "))");
        }).getOrElse((Function0 & Serializable)() -> {
            String tf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName()), "$");
            String ldf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName()), "$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(timestamp, format) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|UTF8String.fromString(" + tf + "$.MODULE$.apply(\n            |  " + format + ".toString(),\n            |  " + zid + ",\n            |  " + ldf + "$.MODULE$.SIMPLE_DATE_FORMAT(),\n            |  false)\n            |.format(" + timestamp + "))")));
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    @Override
    public Expression formatString() {
        return this.right();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public DateFormatClass withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        Statics.releaseFence();
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

