/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impurity;

import org.apache.spark.mllib.tree.impurity.ImpurityCalculator$;
import scala.Double$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4aa\u0005\u000b\u0002\u0002i\u0001\u0003\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\t\u0011M\u0002!\u0011!Q\u0001\n5BQ\u0001\u000e\u0001\u0005\u0002UBQ!\u000f\u0001\u0007\u0002iBQa\u000f\u0001\u0007\u0002qBQ!\u0010\u0001\u0005\u0002yBQ!\u0011\u0001\u0005\u0002\tCQ\u0001\u0012\u0001\u0007\u0002\u0015CqA\u0012\u0001A\u0002\u001b\u0005q\tC\u0004L\u0001\u0001\u0007i\u0011\u0001'\t\u000bI\u0003a\u0011A#\t\u000bM\u0003A\u0011\u0001+\t\u000b]\u0003A\u0011\u0003-\b\ry#\u0002\u0012\u0001\u000e`\r\u0019\u0019B\u0003#\u0001\u001bA\")Ag\u0004C\u0001C\")!m\u0004C\u0001G\"9!oDA\u0001\n\u0013\u0019(AE%naV\u0014\u0018\u000e^=DC2\u001cW\u000f\\1u_JT!!\u0006\f\u0002\u0011%l\u0007/\u001e:jifT!a\u0006\r\u0002\tQ\u0014X-\u001a\u0006\u00033i\tQ!\u001c7mS\nT!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002#Q%\u0011\u0011f\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006gR\fGo]\u0002\u0001+\u0005i\u0003c\u0001\u0012/a%\u0011qf\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003EEJ!AM\u0012\u0003\r\u0011{WO\u00197f\u0003\u0019\u0019H/\u0019;tA\u00051A(\u001b8jiz\"\"A\u000e\u001d\u0011\u0005]\u0002Q\"\u0001\u000b\t\u000b)\u001a\u0001\u0019A\u0017\u0002\t\r|\u0007/_\u000b\u0002m\u0005I1-\u00197dk2\fG/\u001a\u000b\u0002a\u0005\u0019\u0011\r\u001a3\u0015\u0005Yz\u0004\"\u0002!\u0007\u0001\u00041\u0014!B8uQ\u0016\u0014\u0018\u0001C:vER\u0014\u0018m\u0019;\u0015\u0005Y\u001a\u0005\"\u0002!\b\u0001\u00041\u0014!B2pk:$X#\u0001\u0019\u0002\u0011I\fwoQ8v]R,\u0012\u0001\u0013\t\u0003E%K!AS\u0012\u0003\t1{gnZ\u0001\re\u0006<8i\\;oi~#S-\u001d\u000b\u0003\u001bB\u0003\"A\t(\n\u0005=\u001b#\u0001B+oSRDq!\u0015\u0006\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\nq\u0001\u001d:fI&\u001cG/\u0001\u0003qe>\u0014GC\u0001\u0019V\u0011\u00151F\u00021\u00011\u0003\u0015a\u0017MY3m\u0003iIg\u000eZ3y\u001f\u001ad\u0015M]4fgR\f%O]1z\u000b2,W.\u001a8u)\tIF\f\u0005\u0002#5&\u00111l\t\u0002\u0004\u0013:$\b\"B/\u000e\u0001\u0004i\u0013!B1se\u0006L\u0018AE%naV\u0014\u0018\u000e^=DC2\u001cW\u000f\\1u_J\u0004\"aN\b\u0014\u0007=\ts\u0005F\u0001`\u000359W\r^\"bY\u000e,H.\u0019;peR!a\u0007\u001a9r\u0011\u0015)\u0012\u00031\u0001f!\t1WN\u0004\u0002hWB\u0011\u0001nI\u0007\u0002S*\u0011!nK\u0001\u0007yI|w\u000e\u001e \n\u00051\u001c\u0013A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\\\u0012\t\u000b)\n\u0002\u0019A\u0017\t\u000b\u0019\u000b\u0002\u0019\u0001%\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0005Y\u0006twMC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m4(AB(cU\u0016\u001cG\u000f")
public abstract class ImpurityCalculator
implements Serializable {
    private final double[] stats;

    public static ImpurityCalculator getCalculator(String string, double[] dArray, long l) {
        return ImpurityCalculator$.MODULE$.getCalculator(string, dArray, l);
    }

    public double[] stats() {
        return this.stats;
    }

    public abstract ImpurityCalculator copy();

    public abstract double calculate();

    public ImpurityCalculator add(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(95).append("Two ImpurityCalculator instances cannot be added with different counts sizes.").append("  Sizes are ").append(this.stats().length).append(" and ").append(other.stats().length).append(".").toString());
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] + other.stats()[i];
        }
        this.rawCount_$eq(this.rawCount() + other.rawCount());
        return this;
    }

    public ImpurityCalculator subtract(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(100).append("Two ImpurityCalculator instances cannot be subtracted with different counts sizes.").append("  Sizes are ").append(this.stats().length).append(" and ").append(other.stats().length).append(".").toString());
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] - other.stats()[i];
        }
        this.rawCount_$eq(this.rawCount() - other.rawCount());
        return this;
    }

    public abstract double count();

    public abstract long rawCount();

    public abstract void rawCount_$eq(long var1);

    public abstract double predict();

    public double prob(double label) {
        return -1.0;
    }

    public int indexOfLargestArrayElement(double[] array) {
        Tuple3 result = (Tuple3)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(array)).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> ImpurityCalculator.$anonfun$indexOfLargestArrayElement$1(x0$1, BoxesRunTime.unboxToDouble((Object)x1$1)));
        if (BoxesRunTime.unboxToInt((Object)result._1()) < 0) {
            throw new RuntimeException("ImpurityCalculator internal error: indexOfLargestArrayElement failed");
        }
        return BoxesRunTime.unboxToInt((Object)result._1());
    }

    public static final /* synthetic */ Tuple3 $anonfun$indexOfLargestArrayElement$1(Tuple3 x0$1, double x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToDouble((double)x1$1));
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            double currentValue = tuple2._2$mcD$sp();
            if (tuple3 != null) {
                int maxIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                double maxValue = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                int currentIndex = BoxesRunTime.unboxToInt((Object)tuple3._3());
                if (currentValue > maxValue) {
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)currentIndex), (Object)BoxesRunTime.boxToDouble((double)currentValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1)));
                }
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxIndex), (Object)BoxesRunTime.boxToDouble((double)maxValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1)));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public ImpurityCalculator(double[] stats) {
        this.stats = stats;
    }
}

