/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4QAC\u0006\u0002\u0002YA\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!\t\u0005\tc\u0001\u0011\t\u0011)A\u0005E!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00036\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u00151\u0005A\"\u0005H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015i\u0005\u0001\"\u0001Z\u0011\u0015a\u0006\u0001\"\u0011^\u0005Y9UM\\3sC2L'0\u001a3MS:,\u0017M]'pI\u0016d'B\u0001\u0007\u000e\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u001d=\tQ!\u001c7mS\nT!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d9X-[4iiN,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K5\ta\u0001\\5oC2<\u0017BA\u0014%\u0005\u00191Vm\u0019;pe\"\u001a\u0011!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00051z\u0011AC1o]>$\u0018\r^5p]&\u0011af\u000b\u0002\u0006'&t7-Z\u0011\u0002a\u0005)\u0011G\f\u0019/a\u0005Aq/Z5hQR\u001c\b\u0005K\u0002\u0003S=\n\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0003U\u0002\"\u0001\u0007\u001c\n\u0005]J\"A\u0002#pk\ndW\rK\u0002\u0004Se\n\u0013AO\u0001\u0006a9Bd\u0006M\u0001\u000bS:$XM]2faR\u0004\u0003f\u0001\u0003*s\u00051A(\u001b8jiz\"2aP!D!\t\u0001\u0005!D\u0001\f\u0011\u0015\u0001S\u00011\u0001#Q\r\t\u0015f\f\u0005\u0006g\u0015\u0001\r!\u000e\u0015\u0004\u0007&J\u0004fA\u0003*_\u0005a\u0001O]3eS\u000e$\bk\\5oiR!Q\u0007\u0013&M\u0011\u0015Ie\u00011\u0001#\u0003)!\u0017\r^1NCR\u0014\u0018\u000e\u001f\u0005\u0006\u0017\u001a\u0001\rAI\u0001\ro\u0016Lw\r\u001b;NCR\u0014\u0018\u000e\u001f\u0005\u0006g\u0019\u0001\r!N\u0001\baJ,G-[2u)\tyU\u000bE\u0002Q'Vj\u0011!\u0015\u0006\u0003%>\t1A\u001d3e\u0013\t!\u0016KA\u0002S\t\u0012CQAV\u0004A\u0002]\u000b\u0001\u0002^3ti\u0012\u000bG/\u0019\t\u0004!N\u0013\u0003fA\u0004*_Q\u0011QG\u0017\u0005\u0006-\"\u0001\rA\t\u0015\u0004\u0011%z\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\u0003\"a\u00184\u000f\u0005\u0001$\u0007CA1\u001a\u001b\u0005\u0011'BA2\u0016\u0003\u0019a$o\\8u}%\u0011Q-G\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f3!\u001a\u0001!K\u001d")
public abstract class GeneralizedLinearModel
implements Serializable {
    private final Vector weights;
    private final double intercept;

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    public abstract double predictPoint(Vector var1, Vector var2, double var3);

    public RDD<Object> predict(RDD<Vector> testData) {
        Vector localWeights = this.weights();
        Broadcast bcWeights = testData.context().broadcast((Object)localWeights, ClassTag$.MODULE$.apply(Vector.class));
        double localIntercept = this.intercept();
        return testData.mapPartitions((Function1 & java.io.Serializable & Serializable)iter -> {
            Vector w = (Vector)bcWeights.value();
            return iter.map((Function1 & java.io.Serializable & Serializable)v -> BoxesRunTime.boxToDouble((double)this.predictPoint(v, w, localIntercept)));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    public double predict(Vector testData) {
        return this.predictPoint(testData, this.weights(), this.intercept());
    }

    public String toString() {
        return new StringBuilder(30).append(this.getClass().getName()).append(": intercept = ").append(this.intercept()).append(", numFeatures = ").append(this.weights().size()).toString();
    }

    public GeneralizedLinearModel(Vector weights, double intercept) {
        this.weights = weights;
        this.intercept = intercept;
    }
}

