/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.Serializable;
import org.apache.spark.ml.clustering.KMeans$;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\u000f\u001e\t!B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!b\u0001\n\u0003a\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\r\u0003!Q1A\u0005\u0002\u0011C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006#\u0002!\tA\u0015\u0005\u00063\u0002!\tA\u0017\u0005\b=\u0002\u0001\r\u0011\"\u0001[\u0011\u001dy\u0006\u00011A\u0005\u0002\u0001DaA\u001a\u0001!B\u0013Y\u0006bB4\u0001\u0001\u0004%\t\u0001\u001b\u0005\bY\u0002\u0001\r\u0011\"\u0001n\u0011\u0019y\u0007\u0001)Q\u0005S\"9\u0001\u000f\u0001b\u0001\n\u0003\t\bBB;\u0001A\u0003%!\u000fC\u0004w\u0001\t\u0007I\u0011A\u001a\t\r]\u0004\u0001\u0015!\u00035\u0011!A\b\u0001#b\u0001\n\u0013I\bBCA\u0002\u0001\u0001\u0007\t\u0019!C\u0005s\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0011)\tY\u0001\u0001a\u0001\u0002\u0003\u0006KA\u001f\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!a\u000b\u0001\t\u0013\tiC\u0001\tL\u001b\u0016\fgn]!hOJ,w-\u0019;pe*\u0011adH\u0001\u000bG2,8\u000f^3sS:<'B\u0001\u0011\"\u0003\tiGN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011!\u0006M\u0005\u0003c-\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fAbY3oi\u0016\u0014X*\u0019;sSb,\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o}\ta\u0001\\5oC2<\u0017BA\u001d7\u0005-!UM\\:f\u001b\u0006$(/\u001b=\u0002\u001b\r,g\u000e^3s\u001b\u0006$(/\u001b=!\u0003\u0005YW#A\u001f\u0011\u0005)r\u0014BA ,\u0005\rIe\u000e^\u0001\u0003W\u0002\n1B\\;n\r\u0016\fG/\u001e:fg\u0006aa.^7GK\u0006$XO]3tA\u0005yA-[:uC:\u001cW-T3bgV\u0014X-F\u0001F!\t1UJ\u0004\u0002H\u0017B\u0011\u0001jK\u0007\u0002\u0013*\u0011!jJ\u0001\u0007yI|w\u000e\u001e \n\u00051[\u0013A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T\u0016\u0002!\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0003T+Z;\u0006\f\u0005\u0002U\u00015\tQ\u0004C\u00033\u0013\u0001\u0007A\u0007C\u0003<\u0013\u0001\u0007Q\bC\u0003B\u0013\u0001\u0007Q\bC\u0003D\u0013\u0001\u0007Q)A\u0005xK&<\u0007\u000e^*v[V\t1\f\u0005\u0002+9&\u0011Ql\u000b\u0002\u0007\t>,(\r\\3\u0002\u000f\r|7\u000f^*v[\u0006Y1m\\:u'Vlw\fJ3r)\t\tG\r\u0005\u0002+E&\u00111m\u000b\u0002\u0005+:LG\u000fC\u0004f\u0019\u0005\u0005\t\u0019A.\u0002\u0007a$\u0013'\u0001\u0005d_N$8+^7!\u0003\u0015\u0019w.\u001e8u+\u0005I\u0007C\u0001\u0016k\u0013\tY7F\u0001\u0003M_:<\u0017!C2pk:$x\fJ3r)\t\tg\u000eC\u0004f\u001f\u0005\u0005\t\u0019A5\u0002\r\r|WO\u001c;!\u000319X-[4iiN+XNV3d+\u0005\u0011\bCA\u001bt\u0013\t!hGA\u0006EK:\u001cXMV3di>\u0014\u0018!D<fS\u001eDGoU;n-\u0016\u001c\u0007%\u0001\u0004tk6l\u0015\r^\u0001\bgVlW*\u0019;!\u0003I\u0019WM\u001c;feN\u000bX/\u0019:fI:{'/\\:\u0016\u0003i\u00042AK>\\\u0013\ta8FA\u0003BeJ\f\u0017\u0010\u000b\u0002\u0016}B\u0011!f`\u0005\u0004\u0003\u0003Y#!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0019\u0011WO\u001a4fe\u0006Q!-\u001e4gKJ|F%Z9\u0015\u0007\u0005\fI\u0001C\u0004f/\u0005\u0005\t\u0019\u0001>\u0002\u000f\t,hMZ3sA!\u0012\u0001D`\u0001\u0004C\u0012$G\u0003BA\n\u0003+i\u0011\u0001\u0001\u0005\b\u0003/I\u0002\u0019AA\r\u0003\u0015\u0011Gn\\2l!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010?\u00059a-Z1ukJ,\u0017\u0002BA\u0012\u0003;\u0011Q\"\u00138ti\u0006t7-\u001a\"m_\u000e\\\u0017AF3vG2LG-Z1o+B$\u0017\r^3J]Bc\u0017mY3\u0015\u0007\u0005\fI\u0003C\u0004\u0002\u0018i\u0001\r!!\u0007\u0002'\r|7/\u001b8f+B$\u0017\r^3J]Bc\u0017mY3\u0015\u0007\u0005\fy\u0003C\u0004\u0002\u0018m\u0001\r!!\u0007")
public class KMeansAggregator
implements scala.Serializable {
    private transient double[] centerSquaredNorms;
    private final DenseMatrix centerMatrix;
    private final int k;
    private final int numFeatures;
    private final String distanceMeasure;
    private double costSum;
    private long count;
    private final DenseVector weightSumVec;
    private final DenseMatrix sumMat;
    private transient double[] buffer;
    private volatile transient boolean bitmap$trans$0;

    public DenseMatrix centerMatrix() {
        return this.centerMatrix;
    }

    public int k() {
        return this.k;
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public String distanceMeasure() {
        return this.distanceMeasure;
    }

    public double weightSum() {
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.weightSumVec().values())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double costSum() {
        return this.costSum;
    }

    public void costSum_$eq(double x$1) {
        this.costSum = x$1;
    }

    public long count() {
        return this.count;
    }

    public void count_$eq(long x$1) {
        this.count = x$1;
    }

    public DenseVector weightSumVec() {
        return this.weightSumVec;
    }

    public DenseMatrix sumMat() {
        return this.sumMat;
    }

    private double[] centerSquaredNorms$lzycompute() {
        KMeansAggregator kMeansAggregator = this;
        synchronized (kMeansAggregator) {
            if (!this.bitmap$trans$0) {
                double[] dArray;
                String string = this.distanceMeasure();
                String string2 = KMeans$.MODULE$.EUCLIDEAN();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    dArray = (double[])this.centerMatrix().rowIter().map((Function1 & Serializable & scala.Serializable)center -> BoxesRunTime.boxToDouble((double)center.dot(center))).toArray(ClassTag$.MODULE$.Double());
                } else {
                    String string4 = KMeans$.MODULE$.COSINE();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        dArray = null;
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
                this.centerSquaredNorms = dArray;
                this.bitmap$trans$0 = true;
            }
        }
        return this.centerSquaredNorms;
    }

    private double[] centerSquaredNorms() {
        if (!this.bitmap$trans$0) {
            return this.centerSquaredNorms$lzycompute();
        }
        return this.centerSquaredNorms;
    }

    private double[] buffer() {
        return this.buffer;
    }

    private void buffer_$eq(double[] x$1) {
        this.buffer = x$1;
    }

    public KMeansAggregator add(InstanceBlock block) {
        int size = block.size();
        Predef$.MODULE$.require(block.matrix().isTransposed());
        Predef$.MODULE$.require(this.numFeatures() == block.numFeatures(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Dimensions mismatch when adding new ").append("instance. Expecting ").append(this.numFeatures()).append(" but got ").append(block.numFeatures()).append(".").toString());
        Predef$.MODULE$.require(block.weightIter().forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$10 -> x$10 >= 0.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("instance weights ").append(block.weightIter().mkString("[", ",", "]")).append(" has to be >= 0.0").toString());
        if (block.weightIter().forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$11 -> x$11 == 0.0)) {
            return this;
        }
        if (this.buffer() == null || this.buffer().length < size * this.k()) {
            this.buffer_$eq((double[])Array$.MODULE$.ofDim(size * this.k(), ClassTag$.MODULE$.Double()));
        }
        String string = this.distanceMeasure();
        String string2 = KMeans$.MODULE$.EUCLIDEAN();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.euclideanUpdateInPlace(block);
        } else {
            String string4 = KMeans$.MODULE$.COSINE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.cosineUpdateInPlace(block);
            } else {
                throw new MatchError((Object)string);
            }
        }
        this.count_$eq(this.count() + (long)size);
        return this;
    }

    private void euclideanUpdateInPlace(InstanceBlock block) {
        double[] localBuffer = this.buffer();
        BLAS$.MODULE$.gemm(-2.0, block.matrix(), this.centerMatrix().transpose(), 0.0, localBuffer);
        int size = block.size();
        double[] localCenterSquaredNorms = this.centerSquaredNorms();
        double[] localWeightSumArr = this.weightSumVec().values();
        double[] localSumArr = this.sumMat().values();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            double weight = block.getWeight().apply$mcDI$sp(i);
            if (!(weight > 0.0)) continue;
            double instanceSquaredNorm = block.getLabel(i);
            IntRef bestIndex = IntRef.create((int)0);
            double bestSquaredDistance = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.k(); ++j) {
                double squaredDistance = localBuffer[i + j * size] + instanceSquaredNorm + localCenterSquaredNorms[j];
                if (!(squaredDistance < bestSquaredDistance)) continue;
                bestIndex.elem = j;
                bestSquaredDistance = squaredDistance;
            }
            this.costSum_$eq(this.costSum() + weight * bestSquaredDistance);
            int n = bestIndex.elem;
            localWeightSumArr[n] = localWeightSumArr[n] + weight;
            ((Iterator)block.getNonZeroIter().apply((Object)BoxesRunTime.boxToInteger((int)i))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KMeansAggregator.$anonfun$euclideanUpdateInPlace$1(this, bestIndex, localSumArr, weight, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void cosineUpdateInPlace(InstanceBlock block) {
        double[] localBuffer = this.buffer();
        BLAS$.MODULE$.gemm(-1.0, block.matrix(), this.centerMatrix().transpose(), 0.0, localBuffer);
        int size = block.size();
        double[] localWeightSumArr = this.weightSumVec().values();
        double[] localSumArr = this.sumMat().values();
        int j = 0;
        for (int i = 0; i < size; ++i) {
            double weight = block.getWeight().apply$mcDI$sp(i);
            if (!(weight > 0.0)) continue;
            IntRef bestIndex = IntRef.create((int)0);
            double bestDistance = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.k(); ++j) {
                double cosineDistance = 1.0 + localBuffer[i + j * size];
                if (!(cosineDistance < bestDistance)) continue;
                bestIndex.elem = j;
                bestDistance = cosineDistance;
            }
            this.costSum_$eq(this.costSum() + weight * bestDistance);
            int n = bestIndex.elem;
            localWeightSumArr[n] = localWeightSumArr[n] + weight;
            ((Iterator)block.getNonZeroIter().apply((Object)BoxesRunTime.boxToInteger((int)i))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KMeansAggregator.$anonfun$cosineUpdateInPlace$1(this, bestIndex, localSumArr, weight, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$euclideanUpdateInPlace$1(KMeansAggregator $this, IntRef bestIndex$1, double[] localSumArr$1, double weight$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int j = tuple2._1$mcI$sp();
            double v = tuple2._2$mcD$sp();
            int n = bestIndex$1.elem + j * $this.k();
            localSumArr$1[n] = localSumArr$1[n] + v * weight$1;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$cosineUpdateInPlace$1(KMeansAggregator $this, IntRef bestIndex$2, double[] localSumArr$2, double weight$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int j = tuple2._1$mcI$sp();
            double v = tuple2._2$mcD$sp();
            int n = bestIndex$2.elem + j * $this.k();
            localSumArr$2[n] = localSumArr$2[n] + v * weight$2;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public KMeansAggregator(DenseMatrix centerMatrix, int k, int numFeatures, String distanceMeasure) {
        this.centerMatrix = centerMatrix;
        this.k = k;
        this.numFeatures = numFeatures;
        this.distanceMeasure = distanceMeasure;
        this.costSum = 0.0;
        this.count = 0L;
        this.weightSumVec = new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double()));
        this.sumMat = new DenseMatrix(k, numFeatures, (double[])Array$.MODULE$.ofDim(k * numFeatures, ClassTag$.MODULE$.Double()));
    }
}

