/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.Statics;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Negative$;
import spire.algebra.Sign$Positive$;
import spire.algebra.Sign$Zero$;
import spire.math.Algebraic;
import spire.math.Algebraic$;
import spire.math.Complex;
import spire.math.Natural;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Quaternion;
import spire.math.Rational$;
import spire.math.RationalAlgebra;
import spire.math.Real;
import spire.math.Real$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;
import spire.std.package$long$;
import spire.util.Opt$;

@ScalaSignature(bytes="\u0006\u0001\u00115c\u0001CA-\u00037\n\t#!\u001a\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u00111\u0014\u0001\u0007\u0002\u0005u\u0005bBAS\u0001\u0019\u0005\u0011Q\u0014\u0005\b\u0003O\u0003a\u0011AAU\u0011\u001d\t\u0019\f\u0001D\t\u0003SCq!!.\u0001\r\u0003\t9\fC\u0004\u0002@\u00021\t!!+\t\u000f\u0005\u0005\u0007A\"\u0005\u0002*\"9\u00111\u0019\u0001\u0007\u0002\u0005]\u0006bBAc\u0001\u0019\u0005\u0011\u0011\u0016\u0005\b\u0003\u000f\u0004a\u0011AAe\u0011\u001d\tY\r\u0001C\u0001\u0003\u001bDq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002Z\u0002!\t!a7\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\bbBA~\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003{\u0004a\u0011AA}\u0011\u001d\ty\u0010\u0001D\u0001\u0005\u0003AqAa\u0001\u0001\r\u0003\tI\u000bC\u0004\u0003\u0006\u00011\t!!+\t\u000f\t\u001d\u0001A\"\u0001\u0002z\"9!\u0011\u0002\u0001\u0007\u0002\t-\u0001b\u0002B\t\u0001\u0019\u0005!1\u0003\u0005\b\u0005/\u0001a\u0011\u0001B\r\u0011\u001d\u0011i\u0002\u0001D\u0001\u0005?AqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u0003*\u0001!\tAa\u000b\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!Q\u0007\u0001\u0005\u0002\t]\u0002b\u0002B!\u0001\u0011\u0005!1\t\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001fBqAa\u0016\u0001\t\u0003\u0011I\u0006C\u0004\u0003b\u0001!\tAa\u0019\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003~!9!\u0011\u0012\u0001\u0007\u0002\u0005u\u0005b\u0002BF\u0001\u0011\u0015!Q\u0012\u0005\b\u0005+\u0003A\u0011\tBL\u0011\u001d\u0011y\n\u0001C!\u0005CCqA!+\u0001\r\u0003\tI\u0010C\u0004\u0003,\u00021\t!!?\t\u000f\t5\u0006A\"\u0001\u0002z\"9!q\u0016\u0001\u0005\u0002\tE\u0006b\u0002B\\\u0001\u0019\u0005!\u0011\u0018\u0005\b\u0005\u007f\u0003A\u0011\u0001Ba\u0011\u001d\u0011y\r\u0001D\u0001\u0005\u0003AqA!5\u0001\t\u0003\u0011\u0019\u000eC\u0004\u0003X\u0002!\tA!7\t\u000f\tu\u0007\u0001\"\u0001\u0002z\"9!q\u001c\u0001\u0005\u0002\u0005e\bb\u0002Bq\u0001\u0011\u0005!1\u001d\u0005\b\u0005O\u0004A\u0011\u0001Bu\u0011\u001d\u0011y\u000f\u0001C!\u0005c<\u0001\u0002b\u0013\u0002\\!\u00051q\u0003\u0004\t\u00033\nY\u0006#\u0001\u0004\u0002!9\u0011q\u0013\u001d\u0005\u0002\rU\u0001\"CB\rq\t\u0007I\u0011BB\u000e\u0011!\u0019i\u0003\u000fQ\u0001\n\ru\u0001\"CB\u0018q\t\u0007I\u0011BB\u000e\u0011!\u0019\t\u0004\u000fQ\u0001\n\ru\u0001\"CB\u001aq\t\u0007I\u0011AA}\u0011!\u0019)\u0004\u000fQ\u0001\n\u0005M\u0005\"CB\u001cq\t\u0007I\u0011AA}\u0011!\u0019I\u0004\u000fQ\u0001\n\u0005M\u0005bCB\u001eq\t\u0007I\u0011AA.\u0005\u001bC\u0001b!\u00109A\u0003%!q\u0012\u0005\f\u0007\u007fA$\u0019!C\u0001\u00037\u0012i\t\u0003\u0005\u0004Ba\u0002\u000b\u0011\u0002BH\u0011-\u0019\u0019\u0005\u000fb\u0001\n\u0003\tYF!$\t\u0011\r\u0015\u0003\b)A\u0005\u0005\u001fC1ba\u00129\u0005\u0004%\t!a\u0017\u0003\u000e\"A1\u0011\n\u001d!\u0002\u0013\u0011y\tC\u0005\u0004La\"\t!a\u0017\u0004N!91Q\f\u001d\u0005\u0002\r}\u0003bBB/q\u0011\u00051Q\r\u0005\n\u0007WBD\u0011AA.\u0007[Bqa!\u00189\t\u0003\u0019y\bC\u0004\u0004^a\"\u0019a!\"\t\u000f\ru\u0003\bb\u0001\u0004\f\"91Q\f\u001d\u0005\u0004\r=\u0005bBB/q\u0011\r11\u0013\u0005\b\u0007;BD1ABL\u0011\u001d\u0019i\u0006\u000fC\u0002\u00077Cqa!\u00189\t\u0003\u0019y\nC\u0004\u0004^a\"\u0019a!.\t\u000f\ru\u0003\bb\u0001\u0004:\u001a111\u0019\u001d\u0007\u0007\u000bD!ba\u0016Y\u0005\u000b\u0007I\u0011AA\\\u0011)\u00199\r\u0017B\u0001B\u0003%\u0011\u0011\u0018\u0005\u000b\u00077B&Q1A\u0005\u0002\u0005]\u0006BCBe1\n\u0005\t\u0015!\u0003\u0002:\"9\u0011q\u0013-\u0005\u0002\r-\u0007bBAN1\u0012\u0005\u0011Q\u0014\u0005\b\u0003KCF\u0011AAO\u0011\u001d\t)\f\u0017C\u0001\u0003oCq!a*Y\t\u0003\tI\u000bC\u0004\u00024b#\t!!+\t\u000f\u0005\r\u0007\f\"\u0001\u00028\"9\u0011q\u0018-\u0005\u0002\u0005%\u0006bBAa1\u0012\u0005\u0011\u0011\u0016\u0005\b\u0003{DF\u0011AA}\u0011\u001d\ty\u0010\u0017C!\u0005\u0003Aq!a2Y\t\u0003\nI\rC\u0004\u0003\u0004a#\t%!+\t\u000f\t\u0015\u0001\f\"\u0011\u0002*\"91Q\u001b-\u0005B\u0005%\u0006bBBl1\u0012\u0005\u0013\u0011\u0016\u0005\b\u00073DF\u0011IAU\u0011\u001d\u0019Y\u000e\u0017C!\u0003SCq!!2Y\t\u0003\nI\u000bC\u0004\u0003\nb#\t%!(\t\u000f\ru\u0007\f\"\u0011\u0004`\"9!q\u0001-\u0005B\u0005e\bb\u0002B\u00051\u0012\u00051\u0011\u001d\u0005\b\u0005#AF\u0011ABs\u0011\u001d\u00119\u0002\u0017C\u0001\u0007SDqA!\bY\t\u0003\u0019i\u000fC\u0004\u0003*b#\t!!?\t\u000f\t-\u0006\f\"\u0001\u0002z\"9!Q\u0016-\u0005\u0002\u0005e\bb\u0002B\\1\u0012\u00051\u0011\u001f\u0005\b\u0005\u001fDF\u0011\u0001B\u0001\u0011\u001d\u0019)\u0010\u0017C\u0001\u0007oDq!a3Y\t\u0003\ni\rC\u0004\u0003pb#\tea?\t\u000f\r}\b\f\"\u0011\u0002R\"9A\u0011\u0001-\u0005B\u0011\r\u0001b\u0002C\tq\u0011%A1\u0003\u0004\u0007\u0005\u007fDd\u0001\"\n\t\u0017\r]\u0013Q\u0001BC\u0002\u0013\u0005\u0011Q\u0014\u0005\f\u0007\u000f\f)A!A!\u0002\u0013\ty\nC\u0006\u0004\\\u0005\u0015!Q1A\u0005\u0002\u0005u\u0005bCBe\u0003\u000b\u0011\t\u0011)A\u0005\u0003?C\u0001\"a&\u0002\u0006\u0011\u0005Aq\u0005\u0005\t\u00037\u000b)\u0001\"\u0001\u0002\u001e\"A\u0011QUA\u0003\t\u0003\ti\n\u0003\u0005\u00026\u0006\u0015A\u0011AA\\\u0011!\t9+!\u0002\u0005\u0002\u0005%\u0006\u0002CAZ\u0003\u000b!\t!!+\t\u0011\u0005\r\u0017Q\u0001C\u0001\u0003oC\u0001\"a0\u0002\u0006\u0011\u0005\u0011\u0011\u0016\u0005\t\u0003\u0003\f)\u0001\"\u0001\u0002*\"A\u0011Q`A\u0003\t\u0003\tI\u0010\u0003\u0005\u0002\u0000\u0006\u0015A\u0011\tB\u0001\u0011!\t9-!\u0002\u0005B\u0005%\u0007\u0002\u0003B\u0002\u0003\u000b!\t%!+\t\u0011\t\u0015\u0011Q\u0001C!\u0003SC\u0001b!6\u0002\u0006\u0011\u0005\u0013\u0011\u0016\u0005\t\u0007/\f)\u0001\"\u0011\u0002*\"A1\u0011\\A\u0003\t\u0003\nI\u000b\u0003\u0005\u0004\\\u0006\u0015A\u0011IAU\u0011!\t)-!\u0002\u0005B\u0005%\u0006\u0002\u0003BE\u0003\u000b!\t%!(\t\u0011\ru\u0017Q\u0001C!\u0007?D\u0001Ba\u0002\u0002\u0006\u0011\u0005\u0013\u0011 \u0005\t\u0005\u0013\t)\u0001\"\u0001\u0005.!A!\u0011CA\u0003\t\u0003!\t\u0004\u0003\u0005\u0003\u0018\u0005\u0015A\u0011\u0001C\u001b\u0011!\u0011i\"!\u0002\u0005\u0002\u0011e\u0002\u0002\u0003BU\u0003\u000b!\t!!?\t\u0011\t-\u0016Q\u0001C\u0001\u0003sD\u0001B!,\u0002\u0006\u0011\u0005\u0011\u0011 \u0005\t\u0005o\u000b)\u0001\"\u0001\u0005>!A!qZA\u0003\t\u0003\u0011\t\u0001\u0003\u0005\u0004v\u0006\u0015A\u0011\u0001C!\u0011!\u0011y/!\u0002\u0005B\u0011\u0015\u0003\u0002CB\u0000\u0003\u000b!\t%!5\t\u0011\u0011\u0005\u0011Q\u0001C!\t\u0007Aq\u0001\"\u00079\t\u0013!Y\u0002C\u0005\u0005$a\n\t\u0011\"\u0003\u0002f\nA!+\u0019;j_:\fGN\u0003\u0003\u0002^\u0005}\u0013\u0001B7bi\"T!!!\u0019\u0002\u000bM\u0004\u0018N]3\u0004\u0001M9\u0001!a\u001a\u0002v\u0005m\u0004\u0003BA5\u0003cj!!a\u001b\u000b\t\u0005u\u0013Q\u000e\u0006\u0003\u0003_\nQa]2bY\u0006LA!a\u001d\u0002l\tY1kY1mC:+XNY3s!\u0011\tI'a\u001e\n\t\u0005e\u00141\u000e\u0002\u0018'\u000e\fG.\u0019(v[\u0016\u0014\u0018nY\"p]Z,'o]5p]N\u0004b!! \u0002\u000e\u0006Me\u0002BA@\u0003\u0013sA!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b\u0019'\u0001\u0004=e>|GOP\u0005\u0003\u0003_JA!a#\u0002n\u00059\u0001/Y2lC\u001e,\u0017\u0002BAH\u0003#\u0013qa\u0014:eKJ,GM\u0003\u0003\u0002\f\u00065\u0004cAAK\u00015\u0011\u00111L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005M\u0015!\u00038v[\u0016\u0014\u0018\r^8s+\t\ty\n\u0005\u0003\u0002\u0016\u0006\u0005\u0016\u0002BAR\u00037\u0012\u0001bU1gK2{gnZ\u0001\fI\u0016tw.\\5oCR|'/\u0001\u000bok6,'/\u0019;pe&\u001bh+\u00197jI2{gnZ\u000b\u0003\u0003W\u0003B!!,\u000206\u0011\u0011QN\u0005\u0005\u0003c\u000biGA\u0004C_>dW-\u00198\u0002/9,X.\u001a:bi>\u0014\u0018IY:JgZ\u000bG.\u001b3M_:<\u0017a\u00048v[\u0016\u0014\u0018\r^8s\u0003NduN\\4\u0016\u0005\u0005e\u0006\u0003BAW\u0003wKA!!0\u0002n\t!Aj\u001c8h\u0003Y!WM\\8nS:\fGo\u001c:JgZ\u000bG.\u001b3M_:<\u0017!\u00073f]>l\u0017N\\1u_J\f%m]%t-\u0006d\u0017\u000e\u001a'p]\u001e\f\u0011\u0003Z3o_6Lg.\u0019;pe\u0006\u001bHj\u001c8h\u0003-I7OV1mS\u0012duN\\4\u0002\u000f%\u001cx\u000b[8mKR\u0011\u00111V\u0001\nY>twMV1mk\u0016$\"!!/\u0002\u0011%tGOV1mk\u0016$\"!a5\u0011\t\u00055\u0016Q[\u0005\u0005\u0003/\fiGA\u0002J]R\f!B\u001a7pCR4\u0016\r\\;f)\t\ti\u000e\u0005\u0003\u0002.\u0006}\u0017\u0002BAq\u0003[\u0012QA\u00127pCR\f!\"\u001e8eKJd\u00170\u001b8h)\t\t9\u000f\u0005\u0003\u0002j\u0006MXBAAv\u0015\u0011\ti/a<\u0002\t1\fgn\u001a\u0006\u0003\u0003c\fAA[1wC&!\u0011Q_Av\u0005\u0019y%M[3di\u0006\u0019\u0011MY:\u0016\u0005\u0005M\u0015aB5om\u0016\u00148/Z\u0001\u000be\u0016\u001c\u0017\u000e\u001d:pG\u0006d\u0017AB:jO:,X.\u0006\u0002\u0002T\u00061\u0011n\u001d.fe>\fQ![:P]\u0016\fA\"\u001e8bef|F%\\5okN\fQ\u0001\n9mkN$B!a%\u0003\u000e!9!qB\fA\u0002\u0005M\u0015a\u0001:ig\u00061A%\\5okN$B!a%\u0003\u0016!9!q\u0002\rA\u0002\u0005M\u0015A\u0002\u0013uS6,7\u000f\u0006\u0003\u0002\u0014\nm\u0001b\u0002B\b3\u0001\u0007\u00111S\u0001\u0005I\u0011Lg\u000f\u0006\u0003\u0002\u0014\n\u0005\u0002b\u0002B\b5\u0001\u0007\u00111S\u0001\tIA,'oY3oiR!\u00111\u0013B\u0014\u0011\u001d\u0011ya\u0007a\u0001\u0003'\u000bQ\u0001^9v_R$B!a%\u0003.!9!q\u0002\u000fA\u0002\u0005M\u0015\u0001\u0002;n_\u0012$B!a%\u00034!9!qB\u000fA\u0002\u0005M\u0015\u0001\u0003;rk>$Xn\u001c3\u0015\t\te\"q\b\t\t\u0003[\u0013Y$a%\u0002\u0014&!!QHA7\u0005\u0019!V\u000f\u001d7fe!9!q\u0002\u0010A\u0002\u0005M\u0015a\u00017d[R!\u00111\u0013B#\u0011\u001d\u0011ya\ba\u0001\u0003'\u000b1aZ2e)\u0011\t\u0019Ja\u0013\t\u000f\t=\u0001\u00051\u0001\u0002\u0014\u00061Ao\u001c*fC2,\"A!\u0015\u0011\t\u0005U%1K\u0005\u0005\u0005+\nYF\u0001\u0003SK\u0006d\u0017a\u0003;p\u00032<WM\u0019:bS\u000e,\"Aa\u0017\u0011\t\u0005U%QL\u0005\u0005\u0005?\nYFA\u0005BY\u001e,'M]1jG\u0006aAo\u001c\"jO\u0012+7-[7bYR1!Q\rB6\u0005_\u0002B!! \u0003h%!!\u0011NAI\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\u001c\u0005\b\u0005[\u001a\u0003\u0019AAj\u0003\u0015\u00198-\u00197f\u0011\u001d\u0011\th\ta\u0001\u0005g\nA!\\8eKB!!Q\u000fB=\u001b\t\u00119H\u0003\u0003\u0002^\u0005=\u0018\u0002\u0002B>\u0005o\u0012ABU8v]\u0012LgnZ'pI\u0016$BA!\u001a\u0003\u0000!9!\u0011\u0011\u0013A\u0002\t\r\u0015AA7d!\u0011\u0011)H!\"\n\t\t\u001d%q\u000f\u0002\f\u001b\u0006$\bnQ8oi\u0016DH/\u0001\u0006u_N\u000bg-\u001a'p]\u001e\f\u0001\u0002^8CS\u001eLe\u000e^\u000b\u0003\u0005\u001f\u0003B!! \u0003\u0012&!!1SAI\u0005\u0019\u0011\u0015nZ%oi\u0006Q1\u000f[8siZ\u000bG.^3\u0015\u0005\te\u0005\u0003BAW\u00057KAA!(\u0002n\t)1\u000b[8si\u0006I!-\u001f;f-\u0006dW/\u001a\u000b\u0003\u0005G\u0003B!!,\u0003&&!!qUA7\u0005\u0011\u0011\u0015\u0010^3\u0002\u000b\u0019dwn\u001c:\u0002\t\r,\u0017\u000e\\\u0001\u0006e>,h\u000eZ\u0001\be>,h\u000e\u001a+p)\u0011\t\u0019Ja-\t\u000f\tUF\u00061\u0001\u0002 \u0006)A-\u001a8p[\u0006\u0019\u0001o\\<\u0015\t\u0005M%1\u0018\u0005\b\u0005{k\u0003\u0019AAj\u0003\r)\u0007\u0010]\u0001\u0005g&<g.\u0006\u0002\u0003DB!!Q\u0019Bf\u001b\t\u00119M\u0003\u0003\u0003J\u0006}\u0013aB1mO\u0016\u0014'/Y\u0005\u0005\u0005\u001b\u00149M\u0001\u0003TS\u001et\u0017\u0001D2p[B\f'/\u001a+p\u001f:,\u0017aA7j]R!\u00111\u0013Bk\u0011\u001d\u0011y\u0001\ra\u0001\u0003'\u000b1!\\1y)\u0011\t\u0019Ja7\t\u000f\t=\u0011\u00071\u0001\u0002\u0014\u0006QA.[7jiR{\u0017J\u001c;\u0002\u00171LW.\u001b;U_2{gnZ\u0001\bY&l\u0017\u000e\u001e+p)\u0011\t\u0019J!:\t\u000f\t]G\u00071\u0001\u0002 \u0006\u0011B.[7ji\u0012+gn\\7j]\u0006$xN\u001d+p)\u0011\t\u0019Ja;\t\u000f\t5X\u00071\u0001\u0002 \u0006)A.[7ji\u00061Q-];bYN$B!a+\u0003t\"9!Q\u001f\u001cA\u0002\t]\u0018\u0001\u0002;iCR\u0004B!!,\u0003z&!!1`A7\u0005\r\te._\u0015\u0005\u0001\u0005\u0015\u0001LA\u0006CS\u001e\u0014\u0016\r^5p]\u0006d7c\u0002\u001d\u0004\u0004\r%1q\u0002\t\u0005\u0003[\u001b)!\u0003\u0003\u0004\b\u00055$AB!osJ+g\r\u0005\u0003\u0002\u0016\u000e-\u0011\u0002BB\u0007\u00037\u0012\u0011CU1uS>t\u0017\r\\%ogR\fgnY3t!\u0011\tik!\u0005\n\t\rM\u0011Q\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0007/\u00012!!&9\u00039\u0011\u0016\r^5p]\u0006d7\u000b\u001e:j]\u001e,\"a!\b\u0011\t\r}1\u0011F\u0007\u0003\u0007CQAaa\t\u0004&\u0005AQ.\u0019;dQ&twM\u0003\u0003\u0004(\u00055\u0014\u0001B;uS2LAaa\u000b\u0004\"\t)!+Z4fq\u0006y!+\u0019;j_:\fGn\u0015;sS:<\u0007%A\u0007J]R,w-\u001a:TiJLgnZ\u0001\u000f\u0013:$XmZ3s'R\u0014\u0018N\\4!\u0003\u0011QXM]8\u0002\u000bi,'o\u001c\u0011\u0002\u0007=tW-\u0001\u0003p]\u0016\u0004\u0013a\u0002+x_N\nT.M\u0001\t)^|7'M72A\u00059Ak^84c5\u0004\u0014\u0001\u0003+x_N\nT\u000e\r\u0011\u0002\u000fQ;xNN\u001anc\u0005AAk^87g5\f\u0004%A\u0004Uo>44'\u001c\u0019\u0002\u0011Q;xNN\u001ana\u0001\n\u0001\u0002^8E_V\u0014G.\u001a\u000b\u0007\u0007\u001f\u001a)f!\u0017\u0011\t\u000556\u0011K\u0005\u0005\u0007'\niG\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0007/R\u0005\u0019AAP\u0003\u0005q\u0007bBB.\u0015\u0002\u0007\u0011qT\u0001\u0002I\u0006)\u0011\r\u001d9msR1\u00111SB1\u0007GBqaa\u0016L\u0001\u0004\u0011y\tC\u0004\u0004\\-\u0003\rAa$\u0015\r\u0005M5qMB5\u0011\u001d\u00199\u0006\u0014a\u0001\u0003sCqaa\u0017M\u0001\u0004\tI,\u0001\u0007ck&dGmV5uQ\u0012Kg\u000f\u0006\u0006\u0002\u0014\u000e=41OB<\u0007wBqa!\u001dN\u0001\u0004\tI,A\u0002ok6Dqa!\u001eN\u0001\u0004\tI,\u0001\u0003oO\u000e$\u0007bBB=\u001b\u0002\u0007\u0011\u0011X\u0001\u0003e\u0012Dqa! N\u0001\u0004\tI,\u0001\u0003mI\u0016tGCBAJ\u0007\u0003\u001b\u0019\tC\u0004\u0004X9\u0003\r!a(\t\u000f\rmc\n1\u0001\u0002 R!\u00111SBD\u0011\u001d\u0019Ii\u0014a\u0001\u0003'\f\u0011\u0001\u001f\u000b\u0005\u0003'\u001bi\tC\u0004\u0004\nB\u0003\r!!/\u0015\t\u0005M5\u0011\u0013\u0005\b\u0007\u0013\u000b\u0006\u0019\u0001BH)\u0011\t\u0019j!&\t\u000f\r%%\u000b1\u0001\u0002^R!\u00111SBM\u0011\u001d\u0019Ii\u0015a\u0001\u0007\u001f\"B!a%\u0004\u001e\"91\u0011\u0012+A\u0002\t\u0015D\u0003BAJ\u0007CCqaa)V\u0001\u0004\u0019)+A\u0001s!\u0011\u00199ka,\u000f\t\r%61\u0016\t\u0005\u0003\u0003\u000bi'\u0003\u0003\u0004.\u00065\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00042\u000eM&AB*ue&twM\u0003\u0003\u0004.\u00065D\u0003BAJ\u0007oCqaa\u0016W\u0001\u0004\ty\n\u0006\u0003\u0002\u0014\u000em\u0006bBBE/\u0002\u00071Q\u0018\t\u0005\u0003+\u001by,\u0003\u0003\u0004B\u0006m#A\u0002(v[\n,'O\u0001\u0007M_:<'+\u0019;j_:\fGnE\u0003Y\u0003'\u001by!\u0001\u0002oA\u0005\u0011A\r\t\u000b\u0007\u0007\u001b\u001c\tna5\u0011\u0007\r=\u0007,D\u00019\u0011\u001d\u00199&\u0018a\u0001\u0003sCqaa\u0017^\u0001\u0004\tI,A\u0006jgZ\u000bG.\u001b3DQ\u0006\u0014\u0018aC5t-\u0006d\u0017\u000e\u001a\"zi\u0016\fA\"[:WC2LGm\u00155peR\f!\"[:WC2LG-\u00138u\u0003-!w.\u001e2mKZ\u000bG.^3\u0015\u0005\r=C\u0003BAJ\u0007GDqaa)t\u0001\u0004\t\u0019\n\u0006\u0003\u0002\u0014\u000e\u001d\bbBBRi\u0002\u0007\u00111\u0013\u000b\u0005\u0003'\u001bY\u000fC\u0004\u0004$V\u0004\r!a%\u0015\t\u0005M5q\u001e\u0005\b\u0007G3\b\u0019AAJ)\u0011\t\u0019ja=\t\u000f\tu&\u00101\u0001\u0002T\u000691m\\7qCJ,G\u0003BAj\u0007sDqaa)}\u0001\u0004\t\u0019\n\u0006\u0003\u0002,\u000eu\bb\u0002B{}\u0002\u0007!q_\u0001\tQ\u0006\u001c\bnQ8eK\u0006AAo\\*ue&tw\r\u0006\u0002\u0004&\":\u0001\fb\u0002\u0005\u000e\u0011=\u0001\u0003BAW\t\u0013IA\u0001b\u0003\u0002n\t\u00012+\u001a:jC24VM]:j_:,\u0016\nR\u0001\u0006m\u0006dW/\u001a\u0010\u0002\u0001\u0005aAn\u001c8h%\u0006$\u0018n\u001c8bYR11Q\u001aC\u000b\t/A\u0001ba\u0016\u0002\u0004\u0001\u0007\u0011\u0011\u0018\u0005\t\u00077\n\u0019\u00011\u0001\u0002:\u0006Y!-[4SCRLwN\\1m)\u0019!i\u0002b\b\u0005\"A!1qZA\u0003\u0011!\u00199&!\u0016A\u0002\u0005}\u0005\u0002CB.\u0003+\u0002\r!a(\u0002\u0017I,\u0017\r\u001a*fg>dg/Z\n\u0007\u0003\u000b\t\u0019ja\u0004\u0015\r\u0011uA\u0011\u0006C\u0016\u0011!\u00199&a\u0004A\u0002\u0005}\u0005\u0002CB.\u0003\u001f\u0001\r!a(\u0015\t\u0005MEq\u0006\u0005\t\u0007G\u000bY\u00041\u0001\u0002\u0014R!\u00111\u0013C\u001a\u0011!\u0019\u0019+!\u0010A\u0002\u0005ME\u0003BAJ\toA\u0001ba)\u0002@\u0001\u0007\u00111\u0013\u000b\u0005\u0003'#Y\u0004\u0003\u0005\u0004$\u0006\u0005\u0003\u0019AAJ)\u0011\t\u0019\nb\u0010\t\u0011\tu\u0016\u0011\na\u0001\u0003'$B!a5\u0005D!A11UA'\u0001\u0004\t\u0019\n\u0006\u0003\u0002,\u0012\u001d\u0003\u0002\u0003B{\u0003\u001f\u0002\rAa>)\u0011\u0005\u0015Aq\u0001C\u0007\t\u001f\t\u0001BU1uS>t\u0017\r\u001c")
public abstract class Rational
extends ScalaNumber
implements ScalaNumericConversions,
Ordered<Rational> {
    public static Rational apply(Number number) {
        return Rational$.MODULE$.apply(number);
    }

    public static Rational apply(SafeLong safeLong) {
        return Rational$.MODULE$.apply(safeLong);
    }

    public static Rational apply(String string) {
        return Rational$.MODULE$.apply(string);
    }

    public static Rational apply(BigDecimal bigDecimal) {
        return Rational$.MODULE$.apply(bigDecimal);
    }

    public static Rational apply(double d) {
        return Rational$.MODULE$.apply(d);
    }

    public static Rational apply(float f) {
        return Rational$.MODULE$.apply(f);
    }

    public static Rational apply(BigInt bigInt) {
        return Rational$.MODULE$.apply(bigInt);
    }

    public static Rational apply(long l) {
        return Rational$.MODULE$.apply(l);
    }

    public static Rational apply(int n) {
        return Rational$.MODULE$.apply(n);
    }

    public static Rational apply(SafeLong safeLong, SafeLong safeLong2) {
        return Rational$.MODULE$.apply(safeLong, safeLong2);
    }

    public static Rational apply(long l, long l2) {
        return Rational$.MODULE$.apply(l, l2);
    }

    public static Rational apply(BigInt bigInt, BigInt bigInt2) {
        return Rational$.MODULE$.apply(bigInt, bigInt2);
    }

    public static Rational one() {
        return Rational$.MODULE$.one();
    }

    public static Rational zero() {
        return Rational$.MODULE$.zero();
    }

    public static NumberTag.LargeTag<Rational> RationalTag() {
        return Rational$.MODULE$.RationalTag();
    }

    public static RationalAlgebra RationalAlgebra() {
        return Rational$.MODULE$.RationalAlgebra();
    }

    public boolean $less(Object that) {
        return Ordered.$less$((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.$greater$((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.compareTo$((Ordered)this, (Object)that);
    }

    public char toChar() {
        return ScalaNumericAnyConversions.toChar$((ScalaNumericAnyConversions)this);
    }

    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$((ScalaNumericAnyConversions)this);
    }

    public short toShort() {
        return ScalaNumericAnyConversions.toShort$((ScalaNumericAnyConversions)this);
    }

    public int toInt() {
        return ScalaNumericAnyConversions.toInt$((ScalaNumericAnyConversions)this);
    }

    public long toLong() {
        return ScalaNumericAnyConversions.toLong$((ScalaNumericAnyConversions)this);
    }

    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$((ScalaNumericAnyConversions)this);
    }

    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$((ScalaNumericAnyConversions)this);
    }

    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$((ScalaNumericAnyConversions)this);
    }

    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$((ScalaNumericAnyConversions)this, (Object)x);
    }

    public abstract SafeLong numerator();

    public abstract SafeLong denominator();

    public abstract boolean numeratorIsValidLong();

    public abstract boolean numeratorAbsIsValidLong();

    public abstract long numeratorAsLong();

    public abstract boolean denominatorIsValidLong();

    public abstract boolean denominatorAbsIsValidLong();

    public abstract long denominatorAsLong();

    public abstract boolean isValidLong();

    public abstract boolean isWhole();

    public long longValue() {
        return this.toBigInt().longValue();
    }

    public int intValue() {
        return Predef$.MODULE$.long2Long(this.longValue()).intValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public Object underlying() {
        return this;
    }

    public Rational abs() {
        return this.signum() < 0 ? this.unary_$minus() : this;
    }

    public Rational inverse() {
        return this.reciprocal();
    }

    public abstract Rational reciprocal();

    public abstract int signum();

    public abstract boolean isZero();

    public abstract boolean isOne();

    public abstract Rational unary_$minus();

    public abstract Rational $plus(Rational var1);

    public abstract Rational $minus(Rational var1);

    public abstract Rational $times(Rational var1);

    public abstract Rational $div(Rational var1);

    public Rational $percent(Rational rhs) {
        return Rational$.MODULE$.zero();
    }

    public Rational tquot(Rational rhs) {
        return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.$div(rhs).toBigInt()), SafeLong$.MODULE$.one());
    }

    public Rational tmod(Rational rhs) {
        return this.$minus(this.tquot(rhs).$times(rhs));
    }

    public Tuple2<Rational, Rational> tquotmod(Rational rhs) {
        Rational q = this.tquot(rhs);
        return new Tuple2((Object)q, (Object)this.$minus(q.$times(rhs)));
    }

    public Rational lcm(Rational rhs) {
        return this.isZero() || rhs.isZero() ? Rational$.MODULE$.zero() : this.$div(this.gcd(rhs)).$times(rhs);
    }

    public Rational gcd(Rational rhs) {
        Rational rational;
        if (this.isZero()) {
            rational = rhs.abs();
        } else if (rhs.isZero()) {
            rational = this.abs();
        } else if (this.isOne() && rhs.isOne()) {
            rational = this;
        } else {
            LongRef newNumAsLong = LongRef.create((long)0L);
            ObjectRef newNumAsSafeLong = ObjectRef.create((Object)((Object)((SafeLong)((Object)Opt$.MODULE$.empty()))));
            if (this.numeratorAbsIsValidLong() && rhs.numeratorAbsIsValidLong()) {
                newNumAsLong.elem = package$.MODULE$.gcd(this.numeratorAsLong(), rhs.numeratorAsLong());
            } else {
                SafeLong newNum = this.numerator().gcd(rhs.numerator());
                if (newNum.isValidLong()) {
                    newNumAsLong.elem = newNum.toLong();
                } else {
                    newNumAsSafeLong.elem = (SafeLong)((Object)Opt$.MODULE$.apply((Object)newNum));
                }
            }
            if (this.denominatorAbsIsValidLong() && rhs.denominatorAbsIsValidLong()) {
                long ld = this.denominatorAsLong();
                long rd = rhs.denominatorAsLong();
                long dengcd = package$.MODULE$.gcd(ld, rd);
                long tmp = ld / dengcd;
                rational = Rational.checked$attempt$macro$1$1(tmp, rd, newNumAsSafeLong, newNumAsLong);
            } else {
                Rational rational2;
                SafeLong newDenAsSafeLong = this.denominator().lcm(rhs.denominator());
                SafeLong safeLong = (SafeLong)((Object)newNumAsSafeLong.elem);
                SafeLong safeLong2 = (SafeLong)((Object)Opt$.MODULE$.unapply((Object)safeLong));
                if (!Opt$.MODULE$.isEmpty$extension((Object)safeLong2)) {
                    SafeLong sl = (SafeLong)((Object)Opt$.MODULE$.get$extension((Object)safeLong2));
                    rational2 = Rational$.MODULE$.apply(sl, newDenAsSafeLong);
                } else {
                    rational2 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(newNumAsLong.elem), newDenAsSafeLong);
                }
                rational = rational2;
            }
        }
        return rational;
    }

    public Real toReal() {
        return Real$.MODULE$.apply(this);
    }

    public Algebraic toAlgebraic() {
        return Algebraic$.MODULE$.apply(this);
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode mode) {
        java.math.BigDecimal n = new java.math.BigDecimal(this.numerator().toBigInteger());
        java.math.BigDecimal d = new java.math.BigDecimal(this.denominator().toBigInteger());
        return scala.package$.MODULE$.BigDecimal().apply(n.divide(d, scale, mode));
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        java.math.BigDecimal n = new java.math.BigDecimal(this.numerator().toBigInteger());
        java.math.BigDecimal d = new java.math.BigDecimal(this.denominator().toBigInteger());
        return scala.package$.MODULE$.BigDecimal().apply(n.divide(d, mc));
    }

    public abstract SafeLong toSafeLong();

    public final BigInt toBigInt() {
        return this.toSafeLong().toBigInt();
    }

    public short shortValue() {
        return (short)this.longValue();
    }

    public byte byteValue() {
        return (byte)this.longValue();
    }

    public abstract Rational floor();

    public abstract Rational ceil();

    public abstract Rational round();

    public Rational roundTo(SafeLong denom) {
        return this.$times(Rational$.MODULE$.apply(denom)).round().$div(Rational$.MODULE$.apply(denom));
    }

    public abstract Rational pow(int var1);

    public Sign sign() {
        return Sign$.MODULE$.apply(this.signum());
    }

    public abstract int compareToOne();

    public Rational min(Rational rhs) {
        return this.compare((Object)rhs) < 0 ? this : rhs;
    }

    public Rational max(Rational rhs) {
        return this.compare((Object)rhs) > 0 ? this : rhs;
    }

    public Rational limitToInt() {
        return this.signum() < 0 ? this.unary_$minus().limitTo(SafeLong$.MODULE$.apply(Rational$.MODULE$.Two31m0())).unary_$minus() : this.limitTo(SafeLong$.MODULE$.apply(Rational$.MODULE$.Two31m1()));
    }

    public Rational limitToLong() {
        return this.signum() < 0 ? this.unary_$minus().limitTo(SafeLong$.MODULE$.apply(Rational$.MODULE$.Two63m0())).unary_$minus() : this.limitTo(SafeLong$.MODULE$.apply(Rational$.MODULE$.Two63m1()));
    }

    public Rational limitTo(SafeLong max) {
        Rational rational;
        if (this.signum() < 0) {
            rational = this.unary_$minus().limitTo(max).unary_$minus();
        } else {
            BigInt floor;
            Predef$.MODULE$.require(max.signum() > 0, (Function0 & Serializable & scala.Serializable)() -> "Limit must be a positive integer.");
            SafeLong floor2 = SafeLong$.MODULE$.apply(this.toBigInt());
            rational = floor2.$greater$eq((Object)max) ? Rational$.MODULE$.apply(max) : (floor2.$greater$eq((Object)max.$greater$greater(1)) ? Rational$.MODULE$.apply(floor2.toLong()) : (this.compareToOne() < 0 ? this.limitDenominatorTo(max) : (SafeLong$.MODULE$.apply(floor = this.toBigInt()).$greater$eq((Object)max) ? Rational$.MODULE$.apply(max) : (SafeLong$.MODULE$.apply(floor).$greater$eq((Object)max.$greater$greater(1)) ? Rational$.MODULE$.apply(floor.toLong()) : (this.compareToOne() < 0 ? this.limitDenominatorTo(max) : this.limitDenominatorTo(max.$times(this.denominator()).$div(this.numerator())))))));
        }
        return rational;
    }

    public Rational limitDenominatorTo(SafeLong limit) {
        Rational rational;
        Predef$.MODULE$.require(limit.signum() > 0, (Function0 & Serializable & scala.Serializable)() -> "Cannot limit denominator to non-positive number.");
        Sign sign = this.sign();
        if (Sign$Zero$.MODULE$.equals(sign)) {
            rational = this;
        } else if (Sign$Positive$.MODULE$.equals(sign)) {
            rational = this.closest$1(Rational$.MODULE$.apply(this.toBigInt()), new LongRational(1L, 0L), (SafeLong)((Object)Opt$.MODULE$.empty()), (SafeLong)((Object)Opt$.MODULE$.empty()), limit);
        } else if (Sign$Negative$.MODULE$.equals(sign)) {
            rational = this.closest$1(new LongRational(-1L, 0L), Rational$.MODULE$.apply(this.toBigInt()), (SafeLong)((Object)Opt$.MODULE$.empty()), (SafeLong)((Object)Opt$.MODULE$.empty()), limit);
        } else {
            throw new MatchError((Object)sign);
        }
        return rational;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof Real) {
            Real real = (Real)object;
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)real.toRational()))) return false;
            return true;
        }
        if (object instanceof Algebraic) {
            Algebraic algebraic = (Algebraic)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)algebraic), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            if (!this.isWhole()) return false;
            BigInt bigInt2 = this.toBigInt();
            BigInt bigInt3 = bigInt;
            if (bigInt2 != null) {
                if (!bigInt2.equals(bigInt3)) return false;
                return true;
            }
            if (bigInt3 == null) return true;
            return false;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            try {
                BigDecimal bigDecimal2 = this.toBigDecimal(bigDecimal.mc());
                BigDecimal bigDecimal3 = bigDecimal;
                if (bigDecimal2 != null) {
                    if (!bigDecimal2.equals(bigDecimal3)) return false;
                    return true;
                }
                if (bigDecimal3 == null) return true;
                return false;
            }
            catch (ArithmeticException ae) {
                return false;
            }
        }
        if (object instanceof SafeLong) {
            SafeLong safeLong = (SafeLong)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)SafeLong$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)safeLong))) return false;
            return true;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            Number number2 = Number$.MODULE$.apply(this);
            Number number3 = number;
            if (number2 != null) {
                if (!number2.equals(number3)) return false;
                return true;
            }
            if (number3 == null) return true;
            return false;
        }
        if (object instanceof Natural) {
            Natural natural = (Natural)((Object)object);
            if (!this.isWhole()) return false;
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)Rational$.MODULE$.apply(natural.toBigInt())))) return false;
            return true;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)complex), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)((Object)object);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)quaternion), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (!(object instanceof Long)) return this.unifiedPrimitiveEquals(object);
        long l = BoxesRunTime.unboxToLong((Object)object);
        if (!this.isValidLong()) return false;
        if (this.toLong() != l) return false;
        return true;
    }

    private static final Rational checked$fallback$macro$2$1(long tmp$1, long rd$1, ObjectRef newNumAsSafeLong$1, LongRef newNumAsLong$1) {
        SafeLong newDenAsSafeLong = SafeLong$.MODULE$.apply(tmp$1).$times(rd$1);
        return Opt$.MODULE$.isEmpty$extension((Object)((SafeLong)((Object)newNumAsSafeLong$1.elem))) ? Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(newNumAsLong$1.elem), newDenAsSafeLong) : Rational$.MODULE$.apply((SafeLong)((Object)Opt$.MODULE$.get$extension((Object)((SafeLong)((Object)newNumAsSafeLong$1.elem)))), newDenAsSafeLong);
    }

    private static final Rational checked$attempt$macro$1$1(long tmp$1, long rd$1, ObjectRef newNumAsSafeLong$1, LongRef newNumAsLong$1) {
        long z$macro$3 = tmp$1 * rd$1;
        if (tmp$1 != 0L && (rd$1 != z$macro$3 / tmp$1 || tmp$1 == -1L && rd$1 == Long.MIN_VALUE)) {
            return Rational.checked$fallback$macro$2$1(tmp$1, rd$1, newNumAsSafeLong$1, newNumAsLong$1);
        }
        long newDenAsLong = z$macro$3;
        return Opt$.MODULE$.isEmpty$extension((Object)((SafeLong)((Object)newNumAsSafeLong$1.elem))) ? Rational$.MODULE$.apply(newNumAsLong$1.elem, newDenAsLong) : Rational$.MODULE$.apply((SafeLong)((Object)Opt$.MODULE$.get$extension((Object)((SafeLong)((Object)newNumAsSafeLong$1.elem)))), SafeLong$.MODULE$.apply(newDenAsLong));
    }

    private static final SafeLong nextK$1(SafeLong curr) {
        return Opt$.MODULE$.isEmpty$extension((Object)curr) ? (SafeLong)((Object)Opt$.MODULE$.apply((Object)SafeLong$.MODULE$.apply(2L))) : (SafeLong)((Object)Opt$.MODULE$.apply((Object)((SafeLong)((Object)Opt$.MODULE$.get$extension((Object)curr))).$times(2L)));
    }

    /*
     * Unable to fully structure code
     */
    private final Rational closest$1(Rational l, Rational u, SafeLong lk, SafeLong rk, SafeLong limit$1) {
        while (true) {
            block9: {
                block8: {
                    if ((var9_8 = new Tuple2.mcZZ.sp(Opt$.MODULE$.nonEmpty$extension((Object)lk), Opt$.MODULE$.nonEmpty$extension((Object)rk))) == null) break block8;
                    var10_9 = var9_8._1$mcZ$sp();
                    var11_10 = var9_8._2$mcZ$sp();
                    if (!var10_9 || var11_10) break block8;
                    var7_6 = Rational$.MODULE$.apply(((SafeLong)Opt$.MODULE$.get$extension((Object)lk)).$times(l.numerator()).$plus(u.numerator()), ((SafeLong)Opt$.MODULE$.get$extension((Object)lk)).$times(l.denominator()).$plus(u.denominator()));
                    break block9;
                }
                if (var9_8 == null) ** GOTO lbl-1000
                var12_11 = var9_8._1$mcZ$sp();
                var13_12 = var9_8._2$mcZ$sp();
                if (!var12_11 && var13_12) {
                    var7_6 = Rational$.MODULE$.apply(l.numerator().$plus(((SafeLong)Opt$.MODULE$.get$extension((Object)rk)).$times(u.numerator())), l.denominator().$plus(((SafeLong)Opt$.MODULE$.get$extension((Object)rk)).$times(u.denominator())));
                } else lbl-1000:
                // 2 sources

                {
                    var7_6 = Rational$.MODULE$.apply(l.numerator().$plus(u.numerator()), l.denominator().$plus(u.denominator()));
                }
            }
            mediant = var7_6;
            if (mediant.denominator().$greater((Object)limit$1)) {
                if (Opt$.MODULE$.nonEmpty$extension((Object)lk) || Opt$.MODULE$.nonEmpty$extension((Object)rk)) {
                    rk = (SafeLong)Opt$.MODULE$.empty();
                    lk = (SafeLong)Opt$.MODULE$.empty();
                    continue;
                }
                if (this.$minus(l).abs().$greater((Object)u.$minus(this).abs())) {
                    v0 = u;
                    break;
                }
                v0 = l;
                break;
            }
            if (BoxesRunTime.equalsNumNum((java.lang.Number)mediant, (java.lang.Number)this)) {
                v0 = mediant;
                break;
            }
            if (mediant.$less((Object)this)) {
                rk = Rational.nextK$1(rk);
                lk = (SafeLong)Opt$.MODULE$.empty();
                l = mediant;
                continue;
            }
            rk = (SafeLong)Opt$.MODULE$.empty();
            lk = Rational.nextK$1(lk);
            u = mediant;
        }
        return v0;
    }

    public Rational() {
        ScalaNumericAnyConversions.$init$((ScalaNumericAnyConversions)this);
        Ordered.$init$((Ordered)this);
    }

    public static final class BigRational
    extends Rational
    implements scala.Serializable {
        public static final long serialVersionUID = 0L;
        private final SafeLong n;
        private final SafeLong d;

        public SafeLong n() {
            return this.n;
        }

        public SafeLong d() {
            return this.d;
        }

        @Override
        public SafeLong numerator() {
            return this.n();
        }

        @Override
        public SafeLong denominator() {
            return this.d();
        }

        @Override
        public long numeratorAsLong() {
            return this.n().toLong();
        }

        @Override
        public boolean numeratorIsValidLong() {
            return this.n().isValidLong();
        }

        @Override
        public boolean numeratorAbsIsValidLong() {
            return this.n().isValidLong() && this.n().toLong() != Long.MIN_VALUE;
        }

        @Override
        public long denominatorAsLong() {
            return this.d().toLong();
        }

        @Override
        public boolean denominatorIsValidLong() {
            return this.d().isValidLong();
        }

        @Override
        public boolean denominatorAbsIsValidLong() {
            return this.d().isValidLong() && this.d().toLong() != Long.MIN_VALUE;
        }

        @Override
        public Rational reciprocal() {
            return this.signum() < 0 ? Rational$.MODULE$.apply(this.d().unary_$minus(), this.n().unary_$minus()) : Rational$.MODULE$.spire$math$Rational$$bigRational(this.d(), this.n());
        }

        @Override
        public int signum() {
            return this.n().signum();
        }

        @Override
        public boolean isWhole() {
            return this.d().isOne();
        }

        @Override
        public boolean isZero() {
            return false;
        }

        @Override
        public boolean isOne() {
            return false;
        }

        @Override
        public boolean isValidChar() {
            return false;
        }

        @Override
        public boolean isValidByte() {
            return false;
        }

        @Override
        public boolean isValidShort() {
            return false;
        }

        @Override
        public boolean isValidInt() {
            return false;
        }

        @Override
        public boolean isValidLong() {
            return false;
        }

        @Override
        public SafeLong toSafeLong() {
            return this.n().$div(this.d());
        }

        public double doubleValue() {
            return Rational$.MODULE$.toDouble(this.n(), this.d());
        }

        @Override
        public Rational unary_$minus() {
            return Rational$.MODULE$.apply(this.n().unary_$minus(), this.d());
        }

        @Override
        public Rational $plus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.$plus(this);
            } else if (rational2 instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)rational2;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational3 = Rational$.MODULE$.apply(bigRational.d().$times(this.n()).$plus(bigRational.n().$times(this.d())), bigRational.d().$times(this.d()));
                } else {
                    SafeLong lden = this.d().$div(dgcd);
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$plus(bigRational.n().$times(lden));
                    SafeLong ngcd = num.gcd(dgcd);
                    rational3 = ngcd.isOne() ? Rational$.MODULE$.apply(num, lden.$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $minus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.unary_$minus().$plus(this);
            } else if (rational2 instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)rational2;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational3 = Rational$.MODULE$.apply(bigRational.d().$times(this.n()).$minus(bigRational.n().$times(this.d())), bigRational.d().$times(this.d()));
                } else {
                    SafeLong lden = this.d().$div(dgcd);
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$minus(bigRational.n().$times(lden));
                    SafeLong ngcd = num.gcd(dgcd);
                    rational3 = ngcd.isOne() ? Rational$.MODULE$.apply(num, lden.$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $times(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.$times(this);
            } else if (rational2 instanceof BigRational) {
                BigRational bigRational = (BigRational)rational2;
                SafeLong a = this.n().gcd(bigRational.d());
                SafeLong b = this.d().gcd(bigRational.n());
                rational = Rational$.MODULE$.apply(this.n().$div(a).$times(bigRational.n().$div(b)), this.d().$div(b).$times(bigRational.d().$div(a)));
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $div(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                rational = longRational.inverse().$times(this);
            } else if (rational2 instanceof BigRational) {
                BigRational bigRational = (BigRational)rational2;
                SafeLong a = this.n().gcd(bigRational.n());
                SafeLong b = this.d().gcd(bigRational.d());
                SafeLong num = this.n().$div(a).$times(bigRational.d().$div(b));
                SafeLong den = this.d().$div(b).$times(bigRational.n().$div(a));
                rational = den.signum() < 0 ? Rational$.MODULE$.apply(num.unary_$minus(), den.unary_$minus()) : Rational$.MODULE$.apply(num, den);
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational floor() {
            return this.isWhole() ? this : (this.n().signum() >= 0 ? Rational$.MODULE$.apply(this.n().$div(this.d()), SafeLong$.MODULE$.one()) : Rational$.MODULE$.apply(this.n().$div(this.d()).$minus(1L), SafeLong$.MODULE$.one()));
        }

        @Override
        public Rational ceil() {
            return this.isWhole() ? this : (this.n().signum() >= 0 ? Rational$.MODULE$.apply(this.n().$div(this.d()).$plus(1L), SafeLong$.MODULE$.one()) : Rational$.MODULE$.apply(this.n().$div(this.d()), SafeLong$.MODULE$.one()));
        }

        @Override
        public Rational round() {
            SafeLong m;
            SafeLong m2;
            Rational rational = this.n().signum() >= 0 ? ((m2 = this.n().$percent(this.d())).$greater$eq((Object)this.d().$minus(m2)) ? Rational$.MODULE$.apply(this.n().$div(this.d()).$plus(1L)) : Rational$.MODULE$.apply(this.n().$div(this.d()))) : ((m = this.n().$percent(this.d()).unary_$minus()).$greater$eq((Object)this.d().$minus(m)) ? Rational$.MODULE$.apply(this.n().$div(this.d()).$minus(1L)) : Rational$.MODULE$.apply(this.n().$div(this.d())));
            return rational;
        }

        @Override
        public Rational pow(int exp) {
            return exp == 0 ? Rational$.MODULE$.one() : (exp < 0 ? Rational$.MODULE$.apply(this.d().pow(-exp), this.n().pow(-exp)) : Rational$.MODULE$.apply(this.n().pow(exp), this.d().pow(exp)));
        }

        @Override
        public int compareToOne() {
            return this.n().compare((Object)this.d());
        }

        public int compare(Rational r) {
            int n;
            Rational rational = r;
            if (rational instanceof LongRational) {
                LongRational longRational = (LongRational)rational;
                long dgcd = package$.MODULE$.gcd(longRational.d(), this.d().$percent(longRational.d()).toLong());
                n = dgcd == 1L ? this.n().$times(longRational.d()).compare((Object)SafeLong$.MODULE$.apply(longRational.n()).$times(this.d())) : this.n().$times(longRational.d() / dgcd).compare((Object)SafeLong$.MODULE$.apply(longRational.n()).$times(this.d().$div(dgcd)));
            } else if (rational instanceof BigRational) {
                BigRational bigRational = (BigRational)rational;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                n = dgcd.isOne() ? this.n().$times(bigRational.d()).compare((Object)bigRational.n().$times(this.d())) : bigRational.d().$div(dgcd).$times(this.n()).compare((Object)this.d().$div(dgcd).$times(bigRational.n()));
            } else {
                throw new MatchError((Object)rational);
            }
            return n;
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            Object object = that;
            if (object instanceof BigRational) {
                BigRational bigRational = (BigRational)((Object)object);
                bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this.n()), (java.lang.Number)((Object)bigRational.n())) && BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this.d()), (java.lang.Number)((Object)bigRational.d()));
            } else {
                bl = super.equals(that);
            }
            return bl;
        }

        public int hashCode() {
            return 29 * (37 * Statics.anyHash((Object)((Object)this.n())) + Statics.anyHash((Object)((Object)this.d())));
        }

        public String toString() {
            return this.isWhole() ? this.n().toString() : new StringBuilder(1).append((Object)this.n()).append("/").append((Object)this.d()).toString();
        }

        public BigRational(SafeLong n, SafeLong d) {
            this.n = n;
            this.d = d;
        }
    }

    public static final class LongRational
    extends Rational
    implements scala.Serializable {
        public static final long serialVersionUID = 0L;
        private final long n;
        private final long d;

        public long n() {
            return this.n;
        }

        public long d() {
            return this.d;
        }

        @Override
        public SafeLong numerator() {
            return SafeLong$.MODULE$.apply(this.n());
        }

        @Override
        public SafeLong denominator() {
            return SafeLong$.MODULE$.apply(this.d());
        }

        @Override
        public long numeratorAsLong() {
            return this.n();
        }

        @Override
        public boolean numeratorIsValidLong() {
            return true;
        }

        @Override
        public boolean numeratorAbsIsValidLong() {
            return this.n() != Long.MIN_VALUE;
        }

        @Override
        public long denominatorAsLong() {
            return this.d();
        }

        @Override
        public boolean denominatorIsValidLong() {
            return true;
        }

        @Override
        public boolean denominatorAbsIsValidLong() {
            return this.d() != Long.MIN_VALUE;
        }

        @Override
        public Rational reciprocal() {
            if (this.n() == 0L) {
                throw new ArithmeticException("reciprocal called on 0/1");
            }
            return this.n() > 0L ? Rational$.MODULE$.spire$math$Rational$$longRational(this.d(), this.n()) : (this.n() == Long.MIN_VALUE || this.d() == Long.MIN_VALUE ? Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(this.d()).unary_$minus(), SafeLong$.MODULE$.apply(this.n()).unary_$minus()) : Rational$.MODULE$.spire$math$Rational$$longRational(-this.d(), -this.n()));
        }

        @Override
        public int signum() {
            return Long.signum(this.n());
        }

        @Override
        public boolean isWhole() {
            return this.d() == 1L;
        }

        @Override
        public boolean isZero() {
            return this.n() == 0L;
        }

        @Override
        public boolean isOne() {
            return this.d() == 1L && this.n() == 1L;
        }

        @Override
        public boolean isValidChar() {
            return this.isWhole() && RichLong$.MODULE$.isValidChar$extension(this.n());
        }

        @Override
        public boolean isValidByte() {
            return this.isWhole() && RichLong$.MODULE$.isValidByte$extension(this.n());
        }

        @Override
        public boolean isValidShort() {
            return this.isWhole() && RichLong$.MODULE$.isValidShort$extension(this.n());
        }

        @Override
        public boolean isValidInt() {
            return this.isWhole() && RichLong$.MODULE$.isValidInt$extension(this.n());
        }

        @Override
        public boolean isValidLong() {
            return this.isWhole();
        }

        @Override
        public SafeLong toSafeLong() {
            return SafeLong$.MODULE$.apply(this.n() / this.d());
        }

        public double doubleValue() {
            return Rational$.MODULE$.toDouble(SafeLong$.MODULE$.apply(this.n()), SafeLong$.MODULE$.apply(this.d()));
        }

        @Override
        public Rational unary_$minus() {
            return this.n() == Long.MIN_VALUE ? Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.safe64(), SafeLong$.MODULE$.apply(this.d())) : Rational$.MODULE$.spire$math$Rational$$longRational(-this.n(), this.d());
        }

        @Override
        public Rational $plus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                Rational rational3;
                LongRational longRational = (LongRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                if (dgcd == 1L) {
                    long x$macro$6 = this.n();
                    long y$macro$7 = longRational.d();
                    long z$macro$5 = x$macro$6 * y$macro$7;
                    if (x$macro$6 != 0L && (y$macro$7 != z$macro$5 / x$macro$6 || x$macro$6 == -1L && y$macro$7 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$1$2(longRational);
                    }
                    long x$macro$3 = z$macro$5;
                    long x$macro$9 = longRational.n();
                    long y$macro$10 = this.d();
                    long z$macro$8 = x$macro$9 * y$macro$10;
                    if (x$macro$9 != 0L && (y$macro$10 != z$macro$8 / x$macro$9 || x$macro$9 == -1L && y$macro$10 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$1$2(longRational);
                    }
                    long y$macro$4 = z$macro$8;
                    long z$macro$2 = x$macro$3 + y$macro$4;
                    if (((x$macro$3 ^ y$macro$4 ^ 0xFFFFFFFFFFFFFFFFL) & (x$macro$3 ^ z$macro$2)) < 0L) {
                        return this.checked$fallback$macro$1$2(longRational);
                    }
                    long x$macro$12 = this.d();
                    long y$macro$13 = longRational.d();
                    long z$macro$11 = x$macro$12 * y$macro$13;
                    if (x$macro$12 != 0L && (y$macro$13 != z$macro$11 / x$macro$12 || x$macro$12 == -1L && y$macro$13 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$1$2(longRational);
                    }
                    rational3 = Rational$.MODULE$.apply(z$macro$2, z$macro$11);
                } else {
                    long lden = this.d() / dgcd;
                    long rden = longRational.d() / dgcd;
                    long x$macro$19 = this.n();
                    long z$macro$18 = x$macro$19 * rden;
                    if (x$macro$19 != 0L && (rden != z$macro$18 / x$macro$19 || x$macro$19 == -1L && rden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$14$1(rden, longRational, lden, dgcd);
                    }
                    long x$macro$16 = z$macro$18;
                    long x$macro$21 = longRational.n();
                    long z$macro$20 = x$macro$21 * lden;
                    if (x$macro$21 != 0L && (lden != z$macro$20 / x$macro$21 || x$macro$21 == -1L && lden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$14$1(rden, longRational, lden, dgcd);
                    }
                    long y$macro$17 = z$macro$20;
                    long z$macro$15 = x$macro$16 + y$macro$17;
                    if (((x$macro$16 ^ y$macro$17 ^ 0xFFFFFFFFFFFFFFFFL) & (x$macro$16 ^ z$macro$15)) < 0L) {
                        return this.checked$fallback$macro$14$1(rden, longRational, lden, dgcd);
                    }
                    long num = z$macro$15;
                    long ngcd = package$.MODULE$.gcd(num, dgcd);
                    if (ngcd == 1L) {
                        long y$macro$23 = longRational.d();
                        long z$macro$22 = lden * y$macro$23;
                        if (lden != 0L && (y$macro$23 != z$macro$22 / lden || lden == -1L && y$macro$23 == Long.MIN_VALUE)) {
                            return this.checked$fallback$macro$14$1(rden, longRational, lden, dgcd);
                        }
                        rational3 = Rational$.MODULE$.apply(num, z$macro$22);
                    } else {
                        rational3 = Rational$.MODULE$.buildWithDiv(num, ngcd, longRational.d(), lden);
                    }
                }
                rational = rational3;
            } else if (rational2 instanceof BigRational) {
                Rational rational4;
                BigRational bigRational = (BigRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    SafeLong num = bigRational.d().$times(this.n()).$plus(bigRational.n().$times(this.d()));
                    SafeLong den = bigRational.d().$times(this.d());
                    rational4 = Rational$.MODULE$.apply(num, den);
                } else {
                    long l;
                    long lden = this.d() / dgcd;
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$plus(bigRational.n().$times(lden));
                    SafeLong safeLong = num;
                    if (safeLong instanceof SafeLongLong) {
                        SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                        long x = safeLongLong.x();
                        l = package$.MODULE$.gcd(x, dgcd);
                    } else if (safeLong instanceof SafeLongBigInteger) {
                        SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                        BigInteger x = safeLongBigInteger.x();
                        l = package$.MODULE$.gcd(dgcd, x.mod(BigInteger.valueOf(dgcd)).longValue());
                    } else {
                        throw new MatchError((Object)safeLong);
                    }
                    long ngcd = l;
                    rational4 = ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden).$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational4;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $minus(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                Rational rational3;
                LongRational longRational = (LongRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                if (dgcd == 1L) {
                    long x$macro$6 = this.n();
                    long y$macro$7 = longRational.d();
                    long z$macro$5 = x$macro$6 * y$macro$7;
                    if (x$macro$6 != 0L && (y$macro$7 != z$macro$5 / x$macro$6 || x$macro$6 == -1L && y$macro$7 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$1$3(longRational);
                    }
                    long x$macro$3 = z$macro$5;
                    long x$macro$9 = longRational.n();
                    long y$macro$10 = this.d();
                    long z$macro$8 = x$macro$9 * y$macro$10;
                    if (x$macro$9 != 0L && (y$macro$10 != z$macro$8 / x$macro$9 || x$macro$9 == -1L && y$macro$10 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$1$3(longRational);
                    }
                    long y$macro$4 = z$macro$8;
                    long z$macro$2 = x$macro$3 - y$macro$4;
                    if (((x$macro$3 ^ y$macro$4) & (x$macro$3 ^ z$macro$2)) < 0L) {
                        return this.checked$fallback$macro$1$3(longRational);
                    }
                    long x$macro$12 = this.d();
                    long y$macro$13 = longRational.d();
                    long z$macro$11 = x$macro$12 * y$macro$13;
                    if (x$macro$12 != 0L && (y$macro$13 != z$macro$11 / x$macro$12 || x$macro$12 == -1L && y$macro$13 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$1$3(longRational);
                    }
                    rational3 = Rational$.MODULE$.apply(z$macro$2, z$macro$11);
                } else {
                    long lden = this.d() / dgcd;
                    long rden = longRational.d() / dgcd;
                    long x$macro$19 = this.n();
                    long z$macro$18 = x$macro$19 * rden;
                    if (x$macro$19 != 0L && (rden != z$macro$18 / x$macro$19 || x$macro$19 == -1L && rden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$14$2(rden, longRational, lden, dgcd);
                    }
                    long x$macro$16 = z$macro$18;
                    long x$macro$21 = longRational.n();
                    long z$macro$20 = x$macro$21 * lden;
                    if (x$macro$21 != 0L && (lden != z$macro$20 / x$macro$21 || x$macro$21 == -1L && lden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$14$2(rden, longRational, lden, dgcd);
                    }
                    long y$macro$17 = z$macro$20;
                    long z$macro$15 = x$macro$16 - y$macro$17;
                    if (((x$macro$16 ^ y$macro$17) & (x$macro$16 ^ z$macro$15)) < 0L) {
                        return this.checked$fallback$macro$14$2(rden, longRational, lden, dgcd);
                    }
                    long num = z$macro$15;
                    long ngcd = package$.MODULE$.gcd(num, dgcd);
                    if (ngcd == 1L) {
                        long y$macro$23 = longRational.d();
                        long z$macro$22 = lden * y$macro$23;
                        if (lden != 0L && (y$macro$23 != z$macro$22 / lden || lden == -1L && y$macro$23 == Long.MIN_VALUE)) {
                            return this.checked$fallback$macro$14$2(rden, longRational, lden, dgcd);
                        }
                        rational3 = Rational$.MODULE$.apply(num, z$macro$22);
                    } else {
                        rational3 = Rational$.MODULE$.buildWithDiv(num, ngcd, longRational.d(), lden);
                    }
                }
                rational = rational3;
            } else if (rational2 instanceof BigRational) {
                Rational rational4;
                BigRational bigRational = (BigRational)rational2;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    SafeLong num = bigRational.d().$times(this.n()).$minus(bigRational.n().$times(this.d()));
                    SafeLong den = bigRational.d().$times(this.d());
                    rational4 = Rational$.MODULE$.apply(num, den);
                } else {
                    long l;
                    long lden = this.d() / dgcd;
                    SafeLong rden = bigRational.d().$div(dgcd);
                    SafeLong num = rden.$times(this.n()).$minus(bigRational.n().$times(lden));
                    SafeLong safeLong = num;
                    if (safeLong instanceof SafeLongLong) {
                        SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                        long x = safeLongLong.x();
                        l = package$.MODULE$.gcd(x, dgcd);
                    } else if (safeLong instanceof SafeLongBigInteger) {
                        SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                        BigInteger x = safeLongBigInteger.x();
                        l = package$.MODULE$.gcd(dgcd, x.mod(BigInteger.valueOf(dgcd)).longValue());
                    } else {
                        throw new MatchError((Object)safeLong);
                    }
                    long ngcd = l;
                    rational4 = ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden).$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational4;
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational $times(Rational r) {
            Rational rational;
            if (this.n() == 0L) {
                rational = Rational$.MODULE$.zero();
            } else {
                Rational rational2;
                Rational rational3 = r;
                if (rational3 instanceof LongRational) {
                    LongRational longRational = (LongRational)rational3;
                    long a = package$.MODULE$.gcd(this.n(), longRational.d());
                    long b = package$.MODULE$.gcd(this.d(), longRational.n());
                    long n1 = this.n() / a;
                    long n2 = longRational.n() / b;
                    long d1 = this.d() / b;
                    long d2 = longRational.d() / a;
                    long z$macro$2 = n1 * n2;
                    if (n1 != 0L && (n2 != z$macro$2 / n1 || n1 == -1L && n2 == Long.MIN_VALUE)) {
                        return LongRational.checked$fallback$macro$1$4(n1, n2, d1, d2);
                    }
                    long z$macro$3 = d1 * d2;
                    if (d1 != 0L && (d2 != z$macro$3 / d1 || d1 == -1L && d2 == Long.MIN_VALUE)) {
                        return LongRational.checked$fallback$macro$1$4(n1, n2, d1, d2);
                    }
                    rational2 = Rational$.MODULE$.spire$math$Rational$$longRational(z$macro$2, z$macro$3);
                } else if (rational3 instanceof BigRational) {
                    BigRational bigRational = (BigRational)rational3;
                    long a = package$.MODULE$.gcd(this.n(), bigRational.d().$percent(this.n()).toLong());
                    long b = package$.MODULE$.gcd(this.d(), bigRational.n().$percent(this.d()).toLong());
                    rational2 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n() / a).$times(bigRational.n().$div(b)), SafeLong$.MODULE$.apply(this.d() / b).$times(bigRational.d().$div(a)));
                } else {
                    throw new MatchError((Object)rational3);
                }
                rational = rational2;
            }
            return rational;
        }

        @Override
        public Rational $div(Rational r) {
            Rational rational;
            Rational rational2 = r;
            if (rational2 instanceof LongRational) {
                LongRational longRational = (LongRational)rational2;
                if (longRational.n() == 0L) {
                    throw new ArithmeticException("divide (/) by 0");
                }
                if (this.n() == 0L) {
                    return this;
                }
                long a = package$.MODULE$.gcd(this.n(), longRational.n());
                long b = package$.MODULE$.gcd(this.d(), longRational.d());
                long n1 = this.n() / a;
                long n2 = longRational.n() / a;
                LongRef d1 = LongRef.create((long)(this.d() / b));
                LongRef d2 = LongRef.create((long)(longRational.d() / b));
                if (n2 < 0L) {
                    d1.elem = -d1.elem;
                    d2.elem = -d2.elem;
                }
                long z$macro$2 = n1 * d2.elem;
                if (n1 != 0L && (d2.elem != z$macro$2 / n1 || n1 == -1L && d2.elem == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$1$5(n1, d2, d1, n2);
                }
                long z$macro$3 = d1.elem * n2;
                if (d1.elem != 0L && (n2 != z$macro$3 / d1.elem || d1.elem == -1L && n2 == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$1$5(n1, d2, d1, n2);
                }
                rational = Rational$.MODULE$.spire$math$Rational$$longRational(z$macro$2, z$macro$3);
            } else if (rational2 instanceof BigRational) {
                BigRational bigRational = (BigRational)rational2;
                if (this.n() == 0L) {
                    return this;
                }
                long a = package$.MODULE$.gcd(this.n(), bigRational.n().$percent(this.n()).toLong());
                long b = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                SafeLong num = SafeLong$.MODULE$.apply(this.n() / a).$times(bigRational.d().$div(b));
                SafeLong den = SafeLong$.MODULE$.apply(this.d() / b).$times(bigRational.n().$div(a));
                rational = den.signum() < 0 ? Rational$.MODULE$.apply(num.unary_$minus(), den.unary_$minus()) : Rational$.MODULE$.apply(num, den);
            } else {
                throw new MatchError((Object)rational2);
            }
            return rational;
        }

        @Override
        public Rational floor() {
            return this.d() == 1L ? this : (this.n() >= 0L ? Rational$.MODULE$.apply(this.n() / this.d(), 1L) : Rational$.MODULE$.apply(this.n() / this.d() - 1L, 1L));
        }

        @Override
        public Rational ceil() {
            return this.d() == 1L ? this : (this.n() >= 0L ? Rational$.MODULE$.apply(this.n() / this.d() + 1L, 1L) : Rational$.MODULE$.apply(this.n() / this.d(), 1L));
        }

        @Override
        public Rational round() {
            long m;
            long m2;
            Rational rational = this.n() >= 0L ? ((m2 = this.n() % this.d()) >= this.d() - m2 ? Rational$.MODULE$.apply(this.n() / this.d() + 1L) : Rational$.MODULE$.apply(this.n() / this.d())) : ((m = -(this.n() % this.d())) >= this.d() - m ? Rational$.MODULE$.apply(this.n() / this.d() - 1L) : Rational$.MODULE$.apply(this.n() / this.d()));
            return rational;
        }

        @Override
        public Rational pow(int exp) {
            return exp == 0 ? Rational$.MODULE$.one() : (exp < 0 ? this.reciprocal().pow(-exp) : Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).pow(exp), SafeLong$.MODULE$.apply(this.d()).pow(exp)));
        }

        @Override
        public int compareToOne() {
            return new RichLong(Predef$.MODULE$.longWrapper(this.n())).compare((Object)BoxesRunTime.boxToLong((long)this.d()));
        }

        public int compare(Rational r) {
            int n;
            Rational rational = r;
            if (rational instanceof LongRational) {
                LongRational longRational = (LongRational)rational;
                n = this.checked$attempt$macro$1$2(longRational);
            } else if (rational instanceof BigRational) {
                BigRational bigRational = (BigRational)rational;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                n = dgcd == 1L ? SafeLong$.MODULE$.apply(this.n()).$times(bigRational.d()).compare((Object)bigRational.n().$times(this.d())) : SafeLong$.MODULE$.apply(this.n()).$times(bigRational.d().$div(dgcd)).compare((Object)bigRational.n().$times(this.d() / dgcd));
            } else {
                throw new MatchError((Object)rational);
            }
            return n;
        }

        @Override
        public long longValue() {
            return this.d() == 1L ? this.n() : this.n() / this.d();
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            Object object = that;
            if (object instanceof LongRational) {
                LongRational longRational = (LongRational)((Object)object);
                bl = this.n() == longRational.n() && this.d() == longRational.d();
            } else {
                bl = super.equals(that);
            }
            return bl;
        }

        public int hashCode() {
            return this.d() == 1L ? this.unifiedPrimitiveHashcode() : 29 * (37 * Statics.longHash((long)this.n()) + Statics.longHash((long)this.d()));
        }

        public String toString() {
            return this.isWhole() ? ((Object)BoxesRunTime.boxToLong((long)this.n())).toString() : new StringBuilder(1).append(this.n()).append("/").append(this.d()).toString();
        }

        private final Rational checked$fallback$macro$1$2(LongRational x2$1) {
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).$times(x2$1.d()).$plus(SafeLong$.MODULE$.apply(x2$1.n()).$times(this.d())), SafeLong$.MODULE$.apply(this.d()).$times(x2$1.d()));
        }

        private final Rational checked$fallback$macro$14$1(long rden$1, LongRational x2$1, long lden$2, long dgcd$1) {
            SafeLong num = SafeLong$.MODULE$.apply(this.n()).$times(rden$1).$plus(SafeLong$.MODULE$.apply(x2$1.n()).$times(lden$2));
            long ngcd = package$.MODULE$.gcd(dgcd$1, num.$percent(dgcd$1).toLong());
            return ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden$2).$times(x2$1.d())) : Rational$.MODULE$.apply(num.$div(ngcd), SafeLong$.MODULE$.apply(lden$2).$times(x2$1.d() / ngcd));
        }

        private final Rational checked$fallback$macro$1$3(LongRational x2$2) {
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).$times(x2$2.d()).$minus(SafeLong$.MODULE$.apply(x2$2.n()).$times(this.d())), SafeLong$.MODULE$.apply(this.d()).$times(x2$2.d()));
        }

        private final Rational checked$fallback$macro$14$2(long rden$2, LongRational x2$2, long lden$3, long dgcd$2) {
            SafeLong num = SafeLong$.MODULE$.apply(this.n()).$times(rden$2).$minus(SafeLong$.MODULE$.apply(x2$2.n()).$times(lden$3));
            long ngcd = package$.MODULE$.gcd(dgcd$2, num.$percent(dgcd$2).toLong());
            return ngcd == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden$3).$times(x2$2.d())) : Rational$.MODULE$.apply(num.$div(ngcd), SafeLong$.MODULE$.apply(lden$3).$times(x2$2.d() / ngcd));
        }

        private static final Rational checked$fallback$macro$1$4(long n1$1, long n2$1, long d1$1, long d2$1) {
            return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(n1$1).$times(n2$1), SafeLong$.MODULE$.apply(d1$1).$times(d2$1));
        }

        private static final Rational checked$fallback$macro$1$5(long n1$2, LongRef d2$2, LongRef d1$2, long n2$2) {
            return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(n1$2).$times(d2$2.elem), SafeLong$.MODULE$.apply(d1$2.elem).$times(n2$2));
        }

        private final int checked$fallback$macro$2$2(LongRational x2$3) {
            long dgcd = package$.MODULE$.gcd(this.d(), x2$3.d());
            return dgcd == 1L ? SafeLong$.MODULE$.apply(this.n()).$times(x2$3.d()).compare((Object)SafeLong$.MODULE$.apply(x2$3.n()).$times(this.d())) : SafeLong$.MODULE$.apply(this.n()).$times(x2$3.d() / dgcd).compare((Object)SafeLong$.MODULE$.apply(x2$3.n()).$times(this.d() / dgcd));
        }

        private final int checked$attempt$macro$1$2(LongRational x2$3) {
            long x$macro$4 = this.n();
            long y$macro$5 = x2$3.d();
            long z$macro$3 = x$macro$4 * y$macro$5;
            if (x$macro$4 != 0L && (y$macro$5 != z$macro$3 / x$macro$4 || x$macro$4 == -1L && y$macro$5 == Long.MIN_VALUE)) {
                return this.checked$fallback$macro$2$2(x2$3);
            }
            long x$macro$7 = x2$3.n();
            long y$macro$8 = this.d();
            long z$macro$6 = x$macro$7 * y$macro$8;
            if (x$macro$7 != 0L && (y$macro$8 != z$macro$6 / x$macro$7 || x$macro$7 == -1L && y$macro$8 == Long.MIN_VALUE)) {
                return this.checked$fallback$macro$2$2(x2$3);
            }
            return package$long$.MODULE$.LongAlgebra().compare$mcJ$sp(z$macro$3, z$macro$6);
        }

        public LongRational(long n, long d) {
            this.n = n;
            this.d = d;
        }
    }
}

