/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayAppend$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(array, element) - Add the element at the end of the array passed as first\n      argument. Type of element should be similar to type of the elements of the array.\n      Null element is also appended into the array. But if the array passed, is NULL\n      output is NULL\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'), 'd');\n       [\"b\",\"d\",\"c\",\"a\",\"d\"]\n      > SELECT _FUNC_(array(1, 2, 3, null), null);\n       [1,2,3,null,null]\n      > SELECT _FUNC_(CAST(null as Array<Int>), 2);\n       NULL\n  ", since="3.4.0", group="array_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011!\u0011\u0007\u0001#b\u0001\n#\u0019\u0007\"\u00028\u0001\t\u0003z\u0007\"\u0002?\u0001\t\u0003j\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003?\u0001A\u0011KA\u0011\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u000e\u0001\t\u0003\n9\u0004\u0003\u0004\u0002T\u0001!\te\u0019\u0005\b\u0003+\u0002A\u0011CA,\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002j\u0001\t\n\u0011\"\u0001\u0002l!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000bC\u0011\"!&\u0001\u0003\u0003%\t!a&\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0006\"CAT\u0001\u0005\u0005I\u0011IAU\u0011%\t9\fAA\u0001\n\u0003\tI\fC\u0005\u0002>\u0002\t\t\u0011\"\u0011\u0002@\u001eI\u00111]\u0011\u0002\u0002#\u0005\u0011Q\u001d\u0004\tA\u0005\n\t\u0011#\u0001\u0002h\"1\u0001K\u0007C\u0001\u0003kD\u0011\"a>\u001b\u0003\u0003%)%!?\t\u0013\u0005m($!A\u0005\u0002\u0006u\b\"\u0003B\u00025\u0005\u0005I\u0011\u0011B\u0003\u0011%\u00119BGA\u0001\n\u0013\u0011IBA\u0006BeJ\f\u00170\u00119qK:$'B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001y3GN\u001d@\u000bB\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\r\u001b\n\u0005U\n#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005A:\u0014B\u0001\u001d\"\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0013\u0002\r\u0015\u0014(o\u001c:t\u0013\tq4HA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0011$\n\u0005\u001d\u000b%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012A\u0013\t\u0003a-K!\u0001T\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001bF\u000b\u0005\u00021\u0001!)\u0001*\u0002a\u0001\u0015\")a*\u0002a\u0001\u0015\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003]\u0003\"\u0001W0\u000f\u0005ek\u0006C\u0001.B\u001b\u0005Y&B\u0001/.\u0003\u0019a$o\\8u}%\u0011a,Q\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_\u0003\u0006YQ\r\\3nK:$H+\u001f9f+\u0005!\u0007CA3i\u001b\u00051'BA4&\u0003\u0015!\u0018\u0010]3t\u0013\tIgM\u0001\u0005ECR\fG+\u001f9fQ\t91\u000e\u0005\u0002AY&\u0011Q.\u0011\u0002\niJ\fgn]5f]R\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0001\bcA9ws:\u0011!\u000f\u001e\b\u00035NL\u0011AQ\u0005\u0003k\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0002xq\n\u00191+Z9\u000b\u0005U\f\u0005CA3{\u0013\tYhM\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r1%\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t9!!\u0001\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR!\u0011QBA\n!\r\u0001\u0015qB\u0005\u0004\u0003#\t%aA!os\"I\u0011Q\u0003\u0006\u0011\u0002\u0003\u0007\u0011qC\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u00033\tY\"D\u0001$\u0013\r\tib\t\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002\u000e\u0005\r\u0012q\u0005\u0005\b\u0003KY\u0001\u0019AA\u0007\u0003\r\t'O\u001d\u0005\b\u0003SY\u0001\u0019AA\u0007\u0003-)G.Z7f]R$\u0015\r^1\u0002\u00119,H\u000e\\1cY\u0016,\"!a\f\u0011\u0007\u0001\u000b\t$C\u0002\u00024\u0005\u0013qAQ8pY\u0016\fg.A\u0005e_\u001e+gnQ8eKR1\u0011\u0011HA#\u0003\u001f\u0002B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f\t\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0007\niD\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9%\u0004a\u0001\u0003\u0013\n1a\u0019;y!\u0011\tY$a\u0013\n\t\u00055\u0013Q\b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\t&\u0004a\u0001\u0003s\t!!\u001a<\u0002\u0011\u0011\fG/\u0019+za\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bI\u000bI&!\u0018\t\r\u0005ms\u00021\u0001K\u0003\u001dqWm\u001e'fMRDa!a\u0018\u0010\u0001\u0004Q\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006%\u0006\u0015\u0014q\r\u0005\b\u0011B\u0001\n\u00111\u0001K\u0011\u001dq\u0005\u0003%AA\u0002)\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002n)\u001a!*a\u001c,\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001fB\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\n)HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0003mC:<'BAAI\u0003\u0011Q\u0017M^1\n\u0007\u0001\fY)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001aB\u0019\u0001)a'\n\u0007\u0005u\u0015IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005\r\u0006\"CAS+\u0005\u0005\t\u0019AAM\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0016\t\u0007\u0003[\u000b\u0019,!\u0004\u000e\u0005\u0005=&bAAY\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0016q\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00020\u0005m\u0006\"CAS/\u0005\u0005\t\u0019AA\u0007\u0003\u0019)\u0017/^1mgR!\u0011qFAa\u0011%\t)\u000bGA\u0001\u0002\u0004\ti\u0001K\n\u0001\u0003\u000b\fY-!4\u0002R\u0006M\u0017q[Am\u0003;\fy\u000eE\u00021\u0003\u000fL1!!3\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a4\u0002\u0005\u0003R\u0001\u0005\t\u0011!A\u0001zf)\u0016(D?\"\n'O]1zY\u0001*G.Z7f]RL\u0003%\f\u0011BI\u0012\u0004C\u000f[3!K2,W.\u001a8uA\u0005$\b\u0005\u001e5fA\u0015tG\rI8gAQDW\rI1se\u0006L\b\u0005]1tg\u0016$\u0007%Y:!M&\u00148\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005I1sOVlWM\u001c;/AQK\b/\u001a\u0011pM\u0002*G.Z7f]R\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011tS6LG.\u0019:!i>\u0004C/\u001f9fA=4\u0007\u0005\u001e5fA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bs:R\u0001\u0005\t\u0011!A\u0001rU\u000f\u001c7!K2,W.\u001a8uA%\u001c\b%\u00197t_\u0002\n\u0007\u000f]3oI\u0016$\u0007%\u001b8u_\u0002\"\b.\u001a\u0011beJ\f\u0017P\f\u0011CkR\u0004\u0013N\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002\u0002\u0018m]:fI2\u0002\u0013n\u001d\u0011O+2c%\u0002\t\u0011!A\u0001\u0002s.\u001e;qkR\u0004\u0013n\u001d\u0011O+2c%\u0002\t\u0011!A\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005U\u0017!a9\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O\t<C\u0006I\u0014eO1\u0002seY\u0014-A\u001d\nw%\u000b\u0017!O\u0011<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E\t\u0014CF\t3#Y\t\u001a'\u0005\f\u0012bE1\u0012CMI/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114Y\u0001rW\u000f\u001c7*Y\u0001rW\u000f\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a-g1rW\u000f\u001c7-]VdG.\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u0007\u0006\u001bF\u000b\u000b8vY2\u0004\u0013m\u001d\u0011BeJ\f\u0017\u0010P%oizJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa]5oG\u0016\f#!a7\u0002\u000bMrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0005\u0018aC1se\u0006LxLZ;oGN\f1\"\u0011:sCf\f\u0005\u000f]3oIB\u0011\u0001GG\n\u00055\u0005%X\tE\u0004\u0002l\u0006E(J\u0013*\u000e\u0005\u00055(bAAx\u0003\u00069!/\u001e8uS6,\u0017\u0002BAz\u0003[\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t)/\u0001\u0005u_N#(/\u001b8h)\t\t9)A\u0003baBd\u0017\u0010F\u0003S\u0003\u007f\u0014\t\u0001C\u0003I;\u0001\u0007!\nC\u0003O;\u0001\u0007!*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u001d!1\u0003\t\u0006\u0001\n%!QB\u0005\u0004\u0005\u0017\t%AB(qi&|g\u000eE\u0003A\u0005\u001fQ%*C\u0002\u0003\u0012\u0005\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u000b=\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u000e!\u0011\tII!\b\n\t\t}\u00111\u0012\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayAppend
extends BinaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
scala.Serializable {
    private transient DataType elementType;
    private final Expression left;
    private final Expression right;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayAppend arrayAppend) {
        return ArrayAppend$.MODULE$.unapply(arrayAppend);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayAppend> tupled() {
        return ArrayAppend$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayAppend>> curried() {
        return ArrayAppend$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String prettyName() {
        return "array_append";
    }

    private DataType elementType$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.inputTypes().head()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)Nil$.MODULE$;
            }
        }
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType2 = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType2 instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType2).elementType(), e2)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null && (dataType = (DataType)tuple2._1()) instanceof ArrayType) {
            return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
    }

    @Override
    public Object eval(InternalRow input) {
        Object value1 = this.left().eval(input);
        if (value1 == null) {
            return null;
        }
        Object value2 = this.right().eval(input);
        return this.nullSafeEval(value1, value2);
    }

    @Override
    public Object nullSafeEval(Object arr, Object elementData) {
        ArrayData arrayData = (ArrayData)arr;
        int numberOfElements = arrayData.numElements() + 1;
        if (numberOfElements > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(numberOfElements);
        }
        Object[] finalData = new Object[numberOfElements];
        arrayData.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, x) -> {
            finalData[BoxesRunTime.unboxToInt((Object)i)] = x;
            return BoxedUnit.UNIT;
        });
        finalData[arrayData.numElements()] = elementData;
        return new GenericArrayData(finalData);
    }

    @Override
    public boolean nullable() {
        return this.left().nullable();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        Function2 & Serializable & scala.Serializable f = (Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), (String)eval1, i, i, ((ArrayType)this.left().dataType()).containsNull());
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(185).append("\n         |int ").append(newArraySize).append(" = ").append((String)eval1).append(".numElements() + 1;\n         |").append(allocation).append("\n         |int ").append(i).append(" = 0;\n         |while (").append(i).append(" < ").append((String)eval1).append(".numElements()) {\n         |  ").append(assignment).append("\n         |  ").append(i).append(" ++;\n         |}\n         |").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), i, (String)eval2, (Option<String>)new Some((Object)ExprValue$.MODULE$.exprValueToString(rightGen.isNull())))).append("\n         |").append(ev.value()).append(" = ").append(values).append(";\n         |").toString())).stripMargin();
        };
        String resultCode = (String)f.apply((Object)ExprValue$.MODULE$.exprValueToString(leftGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(rightGen.value()));
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code().$plus(rightGen.code())), ctx.nullSafeExec(this.left().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), new StringBuilder(86).append("\n            ").append(ev.isNull()).append(" = false; // resultCode could change nullability.\n            ").append(resultCode).append("\n          ").toString()));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", "\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public DataType dataType() {
        if (this.right().nullable()) {
            return this.left().dataType().asNullable();
        }
        return this.left().dataType();
    }

    @Override
    public ArrayAppend withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayAppend copy(Expression left, Expression right) {
        return new ArrayAppend(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayAppend";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayAppend;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayAppend)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayAppend arrayAppend = (ArrayAppend)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayAppend.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayAppend.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayAppend.canEqual(this)) return false;
        return true;
    }

    public ArrayAppend(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

