/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u000e\u001c\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003E\u0001\u0011\u0005Q\tC\u0004K\u0001\t\u0007I\u0011B&\t\r]\u0003\u0001\u0015!\u0003M\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013QV\u0001\u00020\u0001\t}Cq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004|\u0001\u0001\u0006IA\u001e\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\tI\u0001\u0001Q\u0001\nyD\u0001\"a\u0003\u0001\u0005\u0004%I! \u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003\u007f\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\n\u0011)\tY\u0002\u0001EC\u0002\u0013%\u0011Q\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002f\u0001!\t!a\u001a\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005u\u0003bBA:\u0001\u0011\u0005\u0011Q\f\u0002\u0013+:Lgo\\2jif<UM\\3sCR|'O\u0003\u0002\u001d;\u0005\u00191m\u001d<\u000b\u0005yy\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004tG\",W.\u0019\t\u0003cQj\u0011A\r\u0006\u0003g}\tQ\u0001^=qKNL!!\u000e\u001a\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0004xe&$XM\u001d\t\u0003quj\u0011!\u000f\u0006\u0003um\n!![8\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0007/JLG/\u001a:\u0002\u000f=\u0004H/[8ogB\u0011\u0011IQ\u0007\u00027%\u00111i\u0007\u0002\u000b\u0007N3v\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003G\u000f\"K\u0005CA!\u0001\u0011\u0015yC\u00011\u00011\u0011\u00151D\u00011\u00018\u0011\u0015yD\u00011\u0001A\u000399(/\u001b;feN+G\u000f^5oON,\u0012\u0001\u0014\t\u0003\u001bVk\u0011A\u0014\u0006\u00039=S!\u0001U)\u0002\u000fA\f'o]3sg*\u0011!kU\u0001\nk:Lgo\\2jifT\u0011\u0001V\u0001\u0004G>l\u0017B\u0001,O\u0005E\u00195O^,sSR,'oU3ui&twm]\u0001\u0010oJLG/\u001a:TKR$\u0018N\\4tA\u0005\u0019q-\u001a8\u0016\u0003i\u0003\"!T.\n\u0005qs%!C\"tm^\u0013\u0018\u000e^3s\u0003\u00119WM\u001c\u0011\u0003\u001dY\u000bG.^3D_:4XM\u001d;feB)!\u0006\u00192gS&\u0011\u0011m\u000b\u0002\n\rVt7\r^5p]J\u0002\"a\u00193\u000e\u0003uI!!Z\u000f\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u0003U\u001dL!\u0001[\u0016\u0003\u0007%sG\u000f\u0005\u0002kc:\u00111n\u001c\t\u0003Y.j\u0011!\u001c\u0006\u0003]\u001e\na\u0001\u0010:p_Rt\u0014B\u00019,\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\\\u0013a\u0004<bYV,7i\u001c8wKJ$XM]:\u0016\u0003Y\u00042AK<z\u0013\tA8FA\u0003BeJ\f\u0017\u0010\u0005\u0002{\u00135\t\u0001!\u0001\twC2,XmQ8om\u0016\u0014H/\u001a:tA\u0005\u0011B/[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007i\u0012\u0001B;uS2LA!a\u0002\u0002\u0002\t\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003M!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:!\u0003U!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\fa\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'\u000fI\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0005\u0005M\u0001cA@\u0002\u0016%!\u0011qCA\u0001\u00055!\u0015\r^3G_Jl\u0017\r\u001e;fe\u0006qA-\u0019;f\r>\u0014X.\u0019;uKJ\u0004\u0013a\u00068vY2\f5/U;pi\u0016$W)\u001c9usN#(/\u001b8h+\t\ty\u0002E\u0002+\u0003CI1!a\t,\u0005\u001d\u0011un\u001c7fC:\fQ\"\\1lK\u000e{gN^3si\u0016\u0014HcA=\u0002*!9\u00111F\nA\u0002\u00055\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007E\ny#C\u0002\u00022I\u0012\u0001\u0002R1uCRK\b/\u001a\u0015\u0004'\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m2&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0010\u0002:\t9A/Y5me\u0016\u001c\u0017AC2p]Z,'\u000f\u001e*poR!\u0011QIA,!\u0015\t9%!\u0015j\u001d\u0011\tI%!\u0014\u000f\u00071\fY%C\u0001-\u0013\r\tyeK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u0007M+\u0017OC\u0002\u0002P-Ba!!\u0017\u0015\u0001\u0004\u0011\u0017a\u0001:po\u0006aqO]5uK\"+\u0017\rZ3sgR\u0011\u0011q\f\t\u0004U\u0005\u0005\u0014bAA2W\t!QK\\5u\u0003\u00159(/\u001b;f)\u0011\ty&!\u001b\t\r\u0005ec\u00031\u0001c\u000359(/\u001b;f)>\u001cFO]5oOR\u0019\u0011.a\u001c\t\r\u0005es\u00031\u0001c\u0003\u0015\u0019Gn\\:f\u0003\u00151G.^:i\u0001")
public class UnivocityGenerator {
    private boolean nullAsQuotedEmptyString;
    private final CSVOptions options;
    private final CsvWriterSettings writerSettings;
    private final CsvWriter gen;
    private final Function2<InternalRow, Object, String>[] valueConverters;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private volatile boolean bitmap$0;

    private CsvWriterSettings writerSettings() {
        return this.writerSettings;
    }

    private CsvWriter gen() {
        return this.gen;
    }

    private Function2<InternalRow, Object, String>[] valueConverters() {
        return this.valueConverters;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private boolean nullAsQuotedEmptyString$lzycompute() {
        UnivocityGenerator univocityGenerator = this;
        synchronized (univocityGenerator) {
            if (!this.bitmap$0) {
                this.nullAsQuotedEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_NULL_VALUE_WRITTEN_AS_QUOTED_EMPTY_STRING_CSV()));
                this.bitmap$0 = true;
            }
        }
        return this.nullAsQuotedEmptyString;
    }

    private boolean nullAsQuotedEmptyString() {
        if (!this.bitmap$0) {
            return this.nullAsQuotedEmptyString$lzycompute();
        }
        return this.nullAsQuotedEmptyString;
    }

    private Function2<InternalRow, Object, String> makeConverter(DataType dataType) {
        DataType dataType2;
        while (true) {
            if (DateType$.MODULE$.equals(dataType2 = dataType)) {
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (dataType2 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> IntervalUtils$.MODULE$.toYearMonthIntervalString(row.getInt(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (dataType2 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> IntervalUtils$.MODULE$.toDayTimeIntervalString(row.getLong(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (dataType2 != null) {
            DataType dataType3 = dataType2;
            return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$6(dataType3, row, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        throw new MatchError((Object)dataType2);
    }

    private Seq<String> convertRow(InternalRow row) {
        String[] values = new String[row.numFields()];
        for (int i = 0; i < row.numFields(); ++i) {
            if (!row.isNullAt(i)) {
                values[i] = (String)this.valueConverters()[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.nullAsQuotedEmptyString()) continue;
            values[i] = this.options.nullValue();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])values);
    }

    public void writeHeaders() {
        this.gen().writeHeaders();
    }

    public void write(InternalRow row) {
        this.gen().writeRow((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String writeToString(InternalRow row) {
        return this.gen().writeRowToString((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$1(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.dateFormatter().format(row.getInt(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$2(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.timestampFormatter().format(row.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$3(UnivocityGenerator $this, InternalRow row, int ordinal) {
        return $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(row.getLong(ordinal)));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$6(DataType x8$1, InternalRow row, int ordinal) {
        return row.get(ordinal, x8$1).toString();
    }

    public UnivocityGenerator(StructType schema, Writer writer, CSVOptions options) {
        this.options = options;
        this.writerSettings = options.asWriterSettings();
        this.writerSettings().setHeaders(schema.fieldNames());
        this.gen = new CsvWriter(writer, this.writerSettings());
        this.valueConverters = (Function2[])((TraversableOnce)((TraversableLike)schema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
    }
}

