/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.json.JsonDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetDataSourceV2;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\r\u001b\u0001\u001eB\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0003\"Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005[\u0001\tE\t\u0015!\u0003I\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015a\u0007\u0001\"\u0003n\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bA\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u0005-\u0002!%A\u0005\u0002\u00055\u0002\"CA\"\u0001E\u0005I\u0011AA#\u0011%\tI\u0005AA\u0001\n\u0003\nY\u0005C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0011q\r\u0005\n\u0003g\u0002\u0011\u0011!C!\u0003kB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u0005=\u0005!!A\u0005B\u0005Eu!CAK5\u0005\u0005\t\u0012AAL\r!I\"$!A\t\u0002\u0005e\u0005BB.\u0014\t\u0003\t9\u000bC\u0005\u0002*N\t\t\u0011\"\u0012\u0002,\"I\u0011QV\n\u0002\u0002\u0013\u0005\u0015q\u0016\u0005\n\u0003k\u001b\u0012\u0011!CA\u0003oC\u0011\"!2\u0014\u0003\u0003%I!a2\u00037\u0005cG/\u001a:UC\ndW-\u00113e\u0007>dW/\u001c8t\u0007>lW.\u00198e\u0015\tYB$A\u0004d_6l\u0017M\u001c3\u000b\u0005uq\u0012!C3yK\u000e,H/[8o\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001F\r\u001c=!\tI\u0003'D\u0001+\u0015\tYC&A\u0004m_\u001eL7-\u00197\u000b\u00055r\u0013!\u00029mC:\u001c(BA\u0018\u001f\u0003!\u0019\u0017\r^1msN$\u0018BA\u0019+\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005M\"T\"\u0001\u000e\n\u0005UR\"a\u0005'fC\u001a\u0014VO\u001c8bE2,7i\\7nC:$\u0007CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003ouJ!A\u0010\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bQ\f'\r\\3\u0016\u0003\u0005\u0003\"AQ\"\u000e\u00039J!\u0001\u0012\u0018\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fa\u0001^1cY\u0016\u0004\u0013!C2pYN$v.\u00113e+\u0005A\u0005cA%R):\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u001a\na\u0001\u0010:p_Rt\u0014\"A\u001d\n\u0005AC\u0014a\u00029bG.\fw-Z\u0005\u0003%N\u00131aU3r\u0015\t\u0001\u0006\b\u0005\u0002V16\taK\u0003\u0002X=\u0005)A/\u001f9fg&\u0011\u0011L\u0016\u0002\f'R\u0014Xo\u0019;GS\u0016dG-\u0001\u0006d_2\u001cHk\\!eI\u0002\na\u0001P5oSRtDcA/_?B\u00111\u0007\u0001\u0005\u0006\u007f\u0015\u0001\r!\u0011\u0005\u0006\r\u0016\u0001\r\u0001S\u0001\u0004eVtGC\u00012h!\rI\u0015k\u0019\t\u0003I\u0016l\u0011AH\u0005\u0003Mz\u00111AU8x\u0011\u0015Ag\u00011\u0001j\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t!'.\u0003\u0002l=\ta1\u000b]1sWN+7o]5p]\u0006Ib/\u001a:jMf\fE\u000e^3s)\u0006\u0014G.Z!eI\u000e{G.^7o)\u0015qG\u000f`A\u0001!\ty'/D\u0001q\u0015\t\th&A\u0004dCR\fGn\\4\n\u0005M\u0004(\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\"B;\b\u0001\u00041\u0018\u0001B2p]\u001a\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0010\u0002\u0011%tG/\u001a:oC2L!a\u001f=\u0003\u000fM\u000bFjQ8oM\")\u0011o\u0002a\u0001{B\u0011qN`\u0005\u0003\u007fB\u0014abU3tg&|gnQ1uC2|w\rC\u0003@\u000f\u0001\u0007\u0011)\u0001\u0016d_:\u001cH/\u00198u\r>dGmQ;se\u0016tG\u000fR3gCVdGo\u001d+p\u000bbL7\u000f\u001e#fM\u0006,H\u000e^:\u0015\u000b!\u000b9!!\u0003\t\u000b!D\u0001\u0019A5\t\u000f\u0005-\u0001\u00021\u0001\u0002\u000e\u0005iA/\u00192mKB\u0013xN^5eKJ\u0004RaNA\b\u0003'I1!!\u00059\u0005\u0019y\u0005\u000f^5p]B!\u0011QCA\u000f\u001d\u0011\t9\"!\u0007\u0011\u0005-C\u0014bAA\u000eq\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t11\u000b\u001e:j]\u001eT1!a\u00079\u0003\u0011\u0019w\u000e]=\u0015\u000bu\u000b9#!\u000b\t\u000f}J\u0001\u0013!a\u0001\u0003\"9a)\u0003I\u0001\u0002\u0004A\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003_Q3!QA\u0019W\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001fq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0013q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fR3\u0001SA\u0019\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\b\u0002R\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\f\t\u0004o\u0005\u0005\u0014bAA2q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011NA8!\r9\u00141N\u0005\u0004\u0003[B$aA!os\"I\u0011\u0011\u000f\b\u0002\u0002\u0003\u0007\u0011qL\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0004CBA=\u0003\u007f\nI'\u0004\u0002\u0002|)\u0019\u0011Q\u0010\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0002\u0006m$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\"\u0002\u000eB\u0019q'!#\n\u0007\u0005-\u0005HA\u0004C_>dW-\u00198\t\u0013\u0005E\u0004#!AA\u0002\u0005%\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\b\u0006M\u0005\"CA9#\u0005\u0005\t\u0019AA5\u0003m\tE\u000e^3s)\u0006\u0014G.Z!eI\u000e{G.^7og\u000e{W.\\1oIB\u00111gE\n\u0005'\u0005mE\bE\u0004\u0002\u001e\u0006\r\u0016\tS/\u000e\u0005\u0005}%bAAQq\u00059!/\u001e8uS6,\u0017\u0002BAS\u0003?\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t9*\u0001\u0005u_N#(/\u001b8h)\t\ti%A\u0003baBd\u0017\u0010F\u0003^\u0003c\u000b\u0019\fC\u0003@-\u0001\u0007\u0011\tC\u0003G-\u0001\u0007\u0001*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0016\u0011\u0019\t\u0006o\u0005=\u00111\u0018\t\u0006o\u0005u\u0016\tS\u0005\u0004\u0003\u007fC$A\u0002+va2,'\u0007\u0003\u0005\u0002D^\t\t\u00111\u0001^\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002JB!\u0011qJAf\u0013\u0011\ti-!\u0015\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableAddColumnsCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> colsToAdd;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand alterTableAddColumnsCommand) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(alterTableAddColumnsCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = this;
        synchronized (alterTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(sparkSession.sessionState().conf(), catalog, this.table());
        Seq<StructField> colsWithProcessedDefaults = this.constantFoldCurrentDefaultsToExistDefaults(sparkSession, (Option<String>)catalogTable.provider());
        CommandUtils$.MODULE$.uncacheTableOrView(sparkSession, this.table().quotedString());
        catalog.refreshTable(this.table());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)((TraversableLike)colsWithProcessedDefaults.$plus$plus((GenTraversableOnce)catalogTable.schema(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom()), this.conf().caseSensitiveAnalysis());
        DDLUtils$.MODULE$.checkTableColumns(catalogTable, StructType$.MODULE$.apply(colsWithProcessedDefaults));
        StructType existingSchema = CharVarcharUtils$.MODULE$.getRawSchema(catalogTable.dataSchema());
        catalog.alterTableDataSchema(this.table(), StructType$.MODULE$.apply((Seq)existingSchema.$plus$plus(colsWithProcessedDefaults, Seq$.MODULE$.canBuildFrom())));
        return (Seq)Nil$.MODULE$;
    }

    private CatalogTable verifyAlterTableAddColumn(SQLConf conf, SessionCatalog catalog, TableIdentifier table) {
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportViewError(table);
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get(), conf).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof CSVFileFormat ? true : (obj instanceof JsonFileFormat ? true : obj instanceof ParquetFileFormat)) {
            } else if (obj instanceof JsonDataSourceV2 ? true : (obj instanceof CSVDataSourceV2 ? true : (obj instanceof OrcDataSourceV2 ? true : obj instanceof ParquetDataSourceV2))) {
            } else if (obj.getClass().getCanonicalName().endsWith("OrcFileFormat")) {
            } else {
                throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportDatasourceTableError(obj, table);
            }
        }
        return catalogTable;
    }

    private Seq<StructField> constantFoldCurrentDefaultsToExistDefaults(SparkSession sparkSession, Option<String> tableProvider) {
        return (Seq)this.colsToAdd().map((Function1 & Serializable & scala.Serializable)col -> {
            if (col.metadata().contains(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
                StructType schema = new StructType((StructField[])((Object[])new StructField[]{col}));
                ResolveDefaultColumns$.MODULE$.validateTableProviderForDefaultValue(schema, tableProvider, "ALTER TABLE ADD COLUMNS", true);
                StructType foldedStructType = ResolveDefaultColumns$.MODULE$.constantFoldCurrentDefaultsToExistDefaults(schema, "ALTER TABLE ADD COLUMNS");
                return foldedStructType.fields()[0];
            }
            return col;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> colsToAdd) {
        return new AlterTableAddColumnsCommand(table, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.colsToAdd();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> colsToAdd) {
        this.table = table;
        this.colsToAdd = colsToAdd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

