/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.execution.aggregate.HashMapGenerator;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001D\u0007\u00015!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00119\u0003!\u0011!Q\u0001\n!C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u0006;\u0002!\tF\u0018\u0005\u0006?\u0002!\tB\u0018\u0005\u0006A\u0002!\tB\u0018\u0005\u0006C\u0002!\tB\u0018\u0002\u001b-\u0016\u001cGo\u001c:ju\u0016$\u0007*Y:i\u001b\u0006\u0004x)\u001a8fe\u0006$xN\u001d\u0006\u0003\u001d=\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005A\t\u0012!C3yK\u000e,H/[8o\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\tQ\"\u0003\u0002\u001f\u001b\t\u0001\u0002*Y:i\u001b\u0006\u0004x)\u001a8fe\u0006$xN]\u0001\u0004GRD\bCA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u001d\u0019w\u000eZ3hK:T!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003OE\t\u0001bY1uC2L8\u000f^\u0005\u0003S\t\u0012abQ8eK\u001e,gnQ8oi\u0016DH/\u0001\u000bbO\u001e\u0014XmZ1uK\u0016C\bO]3tg&|gn\u001d\t\u0004YYJdBA\u00174\u001d\tq\u0013'D\u00010\u0015\t\u0001\u0014$\u0001\u0004=e>|GOP\u0005\u0002e\u0005)1oY1mC&\u0011A'N\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\u0011\u0014BA\u001c9\u0005\r\u0019V-\u001d\u0006\u0003iU\u0002\"A\u000f\u001f\u000e\u0003mR!A\u0004\u0013\n\u0005uZ$aE!hOJ,w-\u0019;f\u000bb\u0004(/Z:tS>t\u0017AE4f]\u0016\u0014\u0018\r^3e\u00072\f7o\u001d(b[\u0016\u0004\"\u0001\u0011#\u000f\u0005\u0005\u0013\u0005C\u0001\u00186\u0013\t\u0019U'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"6\u0003E9'o\\;qS:<7*Z=TG\",W.\u0019\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017F\tQ\u0001^=qKNL!!\u0014&\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0007ck\u001a4WM]*dQ\u0016l\u0017-\u0001\bcSRl\u0015\r_\"ba\u0006\u001c\u0017\u000e^=\u0011\u0005E\u0013V\"A\u001b\n\u0005M+$aA%oi\u00061A(\u001b8jiz\"rAV,Y3j[F\f\u0005\u0002\u001d\u0001!)qd\u0002a\u0001A!)!f\u0002a\u0001W!)ah\u0002a\u0001\u007f!)qi\u0002a\u0001\u0011\")aj\u0002a\u0001\u0011\")qj\u0002a\u0001!\u0006Q\u0012N\\5uS\u0006d\u0017N_3BO\u001e\u0014XmZ1uK\"\u000b7\u000f['baR\tq(\u0001\bhK:,'/\u0019;f\u000bF,\u0018\r\\:\u0002)\u001d,g.\u001a:bi\u00164\u0015N\u001c3Pe&s7/\u001a:u\u0003M9WM\\3sCR,'k\\<Ji\u0016\u0014\u0018\r^8s\u0001")
public class VectorizedHashMapGenerator
extends HashMapGenerator {
    private final CodegenContext ctx;
    private final String generatedClassName;
    private final StructType groupingKeySchema;
    private final StructType bufferSchema;
    private final int bitMaxCapacity;

    @Override
    public String initializeAggregateHashMap() {
        StructType schemaStructType = new StructType((StructField[])((TraversableOnce)this.groupingKeySchema.$plus$plus((GenTraversableOnce)this.bufferSchema, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
        String schema = this.ctx.addReferenceObj("schemaTerm", (Object)schemaStructType, this.ctx.addReferenceObj$default$3());
        int aggBufferSchemaFieldsLength = this.bufferSchema.fields().length;
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(875).append("\n       |  private ").append(OnHeapColumnVector.class.getName()).append("[] vectors;\n       |  private ").append(ColumnarBatch.class.getName()).append(" batch;\n       |  private ").append(MutableColumnarRow.class.getName()).append(" aggBufferRow;\n       |  private int[] buckets;\n       |  private int capacity = 1 << ").append(this.bitMaxCapacity).append(";\n       |  private double loadFactor = 0.5;\n       |  private int numBuckets = (int) (capacity / loadFactor);\n       |  private int maxSteps = 2;\n       |  private int numRows = 0;\n       |\n       |  public ").append(this.generatedClassName).append("() {\n       |    vectors = ").append(OnHeapColumnVector.class.getName()).append(".allocateColumns(capacity, ").append(schema).append(");\n       |    batch = new ").append(ColumnarBatch.class.getName()).append("(vectors);\n       |\n       |    // Generates a projection to return the aggregate buffer only.\n       |    ").append(OnHeapColumnVector.class.getName()).append("[] aggBufferVectors =\n       |      new ").append(OnHeapColumnVector.class.getName()).append("[").append(aggBufferSchemaFieldsLength).append("];\n       |    for (int i = 0; i < ").append(aggBufferSchemaFieldsLength).append("; i++) {\n       |      aggBufferVectors[i] = vectors[i + ").append(this.groupingKeys().length()).append("];\n       |    }\n       |    aggBufferRow = new ").append(MutableColumnarRow.class.getName()).append("(aggBufferVectors);\n       |\n       |    buckets = new int[numBuckets];\n       |    java.util.Arrays.fill(buckets, -1);\n       |  }\n     ").toString())).stripMargin();
    }

    @Override
    public String generateEquals() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n       |private boolean equals(int idx, ").append(this.groupingKeySignature()).append(") {\n       |  return ").append(this.genEqualsForKeys$1(this.groupingKeys())).append(";\n       |}\n     ").toString())).stripMargin();
    }

    @Override
    public String generateFindOrInsert() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1033).append("\n       |public ").append(MutableColumnarRow.class.getName()).append(" findOrInsert(").append(this.groupingKeySignature()).append(") {\n       |  long h = hash(").append(((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n       |  int step = 0;\n       |  int idx = (int) h & (numBuckets - 1);\n       |  while (step < maxSteps) {\n       |    // Return bucket index if it's either an empty slot or already contains the key\n       |    if (buckets[idx] == -1) {\n       |      if (numRows < capacity) {\n       |\n       |        // Initialize aggregate keys\n       |        ").append(VectorizedHashMapGenerator.genCodeToSetKeys$1(this.groupingKeys()).mkString("\n")).append("\n       |\n       |        ").append(((TraversableOnce)this.buffVars().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n       |\n       |        // Initialize aggregate values\n       |        ").append(this.genCodeToSetAggBuffers$1(this.bufferValues()).mkString("\n")).append("\n       |\n       |        buckets[idx] = numRows++;\n       |        aggBufferRow.rowId = buckets[idx];\n       |        return aggBufferRow;\n       |      } else {\n       |        // No more space\n       |        return null;\n       |      }\n       |    } else if (equals(idx, ").append(((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")) {\n       |      aggBufferRow.rowId = buckets[idx];\n       |      return aggBufferRow;\n       |    }\n       |    idx = (idx + 1) & (numBuckets - 1);\n       |    step++;\n       |  }\n       |  // Didn't find it\n       |  return null;\n       |}\n     ").toString())).stripMargin();
    }

    @Override
    public String generateRowIterator() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n       |public java.util.Iterator<").append(InternalRow.class.getName()).append("> rowIterator() {\n       |  batch.setNumRows(numRows);\n       |  return batch.rowIterator();\n       |}\n     ").toString())).stripMargin();
    }

    private final String genEqualsForKeys$1(Seq groupingKeys) {
        return ((TraversableOnce)((TraversableLike)groupingKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HashMapGenerator.Buffer key = (HashMapGenerator.Buffer)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                if (key != null) {
                    HashMapGenerator.Buffer buffer = key;
                    int n = ordinal;
                    String value = CodeGenerator$.MODULE$.getValueFromVector(new StringBuilder(9).append("vectors[").append(n).append("]").toString(), buffer.dataType(), "buckets[idx]");
                    return new StringBuilder(2).append("(").append($this.ctx.genEqual(buffer.dataType(), value, buffer.name())).append(")").toString();
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).mkString(" && ");
    }

    private static final Seq genCodeToSetKeys$1(Seq groupingKeys) {
        return (Seq)((TraversableLike)groupingKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HashMapGenerator.Buffer key = (HashMapGenerator.Buffer)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                if (key != null) {
                    HashMapGenerator.Buffer buffer = key;
                    int n = ordinal;
                    return CodeGenerator$.MODULE$.setValue(new StringBuilder(9).append("vectors[").append(n).append("]").toString(), "numRows", buffer.dataType(), buffer.name());
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq genCodeToSetAggBuffers$1(Seq bufferValues) {
        return (Seq)((TraversableLike)bufferValues.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HashMapGenerator.Buffer key = (HashMapGenerator.Buffer)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                if (key != null) {
                    HashMapGenerator.Buffer buffer = key;
                    int n = ordinal;
                    return CodeGenerator$.MODULE$.updateColumn(new StringBuilder(9).append("vectors[").append(this.groupingKeys().length() + n).append("]").toString(), "numRows", buffer.dataType(), (ExprCode)this.buffVars().apply(n), true);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public VectorizedHashMapGenerator(CodegenContext ctx, Seq<AggregateExpression> aggregateExpressions, String generatedClassName, StructType groupingKeySchema, StructType bufferSchema, int bitMaxCapacity) {
        this.ctx = ctx;
        this.generatedClassName = generatedClassName;
        this.groupingKeySchema = groupingKeySchema;
        this.bufferSchema = bufferSchema;
        this.bitMaxCapacity = bitMaxCapacity;
        super(ctx, aggregateExpressions, generatedClassName, groupingKeySchema, bufferSchema);
    }
}

