/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.sling.MockSlingScriptHelper;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.apache.sling.testing.mock.sling.ResourceResolverFactoryInitializer;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.ThreadsafeMockAdapterManagerWrapper;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletResponse;
import org.apache.sling.testing.mock.sling.spi.ResourceResolverTypeAdapter;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class MockSling {
    @NotNull
    public static final ResourceResolverType DEFAULT_RESOURCERESOLVER_TYPE = ResourceResolverType.RESOURCERESOLVER_MOCK;
    private static final ThreadsafeMockAdapterManagerWrapper ADAPTER_MANAGER = new ThreadsafeMockAdapterManagerWrapper();
    private static final ConcurrentMap<Class<? extends ResourceResolverTypeAdapter>, Object> SNAPSHOTS = new ConcurrentHashMap<Class<? extends ResourceResolverTypeAdapter>, Object>();

    private MockSling() {
    }

    @NotNull
    public static ResourceResolverFactory newResourceResolverFactory(@NotNull BundleContext bundleContext) {
        return MockSling.newResourceResolverFactory(DEFAULT_RESOURCERESOLVER_TYPE, bundleContext);
    }

    @NotNull
    public static ResourceResolverFactory newResourceResolverFactory(@NotNull ResourceResolverType type, @NotNull BundleContext bundleContext) {
        ServiceReference existingReference = bundleContext.getServiceReference(ResourceResolverFactory.class);
        if (existingReference != null) {
            throw new IllegalStateException("A ResourceResolverFactory is already registered in this BundleContext - please get the existing service instance.");
        }
        ResourceResolverTypeAdapter adapter = MockSling.getResourceResolverTypeAdapter(type, bundleContext);
        ResourceResolverFactory factory = adapter.newResourceResolverFactory();
        if (factory == null) {
            factory = MockSling.buildFactoryFromRepository(type.getNodeTypeMode(), bundleContext, adapter);
        } else {
            bundleContext.registerService(ResourceResolverFactory.class.getName(), (Object)factory, null);
        }
        return factory;
    }

    @NotNull
    static ResourceResolverFactory buildFactoryFromRepository(@NotNull NodeTypeMode mode, @NotNull BundleContext bundleContext, ResourceResolverTypeAdapter adapter) {
        Object newSnapshot;
        Object existingSnapshot = SNAPSHOTS.get(adapter.getClass());
        SlingRepository repository = existingSnapshot == null ? adapter.newSlingRepository() : adapter.newSlingRepositoryFromSnapshot(existingSnapshot);
        ResourceResolverFactory factory = ResourceResolverFactoryInitializer.setUp(repository, bundleContext, existingSnapshot == null ? mode : NodeTypeMode.NOT_SUPPORTED);
        if (existingSnapshot == null && (newSnapshot = adapter.snapshot(repository)) != null) {
            SNAPSHOTS.putIfAbsent(adapter.getClass(), newSnapshot);
        }
        return factory;
    }

    private static ResourceResolverTypeAdapter getResourceResolverTypeAdapter(ResourceResolverType type, @NotNull BundleContext bundleContext) {
        try {
            Class<?> clazz = Class.forName(type.getResourceResolverTypeAdapterClass());
            try {
                Constructor<?> bundleContextConstructor = clazz.getConstructor(BundleContext.class);
                return (ResourceResolverTypeAdapter)bundleContextConstructor.newInstance(bundleContext);
            }
            catch (NoSuchMethodException ex) {
                return (ResourceResolverTypeAdapter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException("Unable to instantiate resourcer resolver: " + type.getResourceResolverTypeAdapterClass() + (String)(type.getArtifactCoordinates() != null ? ". Make sure this maven dependency is included: " + type.getArtifactCoordinates() : ""), ex);
        }
    }

    @NotNull
    public static ResourceResolver newResourceResolver(@NotNull ResourceResolverType type, @NotNull BundleContext bundleContext) {
        ResourceResolverFactory factory = MockSling.newResourceResolverFactory(type, bundleContext);
        try {
            return factory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException ex) {
            throw new RuntimeException("Mock resource resolver factory implementation seems to require login.", ex);
        }
    }

    @NotNull
    public static ResourceResolver newResourceResolver(@NotNull BundleContext bundleContext) {
        return MockSling.newResourceResolver(DEFAULT_RESOURCERESOLVER_TYPE, bundleContext);
    }

    @Deprecated(since="4.1.0")
    @NotNull
    public static SlingScriptHelper newSlingScriptHelper(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull BundleContext bundleContext) {
        return new MockSlingScriptHelper(request, response, bundleContext);
    }

    @NotNull
    public static SlingScriptHelper newSlingScriptHelper(@NotNull SlingJakartaHttpServletRequest request, @NotNull SlingJakartaHttpServletResponse response, @NotNull BundleContext bundleContext) {
        return new MockSlingScriptHelper(request, response, bundleContext);
    }

    @Deprecated(since="4.1.0")
    @NotNull
    public static SlingScriptHelper newSlingScriptHelper(@NotNull BundleContext bundleContext) {
        MockSlingJakartaHttpServletRequest jakartaRequest = new MockSlingJakartaHttpServletRequest(MockSling.newResourceResolver(bundleContext), bundleContext);
        MockSlingHttpServletRequest javaxRequest = new MockSlingHttpServletRequest(jakartaRequest);
        MockSlingJakartaHttpServletResponse jakartaResponse = new MockSlingJakartaHttpServletResponse();
        MockSlingHttpServletResponse javaxResponse = new MockSlingHttpServletResponse(jakartaResponse);
        return MockSling.newSlingScriptHelper((SlingHttpServletRequest)javaxRequest, (SlingHttpServletResponse)javaxResponse, bundleContext);
    }

    @NotNull
    public static SlingScriptHelper newJakartaSlingScriptHelper(@NotNull BundleContext bundleContext) {
        MockSlingJakartaHttpServletRequest request = new MockSlingJakartaHttpServletRequest(MockSling.newResourceResolver(bundleContext), bundleContext);
        MockSlingJakartaHttpServletResponse response = new MockSlingJakartaHttpServletResponse();
        return MockSling.newSlingScriptHelper((SlingJakartaHttpServletRequest)request, (SlingJakartaHttpServletResponse)response, bundleContext);
    }

    public static void setAdapterManagerBundleContext(@NotNull BundleContext bundleContext) {
        ADAPTER_MANAGER.setBundleContext(bundleContext);
    }

    public static void clearAdapterManagerBundleContext() {
        ADAPTER_MANAGER.clearBundleContext();
    }

    static {
        SlingAdaptable.setAdapterManager((AdapterManager)ADAPTER_MANAGER);
    }
}

