/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.util.classloaderurl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ClassLoaderUrlConnection
extends URLConnection {
    private final ClassLoader classLoader;

    protected ClassLoaderUrlConnection(ClassLoader classLoader, URL url) {
        super(url);
        this.classLoader = classLoader;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream input = this.classLoader.getResourceAsStream(this.url.getFile());
        if (input == null) {
            throw new IOException("Could not load resource '" + this.url.getFile() + "' from classLoader '" + this.classLoader + "'");
        }
        return input;
    }
}

