/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.AccessType;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.impl.VaultFileNode;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultFileImpl
implements VaultFile {
    protected static Logger log = LoggerFactory.getLogger(VaultFileImpl.class);
    private final VaultFileSystem fs;
    private final String name;
    private Artifact artifact;
    private VaultFileNode node;
    private VaultFileImpl parent;
    private LinkedHashMap<String, VaultFileNode> pendingChildNodes;
    private LinkedHashMap<String, VaultFileImpl> children;

    protected VaultFileImpl(VaultFileSystem fs, String rootPath, VaultFileNode node) throws RepositoryException {
        this.fs = fs;
        this.node = node;
        if (rootPath.equals("")) {
            this.name = rootPath;
            for (Artifact a : node.getAggregate().getArtifacts().values()) {
                if (a.getType() == ArtifactType.DIRECTORY) {
                    this.artifact = a;
                    node.getFiles().add(this);
                    continue;
                }
                VaultFileImpl child = new VaultFileImpl(fs, a.getPlatformPath(), node, a);
                node.getFiles().add(child);
                this.addChild(child);
            }
        } else {
            this.name = rootPath;
            for (Artifact a : node.getAggregate().getArtifacts().values()) {
                if (a.getType() == ArtifactType.DIRECTORY) {
                    this.artifact = a;
                    node.getFiles().add(this);
                    continue;
                }
                String[] p = Text.explode((String)a.getPlatformPath(), (int)47);
                VaultFileImpl entry = null;
                for (String cName : p) {
                    entry = entry == null ? this : entry.getOrAddChild(cName);
                }
                if (entry != null && entry != this) {
                    entry.init(node, a);
                }
                node.getFiles().add(entry);
            }
        }
        for (VaultFileNode child : node.getChildren()) {
            this.addPendingNode(child);
        }
    }

    protected VaultFileImpl(VaultFileSystem fs, String name, VaultFileNode node, Artifact artifact) throws RepositoryException {
        this.fs = fs;
        this.name = name;
        this.init(node, artifact);
    }

    protected void init(VaultFileNode node, Artifact a) throws RepositoryException {
        this.children = null;
        this.pendingChildNodes = null;
        this.node = node;
        this.artifact = a;
        if (node != null && a != null && a.getType() == ArtifactType.DIRECTORY) {
            for (VaultFileNode child : node.getChildren()) {
                this.addPendingNode(child);
            }
        }
    }

    protected void attach(VaultFileNode node, Artifact a) {
        this.node = node;
        this.artifact = a;
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return this.name.length() == 0 ? "/" : this.name;
        }
        return this.internalGetPath().toString();
    }

    @Override
    public String getRepoRelPath() {
        if (this.artifact == null) {
            return null;
        }
        String relPath = this.artifact.getRelativePath();
        int idx = relPath.indexOf(47);
        if (idx > 0 && idx < relPath.length() - 1) {
            return relPath.substring(idx + 1);
        }
        return "";
    }

    @Override
    public String getAggregatePath() {
        return this.node == null ? this.parent.getAggregatePath() : this.node.getPath();
    }

    private StringBuffer internalGetPath() {
        if (this.parent == null) {
            return new StringBuffer(this.name);
        }
        return this.parent.internalGetPath().append('/').append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean isDirectory() {
        return this.artifact == null || this.artifact.getType() == ArtifactType.DIRECTORY;
    }

    @Override
    public boolean isTransient() {
        return this.node == null;
    }

    @Override
    public VaultFileImpl getParent() throws IOException, RepositoryException {
        return this.parent;
    }

    @Override
    public Aggregate getAggregate() {
        return this.node == null ? null : this.node.getAggregate();
    }

    @Override
    public Aggregate getControllingAggregate() {
        if (this.node == null && this.parent != null) {
            return this.parent.getControllingAggregate();
        }
        return this.node == null ? null : this.node.getAggregate();
    }

    @Override
    public VaultFileImpl getChild(String name) throws RepositoryException {
        VaultFileImpl child;
        VaultFileImpl vaultFileImpl = child = this.children == null ? null : this.children.get(name);
        if (child == null) {
            String repoName = PlatformNameFormat.getRepositoryName(name);
            this.loadPendingNode(repoName);
            VaultFileImpl vaultFileImpl2 = child = this.children == null ? null : this.children.get(name);
            if (child == null) {
                this.loadChildren();
            }
            child = this.children == null ? null : this.children.get(name);
        }
        return child;
    }

    @Override
    public Collection<? extends VaultFile> getChildren() throws RepositoryException {
        this.loadChildren();
        return this.children.values();
    }

    private void loadChildren() throws RepositoryException {
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        if (this.pendingChildNodes != null) {
            Iterator<String> iter = this.pendingChildNodes.keySet().iterator();
            while (iter.hasNext()) {
                this.loadPendingNode(iter.next());
                iter = this.pendingChildNodes.keySet().iterator();
            }
        }
    }

    protected void addPendingNode(VaultFileNode n) throws RepositoryException {
        if (this.pendingChildNodes == null) {
            this.pendingChildNodes = new LinkedHashMap();
        }
        String name = n.getName();
        this.pendingChildNodes.put(name, n);
        if (name.indexOf(47) > 0) {
            this.loadPendingNode(name);
        }
    }

    private void loadPendingNode(String repoName) throws RepositoryException {
        VaultFileNode n;
        VaultFileNode vaultFileNode = n = this.pendingChildNodes == null ? null : (VaultFileNode)this.pendingChildNodes.remove(repoName);
        if (n == null) {
            return;
        }
        VaultFileImpl parent = this;
        String aggName = n.getAggregate().getRelPath();
        if (aggName.indexOf(47) > 0) {
            String[] p = Text.explode((String)aggName, (int)47);
            for (int i = 0; i < p.length - 1; ++i) {
                parent = parent.getOrAddChild(PlatformNameFormat.getPlatformName(p[i]));
            }
        }
        for (Artifact a : n.getAggregate().getArtifacts().values()) {
            String[] p = Text.explode((String)a.getPlatformPath(), (int)47);
            VaultFileImpl entry = parent;
            for (String cName : p) {
                entry = entry.getOrAddChild(cName);
            }
            entry.init(n, a);
            n.getFiles().add(entry);
        }
    }

    private void addChild(VaultFileImpl child) {
        child.parent = this;
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        this.children.put(child.name, child);
    }

    protected VaultFileImpl getOrAddChild(String name) throws RepositoryException {
        VaultFileImpl c;
        VaultFileImpl vaultFileImpl = c = this.children == null ? null : this.children.get(name);
        if (c == null) {
            c = new VaultFileImpl(this.fs, name, null, null);
            this.addChild(c);
        }
        return c;
    }

    @Override
    public Collection<? extends VaultFile> getRelated() throws RepositoryException {
        if (this.node == null) {
            return null;
        }
        return this.node.getFiles();
    }

    @Override
    public boolean canRead() {
        return this.artifact != null && this.artifact.getPreferredAccess() != AccessType.NONE;
    }

    @Override
    public long lastModified() {
        return this.artifact == null ? 0L : this.artifact.getLastModified();
    }

    @Override
    public long length() {
        return this.artifact == null ? -1L : this.artifact.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.artifact == null ? null : this.artifact.getContentType();
    }

    @Override
    public VaultFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public void invalidate() throws RepositoryException {
        log.info("invalidating file {}", (Object)this.getPath());
        if (this.parent == null) {
            this.node.invalidate();
            for (Artifact a : this.node.getAggregate().getArtifacts().values()) {
                if (a.getType() == ArtifactType.DIRECTORY) {
                    this.artifact = a;
                    this.node.getFiles().add(this);
                    continue;
                }
                VaultFileImpl child = new VaultFileImpl(this.fs, a.getPlatformPath(), this.node, a);
                this.node.getFiles().add(child);
                this.addChild(child);
            }
            for (VaultFileNode child : this.node.getChildren()) {
                this.addPendingNode(child);
            }
        } else {
            for (VaultFileImpl f : this.node.getFiles()) {
                if (f.parent == null || f.parent.artifact.getType() != ArtifactType.DIRECTORY) continue;
                f.parent.node.invalidate();
                f.parent.init(f.parent.node, f.parent.artifact);
                break;
            }
        }
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "Vault file");
        ctx.indent(isLast);
        ctx.printf(false, "name: %s", this.name);
        ctx.printf(false, "path: %s", this.getPath());
        ctx.printf(false, "# pending: %d", this.pendingChildNodes == null ? -1 : this.pendingChildNodes.size());
        ctx.printf(false, "# children: %d", this.children == null ? -1 : this.children.size());
        if (this.artifact != null) {
            this.artifact.dump(ctx, false);
        } else {
            ctx.println(false, "Artifact: (null)");
        }
        if (this.node != null) {
            this.node.dump(ctx, true);
        } else {
            ctx.println(true, "ArtifactsNode: (null)");
        }
        ctx.outdent();
    }
}

