/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultCoupledResource;
import org.apache.sis.metadata.iso.identification.DefaultOperationChainMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.metadata.code.SV_CouplingType;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

@XmlType(name="SV_ServiceIdentification_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"serviceType", "serviceTypeVersions", "accessProperties", "couplingType", "coupledResources", "operatedDataset", "profile", "serviceStandard", "containsOperations", "operatesOn", "operationChain"})
@XmlRootElement(name="SV_ServiceIdentification", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public class DefaultServiceIdentification
extends AbstractIdentification
implements ServiceIdentification {
    private static final long serialVersionUID = 7700836694236616300L;
    private GenericName serviceType;
    private Collection<String> serviceTypeVersions;
    private StandardOrderProcess accessProperties;
    private CodeList<?> couplingType;
    private Collection<DefaultCoupledResource> coupledResources;
    private Collection<Citation> operatedDatasets;
    private Collection<Citation> profiles;
    private Collection<Citation> serviceStandards;
    private Collection<DefaultOperationMetadata> containsOperations;
    private Collection<DataIdentification> operatesOn;
    private Collection<DefaultOperationChainMetadata> containsChain;

    public DefaultServiceIdentification() {
    }

    public DefaultServiceIdentification(GenericName serviceType, Citation citation, CharSequence abstracts) {
        super(citation, abstracts);
        this.serviceType = serviceType;
    }

    public DefaultServiceIdentification(ServiceIdentification object) {
        super((Identification)object);
        if (object instanceof DefaultServiceIdentification) {
            DefaultServiceIdentification c = (DefaultServiceIdentification)object;
            this.serviceType = c.getServiceType();
            this.serviceTypeVersions = DefaultServiceIdentification.copyCollection(c.getServiceTypeVersions(), String.class);
            this.accessProperties = c.getAccessProperties();
            this.couplingType = c.getCouplingType();
            this.coupledResources = DefaultServiceIdentification.copyCollection(c.getCoupledResources(), DefaultCoupledResource.class);
            this.operatedDatasets = DefaultServiceIdentification.copyCollection(c.getOperatedDatasets(), Citation.class);
            this.profiles = DefaultServiceIdentification.copyCollection(c.getProfiles(), Citation.class);
            this.serviceStandards = DefaultServiceIdentification.copyCollection(c.getServiceStandards(), Citation.class);
            this.containsOperations = DefaultServiceIdentification.copyCollection(c.getContainsOperations(), DefaultOperationMetadata.class);
            this.operatesOn = DefaultServiceIdentification.copyCollection(c.getOperatesOn(), DataIdentification.class);
            this.containsChain = DefaultServiceIdentification.copyCollection(c.getContainsChain(), DefaultOperationChainMetadata.class);
        }
    }

    public static DefaultServiceIdentification castOrCopy(ServiceIdentification object) {
        if (object == null || object instanceof DefaultServiceIdentification) {
            return (DefaultServiceIdentification)object;
        }
        return new DefaultServiceIdentification(object);
    }

    @XmlElement(name="serviceType", required=true)
    @UML(identifier="serviceType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public GenericName getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(GenericName newValue) {
        this.checkWritePermission(this.serviceType);
        this.serviceType = newValue;
    }

    @XmlElement(name="serviceTypeVersion")
    @UML(identifier="serviceTypeVersion", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<String> getServiceTypeVersions() {
        this.serviceTypeVersions = this.nonNullCollection(this.serviceTypeVersions, String.class);
        return this.serviceTypeVersions;
    }

    public void setServiceTypeVersions(Collection<? extends String> newValues) {
        this.serviceTypeVersions = this.writeCollection(newValues, this.serviceTypeVersions, String.class);
    }

    @XmlElement(name="accessProperties")
    @UML(identifier="accessProperties", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public StandardOrderProcess getAccessProperties() {
        return this.accessProperties;
    }

    public void setAccessProperties(StandardOrderProcess newValue) {
        this.checkWritePermission(this.accessProperties);
        this.accessProperties = newValue;
    }

    @XmlJavaTypeAdapter(value=SV_CouplingType.class)
    @XmlElement(name="couplingType")
    @UML(identifier="couplingType", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getCouplingType() {
        return this.couplingType;
    }

    public void setCouplingType(CodeList<?> newValue) {
        this.checkWritePermission(this.couplingType);
        this.couplingType = newValue;
    }

    @XmlElement(name="coupledResource")
    @UML(identifier="coupledResource", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultCoupledResource> getCoupledResources() {
        this.coupledResources = this.nonNullCollection(this.coupledResources, DefaultCoupledResource.class);
        return this.coupledResources;
    }

    public void setCoupledResources(Collection<? extends DefaultCoupledResource> newValues) {
        this.coupledResources = this.writeCollection(newValues, this.coupledResources, DefaultCoupledResource.class);
    }

    @UML(identifier="operatedDataset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getOperatedDatasets() {
        this.operatedDatasets = this.nonNullCollection(this.operatedDatasets, Citation.class);
        return this.operatedDatasets;
    }

    public void setOperatedDatasets(Collection<? extends Citation> newValues) {
        this.operatedDatasets = this.writeCollection(newValues, this.operatedDatasets, Citation.class);
    }

    @UML(identifier="profile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getProfiles() {
        this.profiles = this.nonNullCollection(this.profiles, Citation.class);
        return this.profiles;
    }

    public void setProfiles(Collection<? extends Citation> newValues) {
        this.profiles = this.writeCollection(newValues, this.profiles, Citation.class);
    }

    @UML(identifier="serviceStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getServiceStandards() {
        this.serviceStandards = this.nonNullCollection(this.serviceStandards, Citation.class);
        return this.serviceStandards;
    }

    public void setServiceStandards(Collection<? extends Citation> newValues) {
        this.serviceStandards = this.writeCollection(newValues, this.serviceStandards, Citation.class);
    }

    @XmlElement(name="containsOperations")
    @UML(identifier="containsOperations", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultOperationMetadata> getContainsOperations() {
        this.containsOperations = this.nonNullCollection(this.containsOperations, DefaultOperationMetadata.class);
        return this.containsOperations;
    }

    public void setContainsOperations(Collection<? extends DefaultOperationMetadata> newValues) {
        this.containsOperations = this.writeCollection(newValues, this.containsOperations, DefaultOperationMetadata.class);
    }

    @XmlElement(name="operatesOn")
    @UML(identifier="operatesOn", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DataIdentification> getOperatesOn() {
        this.operatesOn = this.nonNullCollection(this.operatesOn, DataIdentification.class);
        return this.operatesOn;
    }

    public void setOperatesOn(Collection<? extends DataIdentification> newValues) {
        this.operatesOn = this.writeCollection(newValues, this.operatesOn, DataIdentification.class);
    }

    @UML(identifier="containsChain", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultOperationChainMetadata> getContainsChain() {
        this.containsChain = this.nonNullCollection(this.containsChain, DefaultOperationChainMetadata.class);
        return this.containsChain;
    }

    public void setContainsChain(Collection<? extends DefaultOperationChainMetadata> newValues) {
        this.containsChain = this.writeCollection(newValues, this.containsChain, DefaultOperationChainMetadata.class);
    }

    @XmlElement(name="operatedDataset")
    private Collection<Citation> getOperatedDataset() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getOperatedDatasets() : null;
    }

    @XmlElement(name="profile")
    private Collection<Citation> getProfile() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getProfiles() : null;
    }

    @XmlElement(name="serviceStandard")
    private Collection<Citation> getServiceStandard() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getServiceStandards() : null;
    }

    @XmlElement(name="containsChain")
    private Collection<DefaultOperationChainMetadata> getOperationChain() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getContainsChain() : null;
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.containsOperations != null && this.coupledResources != null) {
            OperationName.resolve(this.containsOperations, this.coupledResources);
        }
    }
}

