/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.sc;

import java.util.List;
import java.util.Map;
import org.apache.servicecomb.registry.api.AbstractDiscoveryInstance;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;

public class SCDiscoveryInstance
extends AbstractDiscoveryInstance {
    private final Microservice microservice;
    private final MicroserviceInstance microserviceInstance;
    private final Map<String, String> schemas;

    public SCDiscoveryInstance(MicroserviceInstance microserviceInstance, Map<String, String> schemas) {
        this.microservice = microserviceInstance.getMicroservice();
        this.microserviceInstance = microserviceInstance;
        this.schemas = schemas;
    }

    public MicroserviceInstanceStatus getStatus() {
        return MicroserviceInstanceStatus.valueOf((String)this.microserviceInstance.getStatus().name());
    }

    public String getRegistryName() {
        return "sc-registry";
    }

    public String getEnvironment() {
        return this.microservice.getEnvironment();
    }

    public String getApplication() {
        return this.microservice.getAppId();
    }

    public String getServiceName() {
        return this.microservice.getServiceName();
    }

    public String getAlias() {
        return this.microservice.getAlias();
    }

    public String getVersion() {
        return this.microservice.getVersion();
    }

    public DataCenterInfo getDataCenterInfo() {
        if (this.microserviceInstance.getDataCenterInfo() != null) {
            return new DataCenterInfo(this.microserviceInstance.getDataCenterInfo().getName(), this.microserviceInstance.getDataCenterInfo().getRegion(), this.microserviceInstance.getDataCenterInfo().getAvailableZone());
        }
        return new DataCenterInfo();
    }

    public String getDescription() {
        return this.microservice.getDescription();
    }

    public Map<String, String> getProperties() {
        return this.microserviceInstance.getProperties();
    }

    public Map<String, String> getSchemas() {
        return this.schemas;
    }

    public List<String> getEndpoints() {
        return this.microserviceInstance.getEndpoints();
    }

    public String getInstanceId() {
        return this.microserviceInstance.getInstanceId();
    }

    public String getServiceId() {
        return this.microservice.getServiceId();
    }
}

