/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.shareddata.Shareable;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultVertxMetricsFactory;
import org.apache.servicecomb.foundation.vertx.metrics.MetricsOptionsEx;
import org.springframework.core.env.Environment;

public class SharedVertxFactory {
    private static final String LOCAL_MAP_NAME = "scb";
    private static final String INFO = "transport-vertx-info";

    public static DefaultVertxMetricsFactory getMetricsFactory(Environment environment) {
        SharedVertxInfo info = (SharedVertxInfo)SharedVertxFactory.getSharedVertx(environment).sharedData().getLocalMap(LOCAL_MAP_NAME).get((Object)INFO);
        return info.metricsFactory;
    }

    public static Vertx getSharedVertx(Environment environment) {
        return VertxUtils.getVertxMap().computeIfAbsent("transport", key -> SharedVertxFactory.createSharedVertx(environment, key));
    }

    private static Vertx createSharedVertx(Environment environment, String name) {
        SharedVertxInfo info = new SharedVertxInfo(environment);
        Vertx vertx = VertxUtils.init(name, info.vertxOptions);
        info.metricsFactory.setVertx(vertx, info.vertxOptions);
        vertx.sharedData().getLocalMap(LOCAL_MAP_NAME).put((Object)INFO, (Object)info);
        return vertx;
    }

    static class SharedVertxInfo
    implements Shareable {
        public VertxOptions vertxOptions = new VertxOptions();
        public DefaultVertxMetricsFactory metricsFactory = new DefaultVertxMetricsFactory();
        public MetricsOptionsEx metricsOptionsEx = (MetricsOptionsEx)this.metricsFactory.newOptions();

        public SharedVertxInfo(Environment environment) {
            this.vertxOptions.setMetricsOptions((MetricsOptions)this.metricsOptionsEx);
            this.vertxOptions.setEventLoopPoolSize(SharedVertxInfo.readEventLoopPoolSize(environment, "servicecomb.transport.eventloop.size"));
        }

        private static int readEventLoopPoolSize(Environment environment, String key) {
            int count = (Integer)environment.getProperty(key, Integer.TYPE, (Object)-1);
            if (count > 0) {
                return count;
            }
            return VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE;
        }
    }
}

