/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetOptions$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.RebaseSpec;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.RebaseSpec$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$
implements PredicateHelper {
    public static DataSourceUtils$ MODULE$;
    private final String SPARK_VERSION_METADATA_KEY;
    private final String SPARK_TIMEZONE_METADATA_KEY;
    private final String SPARK_LEGACY_DATETIME_METADATA_KEY;
    private final String SPARK_LEGACY_INT96_METADATA_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSourceUtils$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String SPARK_VERSION_METADATA_KEY() {
        return this.SPARK_VERSION_METADATA_KEY;
    }

    public String SPARK_TIMEZONE_METADATA_KEY() {
        return this.SPARK_TIMEZONE_METADATA_KEY;
    }

    public String SPARK_LEGACY_DATETIME_METADATA_KEY() {
        return this.SPARK_LEGACY_DATETIME_METADATA_KEY;
    }

    public String SPARK_LEGACY_INT96_METADATA_KEY() {
        return this.SPARK_LEGACY_INT96_METADATA_KEY;
    }

    /*
     * Unable to fully structure code
     */
    private RebaseSpec getRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig, String minVersion, String metadataKey) {
        if (!Utils$.MODULE$.isTesting()) ** GOTO lbl-1000
        v0 = PortableSQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
        var7_5 = "true";
        if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
            v1 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        } else lbl-1000:
        // 2 sources

        {
            v1 = (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)this.SPARK_VERSION_METADATA_KEY())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getRebaseSpec$1(java.lang.String scala.Function1 java.lang.String java.lang.String ), (Ljava/lang/String;)Lscala/Enumeration$Value;)((String)minVersion, lookupFileMeta, (String)metadataKey)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getRebaseSpec$2(java.lang.String ), ()Lscala/Enumeration$Value;)((String)modeByConfig));
        }
        var8_7 = policy = v1;
        v2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        var9_8 = var8_7;
        var5_9 = !(v2 != null ? v2.equals(var9_8) == false : var9_8 != null) ? new RebaseSpec(LegacyBehaviorPolicy$.MODULE$.LEGACY(), (Option<String>)Option$.MODULE$.apply(lookupFileMeta.apply((Object)this.SPARK_TIMEZONE_METADATA_KEY()))) : new RebaseSpec(policy, RebaseSpec$.MODULE$.apply$default$2());
        return var5_9;
    }

    public RebaseSpec datetimeRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.0.0", this.SPARK_LEGACY_DATETIME_METADATA_KEY());
    }

    public RebaseSpec int96RebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.1.0", this.SPARK_LEGACY_INT96_METADATA_KEY());
    }

    public RuntimeException newRebaseExceptionInRead(String format) {
        Tuple2 tuple2;
        String string = format;
        if ("Parquet INT96".equals(string)) {
            tuple2 = new Tuple2((Object)PortableSQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.INT96_REBASE_MODE());
        } else if ("Parquet".equals(string)) {
            tuple2 = new Tuple2((Object)PortableSQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.DATETIME_REBASE_MODE());
        } else if ("Avro".equals(string)) {
            tuple2 = new Tuple2((Object)PortableSQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key(), (Object)"datetimeRebaseMode");
        } else {
            throw new IllegalStateException(new StringBuilder(21).append("Unrecognized format ").append(format).append(".").toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String config = (String)tuple22._1();
        String option = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)config, (Object)option);
        Tuple2 tuple24 = tuple23;
        String config2 = (String)tuple24._1();
        String option2 = (String)tuple24._2();
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInReadingDatesError(format, config2, option2);
    }

    public RuntimeException newRebaseExceptionInWrite(String format) {
        String string;
        String string2 = format;
        if ("Parquet INT96".equals(string2)) {
            string = PortableSQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
        } else if ("Parquet".equals(string2)) {
            string = PortableSQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key();
        } else if ("Avro".equals(string2)) {
            string = PortableSQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key();
        } else {
            throw new IllegalStateException(new StringBuilder(21).append("Unrecognized format ").append(format).append(".").toString());
        }
        String config = string;
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInWritingDatesError(format, config);
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
            } else {
                Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
            } else {
                Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(RebaseSpec rebaseSpec, String format) {
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseSpec.mode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$2 -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(rebaseSpec.timeZone(), x$2);
            } else {
                Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String timeZone = PortableSQLConf$.MODULE$.get().sessionLocalTimeZone();
                intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$3 -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timeZone, x$3);
            } else {
                Enumeration.Value value6 = LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$1(String minVersion$1, Function1 lookupFileMeta$1, String metadataKey$1, String version) {
        return new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)minVersion$1) || lookupFileMeta$1.apply((Object)metadataKey$1) != null ? LegacyBehaviorPolicy$.MODULE$.LEGACY() : LegacyBehaviorPolicy$.MODULE$.CORRECTED();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$2(String modeByConfig$1) {
        return LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig$1);
    }

    private DataSourceUtils$() {
        MODULE$ = this;
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.SPARK_VERSION_METADATA_KEY = "org.apache.spark.version";
        this.SPARK_TIMEZONE_METADATA_KEY = "org.apache.spark.timeZone";
        this.SPARK_LEGACY_DATETIME_METADATA_KEY = "org.apache.spark.legacyDateTime";
        this.SPARK_LEGACY_INT96_METADATA_KEY = "org.apache.spark.legacyINT96";
    }
}

