/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.viz.utils.Pixel;
import org.apache.sedona.viz.utils.RasterizationUtils;
import org.apache.spark.Partitioner;
import scala.Tuple2;

public class VisualizationPartitioner
extends Partitioner
implements Serializable {
    public int resolutionX;
    public int resolutionY;
    public int partitionX;
    public int partitionY;
    public int partitionIntervalX;
    public int partitionIntervalY;

    public VisualizationPartitioner(int resolutionX, int resolutionY, int partitionX, int partitionY) throws Exception {
        this.resolutionX = resolutionX;
        this.resolutionY = resolutionY;
        this.partitionX = partitionX;
        this.partitionY = partitionY;
        if (this.resolutionX % partitionX != 0 || this.resolutionY % partitionY != 0) {
            throw new Exception("[VisualizationPartitioner][Constructor] The given partition number fails to exactly divide the corresponding resolution axis.");
        }
        this.partitionIntervalX = this.resolutionX / this.partitionX;
        this.partitionIntervalY = this.resolutionY / this.partitionY;
    }

    public static int CalculatePartitionId(int resolutionX, int resolutionY, int partitionX, int partitionY, int coordinateX, int coordinateY) {
        Tuple2<Integer, Integer> partitionId2d = VisualizationPartitioner.Calculate2DPartitionId(resolutionX, resolutionY, partitionX, partitionY, coordinateX, coordinateY);
        int partitionId = -1;
        try {
            partitionId = RasterizationUtils.Encode2DTo1DId(partitionX, partitionY, (Integer)partitionId2d._1, (Integer)partitionId2d._2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return partitionId;
    }

    public static Tuple2<Integer, Integer> Calculate2DPartitionId(int resolutionX, int resolutionY, int partitionX, int partitionY, int coordinateX, int coordinateY) {
        int partitionIntervalX = resolutionX / partitionX;
        int partitionIntervalY = resolutionY / partitionY;
        int partitionCoordinateX = coordinateX / partitionIntervalX;
        int partitionCoordinateY = partitionY - 1 - coordinateY / partitionIntervalY;
        return new Tuple2((Object)partitionCoordinateX, (Object)partitionCoordinateY);
    }

    public int getPartition(Object key) {
        return ((Pixel)key).getCurrentPartitionId();
    }

    public int numPartitions() {
        return this.partitionX * this.partitionY;
    }

    public List<Tuple2<Pixel, Double>> assignPartitionIDs(Tuple2<Pixel, Double> pixelDoubleTuple2, int photoFilterRadius) {
        int[] boundaryCondition;
        ArrayList<Tuple2<Pixel, Double>> duplicatePixelList = new ArrayList<Tuple2<Pixel, Double>>();
        int partitionId = VisualizationPartitioner.CalculatePartitionId(this.resolutionX, this.resolutionY, this.partitionX, this.partitionY, (int)((Pixel)pixelDoubleTuple2._1).getX(), (int)((Pixel)pixelDoubleTuple2._1).getY());
        Pixel newPixel = new Pixel(((Pixel)pixelDoubleTuple2._1()).getX(), ((Pixel)pixelDoubleTuple2._1()).getY(), this.resolutionX, this.resolutionY);
        newPixel.setCurrentPartitionId(partitionId);
        newPixel.setDuplicate(false);
        duplicatePixelList.add(new Tuple2((Object)newPixel, (Object)((Double)pixelDoubleTuple2._2())));
        for (int x : boundaryCondition = new int[]{-1, 0, 1}) {
            for (int y : boundaryCondition) {
                int duplicatePartitionId = VisualizationPartitioner.CalculatePartitionId(this.resolutionX, this.resolutionY, this.partitionX, this.partitionY, (int)((Pixel)pixelDoubleTuple2._1()).getX() + x * photoFilterRadius, (int)((Pixel)pixelDoubleTuple2._1()).getY() + y * photoFilterRadius);
                if (duplicatePartitionId == partitionId || duplicatePartitionId < 0) continue;
                Pixel newPixelDuplicate = new Pixel(((Pixel)pixelDoubleTuple2._1()).getX(), ((Pixel)pixelDoubleTuple2._1()).getY(), this.resolutionX, this.resolutionY);
                newPixelDuplicate.setCurrentPartitionId(duplicatePartitionId);
                newPixelDuplicate.setDuplicate(true);
                duplicatePixelList.add((Tuple2<Pixel, Double>)new Tuple2((Object)newPixelDuplicate, (Object)((Double)pixelDoubleTuple2._2())));
            }
        }
        return duplicatePixelList;
    }

    public Tuple2<Pixel, Double> assignPartitionID(Tuple2<Pixel, Double> pixelDoubleTuple2) {
        int partitionId = VisualizationPartitioner.CalculatePartitionId(this.resolutionX, this.resolutionY, this.partitionX, this.partitionY, (int)((Pixel)pixelDoubleTuple2._1).getX(), (int)((Pixel)pixelDoubleTuple2._1).getY());
        Pixel newPixel = (Pixel)pixelDoubleTuple2._1();
        newPixel.setCurrentPartitionId(partitionId);
        newPixel.setDuplicate(false);
        return new Tuple2((Object)newPixel, (Object)((Double)pixelDoubleTuple2._2()));
    }
}

