/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import java.util.List;
import java.util.Map;
import org.apache.sedona.shaded.antlr.Token;
import org.apache.sedona.shaded.antlr.tree.ParseTree;
import org.apache.sedona.shaded.jiffle.Jiffle;
import org.apache.sedona.shaded.jiffle.parser.ConstantLookup;
import org.apache.sedona.shaded.jiffle.parser.Errors;
import org.apache.sedona.shaded.jiffle.parser.GlobalScope;
import org.apache.sedona.shaded.jiffle.parser.JiffleParser;
import org.apache.sedona.shaded.jiffle.parser.LocalScope;
import org.apache.sedona.shaded.jiffle.parser.PropertyWorker;
import org.apache.sedona.shaded.jiffle.parser.Symbol;
import org.apache.sedona.shaded.jiffle.parser.SymbolScope;

public class VarWorker
extends PropertyWorker<SymbolScope> {
    private final GlobalScope globalScope = new GlobalScope();
    private SymbolScope currentScope = this.globalScope;

    public VarWorker(ParseTree tree, Map<String, Jiffle.ImageRole> imageParams) {
        super(tree);
        this.addImageVarsToGlobal(imageParams);
        this.walkTree();
        this.set(tree, this.globalScope);
    }

    private void addImageVarsToGlobal(Map<String, Jiffle.ImageRole> imageParams) {
        for (Map.Entry<String, Jiffle.ImageRole> e : imageParams.entrySet()) {
            String name = e.getKey();
            Symbol.Type type = e.getValue() == Jiffle.ImageRole.SOURCE ? Symbol.Type.SOURCE_IMAGE : Symbol.Type.DEST_IMAGE;
            this.globalScope.add(new Symbol(name, type));
        }
    }

    @Override
    public void exitScript(JiffleParser.ScriptContext ctx) {
        this.set(ctx, this.globalScope);
    }

    @Override
    public void enterBody(JiffleParser.BodyContext ctx) {
        this.pushScope(ctx, "pixel");
    }

    @Override
    public void exitBody(JiffleParser.BodyContext ctx) {
        this.popScope();
    }

    @Override
    public void exitInitBlock(JiffleParser.InitBlockContext ctx) {
        List<JiffleParser.VarDeclarationContext> vars = ctx.varDeclaration();
        for (JiffleParser.VarDeclarationContext var : vars) {
            Token tok = var.ID().getSymbol();
            String name = tok.getText();
            if (this.isImage(name)) {
                this.error(tok, Errors.IMAGE_VAR_INIT_BLOCK, name);
                continue;
            }
            if (this.currentScope.has(name)) {
                this.error(tok, Errors.DUPLICATE_VAR_DECL, name);
                continue;
            }
            this.currentScope.add(new Symbol(name, Symbol.Type.UNKNOWN));
        }
    }

    @Override
    public void enterBlock(JiffleParser.BlockContext ctx) {
        this.pushScope(ctx, "block");
    }

    @Override
    public void exitBlock(JiffleParser.BlockContext ctx) {
        this.popScope();
    }

    @Override
    public void enterForeachStmt(JiffleParser.ForeachStmtContext ctx) {
        this.pushScope(ctx, "foreach");
        Token tok = ctx.ID().getSymbol();
        String name = tok.getText();
        this.currentScope.add(new Symbol(name, Symbol.Type.LOOP_VAR));
    }

    @Override
    public void exitForeachStmt(JiffleParser.ForeachStmtContext ctx) {
        this.popScope();
    }

    @Override
    public void exitAssignment(JiffleParser.AssignmentContext ctx) {
        String name;
        Token tok = ctx.assignmentTarget().ID().getSymbol();
        if (this.isValidAssignment(ctx) && !this.currentScope.has(name = tok.getText())) {
            this.currentScope.add(new Symbol(name, Symbol.Type.UNKNOWN));
        }
    }

    @Override
    public void exitVarID(JiffleParser.VarIDContext ctx) {
        Token tok = ctx.ID().getSymbol();
        String name = tok.getText();
        if (!this.currentScope.has(name)) {
            this.error(tok, Errors.VAR_UNDEFINED, name);
        } else if (this.isDestImage(name)) {
            this.error(tok, Errors.READING_FROM_DEST_IMAGE, name);
        }
    }

    @Override
    public void exitListLiteral(JiffleParser.ListLiteralContext ctx) {
        super.exitListLiteral(ctx);
    }

    private boolean isValidAssignment(JiffleParser.AssignmentContext ctx) {
        Token tok = ctx.assignmentTarget().ID().getSymbol();
        JiffleParser.BandSpecifierContext bandSpecifier = ctx.assignmentTarget().bandSpecifier();
        String name = tok.getText();
        if (this.currentScope.has(name) && this.currentScope.get(name).getType() == Symbol.Type.SCALAR) {
            return true;
        }
        if (this.isLoopVar(name)) {
            this.error(tok, Errors.ASSIGNMENT_TO_LOOP_VAR, name);
        } else {
            if (this.isSourceImage(name)) {
                this.error(tok, Errors.WRITING_TO_SOURCE_IMAGE, name);
                return false;
            }
            if (this.isDestImage(name) && ctx.ASSIGN() == null) {
                this.error(tok, Errors.INVALID_ASSIGNMENT_OP_WITH_DEST_IMAGE, name);
                return false;
            }
            if (ConstantLookup.isDefined(name)) {
                this.error(tok, Errors.ASSIGNMENT_TO_CONSTANT, name);
                return false;
            }
            if (!this.isDestImage(name) && bandSpecifier != null) {
                this.error(tok, Errors.INVALID_ASSIGNMENT_NOT_DEST_IMAGE, name);
                return false;
            }
        }
        return true;
    }

    private void pushScope(ParseTree ctx, String newScopeLabel) {
        LocalScope scope = new LocalScope(newScopeLabel, this.currentScope);
        this.set(ctx, scope);
        this.currentScope = scope;
    }

    private void popScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    private void error(Token tok, Errors error, String varName) {
        this.messages.error(tok, (Object)((Object)error) + ": " + varName);
    }

    private boolean isImage(String name) {
        return this.isSourceImage(name) || this.isDestImage(name);
    }

    private boolean isSourceImage(String name) {
        if (this.globalScope.has(name)) {
            return this.globalScope.get(name).getType() == Symbol.Type.SOURCE_IMAGE;
        }
        return false;
    }

    private boolean isDestImage(String name) {
        if (this.globalScope.has(name)) {
            return this.globalScope.get(name).getType() == Symbol.Type.DEST_IMAGE;
        }
        return false;
    }

    private boolean isLoopVar(String name) {
        if (this.currentScope.has(name)) {
            return this.currentScope.get(name).getType() == Symbol.Type.LOOP_VAR;
        }
        return false;
    }
}

