/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2ContainsPointQuery;
import org.apache.sedona.shaded.s2.S2ContainsVertexQuery;
import org.apache.sedona.shaded.s2.S2Edge;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2IncidentEdgeTracker;
import org.apache.sedona.shaded.s2.S2IndexCellData;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Predicates;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.apache.sedona.shaded.s2.primitives.IntPairVector;
import org.apache.sedona.shaded.s2.primitives.IntVector;
import org.apache.sedona.shaded.s2.primitives.Ints;
import org.apache.sedona.shaded.s2.primitives.PooledList;
import org.apache.sedona.shaded.s2.primitives.Sorter;

public final class S2ValidationQueries {
    public static <E extends S2Edge> void sortEdgesCcw(final S2Point origin, final E first, final List<E> data) {
        Preconditions.checkArgument(first.getStart().equalsPoint(origin) || first.getEnd().equalsPoint(origin));
        final S2Point firstVertex = first.getStart().equalsPoint(origin) ? first.getEnd() : first.getStart();
        Preconditions.checkArgument(!firstVertex.equalsPoint(origin));
        for (S2Edge edge : data) {
            Preconditions.checkArgument(edge.getStart().equalsPoint(origin) || edge.getEnd().equalsPoint(origin));
        }
        Sorter.SortableCollection sortable = new Sorter.SortableCollection(){

            @Override
            public int size() {
                return data.size();
            }

            @Override
            public void truncate(int end) {
                if (end < data.size()) {
                    data.subList(end, data.size()).clear();
                }
            }

            @Override
            public boolean less(int leftIndex, int rightIndex) {
                S2Edge b;
                S2Edge a = (S2Edge)data.get(leftIndex);
                if (S2ValidationQueries.areEqual(a, b = (S2Edge)data.get(rightIndex))) {
                    return false;
                }
                if (S2ValidationQueries.areReversed(a, b)) {
                    return a.getStart().equalsPoint(origin);
                }
                if (S2ValidationQueries.areEqual(a, first)) {
                    return true;
                }
                if (S2ValidationQueries.areEqual(b, first)) {
                    return false;
                }
                S2Point aPoint = a.getStart().equalsPoint(origin) ? a.getEnd() : a.getStart();
                S2Point bPoint = b.getStart().equalsPoint(origin) ? b.getEnd() : b.getStart();
                return S2Predicates.orderedCCW(firstVertex, aPoint, bPoint, origin);
            }

            @Override
            public void swap(int leftIndex, int rightIndex) {
                S2Edge tmp = (S2Edge)data.get(leftIndex);
                data.set(leftIndex, (S2Edge)data.get(rightIndex));
                data.set(rightIndex, tmp);
            }
        };
        sortable.sort();
    }

    private static boolean areEqual(S2Edge a, S2Edge b) {
        return a.getStart().equalsPoint(b.getStart()) && a.getEnd().equalsPoint(b.getEnd());
    }

    private static boolean areReversed(S2Edge a, S2Edge b) {
        return a.getStart().equalsPoint(b.getEnd()) && a.getEnd().equalsPoint(b.getStart());
    }

    private static boolean validPoint(S2Point p) {
        return Double.isFinite(p.getX()) && Double.isFinite(p.getY()) && Double.isFinite(p.getZ());
    }

    private S2ValidationQueries() {
    }

    public static class S2LegacyValidQuery
    extends S2ValidQuery {
        public S2LegacyValidQuery() {
            this.options.setAllowDegenerateEdges(false).setAllowReverseDuplicates(false);
        }

        @Override
        protected boolean start(S2Error error) {
            if (!super.start(error)) {
                return false;
            }
            int dim = -1;
            for (S2Shape shape : this.index().getShapes()) {
                if (dim < 0) {
                    dim = shape.dimension();
                }
                if (dim == shape.dimension()) continue;
                error.init(S2Error.Code.INVALID_DIMENSION, "Mixed dimensional geometry is invalid for legacy semantics.", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkShape(S2Iterator<S2ShapeIndex.Cell> iter, S2Shape shape, int shapeId, S2Error error) {
            if (shape.dimension() == 2) {
                boolean hasEmptyLoops = false;
                for (int c = 0; c < shape.numChains(); ++c) {
                    int chainLength = shape.getChainLength(c);
                    if (chainLength == 0) {
                        hasEmptyLoops = true;
                        continue;
                    }
                    if (chainLength >= 3) continue;
                    error.init(S2Error.Code.LOOP_NOT_ENOUGH_VERTICES, "Shape %d has a non-empty chain with less than three edges.", shapeId);
                    return false;
                }
                if (hasEmptyLoops && shape.numChains() > 1) {
                    error.init(S2Error.Code.POLYGON_EMPTY_LOOP, "Shape %d has too many empty chains", shapeId);
                    return false;
                }
            }
            return super.checkShape(iter, shape, shapeId, error);
        }

        @Override
        protected boolean startCell(S2Error error) {
            S2IndexCellData cell = this.currentCell();
            for (S2ShapeIndex.S2ClippedShape clipped : cell.clippedShapes()) {
                List<S2IndexCellData.EdgeAndIdChain> edges = cell.shapeEdges(clipped.shapeId());
                for (int i = 0; i < edges.size(); ++i) {
                    for (int j = i + 1; j < edges.size(); ++j) {
                        if (edges.get(j).chainId() != edges.get(i).chainId() || !edges.get(j).start().equalsPoint(edges.get(i).start())) continue;
                        error.init(S2Error.Code.DUPLICATE_VERTICES, "Chain %d of shape %d has duplicate vertices", edges.get(i).chainId(), clipped.shapeId());
                        return false;
                    }
                }
            }
            return super.startCell(error);
        }
    }

    public static class S2ValidQuery
    extends S2ValidationQueryBase {
        private final PooledList<TestVertex> testVertices = new PooledList<TestVertex>(() -> new TestVertex());
        private final PooledList<EdgeWithInfo> edges = new PooledList<EdgeWithInfo>(() -> new EdgeWithInfo());
        private final IntPairVector chainSums = new IntPairVector();
        protected Options options = new Options();

        private static boolean permittedTouches(TouchTypePair allowed, TouchType typeA, TouchType typeB) {
            return allowed.first.matches(typeA) && allowed.second.matches(typeB);
        }

        public Options options() {
            return this.options;
        }

        @Override
        protected boolean checkShape(S2Iterator<S2ShapeIndex.Cell> iter, S2Shape shape, int shapeId, S2Error error) {
            int dim = shape.dimension();
            if (dim < 0 || dim > 2) {
                error.init(S2Error.Code.INVALID_DIMENSION, "Shape %d has invalid dimension: %d", shapeId, dim);
                return false;
            }
            IntVector chainsToCheck = new IntVector();
            S2Shape.MutableEdge prevEdge = new S2Shape.MutableEdge();
            S2Shape.MutableEdge currEdge = new S2Shape.MutableEdge();
            S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
            S2Shape.MutableEdge last = new S2Shape.MutableEdge();
            for (int chainId = 0; chainId < shape.numChains(); ++chainId) {
                List<S2Point> chain = shape.chain(chainId);
                int chainStart = shape.getChainStart(chainId);
                int chainLength = shape.getChainLength(chainId);
                if (dim == 2 && chain.size() > 0) {
                    int edgeId = shape.getChainStart(chainId);
                    shape.getEdge(edgeId, currEdge);
                    shape.getEdge(shape.prevEdgeWrap(edgeId), prevEdge);
                    if (!prevEdge.b.equalsPoint(currEdge.a)) {
                        error.init(S2Error.Code.LOOP_NOT_ENOUGH_VERTICES, "Chain %d of shape %d isn't closed", chainId, shapeId);
                        return false;
                    }
                }
                for (int offset = 0; offset < chainLength; ++offset) {
                    shape.getChainEdge(chainId, offset, edge);
                    if (!S2ValidationQueries.validPoint(edge.a) || !S2ValidationQueries.validPoint(edge.b)) {
                        error.init(S2Error.Code.INVALID_VERTEX, "Shape %d has invalid coordinates", shapeId);
                        return false;
                    }
                    if (!S2.isUnitLength(edge.a) || !S2.isUnitLength(edge.b)) {
                        error.init(S2Error.Code.NOT_UNIT_LENGTH, "Shape %d has non-unit length vertices", shapeId);
                        return false;
                    }
                    if (dim > 0 && !this.options().allowDegenerateEdges() && edge.isDegenerate()) {
                        error.init(S2Error.Code.DUPLICATE_VERTICES, "Shape %d: chain %d, edge %d is degenerate", shapeId, chainId, chainStart + offset);
                        return false;
                    }
                    if (edge.a.equalsPoint(edge.b.neg())) {
                        error.init(S2Error.Code.ANTIPODAL_VERTICES, "Shape %d has adjacent antipodal vertices", shapeId);
                        return false;
                    }
                    if (dim <= 0 || chain.size() < 2 || offset <= 0) continue;
                    shape.getChainEdge(chainId, offset - 1, last);
                    if (last.b.equalsPoint(edge.a)) continue;
                    error.init(S2Error.Code.NOT_CONTINUOUS, "Chain %d of shape %d has neighboring edges that don't connect.", chainId, shapeId);
                    return false;
                }
                if (dim != 2 || chain.size() == 0) continue;
                int uniqueCount = 1;
                shape.getChainEdge(chainId, 0, edge);
                S2Point first = edge.a;
                for (int i = 0; i < shape.getChainLength(chainId); ++i) {
                    S2Point vertex = shape.getChainVertex(chainId, i);
                    if (vertex.equalsPoint(first)) continue;
                    ++uniqueCount;
                    break;
                }
                if (uniqueCount == 1) continue;
                chainsToCheck.add(chainId);
            }
            Ints.OfInt chainsIter = chainsToCheck.intIterator();
            while (chainsIter.hasNext()) {
                int chainId = chainsIter.nextInt();
                if (this.checkChainOrientation(iter, shape, shapeId, chainId, error)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean startCell(S2Error error) {
            if (!this.checkForDuplicateEdges(error) || !this.checkForInteriorCrossings(error)) {
                return false;
            }
            return this.checkTouchesAreValid(error);
        }

        @Override
        protected boolean checkEdge(S2Shape shape, S2ShapeIndex.S2ClippedShape clipped, S2IndexCellData.EdgeAndIdChain edge, S2Error error) {
            int dim = shape.dimension();
            return dim != 0 || !this.pointContained(clipped.shapeId(), edge.start(), error);
        }

        @Override
        protected boolean finish(S2Error error) {
            for (Map.Entry entry : this.incidentEdges().entrySet()) {
                S2Shape shape = this.index().getShapes().get(((S2IncidentEdgeTracker.IncidentEdgeKey)entry.getKey()).shapeId);
                if (shape.dimension() != 2 || this.checkVertexCrossings(((S2IncidentEdgeTracker.IncidentEdgeKey)entry.getKey()).vertex, shape, ((S2IncidentEdgeTracker.IncidentEdgeKey)entry.getKey()).shapeId, (Iterable)entry.getValue(), error)) continue;
                return false;
            }
            S2ContainsPointQuery.Options options = new S2ContainsPointQuery.Options(S2ContainsPointQuery.S2VertexModel.OPEN);
            S2ContainsPointQuery query = new S2ContainsPointQuery(this.index(), options);
            for (int shapeId = 0; shapeId < this.index().getShapes().size(); ++shapeId) {
                S2Shape shape = this.index().getShapes().get(shapeId);
                if (shape == null || shape.dimension() == 0) continue;
                S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                for (int chain = 0; chain < shape.numChains(); ++chain) {
                    if (shape.getChainLength(chain) < 1) continue;
                    shape.getChainEdge(chain, 0, edge);
                    S2Point vertex = edge.a;
                    if (!query.contains(vertex)) continue;
                    error.init(S2Error.Code.OVERLAPPING_GEOMETRY, "Shape %d has one or more edges contained in another shape.", shapeId);
                    return false;
                }
            }
            return true;
        }

        private boolean checkVertexCrossings(S2Point vertex, S2Shape shape, int shapeId, Iterable<Integer> edgeIds, S2Error error) {
            this.edges.clear();
            S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
            S2Shape.ChainPosition pos = new S2Shape.ChainPosition();
            for (int edgeId : edgeIds) {
                shape.getChainPosition(edgeId, pos);
                shape.getEdge(edgeId, edge);
                this.edges.add().set(edge.a, edge.b, edgeId, pos.chainId, shape.prevEdgeWrap(edgeId), edge.a.equalsPoint(vertex) ? -1 : 1);
            }
            S2ValidQuery.sortCcw(vertex, this.edges);
            for (int i = 0; i < this.edges.size(); ++i) {
                int j;
                EdgeWithInfo curr = this.edges.get(i);
                if (curr.sign > 0) continue;
                this.chainSums.clear();
                for (j = 1; j < this.edges.size(); ++j) {
                    EdgeWithInfo edgeInfo = this.edges.get((i + j) % this.edges.size());
                    if (curr.chainId == edgeInfo.chainId && curr.prevEdgeId == edgeInfo.edgeId) {
                        for (int csi = 0; csi < this.chainSums.size(); ++csi) {
                            if (this.chainSums.getSecond(csi) == 0) continue;
                            error.init(S2Error.Code.OVERLAPPING_GEOMETRY, "Shape %d has one or more chains that cross at a vertex", shapeId);
                            return false;
                        }
                        break;
                    }
                    int chainSumIndex = S2ValidQuery.findOrAddFirst(this.chainSums, edgeInfo.chainId);
                    int sum = this.chainSums.getSecond(chainSumIndex) + edgeInfo.sign;
                    this.chainSums.setSecond(chainSumIndex, sum);
                }
                assert (j != this.edges.size());
            }
            return true;
        }

        private static int findOrAddFirst(IntPairVector pairVector, int firstValue) {
            int firstIndex = -1;
            for (int i = 0; i < pairVector.size(); ++i) {
                if (pairVector.getFirst(i) != firstValue) continue;
                firstIndex = i;
                break;
            }
            if (firstIndex == -1) {
                firstIndex = pairVector.size();
                pairVector.add(firstValue, 0);
            }
            return firstIndex;
        }

        public static void sortCcw(S2Point origin, PooledList<EdgeWithInfo> edges) {
            EdgeWithInfo first = edges.get(0);
            S2Point firstVertex = first.getStart().equalsPoint(origin) ? first.getEnd() : first.getStart();
            Preconditions.checkArgument(!firstVertex.equalsPoint(origin));
            for (EdgeWithInfo edge : edges) {
                Preconditions.checkArgument(edge.hasEndpoint(origin));
            }
            Comparator comparator = (a, b) -> {
                if (a.hasSamePoints((EdgeWithInfo)b)) {
                    return -1;
                }
                if (a.hasReversePoints((EdgeWithInfo)b)) {
                    return a.getStart().equalsPoint(origin) ? 1 : -1;
                }
                if (a.hasSamePoints(first)) {
                    return 1;
                }
                if (b.hasSamePoints(first)) {
                    return -1;
                }
                S2Point aPoint = a.getStart().equalsPoint(origin) ? a.getEnd() : a.getStart();
                S2Point bPoint = b.getStart().equalsPoint(origin) ? b.getEnd() : b.getStart();
                return S2Predicates.orderedCCW(firstVertex, aPoint, bPoint, origin) ? 1 : -1;
            };
            edges.sort(comparator);
        }

        private boolean pointContained(int shapeId, S2Point point, S2Error error) {
            S2IndexCellData cell = this.currentCell();
            for (S2ShapeIndex.S2ClippedShape clipped : cell.clippedShapes()) {
                S2Shape shape;
                if (clipped.shapeId() == shapeId || (shape = this.index().getShapes().get(clipped.shapeId())).dimension() != 2 || !cell.shapeContains(clipped, point)) continue;
                error.init(S2Error.Code.OVERLAPPING_GEOMETRY, "Shape %d has one or more edges contained in another shape.", shapeId);
                return true;
            }
            return false;
        }

        private boolean checkChainOrientation(S2Iterator<S2ShapeIndex.Cell> iter, S2Shape shape, int shapeId, int chainId, S2Error error) {
            int chainLength = shape.getChainLength(chainId);
            S2ContainsVertexQuery query = new S2ContainsVertexQuery();
            S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
            for (int offset = 0; offset < chainLength; ++offset) {
                S2Point vertex = shape.getChainVertex(chainId, offset);
                query.init(vertex);
                if (!iter.locate(vertex)) {
                    error.init(S2Error.Code.DATA_LOSS, "Shape vertex was not indexed", new Object[0]);
                    return false;
                }
                S2Point center = iter.id().toPoint();
                S2ShapeIndex.S2ClippedShape clipped = iter.entry().findClipped(shapeId);
                assert (clipped != null);
                int winding = clipped.containsCenter() ? 1 : 0;
                S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(center, vertex);
                for (int i = 0; i < clipped.numEdges(); ++i) {
                    shape.getEdge(clipped.edge(i), edge);
                    winding += crosser.signedEdgeOrVertexCrossing(edge.a, edge.b);
                    if (vertex.equalsPoint(edge.a)) {
                        query.addOutgoing(edge.b);
                        continue;
                    }
                    if (!vertex.equalsPoint(edge.b)) continue;
                    query.addIncoming(edge.a);
                }
                boolean duplicates = query.duplicateEdges();
                int sign = 0;
                if (!duplicates && (sign = query.containsSign()) == 0) continue;
                if (duplicates || winding != (sign < 0 ? 0 : 1)) {
                    error.init(S2Error.Code.POLYGON_INCONSISTENT_LOOP_ORIENTATIONS, "Shape %d has one or more edges with interior on the right.", shapeId);
                    return false;
                }
                return true;
            }
            return true;
        }

        private boolean checkForDuplicateEdges(S2Error error) {
            int dim0 = this.options().allowDuplicatePolylineEdges() ? 2 : 1;
            int dim1 = 2;
            List<S2IndexCellData.EdgeAndIdChain> edges = this.currentCell().dimRangeEdges(dim0, dim1);
            int numEdges = edges.size();
            for (int i = 0; i < numEdges; ++i) {
                for (int j = i + 1; j < numEdges; ++j) {
                    boolean duplicate = edges.get(i).isEqualTo(edges.get(j));
                    if (!this.options().allowReverseDuplicates()) {
                        duplicate |= edges.get(i).isReverseOf(edges.get(j));
                    }
                    if (!duplicate) continue;
                    error.init(S2Error.Code.OVERLAPPING_GEOMETRY, "One or more duplicate polygon edges detected", new Object[0]);
                    return false;
                }
            }
            return true;
        }

        private boolean checkForInteriorCrossings(S2Error error) {
            List<S2IndexCellData.EdgeAndIdChain> edges = this.currentCell().dimRangeEdges(1, 2);
            int checkStart = 0;
            if (this.options().allowPolylineInteriorCrossings()) {
                checkStart = this.currentCell().dimEdges(1).size();
            }
            if (checkStart >= edges.size()) {
                return true;
            }
            int numEdges = edges.size();
            int i = 0;
            while (i + 1 < numEdges) {
                int j;
                if (edges.get(i).end().equalsPoint(edges.get(j).start()) && ++j >= numEdges) break;
                S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(edges.get(i).start(), edges.get(i).end());
                for (j = Math.max(checkStart, i + 1); j < numEdges; ++j) {
                    if (crosser.c() == null || !crosser.c().equalsPoint(edges.get(j).start())) {
                        crosser.restartAt(edges.get(j).start());
                    }
                    if (crosser.robustCrossing(edges.get(j).end()) <= 0) continue;
                    error.init(S2Error.Code.OVERLAPPING_GEOMETRY, "Chain %d edge %d crosses chain %d edge %d", edges.get(i).chainId(), edges.get(i).offset(), edges.get(i).chainId(), edges.get(i).offset());
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean checkTouchesAreValid(S2Error error) {
            boolean[] needDim = new boolean[]{true, true, true};
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    TouchTypePair allowed = this.options().allowedTouches(i, j);
                    boolean anyAllowed = allowed.isEqualTo(TouchTypePair.ANY_TO_ANY);
                    int n = i;
                    needDim[n] = needDim[n] & !anyAllowed;
                }
            }
            if (!(needDim[0] || needDim[1] || needDim[2])) {
                return true;
            }
            this.testVertices.clear();
            for (S2ShapeIndex.S2ClippedShape clipped : this.currentCell().clippedShapes()) {
                int shapeId = clipped.shapeId();
                S2Shape shape = this.index().getShapes().get(shapeId);
                int dim = shape.dimension();
                if (!needDim[dim]) continue;
                for (S2IndexCellData.EdgeAndIdChain edge : this.currentCell().shapeEdges(shapeId)) {
                    if (dim == 1) {
                        boolean onBoundary = S2ValidQuery.polylineVertexIsBoundaryPoint(shape, edge, 0);
                        this.testVertices.add().set(edge.start(), edge.edgeId(), shapeId, dim, onBoundary);
                        onBoundary = S2ValidQuery.polylineVertexIsBoundaryPoint(shape, edge, 1);
                        if (!onBoundary) continue;
                        this.testVertices.add().set(edge.end(), edge.edgeId(), shapeId, dim, true);
                        continue;
                    }
                    this.testVertices.add().set(edge.start(), edge.edgeId(), shapeId, dim, dim == 2);
                }
            }
            for (TestVertex testPoint : this.testVertices) {
                for (S2ShapeIndex.S2ClippedShape clipped : this.currentCell().clippedShapes()) {
                    int shapeId = clipped.shapeId();
                    S2Shape shape = this.index().getShapes().get(shapeId);
                    int dim = shape.dimension();
                    for (S2IndexCellData.EdgeAndIdChain edge : this.currentCell().shapeEdges(shapeId)) {
                        TouchTypePair allowed;
                        boolean onBoundary;
                        if (testPoint.shapeId == shapeId && testPoint.edgeId == edge.edgeId()) continue;
                        int vertIndex = -1;
                        if (testPoint.vertex.equalsPoint(edge.start())) {
                            vertIndex = 0;
                        }
                        if (testPoint.vertex.equalsPoint(edge.end())) {
                            vertIndex = 1;
                        }
                        if (vertIndex < 0 || testPoint.shapeId == shapeId && dim == 1 && (vertIndex == 0 && shape.prevEdgeWrap(edge.edgeId()) == testPoint.edgeId || vertIndex == 1 && shape.nextEdgeWrap(edge.edgeId()) == testPoint.edgeId)) continue;
                        boolean bl = onBoundary = dim == 2;
                        if (dim == 1) {
                            onBoundary = S2ValidQuery.polylineVertexIsBoundaryPoint(shape, edge, vertIndex);
                        }
                        TouchType typeA = TouchType.INTERIOR;
                        if (testPoint.onBoundary) {
                            typeA = TouchType.BOUNDARY;
                        }
                        TouchType typeB = TouchType.INTERIOR;
                        if (onBoundary) {
                            typeB = TouchType.BOUNDARY;
                        }
                        if (S2ValidQuery.permittedTouches(allowed = this.options().allowedTouches(testPoint.dim, dim), typeA, typeB) || S2ValidQuery.permittedTouches(allowed, typeB, typeA)) continue;
                        error.init(S2Error.Code.OVERLAPPING_GEOMETRY, "Index has geometry with invalid vertex touches.", new Object[0]);
                        return false;
                    }
                }
            }
            return true;
        }

        private static boolean polylineVertexIsBoundaryPoint(S2Shape shape, S2IndexCellData.EdgeAndIdChain edge, int vertex) {
            assert (vertex == 0 || vertex == 1);
            if (edge.offset() == 0 && vertex == 0) {
                return shape.prevEdgeWrap(edge.edgeId()) == -1;
            }
            if (edge.offset() == shape.getChainLength(edge.chainId()) - 1 && vertex == 1) {
                return shape.nextEdgeWrap(edge.edgeId()) == -1;
            }
            return false;
        }

        protected static class Options {
            private boolean allowDegenerateEdges = true;
            private boolean allowDuplicatePolylineEdges = true;
            private boolean allowReverseDuplicates = true;
            private boolean allowPolylineIntgeriorCrossings = true;
            private final ArrayList<ArrayList<TouchTypePair>> allowedTouches = new ArrayList();

            public Options() {
                for (int i = 0; i < 3; ++i) {
                    this.allowedTouches.add(new ArrayList());
                    ArrayList<TouchTypePair> row = this.allowedTouches.get(i);
                    for (int j = 0; j < 3; ++j) {
                        row.add(TouchTypePair.ANY_TO_ANY);
                    }
                }
            }

            public TouchTypePair allowedTouches(int dima, int dimb) {
                Preconditions.checkArgument(dima >= 0);
                Preconditions.checkArgument(dima <= 2);
                Preconditions.checkArgument(dimb >= 0);
                Preconditions.checkArgument(dimb <= 2);
                if (dima > dimb) {
                    int tmp = dima;
                    dima = dimb;
                    dimb = tmp;
                }
                return this.allowedTouches.get(dima).get(dimb);
            }

            @CanIgnoreReturnValue
            public Options setAllowedTouches(int dima, int dimb, TouchTypePair types) {
                assert (0 <= dima && dima <= 2);
                assert (0 <= dimb && dimb <= 2);
                if (dima > dimb) {
                    int tmp = dima;
                    dima = dimb;
                    dimb = tmp;
                }
                this.allowedTouches.get(dima).set(dimb, types);
                return this;
            }

            @CanIgnoreReturnValue
            public Options setNoPointTouchesAllowed() {
                for (int i = 0; i < 3; ++i) {
                    this.setAllowedTouches(0, i, TouchTypePair.of(TouchType.NONE, TouchType.NONE));
                }
                return this;
            }

            public boolean allowDuplicatePolylineEdges() {
                return this.allowDuplicatePolylineEdges;
            }

            @CanIgnoreReturnValue
            public Options setAllowDuplicatePolylineEdges(boolean flag) {
                this.allowDuplicatePolylineEdges = flag;
                return this;
            }

            public boolean allowPolylineInteriorCrossings() {
                return this.allowPolylineIntgeriorCrossings;
            }

            @CanIgnoreReturnValue
            public Options setAllowPolylineInteriorCrossings(boolean flag) {
                this.allowPolylineIntgeriorCrossings = flag;
                return this;
            }

            public boolean allowReverseDuplicates() {
                return this.allowReverseDuplicates;
            }

            @CanIgnoreReturnValue
            public Options setAllowReverseDuplicates(boolean flag) {
                this.allowReverseDuplicates = flag;
                return this;
            }

            public boolean allowDegenerateEdges() {
                return this.allowDegenerateEdges;
            }

            @CanIgnoreReturnValue
            public Options setAllowDegenerateEdges(boolean flag) {
                this.allowDegenerateEdges = flag;
                return this;
            }
        }

        protected static class TouchTypePair {
            public static final TouchTypePair ANY_TO_ANY = TouchTypePair.of(TouchType.ANY, TouchType.ANY);
            final TouchType first;
            final TouchType second;

            public TouchTypePair(TouchType first, TouchType second) {
                this.first = first;
                this.second = second;
            }

            public static TouchTypePair of(TouchType first, TouchType second) {
                return new TouchTypePair(first, second);
            }

            public boolean isEqualTo(TouchTypePair other) {
                return this.first.equals((Object)other.first) && this.second.equals((Object)other.second);
            }
        }

        protected static enum TouchType {
            NONE(0),
            INTERIOR(1),
            BOUNDARY(2),
            ANY(3);

            private final int value;

            private TouchType(int value) {
                this.value = value;
            }

            public boolean interiorMayTouch() {
                return (this.value & 1) != 0;
            }

            public boolean boundaryMayTouch() {
                return (this.value & 2) != 0;
            }

            public boolean matches(TouchType other) {
                return (this.value & other.value) != 0;
            }
        }

        private static class EdgeWithInfo {
            S2Point startPoint = null;
            S2Point endPoint = null;
            int edgeId;
            int chainId;
            int prevEdgeId;
            int sign;

            private EdgeWithInfo() {
            }

            public void set(S2Point start, S2Point end, int edgeId, int chainId, int prev, int sign) {
                this.startPoint = start;
                this.endPoint = end;
                this.edgeId = edgeId;
                this.chainId = chainId;
                this.prevEdgeId = prev;
                this.sign = sign;
            }

            public S2Point getStart() {
                return this.startPoint;
            }

            public S2Point getEnd() {
                return this.endPoint;
            }

            public boolean hasEndpoint(S2Point point) {
                return point.equalsPoint(this.startPoint) || point.equalsPoint(this.endPoint);
            }

            public boolean hasSamePoints(EdgeWithInfo other) {
                return this.startPoint.equalsPoint(other.startPoint) && this.endPoint.equalsPoint(other.endPoint);
            }

            public boolean hasReversePoints(EdgeWithInfo other) {
                return this.startPoint.equalsPoint(other.endPoint) && this.endPoint.equalsPoint(other.startPoint);
            }
        }

        private static class TestVertex {
            S2Point vertex = null;
            int edgeId = 0;
            int shapeId = 0;
            int dim = 0;
            boolean onBoundary = false;

            private TestVertex() {
            }

            public void set(S2Point vertex, int edgeId, int shapeId, int dim, boolean onBoundary) {
                this.vertex = vertex;
                this.edgeId = edgeId;
                this.shapeId = shapeId;
                this.dim = dim;
                this.onBoundary = onBoundary;
            }
        }
    }

    public static class S2ValidationQueryBase {
        private final S2IndexCellData cellBuffer = new S2IndexCellData();
        private final S2IncidentEdgeTracker incidentEdgeTracker = new S2IncidentEdgeTracker();
        private S2ShapeIndex index = null;

        public S2Error validate(S2ShapeIndex index) {
            S2Error error = new S2Error();
            this.validate(index, error);
            return error;
        }

        @CanIgnoreReturnValue
        public boolean validate(S2ShapeIndex index, S2Error error) {
            this.index = index;
            boolean result = this.validate(error);
            this.index = null;
            return result;
        }

        private boolean validate(S2Error error) {
            this.incidentEdgeTracker.reset();
            this.cellBuffer.reset();
            if (!this.start(error)) {
                return false;
            }
            S2Iterator.ListIterator<S2ShapeIndex.Cell> iter = this.index.iterator();
            for (int shapeId = 0; shapeId < this.index.getShapes().size(); ++shapeId) {
                S2Shape shape = this.index.getShapes().get(shapeId);
                if (shape == null || this.checkShape(iter, shape, shapeId, error)) continue;
                return false;
            }
            iter.restart();
            while (!iter.done()) {
                S2Shape shape;
                int shapeId;
                this.setCurrentCell(iter);
                for (S2ShapeIndex.S2ClippedShape clipped : this.currentCell().clippedShapes()) {
                    shapeId = clipped.shapeId();
                    shape = this.currentCell().shape(clipped);
                    if (shape.dimension() < 2) continue;
                    this.incidentEdgeTracker.startShape(shapeId);
                    for (S2IndexCellData.EdgeAndIdChain edge : this.currentCell().shapeEdges(shapeId)) {
                        this.incidentEdgeTracker.addEdge(edge.edgeId(), edge.start(), edge.end());
                    }
                    this.incidentEdgeTracker.finishShape();
                }
                if (!this.startCell(error)) {
                    return false;
                }
                for (S2ShapeIndex.S2ClippedShape clipped : this.currentCell().clippedShapes()) {
                    shapeId = clipped.shapeId();
                    shape = this.currentCell().shape(clipped);
                    if (!this.startShape(shape, clipped, error)) {
                        return false;
                    }
                    for (S2IndexCellData.EdgeAndIdChain edge : this.currentCell().shapeEdges(shapeId)) {
                        if (this.checkEdge(shape, clipped, edge, error)) continue;
                        return false;
                    }
                    if (this.finishShape(shape, clipped, error)) continue;
                    return false;
                }
                iter.next();
            }
            return this.finish(error);
        }

        protected boolean start(S2Error error) {
            return true;
        }

        protected boolean checkShape(S2Iterator<S2ShapeIndex.Cell> iter, S2Shape shape, int shapeId, S2Error error) {
            return true;
        }

        protected boolean startCell(S2Error error) {
            return true;
        }

        protected boolean startShape(S2Shape shape, S2ShapeIndex.S2ClippedShape clippedShape, S2Error error) {
            return true;
        }

        protected boolean checkEdge(S2Shape shape, S2ShapeIndex.S2ClippedShape clippedShape, S2IndexCellData.EdgeAndIdChain chain, S2Error error) {
            return true;
        }

        protected boolean finishShape(S2Shape shape, S2ShapeIndex.S2ClippedShape clippedShape, S2Error error) {
            return true;
        }

        protected boolean finish(S2Error error) {
            return true;
        }

        protected S2ShapeIndex index() {
            assert (this.index != null);
            return this.index;
        }

        protected S2IncidentEdgeTracker.IncidentEdgeMap incidentEdges() {
            return this.incidentEdgeTracker.incidentEdges();
        }

        protected S2IndexCellData currentCell() {
            return this.cellBuffer;
        }

        private void setCurrentCell(S2Iterator<S2ShapeIndex.Cell> iter) {
            this.cellBuffer.loadCell(this.index, iter.id(), iter.entry());
        }
    }
}

